/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.datasources.Function;
import com.sas.query.datasources.FunctionConstants;
import com.sas.query.datasources.FunctionList;
import com.sas.query.models.Comparison;
import com.sas.query.models.VectorSort;
import com.sas.query.visuals.FlatSplitPane;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.SqlTextHelper;
import com.sas.query.visuals.WindowUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ExpressionEditFunctionsPanel
extends JPanel
implements FunctionConstants {
    protected static QueryResource bundle = new QueryResource(ExpressionEditFunctionsPanel.class);
    protected JList catagoriesList;
    protected JList functionsList;
    protected JLabel catagoriesLabel;
    protected JLabel functionsLabel;
    protected JTextField functionsDescription;
    protected Vector m_actionTriggers;
    protected SqlTextHelper m_drivenSqlHelper;
    protected Vector m_functionCatagories;
    protected FunctionList m_functionDefsInCat;
    protected FunctionList m_allFunctionDefs;
    protected SymItem m_lSymItem;
    protected MouseListener m_mouseListener;
    protected FlatSplitPane splitter;
    protected JPanel left;
    protected JPanel right;
    protected JScrollPane scrollPane;

    public ExpressionEditFunctionsPanel(SqlTextHelper drivenSqlHelper, Vector actionTriggers) {
        this.m_drivenSqlHelper = drivenSqlHelper;
        this.initialize();
        this.m_actionTriggers = actionTriggers;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.splitter = new FlatSplitPane(1);
        this.left = new JPanel(new BorderLayout(0, 0));
        this.catagoriesLabel = new JLabel(bundle.getString("ExpressionEditFunctionsPanel.catagoriesLabel.txt"));
        this.catagoriesLabel.setFont(new Font("Dialog", 0, 12));
        this.left.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 4));
        this.left.add("North", this.catagoriesLabel);
        this.catagoriesList = new JList();
        this.scrollPane = new JScrollPane(this.catagoriesList);
        WindowUtil.fixupJScrollPane(this.scrollPane);
        this.left.add("Center", this.scrollPane);
        this.splitter.getSplitter().setLeftComponent(this.left);
        this.right = new JPanel(new BorderLayout(0, 0));
        this.functionsLabel = new JLabel(bundle.getString("ExpressionEditFunctionsPanel.functionsLabel.txt"));
        this.functionsLabel.setFont(new Font("Dialog", 0, 12));
        this.right.setBorder(BorderFactory.createEmptyBorder(4, 5, 4, 4));
        this.right.add("North", this.functionsLabel);
        this.functionsList = new JList();
        this.functionsList.setSelectionMode(0);
        this.scrollPane = new JScrollPane(this.functionsList);
        WindowUtil.fixupJScrollPane(this.scrollPane);
        this.right.add("Center", this.scrollPane);
        this.splitter.getSplitter().setRightComponent(this.right);
        this.splitter.getSplitter().setDividerLocation(160);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 5, 5, 5);
        ((GridBagLayout)this.getLayout()).setConstraints(this.splitter, gbc);
        this.add(this.splitter);
        this.functionsDescription = new JTextField();
        this.functionsDescription.setText("");
        this.functionsDescription.setBorder(BorderFactory.createEmptyBorder());
        this.functionsDescription.setEditable(false);
        this.functionsDescription.setEnabled(true);
        this.functionsDescription.setBackground(SystemColor.control);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 5, 5);
        ((GridBagLayout)this.getLayout()).setConstraints(this.functionsDescription, gbc);
        this.add(this.functionsDescription);
        this.m_functionCatagories = this.getAllCategories();
        Comparison functionCategoryComparitor = new Comparison(){

            @Override
            public int compare(Object firstObject, Object secondObject) {
                int firstIndex = (Integer)firstObject;
                int secondIndex = (Integer)secondObject;
                return Function.getCatagoryName(firstIndex).compareTo(Function.getCatagoryName(secondIndex));
            }
        };
        VectorSort.sort(this.m_functionCatagories, functionCategoryComparitor, 1);
        DefaultListModel<String> m = new DefaultListModel<String>();
        for (int i = 0; i < this.m_functionCatagories.size(); ++i) {
            m.add(i, Function.getCatagoryName((Integer)this.m_functionCatagories.elementAt(i)));
        }
        this.catagoriesList.setModel(m);
        this.noCategorySelected();
        this.addAllListeners();
        if (m.size() > 0) {
            this.catagoriesList.setSelectedIndex(0);
        }
    }

    private Vector getAllCategories() {
        return this.m_drivenSqlHelper.getQuery().getSqlProperties().getAllFunctionCategories(this.getAllFunDefs());
    }

    public void addAllListeners() {
        this.m_lSymItem = new SymItem();
        this.catagoriesList.addListSelectionListener(this.m_lSymItem);
        this.functionsList.addListSelectionListener(this.m_lSymItem);
        this.m_mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getClickCount() == 2 && (index = ExpressionEditFunctionsPanel.this.functionsList.locationToIndex(e.getPoint())) > -1) {
                    ExpressionEditFunctionsPanel.this.doFirePropertyChange("newFunction", null, null);
                }
            }
        };
        this.functionsList.addMouseListener(this.m_mouseListener);
    }

    public void removeAllListeners() {
        if (this.m_lSymItem != null) {
            this.catagoriesList.removeListSelectionListener(this.m_lSymItem);
            this.functionsList.addListSelectionListener(this.m_lSymItem);
            this.m_lSymItem = null;
        }
        if (this.m_mouseListener != null) {
            this.functionsList.removeMouseListener(this.m_mouseListener);
            this.m_mouseListener = null;
        }
        this.catagoriesList = null;
        this.functionsList = null;
        this.catagoriesLabel = null;
        this.functionsLabel = null;
        this.functionsDescription = null;
        this.m_actionTriggers = null;
        this.m_drivenSqlHelper = null;
        this.m_functionCatagories = null;
        this.m_functionDefsInCat = null;
        this.m_allFunctionDefs = null;
        this.removeAll();
        this.splitter.removeAllListeners();
        this.splitter = null;
        this.left.removeAll();
        this.left = null;
        this.right.removeAll();
        this.right = null;
        this.scrollPane.removeAll();
        this.scrollPane = null;
    }

    private FunctionList getAllFunDefs() {
        if (this.m_allFunctionDefs == null) {
            this.m_allFunctionDefs = this.m_drivenSqlHelper.getQuery().getSqlProperties().getAllFunctions();
            this.m_allFunctionDefs = this.m_allFunctionDefs.removeAllInCategory(0xC00000);
            this.m_allFunctionDefs = this.m_allFunctionDefs.removeByType(12);
            this.m_allFunctionDefs = this.m_allFunctionDefs.removeDuplicatesByNiceFunctionName();
        }
        return this.m_allFunctionDefs;
    }

    private void categorySelected() {
        DefaultListModel m2;
        this.noCategorySelected();
        int index = this.catagoriesList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        int iCategory = (Integer)this.m_functionCatagories.elementAt(index);
        this.m_functionDefsInCat = this.getAllFunDefs().getSubsetByCategory(iCategory);
        this.m_functionDefsInCat.sortByName();
        ListModel mx = this.functionsList.getModel();
        if (mx == null || !(mx instanceof DefaultListModel)) {
            m2 = new DefaultListModel();
            this.functionsList.setModel(m2);
        } else {
            m2 = (DefaultListModel)mx;
            m2.removeAllElements();
        }
        for (int i = 0; i < this.m_functionDefsInCat.size(); ++i) {
            m2.add(i, this.m_functionDefsInCat.elementAt(i).getNiceFunctionName());
        }
    }

    private void noCategorySelected() {
        this.functionsList.removeAll();
        this.disableActionTrigger();
    }

    public Function getSelectedFunction() {
        if (this.functionsList.getSelectedIndex() == -1) {
            return null;
        }
        return this.m_functionDefsInCat.elementAt(this.functionsList.getSelectedIndex());
    }

    public int getSelectedCategory() {
        if (this.catagoriesList.getSelectedIndex() == -1) {
            return -1;
        }
        return (Integer)this.m_functionCatagories.elementAt(this.catagoriesList.getSelectedIndex());
    }

    public void enableActionTrigger() {
        if (this.m_actionTriggers != null) {
            for (int i = 0; i < this.m_actionTriggers.size(); ++i) {
                ((Component)this.m_actionTriggers.elementAt(i)).setEnabled(true);
            }
            this.functionsDescription.setText("");
            this.functionsDescription.setToolTipText("");
            if (this.getSelectedFunction() != null) {
                String tmp = this.getSelectedFunction().getFunctionDescription();
                this.functionsDescription.setText(tmp);
                this.functionsDescription.setToolTipText(tmp);
                this.functionsDescription.setCaretPosition(0);
            }
            this.firePropertyChange("functionSelectionChanged", null, null);
        }
    }

    public void disableActionTrigger() {
        if (this.m_actionTriggers != null) {
            for (int i = 0; i < this.m_actionTriggers.size(); ++i) {
                ((Component)this.m_actionTriggers.elementAt(i)).setEnabled(false);
            }
            this.functionsDescription.setText("");
            this.functionsDescription.setToolTipText("");
            this.firePropertyChange("functionSelectionChanged", null, null);
        }
    }

    public void doFirePropertyChange(String str, Object obj1, Object obj2) {
        this.firePropertyChange(str, obj1, obj2);
    }

    public void initialize() {
    }

    class SymItem
    implements ListSelectionListener {
        SymItem() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            Object object = event.getSource();
            if (object == ExpressionEditFunctionsPanel.this.functionsList) {
                if (ExpressionEditFunctionsPanel.this.functionsList.getSelectedIndex() == -1) {
                    ExpressionEditFunctionsPanel.this.disableActionTrigger();
                } else {
                    ExpressionEditFunctionsPanel.this.enableActionTrigger();
                }
            } else if (object == ExpressionEditFunctionsPanel.this.catagoriesList) {
                if (ExpressionEditFunctionsPanel.this.catagoriesList.getSelectedIndex() == -1) {
                    ExpressionEditFunctionsPanel.this.noCategorySelected();
                } else {
                    ExpressionEditFunctionsPanel.this.categorySelected();
                }
            }
        }
    }
}

