/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.models.Column;
import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.DataBaseUIRequest;
import com.sas.query.visuals.ExpressionEditReferencesPanel;
import com.sas.query.visuals.FlatSplitPane;
import com.sas.query.visuals.JReferableTreeView;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.SqlTextHelper;
import com.sas.query.visuals.WindowUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class ExpressionEditDistinctValsPanel
extends JPanel
implements TreeSelectionListener {
    static final int GULP_SIZE = 100;
    static final int MAXIMUM_DRINK = 1000;
    protected JReferableTreeView dataSourcesTree;
    protected JList distinctValuesList;
    protected Vector distinctValuesListList;
    protected JLabel dataSourcesLabel;
    protected JLabel distinctValuesLabel;
    protected JTextField columnDescription;
    protected Component m_actionTrigger;
    protected SqlTextHelper m_drivenSqlHelper;
    protected Column m_currentlySelectedColumn;
    protected ListSelectionListener lsl;
    protected MouseListener m_mouseListener;
    protected FlatSplitPane splitter;
    protected JPanel left;
    protected JPanel right;
    protected JScrollPane scrollPane;
    protected static QueryResource bundle = new QueryResource(ExpressionEditDistinctValsPanel.class);

    public ExpressionEditDistinctValsPanel(SqlTextHelper drivenSqlHelper, Component actionTrigger) {
        this.m_drivenSqlHelper = drivenSqlHelper;
        this.m_actionTrigger = actionTrigger;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.splitter = new FlatSplitPane(1);
        this.left = new JPanel(new BorderLayout(0, 0));
        this.dataSourcesLabel = new JLabel(bundle.getString("ExpressionEditDistinctValsPanel.dataSourcesLabel.txt"));
        this.dataSourcesLabel.setFont(new Font("Dialog", 0, 12));
        this.left.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.left.add("North", this.dataSourcesLabel);
        this.dataSourcesTree = new JReferableTreeView(this.m_drivenSqlHelper.getQuery(), 2);
        this.left.add("Center", this.dataSourcesTree);
        this.splitter.getSplitter().setLeftComponent(this.left);
        this.right = new JPanel(new BorderLayout(0, 0));
        this.distinctValuesLabel = new JLabel(bundle.getString("ExpressionEditDistinctValsPanel.distinctValuesLabel.txt"));
        this.distinctValuesLabel.setFont(new Font("Dialog", 0, 12));
        this.right.setBorder(BorderFactory.createEmptyBorder(4, 5, 4, 4));
        this.right.add("North", this.distinctValuesLabel);
        this.distinctValuesList = new JList();
        this.distinctValuesListList = new Vector();
        this.distinctValuesList.setModel(new SimpleListModel(this.distinctValuesListList));
        this.distinctValuesList.setSelectionMode(0);
        this.scrollPane = new JScrollPane(this.distinctValuesList);
        WindowUtil.fixupJScrollPane(this.scrollPane);
        this.right.add("Center", this.scrollPane);
        this.splitter.getSplitter().setRightComponent(this.right);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 5, 5, 5);
        ((GridBagLayout)this.getLayout()).setConstraints(this.splitter, gbc);
        this.add(this.splitter);
        this.splitter.getSplitter().setDividerLocation(160);
        this.columnDescription = new JTextField();
        this.columnDescription.setText("");
        this.columnDescription.setBorder(BorderFactory.createEmptyBorder());
        this.columnDescription.setEditable(false);
        this.columnDescription.setEnabled(true);
        this.columnDescription.setBackground(SystemColor.control);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 5, 5);
        ((GridBagLayout)this.getLayout()).setConstraints(this.columnDescription, gbc);
        this.add(this.columnDescription);
        this.addAllListeners();
        this.noColumnSelected();
    }

    public void addAllListeners() {
        this.lsl = new ListSelListener();
        this.distinctValuesList.addListSelectionListener(this.lsl);
        this.dataSourcesTree.m_tree.addTreeSelectionListener(this);
        this.m_mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getClickCount() == 2 && (index = ExpressionEditDistinctValsPanel.this.distinctValuesList.locationToIndex(e.getPoint())) > -1) {
                    ExpressionEditDistinctValsPanel.this.firePropertyChange("newItem", null, null);
                }
            }
        };
        this.distinctValuesList.addMouseListener(this.m_mouseListener);
    }

    public void removeAllListeners() {
        if (this.lsl != null) {
            this.distinctValuesList.removeListSelectionListener(this.lsl);
            this.lsl = null;
        }
        this.dataSourcesTree.m_tree.removeTreeSelectionListener(this);
        if (this.m_mouseListener != null) {
            this.distinctValuesList.removeMouseListener(this.m_mouseListener);
            this.m_mouseListener = null;
            this.dataSourcesTree.closing();
        }
        this.dataSourcesTree = null;
        this.distinctValuesList = null;
        this.distinctValuesListList = null;
        this.dataSourcesLabel = null;
        this.distinctValuesLabel = null;
        this.columnDescription = null;
        this.m_actionTrigger = null;
        this.m_drivenSqlHelper = null;
        this.m_currentlySelectedColumn = null;
        this.splitter.removeAllListeners();
        this.splitter = null;
        this.left.removeAll();
        this.left = null;
        this.right.removeAll();
        this.right = null;
        this.scrollPane.removeAll();
        this.scrollPane = null;
    }

    private void columnSelected(Column selColumn) {
        this.setCurrentColumn(selColumn);
        if (selColumn == null) {
            this.toolTipMsg(bundle.getString("ExpressionEditDistinctValsPanel.nullColumnTip.txt"));
            this.clearDistinctValuesList();
            return;
        }
        if (!selColumn.supportsDistinctValues()) {
            String tmp = bundle.messageString("ExpressionEditDistinctValsPanel.cantDisplayDistinctVals.fmt.txt", selColumn.getLabel());
            this.toolTipMsg(tmp);
            this.clearDistinctValuesList();
            return;
        }
        this.showDistinctValues(selColumn);
    }

    private void clearDistinctValuesList() {
        this.distinctValuesListList.removeAllElements();
        ((SimpleListModel)this.distinctValuesList.getModel()).fireChange();
        this.disableActionTrigger();
    }

    private void toolTipMsg(String str) {
        this.columnDescription.setText(str);
        this.columnDescription.setToolTipText(str);
        this.columnDescription.setCaretPosition(0);
        this.columnDescription.paintImmediately(this.columnDescription.getVisibleRect());
    }

    public Vector getDistinctValueSet(Object requestInfo, MessageHandler messages) {
        Vector returnValue = null;
        try {
            Column selColumn = (Column)requestInfo;
            returnValue = selColumn.getDistinctValueSet(100);
        }
        catch (Exception e) {
            this.m_drivenSqlHelper.getQuery().getMessageHandler().addInternalError(e);
        }
        return returnValue;
    }

    private void showDistinctValues(Column selColumn) {
        int numReadValues = 0;
        this.clearDistinctValuesList();
        this.toolTipMsg(bundle.getString("ExpressionEditDistinctValsPanel.gettingDistinctVals.txt"));
        WindowUtil.busyOn(this);
        try {
            int i;
            MessageHandler tempMessages = new MessageHandler();
            DataBaseUIRequest dbRequest = new DataBaseUIRequest(selColumn.getQuery(), this, bundle.getString("ExpressionEditDistinctValsPanel.gettingDistinctVals.txt"));
            Vector vals = (Vector)dbRequest.exec(this, "getDistinctValueSet", selColumn, tempMessages);
            if (vals == null) {
                WindowUtil.busyOff(this);
                return;
            }
            numReadValues += vals.size();
            while (selColumn.isThereAnotherDistinctValue() && numReadValues < 1000) {
                this.toolTipMsg(bundle.messageString("ExpressionEditDistinctValsPanel.loadingNumMessage.fmt.txt", new Integer(numReadValues)));
                for (i = 0; i < vals.size(); ++i) {
                    this.distinctValuesListList.addElement((String)vals.elementAt(i));
                }
                vals = selColumn.getNextValueSet(new Integer(100));
                if (vals == null) {
                    WindowUtil.busyOff(this);
                    return;
                }
                numReadValues += vals.size();
            }
            for (i = 0; i < vals.size(); ++i) {
                this.distinctValuesListList.addElement((String)vals.elementAt(i));
            }
            String tmp = ExpressionEditReferencesPanel.describeColumn(selColumn);
            this.toolTipMsg(tmp);
        }
        catch (Throwable t) {
            WindowUtil.busyOff(this);
            this.m_drivenSqlHelper.getQuery().getMessageHandler().addInternalError(t);
        }
        WindowUtil.busyOff(this);
        ((SimpleListModel)this.distinctValuesList.getModel()).fireChange();
    }

    private void noColumnSelected() {
        this.clearDistinctValuesList();
        this.columnDescription.setText(bundle.messageString("ExpressionEditDistinctValsPanel.selectColExpr.txt"));
        this.columnDescription.setToolTipText(bundle.messageString("ExpressionEditDistinctValsPanel.selectColExpr.txt"));
        this.columnDescription.setCaretPosition(0);
    }

    @Override
    public void valueChanged(TreeSelectionEvent tse) {
        Object node;
        TreePath t = ((JTree)tse.getSource()).getSelectionPath();
        if (t != null && (node = t.getLastPathComponent()) != null) {
            if (node instanceof Column) {
                this.columnSelected((Column)node);
            } else {
                this.noColumnSelected();
            }
        }
    }

    public void enableActionTrigger() {
        this.m_actionTrigger.setEnabled(true);
    }

    public void disableActionTrigger() {
        this.m_actionTrigger.setEnabled(false);
    }

    private void setCurrentColumn(Column c) {
        this.m_currentlySelectedColumn = c;
        if (c == null) {
            this.clearDistinctValuesList();
        }
    }

    public Column getCurrentColumn() {
        return this.m_currentlySelectedColumn;
    }

    public String getCurrentValue() {
        String retval = "";
        int cursel = this.distinctValuesList.getSelectedIndex();
        if (cursel >= 0) {
            retval = this.distinctValuesList.getModel().getElementAt(cursel).toString();
        }
        return retval;
    }

    protected class SimpleListModel
    extends AbstractListModel {
        protected Vector m_vector;

        SimpleListModel(Vector vect) {
            this.m_vector = vect;
        }

        @Override
        public int getSize() {
            return this.m_vector.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.m_vector.elementAt(index);
        }

        public void fireChange() {
            this.fireContentsChanged(ExpressionEditDistinctValsPanel.this.distinctValuesList, 0, this.getSize() - 1);
        }
    }

    class ListSelListener
    implements ListSelectionListener {
        ListSelListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            JList source = (JList)event.getSource();
            int currentSel = source.getSelectedIndex();
            if (source == ExpressionEditDistinctValsPanel.this.distinctValuesList) {
                if (currentSel < 0) {
                    ExpressionEditDistinctValsPanel.this.disableActionTrigger();
                } else {
                    ExpressionEditDistinctValsPanel.this.enableActionTrigger();
                }
            }
        }
    }
}

