/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.visuals.DrawUtil;
import com.sas.query.visuals.FilterNodeView;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

class DropRegion {
    public static final int DOUBLE_AND = 0;
    public static final int OR = 1;
    public static final int AFTER_AND = 2;
    public static final int FRONT_AND = 3;
    public static final int MIDDLE_AND = 4;
    public static final int TERMINATOR_AND = 5;
    public static final int MINIMUM_DROP_DISTANCE = 144;
    protected int m_dropType;
    protected FilterNodeView m_targetView;
    protected boolean m_fIsCopyRequired;
    public Point m_endPointA;
    public Point m_endPointB;

    public DropRegion(int dropType, FilterNodeView targetView) {
        this(dropType, targetView, false);
    }

    public DropRegion(int dropType, FilterNodeView targetView, boolean fIsCopyRequired) {
        this.m_dropType = dropType;
        this.m_targetView = targetView;
        this.m_fIsCopyRequired = fIsCopyRequired;
        if (dropType == 0) {
            FilterNodeView secondView = this.m_targetView.getAndNodeView();
            this.m_endPointA = new Point(this.m_targetView.x + this.m_targetView.width + (secondView.x - (this.m_targetView.x + this.m_targetView.width)) / 2, this.m_targetView.y);
            this.m_endPointB = new Point(this.m_targetView.x + this.m_targetView.width + (secondView.x - (this.m_targetView.x + this.m_targetView.width)) / 2, this.m_targetView.y + this.m_targetView.height);
        } else if (dropType == 1) {
            this.m_endPointA = new Point(this.m_targetView.x, this.m_targetView.y + this.m_targetView.height + FilterNodeView.INTER_NODE_OR_SPACE / 2);
            this.m_endPointB = new Point(this.m_targetView.x + this.m_targetView.width, this.m_targetView.y + this.m_targetView.height + FilterNodeView.INTER_NODE_OR_SPACE / 2);
        } else if (dropType == 2) {
            this.m_endPointA = new Point(this.m_targetView.x + this.m_targetView.width + FilterNodeView.INTER_NODE_AND_SPACE / 4, this.m_targetView.y);
            this.m_endPointB = new Point(this.m_targetView.x + this.m_targetView.width + FilterNodeView.INTER_NODE_AND_SPACE / 4, this.m_targetView.y + this.m_targetView.height);
        } else if (dropType == 4) {
            this.m_endPointA = new Point(this.m_targetView.x - FilterNodeView.INTER_NODE_AND_SPACE / 2, this.m_targetView.y);
            this.m_endPointB = new Point(this.m_targetView.x - FilterNodeView.INTER_NODE_AND_SPACE / 2, this.m_targetView.y + this.m_targetView.height);
        } else if (dropType == 3) {
            this.m_endPointA = new Point(this.m_targetView.x - FilterNodeView.INTER_NODE_AND_SPACE / 4, this.m_targetView.y);
            this.m_endPointB = new Point(this.m_targetView.x - FilterNodeView.INTER_NODE_AND_SPACE / 4, this.m_targetView.y + this.m_targetView.height);
        } else if (dropType == 5) {
            this.m_endPointA = new Point(this.m_targetView.x + this.m_targetView.width + FilterNodeView.INTER_NODE_AND_SPACE / 4, this.m_targetView.y);
            this.m_endPointB = new Point(this.m_targetView.x + this.m_targetView.width + FilterNodeView.INTER_NODE_AND_SPACE / 4, this.m_targetView.y + this.m_targetView.height);
        }
    }

    public int getDistanceFromPoint(Point point) {
        int distance = 145;
        distance = (int)DrawUtil.distanceToLine(this.m_endPointA, this.m_endPointB, point);
        return distance;
    }

    public void paint(Graphics g, Rectangle targetRect) {
        if (this.getDropType() == 0 || this.getDropType() == 2 || this.getDropType() == 4 || this.getDropType() == 5 || this.getDropType() == 3) {
            int startX = this.m_endPointA.x;
            int startY = this.m_endPointA.y;
            int height = this.m_endPointB.y - this.m_endPointA.y;
            g.drawLine(startX - 5, startY - 5, startX, startY);
            g.drawLine(startX + 6, startY - 5, startX + 1, startY);
            g.drawLine(startX - 5, startY + height + 5, startX, startY + height);
            g.drawLine(startX + 6, startY + height + 5, startX + 1, startY + height);
            g.fillRect(startX, startY, 2, height);
            g.drawString(FilterNodeView.AND_DISPLAY_STRING, startX + 8, startY - 3);
        } else if (this.getDropType() == 1) {
            int startX = this.m_endPointA.x;
            int startY = this.m_endPointA.y;
            int width = this.m_endPointB.x - this.m_endPointA.x;
            g.drawLine(startX - 5, startY - 5, startX, startY);
            g.drawLine(startX - 5, startY + 6, startX, startY + 1);
            g.drawLine(startX + width + 5, startY - 5, startX + width, startY);
            g.drawLine(startX + width + 5, startY + 6, startX + width, startY + 1);
            g.fillRect(startX, startY, width, 2);
            g.drawString(FilterNodeView.OR_DISPLAY_STRING, startX + width + 8, startY + 6);
        }
    }

    public int getDropType() {
        return this.m_dropType;
    }

    public boolean isCopyRequired() {
        return this.m_fIsCopyRequired;
    }

    public FilterNodeView getTargetView() {
        return this.m_targetView;
    }
}

