/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.visuals.FilterTreeView;
import com.sas.query.visuals.QueryComponentInterface;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.VerticalHeader;
import com.sas.query.visuals.WindowUtil;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class DataFilterSection
extends JPanel
implements QueryComponentInterface {
    Query m_query;
    FilterTreeView m_filterTreeView;
    protected static QueryResource bundle = new QueryResource(DataFilterSection.class);
    public static final long NO_DATA_FILTER_OPTIONS = 0L;
    public static final long NO_VERTICAL_HEADER = 1L;

    public DataFilterSection(Query query) {
        this(query, 0L);
    }

    public DataFilterSection(Query query, long optionFlags) {
        this.m_query = query;
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 3;
        c.anchor = 18;
        if ((optionFlags & 1L) == 0L) {
            VerticalHeader label = new VerticalHeader(bundle.getString("dataFilters.Section.Title.txt"));
            gbl.setConstraints(label, c);
            this.add(label);
        }
        JScrollPane scrollPane = new JScrollPane(20, 30);
        WindowUtil.fixupJScrollPane(scrollPane);
        JViewport viewPort = scrollPane.getViewport();
        this.m_filterTreeView = new FilterTreeView(this.m_query, query.getWhereFilterTree(), scrollPane);
        viewPort.add(this.m_filterTreeView);
        c.fill = 1;
        c.gridx = -1;
        c.gridwidth = 0;
        c.gridheight = 0;
        c.anchor = 14;
        c.weightx = 1.0;
        c.weighty = 1.0;
        gbl.setConstraints(scrollPane, c);
        this.add(scrollPane);
    }

    public FilterTreeView getFilterTree() {
        return this.m_filterTreeView;
    }

    @Override
    public void closing() {
        this.m_filterTreeView.closing();
    }

    @Override
    public boolean validateInput() {
        return true;
    }

    @Override
    public void doDataExchange(boolean bSaveToModel) {
    }
}

