/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.QueryUtils;
import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.DataBaseProgressIndicator;
import com.sas.query.visuals.MessageUtil;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.WindowUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JDialog;

public class DataBaseUIRequest {
    private static final boolean debug = false;
    protected static QueryResource bundle = new QueryResource(DataBaseUIRequest.class);
    protected String m_strMethod;
    protected String m_strCancelMethod;
    protected String m_strCleanupMethod;
    protected Object m_requestInfo;
    protected MessageHandler m_messages;
    protected Object m_receiver;
    protected Class m_lastParmLookupClass;
    protected String m_messageText;
    protected String m_titleText;
    protected int m_delayBeforeProgressCancelDialogAppearance = 1000;
    protected Object m_results;
    protected DataBaseQueryThread m_queryThread;
    protected Frame m_parentFrame;
    protected JDialog m_parentDialog;
    protected Component m_parentComponent;
    protected boolean m_cancellationRequested = false;
    protected Query m_query;
    protected DataBaseProgressIndicator m_ProgressCancelDialog;

    public DataBaseUIRequest(Query query, JComponent parent) {
        this.setParent(parent);
        this.m_query = query;
    }

    public DataBaseUIRequest(Query query, JComponent parent, String message) {
        this.m_messageText = message;
        this.setParent(parent);
        this.m_query = query;
    }

    public DataBaseUIRequest(Query query, JComponent parent, String message, String title) {
        this.m_messageText = message;
        this.m_titleText = title;
        this.setParent(parent);
        this.m_query = query;
    }

    public DataBaseUIRequest(Query query, JDialog parent) {
        this.m_parentFrame = WindowUtil.getParentFrame(parent);
        this.m_query = query;
    }

    public DataBaseUIRequest(Query query, JDialog parent, String message) {
        this.m_messageText = message;
        this.setParent(parent);
        this.m_query = query;
    }

    public DataBaseUIRequest(Query query, JDialog parent, String message, String title) {
        this.m_messageText = message;
        this.m_titleText = title;
        this.m_parentFrame = WindowUtil.getParentFrame(parent);
        this.m_query = query;
    }

    public DataBaseUIRequest(Query query, Frame parent) {
        this.m_parentFrame = parent;
        this.m_query = query;
    }

    public DataBaseUIRequest(Query query, Frame parent, String message) {
        this.m_messageText = message;
        this.m_parentFrame = parent;
        this.m_query = query;
    }

    public DataBaseUIRequest(Query query, Frame parent, String message, String title) {
        this.m_messageText = message;
        this.m_titleText = title;
        this.m_parentFrame = parent;
        this.m_query = query;
    }

    public boolean wasCancelRequested() {
        return this.m_cancellationRequested;
    }

    public int getDelayBeforeProgressCancelDialog() {
        return this.m_delayBeforeProgressCancelDialogAppearance;
    }

    public void setDelayBeforeProgressCancelDialog(int val) {
        this.m_delayBeforeProgressCancelDialogAppearance = val < 0 ? 1500 : val;
    }

    public Object exec(Object receiver, String strMethod, String strCancelMethod, String strCleanupMethod, Object requestInfo, MessageHandler messages) {
        this.resetVars();
        this.m_strMethod = strMethod;
        this.m_strCancelMethod = strCancelMethod;
        this.m_strCleanupMethod = strCleanupMethod;
        this.m_requestInfo = requestInfo;
        this.m_messages = messages;
        this.m_receiver = receiver;
        return this.doIt();
    }

    public Object exec(Object receiver, String strMethod, Object requestInfo, MessageHandler messages) {
        this.resetVars();
        this.m_strMethod = strMethod;
        this.m_requestInfo = requestInfo;
        this.m_messages = messages;
        this.m_receiver = receiver;
        return this.doIt();
    }

    public Object exec(Object receiver, String strMethodName) {
        this.resetVars();
        this.m_strMethod = strMethodName;
        this.m_receiver = receiver;
        return this.doIt();
    }

    private void resetVars() {
        this.m_results = null;
        this.m_lastParmLookupClass = null;
        this.m_strMethod = null;
        this.m_strCancelMethod = null;
        this.m_strCleanupMethod = null;
        this.m_requestInfo = null;
        this.m_receiver = null;
        this.m_queryThread = null;
        this.m_cancellationRequested = false;
        this.m_ProgressCancelDialog = null;
    }

    protected boolean queryStillRunning() {
        boolean retVal = false;
        if (this.m_queryThread != null && this.m_queryThread.isAlive()) {
            retVal = true;
        }
        return retVal;
    }

    public String getMessage() {
        if (this.m_messageText == null) {
            return bundle.getString("DataBaseUIRequest.RetrievingData.txt");
        }
        return this.m_messageText;
    }

    public void setMessage(String text) {
        this.m_messageText = text;
    }

    public String getTitle() {
        if (this.m_titleText == null) {
            return bundle.messageString("DatabaseUIRequest.Title.Accessing.txt");
        }
        return this.m_titleText;
    }

    public void setTitle(String text) {
        this.m_titleText = text;
    }

    protected Object doIt() {
        Object returnVal = null;
        WindowUtil.busyOn(this.m_parentComponent);
        try {
            this.doItQuick();
            if (this.queryStillRunning()) {
                this.doItLong();
            }
            returnVal = this.m_results;
        }
        catch (Exception e) {
            WindowUtil.busyOff(this.m_parentComponent);
            this.m_messages.addInternalError(e);
        }
        WindowUtil.busyOff(this.m_parentComponent);
        return returnVal;
    }

    protected void doItQuick() {
        long howLongWeBeenWaiting = 0L;
        this.m_queryThread = new DataBaseQueryThread(this);
        this.m_queryThread.setPriority(5);
        this.m_queryThread.start();
        if (this.getDelayBeforeProgressCancelDialog() == 0) {
            return;
        }
        while (this.queryStillRunning()) {
            WindowUtil.sleep(250);
            if ((howLongWeBeenWaiting += 250L) < (long)this.getDelayBeforeProgressCancelDialog()) continue;
            return;
        }
        this.m_queryThread = null;
    }

    public void requestCleanup() {
        Object retval = null;
        try {
            if (this.m_strCleanupMethod != null) {
                if (this.m_requestInfo == null) {
                    Method callback = this.m_receiver.getClass().getMethod(this.m_strCleanupMethod, null);
                    retval = callback.invoke(this.m_receiver, null);
                } else {
                    Class[] parmClassArray = new Class[]{Object.class, MessageHandler.class};
                    Object[] actualParmArray = new Object[]{this.m_requestInfo, this.m_messages};
                    Method callback = this.m_receiver.getClass().getMethod(this.m_strCleanupMethod, parmClassArray);
                    retval = callback.invoke(this.m_receiver, actualParmArray);
                }
            }
        }
        catch (NoSuchMethodException e) {
            MessageHandler.addStaticError(bundle.messageString("CommonUI.unableRegisterCallbackMethod.txt") + this.m_strMethod + "\n" + e.getMessage());
            MessageHandler.addStaticError(e);
        }
        catch (InvocationTargetException e) {
            MessageHandler.addStaticError(bundle.messageString("CommonUI.invokeError.fmt.txt", this.m_strMethod));
            MessageHandler.addStaticError(e);
        }
        catch (Exception e) {
            String extra = e.getMessage();
            if (extra == null) {
                extra = e.toString();
            }
            MessageHandler.addStaticError(bundle.messageString("CommonUI.CallingCallbackMethod.txt") + this.m_strMethod + "\n" + extra);
        }
    }

    public void requestCancel() {
        if (this.m_query.getDataSource().supportsSingleThreadDataAccessOnly()) {
            this.m_messages.addWarning(bundle.getString("DataBaseUIRequest.nocancelmsg1.txt"));
            this.m_messages.addWarning(bundle.getString("DataBaseUIRequest.nocancelmsg2.txt"));
            this.m_messages.addWarning(bundle.getString("DataBaseUIRequest.nocancelmsg3.txt"));
            this.m_messages.addWarning(bundle.getString("DataBaseUIRequest.nocancelmsg4.txt"));
            try {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                String srcData = this.m_query.getSql();
                srcData = QueryUtils.formatSql(srcData, this.m_query.getDataSource());
                StringSelection contents = new StringSelection(srcData);
                clipboard.setContents(contents, new ClipboardObserver());
            }
            catch (Throwable clipboard) {
                // empty catch block
            }
            MessageUtil.displayMessages(this.m_messages);
            return;
        }
        this.m_cancellationRequested = true;
        Object retval = null;
        try {
            if (this.m_strCancelMethod != null) {
                if (this.m_requestInfo == null) {
                    Method callback = this.m_receiver.getClass().getMethod(this.m_strCancelMethod, null);
                    retval = callback.invoke(this.m_receiver, null);
                } else {
                    Class[] parmClassArray = new Class[]{Object.class, MessageHandler.class};
                    Object[] actualParmArray = new Object[]{this.m_requestInfo, this.m_messages};
                    Method callback = this.m_receiver.getClass().getMethod(this.m_strCancelMethod, parmClassArray);
                    retval = callback.invoke(this.m_receiver, actualParmArray);
                }
            }
        }
        catch (NoSuchMethodException e) {
            MessageHandler.addStaticError(bundle.messageString("CommonUI.unableRegisterCallbackMethod.txt") + this.m_strMethod + "\n" + e.getMessage());
            MessageHandler.addStaticError(e);
        }
        catch (InvocationTargetException e) {
            MessageHandler.addStaticError(bundle.messageString("CommonUI.invokeError.fmt.txt", this.m_strMethod));
            MessageHandler.addStaticError(e);
        }
        catch (Exception e) {
            String extra = e.getMessage();
            if (extra == null) {
                extra = e.toString();
            }
            MessageHandler.addStaticError(bundle.messageString("CommonUI.CallingCallbackMethod.txt") + this.m_strMethod + "\n" + extra);
        }
    }

    public DataBaseProgressIndicator makeDialog(Frame frame, DataBaseUIRequest request, String title, String message) {
        return new DataBaseProgressIndicator(frame, request, title, message);
    }

    private DataBaseProgressIndicator makeDialog(DataBaseUIRequest request, String title, String message) {
        DataBaseProgressIndicator indicatorDialog = null;
        if (this.m_parentFrame != null) {
            indicatorDialog = new DataBaseProgressIndicator(this.m_parentFrame, request, title, message);
        } else if (this.m_parentDialog != null) {
            indicatorDialog = new DataBaseProgressIndicator(this.m_parentDialog, request, title, message);
        }
        return indicatorDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doItLong() {
        if (this.queryStillRunning()) {
            Object object = this;
            synchronized (object) {
                this.m_ProgressCancelDialog = this.makeDialog(this, this.getTitle(), this.getMessage());
                ProgressPingPongThread dialogUpdater = new ProgressPingPongThread(this);
                dialogUpdater.start();
            }
            if (this.m_ProgressCancelDialog != null && this.m_results == null) {
                try {
                    this.m_ProgressCancelDialog.show();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (this.m_queryThread != null) {
                object = this.m_queryThread;
                synchronized (object) {
                    if (this.m_cancellationRequested) {
                        this.m_queryThread = null;
                        return;
                    }
                }
            }
        }
    }

    public Object doTheQuery() {
        Object retval = null;
        if (this.m_receiver != null && this.m_strMethod != null) {
            Class[] parmClassArray = null;
            Object[] actualParmArray = null;
            try {
                if (this.m_requestInfo == null) {
                    Method callback = this.m_receiver.getClass().getMethod(this.m_strMethod, null);
                    retval = callback.invoke(this.m_receiver, null);
                } else {
                    parmClassArray = new Class[]{Object.class, MessageHandler.class};
                    actualParmArray = new Object[]{this.m_requestInfo, this.m_messages};
                    Method callback = this.m_receiver.getClass().getMethod(this.m_strMethod, parmClassArray);
                    retval = callback.invoke(this.m_receiver, actualParmArray);
                }
            }
            catch (NoSuchMethodException e) {
                MessageHandler.addStaticError(bundle.messageString("CommonUI.unableRegisterCallbackMethod.txt") + this.m_strMethod + "\n" + e.getMessage() + parmClassArray);
                MessageHandler.addStaticError(e);
            }
            catch (InvocationTargetException e) {
                MessageHandler.addStaticError(bundle.messageString("CommonUI.invokeError.fmt.txt", this.m_strMethod));
                MessageHandler.addStaticError(e);
            }
            catch (Exception e) {
                String extra = e.getMessage();
                if (extra == null) {
                    extra = e.toString();
                }
                MessageHandler.addStaticError(bundle.messageString("CommonUI.CallingCallbackMethod.txt") + this.m_strMethod + "\n" + extra + actualParmArray);
            }
        }
        return retval;
    }

    private Component getParentComponent(Component comp) {
        Component returnParentComponent = null;
        for (Component parent = comp; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JDialog) && !(parent instanceof Frame) || !parent.isVisible()) continue;
            returnParentComponent = parent;
            break;
        }
        return returnParentComponent;
    }

    private void setParent(Component parent) {
        Component tempParent;
        this.m_parentFrame = null;
        this.m_parentDialog = null;
        this.m_parentComponent = tempParent = this.getParentComponent(parent);
        if (tempParent instanceof JDialog) {
            this.m_parentDialog = (JDialog)tempParent;
        } else if (tempParent instanceof Frame) {
            this.m_parentFrame = (Frame)tempParent;
        }
    }

    static class ClipboardObserver
    implements ClipboardOwner {
        ClipboardObserver() {
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }

    class ProgressPingPongThread
    extends Thread {
        DataBaseUIRequest m_request;

        public ProgressPingPongThread(DataBaseUIRequest request) {
            this.m_request = request;
        }

        @Override
        public void run() {
            DataBaseQueryThread queryThread = this.m_request.m_queryThread;
            while (this.m_request.m_ProgressCancelDialog != null && !this.m_request.m_ProgressCancelDialog.isShowing()) {
                WindowUtil.sleep(100);
            }
            DataBaseProgressIndicator progIndicator = this.m_request.m_ProgressCancelDialog;
            int tickCount = 0;
            while (queryThread != null && queryThread.isAlive() && progIndicator != null && progIndicator.isShowing()) {
                ++tickCount;
                this.m_request.m_ProgressCancelDialog.showActivity();
                WindowUtil.sleep(100);
            }
        }
    }

    class DataBaseQueryThread
    extends Thread {
        DataBaseUIRequest m_request;

        public DataBaseQueryThread(DataBaseUIRequest request) {
            this.m_request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object results = this.m_request.doTheQuery();
            Object object = this;
            synchronized (object) {
                if (this.m_request.m_queryThread == this) {
                    this.m_request.m_results = results;
                }
            }
            object = this.m_request;
            synchronized (object) {
                if (DataBaseUIRequest.this.m_ProgressCancelDialog != null) {
                    WindowUtil.sleep(350);
                    DataBaseUIRequest.this.m_ProgressCancelDialog.dispose();
                    DataBaseUIRequest.this.m_ProgressCancelDialog = null;
                }
            }
        }
    }
}

