/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.visuals.FilterNodeView;
import com.sas.query.visuals.FilterTreeView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.ImageIcon;

class CutRegion
extends Rectangle {
    protected FilterNodeView m_targetView;
    static ImageIcon m_image = null;

    public CutRegion(FilterNodeView targetView) {
        this.m_targetView = targetView;
        Rectangle parentRect = this.m_targetView.getBounds();
        FilterNodeView childView = this.m_targetView.getAndNodeView();
        Rectangle childRect = childView.getBounds();
        int endX = childRect.x - 1;
        int pipeSize = 3;
        int midpointX = endX - FilterNodeView.INTER_NODE_AND_SPACE / 3 * 2;
        this.x = midpointX - pipeSize;
        this.y = childRect.y + 27 + pipeSize + 2;
        this.width = endX - midpointX;
        this.width = pipeSize * 3;
        this.height = Math.abs(parentRect.y - childRect.y);
        m_image = FilterTreeView.m_cutImage;
    }

    public void paint(Graphics g, Point mousePosition, Vector regions) {
        int lineHideHeight = 0;
        for (int index = 0; index < regions.size(); ++index) {
            CutRegion region = (CutRegion)regions.elementAt(index);
            if (region.equals(this) || region.x != this.x || region.y != this.y || region.height <= lineHideHeight || region.height >= this.height) continue;
            lineHideHeight = region.height;
        }
        g.setColor(Color.red);
        g.drawLine(this.x + 3 + 1, this.y + lineHideHeight - 2, this.x + 3 + 1, this.y + this.height - 4);
        if (m_image != null) {
            g.drawImage(m_image.getImage(), mousePosition.x + 8, mousePosition.y - 4, null);
        }
    }

    public FilterNodeView getTargetView() {
        return this.m_targetView;
    }
}

