/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.models.JoinList;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.ModelChangeListener;
import com.sas.query.models.PropertyChangeConstants;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.WindowUtil;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class CrossJoinWarningDialog
extends JDialog
implements ModelChangeListener,
PropertyChangeConstants {
    protected static QueryResource bundle = new QueryResource(CrossJoinWarningDialog.class);
    protected static Query m_query;
    protected static CrossJoinWarningDialog m_previousDialog;
    protected static boolean m_bWarningState;
    protected boolean m_bContinuePressed = false;

    public CrossJoinWarningDialog(Frame frame, Query query) {
        super(frame, bundle.getString("CrossJoinWarningDialog.Label.Title.txt"), true);
        if (m_query != null) {
            m_query.removePropertyListener(m_previousDialog);
        }
        query.addPropertyListener(this, 24);
        m_previousDialog = this;
        m_query = query;
        this._layoutWidgets();
        this.pack();
        WindowUtil.center(this);
    }

    public void onContinue() {
        this.m_bContinuePressed = true;
        this.dispose();
    }

    public void onCancel() {
        m_bWarningState = true;
        this.m_bContinuePressed = false;
        this.dispose();
    }

    public boolean isProcessCrossJoinCancelled() {
        if (this.isCrossJoinPerformed() && this.getWarningState()) {
            this.show();
            if (!this.m_bContinuePressed) {
                return true;
            }
        }
        return false;
    }

    public boolean isCrossJoinPerformed() {
        JoinList joinList = m_query.getJoins();
        boolean bCrossJoinOccured = false;
        int numOfJoinGroups = 0;
        for (int i = 0; i < joinList.size(); ++i) {
            if (!joinList.elementAt(i).getNewJoinGroupValue()) continue;
            ++numOfJoinGroups;
        }
        if (numOfJoinGroups > 1) {
            bCrossJoinOccured = true;
        }
        return bCrossJoinOccured;
    }

    public void setWarningState(boolean state) {
        m_bWarningState = state;
    }

    public boolean getWarningState() {
        return m_bWarningState;
    }

    public void _layoutWidgets() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(12, 12, 0, 0);
        UIDefaults defaults = UIManager.getDefaults();
        JLabel warningIcon = new JLabel(defaults.getIcon("OptionPane.warningIcon"));
        gridBagLayout.setConstraints(warningIcon, gbc);
        this.getContentPane().add(warningIcon);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(12, 15, 0, 10);
        JLabel messageLabel = new JLabel(bundle.messageString("CrossJoinWarningDialog.Message.PerformedCrossJoin.txt"));
        gridBagLayout.setConstraints(messageLabel, gbc);
        this.getContentPane().add(messageLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 15, 0, 0);
        JPanel panel = new JPanel();
        JButton continueButton = new JButton(bundle.messageString("Standard.ButtonLabel.Continue.txt"));
        JButton cancelButton = new JButton(bundle.messageString("Standard.ButtonLabel.Cancel.txt"));
        continueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CrossJoinWarningDialog.this.onContinue();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CrossJoinWarningDialog.this.onCancel();
            }
        });
        panel.add(continueButton);
        panel.add(cancelButton);
        gridBagLayout.setConstraints(panel, gbc);
        this.getContentPane().add(panel);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 15, 0, 0);
        JCheckBox checkBox = new JCheckBox(bundle.messageString("Message.Dialog.DontShowWarningAgain.txt"));
        checkBox.addItemListener(new CheckBoxListener());
        gridBagLayout.setConstraints(checkBox, gbc);
        this.getContentPane().add(checkBox);
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
        if (event.isStructureChange()) {
            this.setWarningState(true);
        }
    }

    static {
        m_bWarningState = true;
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                CrossJoinWarningDialog.this.setWarningState(false);
            } else {
                CrossJoinWarningDialog.this.setWarningState(true);
            }
        }
    }
}

