/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ButtonBar
extends JPanel {
    protected boolean m_equiSpaced;

    public boolean getEquiSpace() {
        return this.m_equiSpaced;
    }

    public void removeAllListeners() {
        this.removeAll();
    }

    public void setOutline(boolean bOutline) {
        if (bOutline) {
            this.setBorder(BorderFactory.createBevelBorder(1, SystemColor.controlLtHighlight, SystemColor.controlHighlight, SystemColor.controlDkShadow, SystemColor.controlShadow));
        } else {
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
    }

    public ButtonBar(int orientation, Vector components, Insets insets, boolean equalSpaced) {
        GridBagConstraints gbc;
        this.m_equiSpaced = equalSpaced;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        Enumeration e = components.elements();
        Object pushback = null;
        int i = 0;
        while (e.hasMoreElements()) {
            Object current;
            JComponent c = null;
            Component spacerComponent = null;
            boolean spacer = false;
            if (pushback == null) {
                current = e.nextElement();
            } else {
                current = pushback;
                pushback = null;
            }
            if (current instanceof Integer) {
                spacer = true;
                spacerComponent = orientation == 2 ? Box.createHorizontalStrut((Integer)current) : Box.createVerticalStrut((Integer)current);
            } else {
                c = (JComponent)current;
                if (this.getEquiSpace()) {
                    Vector<JComponent> groupGuys = new Vector<JComponent>();
                    groupGuys.addElement(c);
                    while (e.hasMoreElements()) {
                        current = e.nextElement();
                        if (current instanceof Component) {
                            groupGuys.addElement((JComponent)current);
                            continue;
                        }
                        pushback = current;
                        break;
                    }
                    c = new ButtonBarEquiSized(orientation, groupGuys, insets);
                }
            }
            gbc = new GridBagConstraints();
            if (orientation == 2) {
                gbc.gridx = i;
                gbc.gridy = 0;
                gbc.weighty = 1.0;
                gbc.anchor = 18;
                gbc.fill = 3;
            } else {
                gbc.gridx = 0;
                gbc.gridy = i;
                gbc.weightx = 1.0;
                gbc.anchor = 12;
                gbc.fill = 2;
            }
            if (spacer) {
                gbc.insets = new Insets(0, 0, 0, 0);
                gridBagLayout.setConstraints(spacerComponent, gbc);
                this.add(spacerComponent);
                spacer = false;
            } else {
                gbc.insets = insets;
                gridBagLayout.setConstraints(c, gbc);
                this.add(c);
            }
            ++i;
        }
        JPanel panel1Eater = new JPanel();
        gbc = new GridBagConstraints();
        if (orientation == 2) {
            gbc.gridx = components.size();
            gbc.gridy = 0;
        } else {
            gbc.gridx = 0;
            gbc.gridy = components.size();
        }
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 12;
        gbc.fill = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        gridBagLayout.setConstraints(panel1Eater, gbc);
        this.add(panel1Eater);
    }

    private class ButtonBarEquiSized
    extends JPanel {
        ButtonBarEquiSized(int orientation, Vector components, Insets insets) {
            if (orientation == 2) {
                this.setLayout(new GridLayout(1, components.size()));
            } else {
                this.setLayout(new GridLayout(components.size(), 1));
            }
            for (int i = 0; i < components.size(); ++i) {
                Component x = (Component)components.elementAt(i);
                this.add(x);
            }
        }
    }
}

