/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.visuals.BarNoun;
import com.sas.query.visuals.BarPart;
import com.sas.query.visuals.ImageHandler;
import com.sas.query.visuals.PopMenuItem;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.StandardView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;

public abstract class BarView
extends StandardView
implements ActionListener {
    static QueryResource bundle = new QueryResource(BarView.class);
    protected boolean m_bAllowArrangement = true;
    protected boolean m_bAllowBarEdit = true;
    protected JDialog m_singleEditor;
    protected JDialog m_totalEditor;
    protected JPanel m_partsPanel;
    protected JPanel m_scrollerPanel;
    protected JButton m_editButton;
    protected JButton m_leftButton;
    protected JButton m_rightButton;
    protected JLabel m_label;
    protected ImageIcon m_rightTornIcon = null;
    protected ImageIcon m_leftTornIcon = null;
    protected int m_selectedIndex = -1;
    protected JPopupMenu m_barPopmenu = null;
    protected JPopupMenu m_partPopmenu = null;
    protected Color m_nounBackground;
    protected Color m_nounForeground;
    protected Color m_verbForeground;
    protected Color m_nounSelectedBackground = Color.white;
    protected int m_minimumX = 12;
    protected int m_hitLocationType;
    protected static final int NOT_ON_A_PART = 1;
    protected static final int ON_PART = 2;
    protected Vector m_parts = new Vector();
    protected int m_additionalSpaceBeforeParts = 0;
    protected int m_firstVisiblePart = 0;
    protected int m_cFullyDisplayedParts = 0;
    protected boolean m_allowBarEditorButton = false;
    protected transient boolean m_fReadyToDrag = false;
    protected transient boolean m_bDragging = false;
    protected transient Dimension m_dragOffset;
    protected transient Point m_dragPoint = new Point(-1, -1);

    public BarView(Query query, String strLabel, Color nounBackground, Color partForeground) {
        super(query);
        this.m_nounBackground = nounBackground;
        this.m_nounForeground = partForeground;
        this.m_verbForeground = partForeground;
        this.addKeyListener(new KeyHandler());
        this.setBorder(BorderFactory.createBevelBorder(1, SystemColor.controlLtHighlight, SystemColor.controlHighlight, SystemColor.controlDkShadow, SystemColor.controlShadow));
        JPanel insetPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 4, 2, 4);
        gridBagLayout.setConstraints(insetPanel, gbc);
        this.add(insetPanel);
        insetPanel.setLayout(new BorderLayout());
        this.m_label = new JLabel(strLabel);
        this.m_label.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        insetPanel.add("West", this.m_label);
        this.m_partsPanel = new BarPanel();
        this.m_partsPanel.setLayout(new FlowLayout(0, 2, 0));
        insetPanel.add("Center", this.m_partsPanel);
        this.m_scrollerPanel = new JPanel();
        this.m_scrollerPanel.setLayout(new FlowLayout(0, 0, 0));
        insetPanel.add("East", this.m_scrollerPanel);
        this.m_rightTornIcon = ImageHandler.getImageIcon(bundle, "tornBarRightIcon");
        this.m_leftTornIcon = ImageHandler.getImageIcon(bundle, "tornBarLeftIcon");
        ImageIcon defaultIcon = ImageHandler.getImageIcon(bundle, "leftArrowIcon");
        if (defaultIcon != null && defaultIcon.getIconHeight() > 0) {
            this.m_leftButton = new JButton(defaultIcon);
            this.m_leftButton.setMargin(new Insets(0, 0, 0, 0));
        } else {
            this.m_leftButton = new JButton("<-");
        }
        this.m_leftButton.setFocusPainted(false);
        this.m_scrollerPanel.add(this.m_leftButton);
        this.m_leftButton.addActionListener(this);
        defaultIcon = ImageHandler.getImageIcon(bundle, "rightArrowIcon");
        if (defaultIcon != null && defaultIcon.getIconHeight() > 0) {
            this.m_rightButton = new JButton(defaultIcon);
            this.m_rightButton.setMargin(new Insets(0, 0, 0, 0));
        } else {
            this.m_rightButton = new JButton("->");
        }
        this.m_rightButton.setFocusPainted(false);
        this.m_scrollerPanel.add(this.m_rightButton);
        this.m_rightButton.addActionListener(this);
        defaultIcon = ImageHandler.getImageIcon(bundle, "dotsIcon");
        if (defaultIcon != null && defaultIcon.getIconHeight() > 0) {
            this.m_editButton = new JButton(defaultIcon);
            this.m_editButton.setMargin(new Insets(0, 0, 0, 0));
        } else {
            this.m_editButton = new JButton(bundle.getString("CommonUI.threeDotsForMore.txt"));
        }
        this.m_editButton.setFocusPainted(false);
        this.m_editButton.setVisible(this.hasEditor());
        this.m_scrollerPanel.add(this.m_editButton);
        this.m_scrollerPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        this.m_editButton.addActionListener(this);
    }

    public void setAllowArrangement(boolean bAllow) {
        this.m_bAllowArrangement = bAllow;
    }

    public boolean hasEditor() {
        return true;
    }

    public void showEditorButton(boolean value) {
        this.m_allowBarEditorButton = value;
        if (!value) {
            this.m_editButton.setVisible(value);
        } else {
            this.m_editButton.setVisible(this.hasEditor());
        }
    }

    public void setAllowBarEdit(boolean bAllow) {
        this.m_bAllowBarEdit = bAllow;
        this.m_editButton.setVisible(false);
    }

    protected JLabel getLabel() {
        return this.m_label;
    }

    protected void setGap(int gap) {
        this.m_additionalSpaceBeforeParts = gap;
        Border labelBorder = this.m_label.getBorder();
        if (labelBorder == null) {
            labelBorder = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        }
        Insets oldInsets = labelBorder.getBorderInsets(this.m_label);
        oldInsets.right = gap - oldInsets.right;
        this.m_label.setBorder(BorderFactory.createEmptyBorder(oldInsets.top, oldInsets.left, oldInsets.bottom, oldInsets.right));
    }

    public void addPart(BarPart part) {
        part.setBackground(this.m_nounBackground);
        if (part instanceof BarNoun) {
            part.setForeground(this.m_nounForeground);
        } else {
            part.setForeground(this.m_verbForeground);
        }
        part.setParent(this);
        this.m_parts.addElement(part);
    }

    public void removeAllParts() {
        this.m_parts.removeAllElements();
    }

    public boolean ensurePartIsSelected() {
        return this.getSelectedIndex() != -1 && this.getSelectedIndex() < this.getPartCount();
    }

    public BarPart getSelectedPart() {
        if (this.getSelectedIndex() == -1) {
            return null;
        }
        return (BarPart)this.m_parts.elementAt(this.getSelectedIndex());
    }

    public int getSelectedIndex() {
        return this.m_selectedIndex;
    }

    public void setSelectedPart(int index) {
        BarPart candidate;
        if (this.getSelectedIndex() > -1 && this.getSelectedIndex() < this.getPartCount()) {
            this.getSelectedPart().setBackground(this.m_nounBackground);
            this.getSelectedPart().setForeground(this.m_nounForeground);
        }
        if (index != -1 && !(candidate = (BarPart)this.m_parts.elementAt(index)).isFocusTraversable()) {
            index = this.nearestFocusTraversableIndex(index);
        }
        this.m_selectedIndex = index;
        if (this.getSelectedIndex() != -1) {
            this.getSelectedPart().setBackground(this.m_nounSelectedBackground);
            this.getSelectedPart().setForeground(Color.black);
        }
        this.repaint();
    }

    public JPopupMenu getBarPopmenu() {
        if (this.m_barPopmenu == null) {
            // empty if block
        }
        return this.m_barPopmenu;
    }

    public void setBarPopmenu(JPopupMenu menu) {
        this.m_barPopmenu = menu;
    }

    public JPopupMenu getPartPopmenu() {
        if (this.m_partPopmenu == null) {
            this.m_partPopmenu = new JPopupMenu("BarViewMenu");
            this.m_partPopmenu.add(new PopMenuItem(bundle.getString("Common.Edit....txt"), "onEdit", this));
            this.m_partPopmenu.add(new PopMenuItem(bundle.getString("Common.Delete.txt"), "onDelete", this));
        }
        return this.m_partPopmenu;
    }

    public void setPartPopmenu(JPopupMenu menu) {
        this.m_partPopmenu = menu;
    }

    public void onEditBar() {
    }

    public abstract void onEdit();

    public abstract void onInsert();

    public void onDelete() {
        if (this.getSelectedIndex() >= this.getPartCount()) {
            if (this.getPartCount() <= 0) {
                this.setSelectedPart(-1);
            } else {
                this.setSelectedPart(this.previousFocusablePart(this.getPartCount() + 1));
            }
        } else if (this.getPartCount() > 0) {
            this.setSelectedPart(this.getSelectedIndex());
        } else {
            this.setSelectedPart(-1);
        }
    }

    public void onAction() {
        this.onEdit();
    }

    public void onScrollLeft() {
        int lastPart = this.m_firstVisiblePart;
        while (lastPart < this.m_firstVisiblePart + this.m_cFullyDisplayedParts - 1 && this.m_firstVisiblePart != 0) {
            this.m_firstVisiblePart = Math.max(0, this.m_firstVisiblePart - 1);
            this.repaint();
        }
    }

    public void onScrollRight() {
        int delta = this.m_cFullyDisplayedParts - 1;
        for (int index = 0; index < delta; ++index) {
            this.m_firstVisiblePart = Math.min(this.getPartCount() - 1, this.m_firstVisiblePart + 1);
            this.repaint();
        }
    }

    public abstract void onMovePart(int var1, int var2);

    @Override
    public abstract void modelChangeCallback(ModelChangeEvent var1);

    public void repositionParts() {
        boolean bNeedScrollButtons;
        int offset = this.m_minimumX;
        this.m_cFullyDisplayedParts = 0;
        for (int index = this.m_firstVisiblePart; index < this.m_parts.size(); ++index) {
            BarPart part = (BarPart)this.m_parts.elementAt(index);
            if (part.height == 0) {
                Dimension size = part.getPreferredSize();
                part.setSize(size);
            }
            part.x = offset;
            if ((offset += part.width + 2) >= this.m_partsPanel.getBounds().width) continue;
            ++this.m_cFullyDisplayedParts;
        }
        boolean bl = bNeedScrollButtons = this.m_firstVisiblePart != 0;
        if (offset > this.m_partsPanel.getBounds().width && this.m_parts.size() > 0) {
            bNeedScrollButtons = true;
        }
        this.m_leftButton.setVisible(bNeedScrollButtons);
        this.m_rightButton.setVisible(bNeedScrollButtons);
        if (bNeedScrollButtons) {
            this.m_leftButton.setEnabled(true);
            this.m_rightButton.setEnabled(true);
            if (this.m_firstVisiblePart == 0) {
                this.m_leftButton.setEnabled(false);
            }
            if (offset < this.m_partsPanel.getBounds().width) {
                this.m_rightButton.setEnabled(false);
            }
            this.m_leftButton.setToolTipText(bundle.messageString("BarView.NumberHiddenMessage.fmt.txt", new Integer(this.m_firstVisiblePart)));
            this.m_rightButton.setToolTipText(bundle.messageString("BarView.NumberHiddenMessage.fmt.txt", new Integer(this.m_parts.size() - (this.m_firstVisiblePart + this.m_cFullyDisplayedParts))));
        }
    }

    @Override
    public void paint(Graphics g) {
        this.repositionParts();
        super.paint(g);
    }

    public int getPartCount() {
        return this.m_parts.size();
    }

    public BarPart getPartAtLocation(int nLocation) {
        if (nLocation >= this.m_parts.size()) {
            return null;
        }
        return (BarPart)this.m_parts.elementAt(nLocation);
    }

    public int getLocationForPart(BarPart part) {
        for (int index = 0; index < this.m_parts.size(); ++index) {
            if (this.m_parts.elementAt(index) != part) continue;
            return index;
        }
        return -1;
    }

    private int previousFocusablePart(int currentSel) {
        if (currentSel > this.m_parts.size()) {
            currentSel = this.m_parts.size();
        }
        for (int whoGetsFocus = currentSel - 1; whoGetsFocus >= 0; --whoGetsFocus) {
            BarPart candidate = (BarPart)this.m_parts.elementAt(whoGetsFocus);
            if (!candidate.isFocusTraversable()) continue;
            return whoGetsFocus;
        }
        return currentSel;
    }

    private int nearestFocusTraversableIndex(int target) {
        int next = this.nextFocusablePart(target);
        int prev = this.previousFocusablePart(target);
        if (next == target) {
            return prev;
        }
        if (prev == target) {
            return next;
        }
        if (next - target > target - prev) {
            return prev;
        }
        return next;
    }

    private int nextFocusablePart(int currentSel) {
        for (int whoGetsFocus = currentSel + 1; whoGetsFocus < this.m_parts.size(); ++whoGetsFocus) {
            BarPart candidate = (BarPart)this.m_parts.elementAt(whoGetsFocus);
            if (!candidate.isFocusTraversable()) continue;
            return whoGetsFocus;
        }
        return currentSel;
    }

    public void moveFocusLeft() {
        for (int index = 1; index < this.m_parts.size(); ++index) {
            if (this.m_parts.elementAt(index) != this.getSelectedPart()) continue;
            this.setSelectedPart(this.previousFocusablePart(index));
            return;
        }
    }

    public void moveFocusRight() {
        for (int index = 0; index < this.m_parts.size() - 1; ++index) {
            if (this.m_parts.elementAt(index) != this.getSelectedPart()) continue;
            this.setSelectedPart(this.nextFocusablePart(index));
            return;
        }
    }

    protected void _dragPart(Point point) {
        this.m_dragPoint = point;
        Graphics g = this.getGraphics();
        if (g != null) {
            this.paint(g);
        }
    }

    protected void _dropPart() {
        int newIndex = this._getNewIndexForDragPart();
        if (this.getSelectedIndex() < newIndex) {
            --newIndex;
        }
        this.onMovePart(this.getSelectedIndex(), newIndex);
        if (this.getSelectedIndex() > newIndex) {
            this.setSelectedPart(newIndex);
        } else {
            this.setSelectedPart(this.previousFocusablePart(newIndex));
        }
    }

    protected void _cancelCurrentAction() {
        this.m_bDragging = false;
        this.m_fReadyToDrag = false;
        this.repaint();
    }

    public void refresh() {
        if (this.getParent() == null) {
            return;
        }
        if (!this.isShowing()) {
            return;
        }
        if (this.getGraphics() != null) {
            if (this.getParent().getParent() == null) {
                return;
            }
            if (this.getParent().getParent().isValid()) {
                this.repaint();
            } else if (this.getParent().getParent() != null) {
                this.getParent().getParent().validate();
                this.getParent().getParent().repaint();
            }
        }
    }

    protected int _getNewIndexForDragPart() {
        int nSelectedPartDragIndex = this.getPartCount();
        int offset = this.m_minimumX;
        for (int index = 0; index < this.m_parts.size(); ++index) {
            BarPart part = (BarPart)this.m_parts.elementAt(index);
            if (this.m_dragPoint.x >= (offset += part.width + 2) || this.m_dragPoint.x - offset >= part.width / 2) continue;
            nSelectedPartDragIndex = index;
            nSelectedPartDragIndex = Math.max(0, nSelectedPartDragIndex);
            break;
        }
        if (nSelectedPartDragIndex == this.getPartCount() && this.getSelectedIndex() == this.getPartCount() - 1) {
            return this.getSelectedIndex();
        }
        if (nSelectedPartDragIndex == this.getSelectedIndex() + 1) {
            BarPart partToRight = this.getPartAtLocation(nSelectedPartDragIndex);
            if (this.m_dragPoint.x - partToRight.x > partToRight.width / 2) {
                return nSelectedPartDragIndex + 1;
            }
            return this.getSelectedIndex();
        }
        return nSelectedPartDragIndex;
    }

    private BarPart _internalHitTest(Point point) {
        this.m_hitLocationType = 1;
        if (this.m_firstVisiblePart < 0) {
            return null;
        }
        if (this.m_firstVisiblePart >= this.m_parts.size()) {
            return null;
        }
        Point offsetPoint = new Point(point);
        BarPart firstPart = (BarPart)this.m_parts.elementAt(this.m_firstVisiblePart);
        offsetPoint.x += firstPart.x;
        for (int index = this.m_firstVisiblePart; index < this.m_parts.size(); ++index) {
            BarPart part = (BarPart)this.m_parts.elementAt(index);
            if (!part.contains(point)) continue;
            this.m_hitLocationType = 2;
            return part;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_editButton) {
            this.onEditBar();
        } else if (event.getSource() == this.m_leftButton) {
            this.onScrollLeft();
        } else if (event.getSource() == this.m_rightButton) {
            this.onScrollRight();
        }
    }

    class BarPanel
    extends JPanel {
        BarPanel() {
            this.addFocusListener(new FocusHandler());
            this.addKeyListener(new KeyHandler());
            this.addMouseListener(new MouseHandler());
            this.addMouseMotionListener(new MouseMotionHandler());
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (BarView.this.m_bDragging) {
                Rectangle newPositionRect;
                int nSelectedPartDragIndex = BarView.this._getNewIndexForDragPart();
                g.setColor(Color.white);
                Rectangle selectedRect = BarView.this.getSelectedPart().getBounds();
                if (nSelectedPartDragIndex < BarView.this.getSelectedIndex()) {
                    selectedRect.x += BarView.this.getSelectedPart().width + 2;
                }
                g.drawString(BarView.this.getSelectedPart().getDisplayString(), selectedRect.x + 7, selectedRect.y + selectedRect.height - 7);
                g.setColor(Color.black);
                if (nSelectedPartDragIndex >= BarView.this.getPartCount()) {
                    Rectangle lastRect = BarView.this.getPartAtLocation(BarView.this.getPartCount() - 1).getBounds();
                    newPositionRect = new Rectangle(lastRect.x + lastRect.width + 2, lastRect.y, BarView.this.getSelectedPart().width - 1, BarView.this.getSelectedPart().height - 1);
                } else {
                    newPositionRect = BarView.this.getPartAtLocation(nSelectedPartDragIndex).getBounds();
                    newPositionRect.width = BarView.this.getSelectedPart().width;
                }
                newPositionRect.grow(-1, -1);
                g.drawRect(newPositionRect.x, newPositionRect.y, newPositionRect.width, newPositionRect.height);
                newPositionRect.grow(-1, -1);
                g.drawRect(newPositionRect.x, newPositionRect.y, newPositionRect.width, newPositionRect.height);
                BarPart selectedPart = BarView.this.getSelectedPart();
                selectedPart.x = BarView.this.m_dragPoint.x - BarView.this.m_dragOffset.width;
                selectedPart.x = Math.max(selectedPart.x, BarView.this.m_minimumX);
                if (nSelectedPartDragIndex != BarView.this.getSelectedIndex()) {
                    for (int index = nSelectedPartDragIndex; index < BarView.this.m_parts.size(); ++index) {
                        BarPart part = (BarPart)BarView.this.m_parts.elementAt(index);
                        if (index == BarView.this.getSelectedIndex()) continue;
                        part.x += selectedPart.width + 2;
                    }
                }
            }
            int nMaxPart = Math.min(BarView.this.m_parts.size(), BarView.this.m_firstVisiblePart + BarView.this.m_cFullyDisplayedParts + 1);
            for (int index = BarView.this.m_firstVisiblePart; index < nMaxPart; ++index) {
                BarPart part = (BarPart)BarView.this.m_parts.elementAt(index);
                Graphics clippedG = g.create();
                Shape oldClip = clippedG.getClip();
                Dimension size = this.getSize();
                clippedG.setClip(0, 0, size.width, size.height);
                part.paint(clippedG);
                if (oldClip != null) {
                    clippedG.setClip(oldClip);
                }
                clippedG.dispose();
            }
            if (nMaxPart != BarView.this.m_parts.size() && BarView.this.m_rightTornIcon != null) {
                g.drawImage(BarView.this.m_rightTornIcon.getImage(), this.getWidth() - BarView.this.m_rightTornIcon.getIconWidth(), 0, BarView.this.m_rightTornIcon.getIconWidth(), this.getHeight(), this);
            }
            if (BarView.this.m_firstVisiblePart != 0 && BarView.this.m_leftTornIcon != null) {
                g.drawImage(BarView.this.m_leftTornIcon.getImage(), BarView.this.m_minimumX, 0, BarView.this.m_leftTornIcon.getIconWidth(), this.getHeight(), this);
            }
            if (BarView.this.m_bDragging && BarView.this.getSelectedPart() != null) {
                BarView.this.getSelectedPart().paint(g);
            }
        }
    }

    class FocusHandler
    extends FocusAdapter {
        FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (BarView.this.getSelectedPart() != null) {
                BarView.this.getSelectedPart().setBackground(BarView.this.m_nounSelectedBackground);
                BarView.this.getSelectedPart().repaint();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (BarView.this.getSelectedPart() != null) {
                BarView.this.getSelectedPart().setBackground(BarView.this.m_nounSelectedBackground.darker());
                BarView.this.getSelectedPart().repaint();
            }
        }
    }

    class MouseMotionHandler
    extends MouseMotionAdapter {
        MouseMotionHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            Point point = event.getPoint();
            if (BarView.this.m_fReadyToDrag && (Math.abs(BarView.this.m_dragPoint.x - point.x) > 2 || Math.abs(BarView.this.m_dragPoint.x - point.x) > 2)) {
                BarView.this.m_dragOffset = new Dimension(BarView.this.m_dragPoint.x - BarView.this.getSelectedPart().x, BarView.this.m_dragPoint.y - BarView.this.getSelectedPart().y);
                BarView.this.m_bDragging = true;
                BarView.this.m_fReadyToDrag = false;
            }
            if (BarView.this.m_bDragging) {
                BarView.this._dragPart(point);
            }
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            BarPart source = BarView.this._internalHitTest(event.getPoint());
            if (BarView.this.m_hitLocationType == 2) {
                BarView.this.requestFocus();
                BarView.this.setSelectedPart(BarView.this.getLocationForPart(source));
                if (BarView.this.m_bAllowArrangement) {
                    BarView.this.m_fReadyToDrag = true;
                    BarView.this.m_dragPoint = event.getPoint();
                }
                if (event.getClickCount() == 2) {
                    if ((event.getModifiers() & 4) == 0) {
                        BarView.this.onAction();
                        return;
                    }
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if ((event.getModifiers() & 4) != 0) {
                JPopupMenu popmenu = null;
                if (BarView.this.m_hitLocationType == 2) {
                    popmenu = BarView.this.getPartPopmenu();
                } else if (event.getSource() instanceof BarPanel) {
                    popmenu = BarView.this.getBarPopmenu();
                }
                if (popmenu != null) {
                    JComponent source = (JComponent)event.getSource();
                    source.add(popmenu);
                    popmenu.show(source, event.getX(), event.getY());
                    return;
                }
            } else if (BarView.this.m_bDragging) {
                BarView.this._dropPart();
            }
            BarView.this._cancelCurrentAction();
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            switch (event.getKeyCode()) {
                case 27: {
                    BarView.this._cancelCurrentAction();
                    break;
                }
                case 127: {
                    if (!BarView.this.ensurePartIsSelected()) break;
                    BarView.this.onDelete();
                    break;
                }
                case 40: {
                    if (!BarView.this.ensurePartIsSelected() || event.isControlDown()) break;
                    BarView.this.moveFocusRight();
                    break;
                }
                case 38: {
                    if (!BarView.this.ensurePartIsSelected() || event.isControlDown()) break;
                    BarView.this.moveFocusLeft();
                    break;
                }
                case 37: {
                    if (!BarView.this.ensurePartIsSelected()) break;
                    BarView.this.moveFocusLeft();
                    break;
                }
                case 39: {
                    if (!BarView.this.ensurePartIsSelected() || event.isControlDown()) break;
                    BarView.this.moveFocusRight();
                    break;
                }
                case 10: {
                    BarView.this.onAction();
                    break;
                }
                case 34: {
                    break;
                }
                case 33: {
                    break;
                }
                case 36: {
                    BarView.this.setSelectedPart(BarView.this.nextFocusablePart(-1));
                    break;
                }
                case 35: {
                    BarView.this.setSelectedPart(BarView.this.previousFocusablePart(99999));
                    break;
                }
            }
        }
    }
}

