/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.BarPart;
import com.sas.query.visuals.DrawUtil;
import com.sas.query.visuals.QueryResource;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.lang.reflect.Method;

class BarNoun
extends BarPart {
    protected Object m_data;
    protected Method m_displayMethod;
    protected static QueryResource bundle = new QueryResource(BarNoun.class);

    public BarNoun(Object data, Method displayMethod) {
        this.m_data = data;
        this.m_displayMethod = displayMethod;
        this.refresh();
    }

    public void refresh() {
        try {
            this.m_displayString = (String)this.m_displayMethod.invoke(this.m_data, null);
        }
        catch (Exception e) {
            MessageHandler.addStaticError(bundle.messageString("BarNoun.getLabelBarnounerror.fmt.txt", e.getMessage()));
        }
    }

    @Override
    Object getData() {
        return this.m_data;
    }

    @Override
    public void paint(Graphics g) {
        Rectangle rect = this.getBounds();
        DrawUtil.draw3DBox(g, this.getParent().getBackground(), Color.white, Color.darkGray, this.x, this.y, rect.width - 1, rect.height - 1);
        DrawUtil.draw3DBox(g, this.getBackground(), Color.darkGray, Color.white, this.x + 3, this.y + 3, rect.width - 7, rect.height - 7);
        g.setColor(this.getForeground());
        Graphics stringG = g.create();
        Shape clip = stringG.getClip();
        if (clip != null) {
            Rectangle newClip = new Rectangle(this.x, this.y, this.width - 7, this.height);
            stringG.setClip(clip.getBounds().intersection(newClip));
            stringG.drawString(this.m_displayString, this.x + 7, this.y + rect.height - 7);
            stringG.setClip(clip);
        }
        stringG.dispose();
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }
}

