/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.visuals;

import com.sas.query.Query;
import com.sas.query.models.JDataSourceTree;
import com.sas.query.visuals.JDataSourceTreeView;
import com.sas.query.visuals.QueryResource;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;

public class AddTableDialog
extends JDialog {
    protected Query m_query;
    protected Frame m_parentFrame;
    protected JDataSourceTreeView m_dataSourceTreeView;
    protected boolean m_bDisplayColumns = false;
    protected String m_strTitle;
    protected String m_strActionLabel;
    protected String m_strCancelLabel;
    static QueryResource bundle = new QueryResource(AddTableDialog.class);

    public AddTableDialog(Frame parentFrame, boolean bModalFlag, boolean bDisplayColumns) {
        super(parentFrame, " ", bModalFlag);
        this.m_bDisplayColumns = bDisplayColumns;
    }

    public AddTableDialog(Query query, Frame parentFrame) {
        super(parentFrame, " ", true);
        this.m_parentFrame = parentFrame;
        this.m_query = query;
        this._initialization();
        this._layoutWidgets();
        this.setSize(345, 340);
    }

    protected void _initialization() {
        this.m_strTitle = bundle.getString("AddTableDialog.Title.txt");
        this.m_strActionLabel = bundle.getString("Common.Add.txt");
        this.m_strCancelLabel = bundle.getString("Common.Close.txt");
        JDataSourceTree m_metadataModel = new JDataSourceTree(this.m_query, this.m_query.getDataSource(), this.m_bDisplayColumns);
        this.m_dataSourceTreeView = new JDataSourceTreeView(this.m_query, m_metadataModel);
    }

    public void _layoutWidgets() {
        this.setResizable(true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(16, 12, 12, 10);
        gridBagLayout.setConstraints(this.m_dataSourceTreeView, gbc);
        this.getContentPane().add(this.m_dataSourceTreeView);
        JButton addButton = new JButton(this.m_strActionLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 12;
        gbc.fill = 2;
        gbc.insets = new Insets(16, 8, 0, 12);
        gridBagLayout.setConstraints(addButton, gbc);
        this.getContentPane().add(addButton);
        addButton.addActionListener(new OkButtonHandler());
        JButton closeButton = new JButton(this.m_strCancelLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 12;
        gbc.fill = 0;
        gbc.insets = new Insets(8, 8, 8, 12);
        gridBagLayout.setConstraints(closeButton, gbc);
        this.getContentPane().add(closeButton);
        closeButton.addActionListener(new DialogCloser(this));
        this.setTitle(this.m_strTitle);
        this.setBounds(100, 100, 270, 340);
        this.addWindowListener(new DialogCloser(this));
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_dataSourceTreeView.closing();
    }

    protected static final class DialogCloser
    extends WindowAdapter
    implements ActionListener {
        JDialog m_dialog;

        DialogCloser(JDialog dialog) {
            this.m_dialog = dialog;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.m_dialog.dispose();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.m_dialog.dispose();
        }
    }

    protected class OkButtonHandler
    implements ActionListener {
        OkButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            AddTableDialog.this.m_dataSourceTreeView.onAction();
        }
    }
}

