/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.parser;

import com.sas.query.Query;
import com.sas.query.datasources.DataSourceTable;
import com.sas.query.models.Table;
import com.sas.query.parser.ParserException;
import com.sas.query.parser.Token;
import com.sas.query.parser.TokenConstants;
import com.sas.query.parser.TokenList;
import com.sas.query.parser.Tokenizer;

public class TransientFromClauseToken
implements TokenConstants {
    protected Token m_token;
    protected int m_priority = -1;
    protected String m_alias = null;

    public TransientFromClauseToken(Token token) {
        this.m_token = token;
    }

    public String toString() {
        if (this.m_token != null) {
            return this.m_token.toString();
        }
        return "null";
    }

    public Token getToken() {
        return this.m_token;
    }

    public void setPriority(int i) {
        this.m_priority = i;
    }

    public int getPriority() {
        return this.m_priority;
    }

    public boolean hasAlias() {
        return this.m_alias != null;
    }

    public String getAlias() {
        if (this.m_alias == null) {
            return "";
        }
        return this.m_alias;
    }

    public void setAlias(String alias) {
        this.m_alias = alias;
    }

    public boolean isTable() {
        return this.m_token.isType(1, 72);
    }

    private boolean isLogicalTable() {
        return this.m_token.isType(1, 71);
    }

    public DataSourceTable getTable() {
        if (!this.isTable()) {
            if (this.isLogicalTable()) {
                Table logTable = (Table)this.m_token.getData();
                DataSourceTable dsTable = logTable.getDataSourceTable();
                return dsTable;
            }
            return null;
        }
        return (DataSourceTable)this.m_token.getData();
    }

    public boolean isLeftParen() {
        return this.m_token.isType(13, 36);
    }

    public boolean isRightParen() {
        return this.m_token.isType(13, 37);
    }

    public boolean isJoin() {
        return this.m_token.isKeyword("JOIN");
    }

    public boolean isOn() {
        return this.m_token.isKeyword("ON");
    }

    public boolean isUsing() {
        return this.m_token.isKeyword("USING");
    }

    public boolean isAs() {
        return this.m_token.isKeyword("AS");
    }

    public boolean isJoinCondition() {
        if (this.isOn()) {
            return true;
        }
        return this.isUsing();
    }

    public Table addToQuery(Query query, TokenList completeFromClause) throws ParserException {
        Table retVal = query.addTable(this.getTable());
        if (retVal == null) {
            throw new ParserException("Table not found:  " + this.toString());
        }
        if (this.hasAlias()) {
            retVal.setCorrelationName(this.getAlias());
        }
        Tokenizer.resolveTables(completeFromClause, query);
        Tokenizer.resolveColumns(completeFromClause, query);
        return retVal;
    }
}

