/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.parser;

import com.sas.query.Query;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.DataSourceContainer;
import com.sas.query.datasources.DataSourceContainerList;
import com.sas.query.datasources.DataSourceTable;
import com.sas.query.datasources.Function;
import com.sas.query.datasources.FunctionList;
import com.sas.query.datasources.Operator;
import com.sas.query.datasources.SqlProperties;
import com.sas.query.models.Column;
import com.sas.query.models.ColumnList;
import com.sas.query.models.ColumnStar;
import com.sas.query.models.ExpressionConstants;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.Table;
import com.sas.query.models.TableList;
import com.sas.query.parser.Token;
import com.sas.query.parser.TokenConstants;
import com.sas.query.parser.TokenList;
import com.sas.query.visuals.QueryResource;
import java.util.Stack;

public class Tokenizer
implements TokenConstants,
ExpressionConstants {
    public static final String STANDARD_KEYWORDS = ",SELECT,FROM,WHERE,HAVING,GROUP,ORDER,BY,ASC,DESC,AS,AND,OR,NOT,IS,NULL,DISTINCT,ALL,USING,ON,JOIN,UNION,CROSS,NATURAL,INNER,LEFT,OUTER,RIGHT,FULL,EXISTS,INTERSECT,EXCEPT,CORRESPONDING,LABEL,FORMAT,INFORMAT,MISSING,";
    protected static QueryResource bundle = new QueryResource(Tokenizer.class);
    protected DataSource m_dataSource;
    protected SqlProperties m_properties;
    protected String m_strInput;
    protected MessageHandler m_messages;
    protected int m_offset = 0;
    protected boolean m_bNextCharAlreadyPeeked = false;
    protected char m_peekedChar;
    protected String m_keywordList;
    protected FunctionList m_functionList;
    protected FunctionList m_operatorList;
    protected String m_identifierQuoteStart;
    protected String m_identifierQuoteEnd;

    public Tokenizer(DataSource dataSource, String strInput, MessageHandler messages) {
        this.m_dataSource = dataSource;
        this.m_properties = dataSource.getProperties();
        this.m_strInput = strInput;
        this.m_messages = messages;
        this.m_keywordList = STANDARD_KEYWORDS + this.m_dataSource.getProperties().getSqlKeywords() + ",";
        this.m_keywordList = this.m_keywordList.toUpperCase();
        this.m_functionList = this.m_dataSource.getProperties().getAllFunctions();
        this.m_operatorList = this.m_functionList.getSubsetByFunctionType(12).getSubsetByPrimaryParmType(65535).getSubsetByNumParms(2).getSubsetByReturnType(65535);
        this.m_identifierQuoteStart = this.m_properties.getIdentifierQuoteStart();
        this.m_identifierQuoteEnd = this.m_properties.getIdentifierQuoteEnd();
    }

    public TokenList getTokens() {
        Token token;
        TokenList tokenList = new TokenList(this.m_strInput);
        while ((token = this.getNextToken()) != null) {
            tokenList.addElement(token);
        }
        this._resolveTokens(tokenList);
        this._resolvePairedTokens(tokenList);
        this._findMatchingParens(tokenList);
        return tokenList;
    }

    public TokenList getSimpleTokens() {
        Token token;
        TokenList tokenList = new TokenList(this.m_strInput);
        while ((token = this.getNextToken()) != null) {
            tokenList.addElement(token);
        }
        return tokenList;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Token getNextToken() {
        FunctionList functionList;
        Token newToken;
        block33: {
            char nextChar;
            block35: {
                block34: {
                    int specialIndex;
                    newToken = new Token(this);
                    newToken.setStart(this.getOffset());
                    do {
                        if ((nextChar = this.getNextChar()) == '\u0000') {
                            if (newToken.getStart() == this.getOffset() - 1) {
                                return null;
                            }
                            newToken.setEnd(this.getOffset() - 1);
                            break block33;
                        }
                        if (Character.isWhitespace(nextChar)) {
                            if (newToken.getStart() + 1 != this.getOffset()) {
                                newToken.setEnd(this.getOffset() - 1);
                                break block33;
                            }
                            newToken.setStart(this.getOffset());
                        }
                        if (nextChar == '\'' || nextChar == '\"') {
                            if (newToken.getStart() + 1 == this.getOffset()) break block34;
                            newToken.setEnd(this.getOffset() - 1);
                            this.pushBackLastChar();
                            break block33;
                        }
                        if (this.m_identifierQuoteStart.length() <= 0 || nextChar != this.m_identifierQuoteStart.charAt(0)) continue;
                        if (newToken.getStart() + 1 == this.getOffset()) break block35;
                        newToken.setEnd(this.getOffset() - 1);
                        this.pushBackLastChar();
                        break block33;
                    } while ((specialIndex = "\"%&'()*+,-./:;<=>?|{}^!~".indexOf(nextChar)) == -1);
                    if (newToken.getStart() + 1 != this.getOffset()) {
                        newToken.setEnd(this.getOffset() - 1);
                        this.pushBackLastChar();
                        break block33;
                    } else {
                        newToken.setEnd(this.getOffset());
                        newToken.setType(13);
                        newToken.setSubType(specialIndex + 32);
                    }
                    break block33;
                }
                char startingQuote = nextChar;
                do {
                    if ((nextChar = this.getNextChar()) != '\u0000') continue;
                    if (newToken.getStart() != this.getOffset()) {
                        newToken.setEnd(this.getOffset() - 1);
                        this.m_messages.addError(bundle.messageString("NoMatchingQuoteFound.fmt.txt", newToken));
                        return newToken;
                    }
                    return null;
                } while (nextChar != startingQuote || (nextChar = this.getNextChar()) == startingQuote);
                if (nextChar != 'n') {
                    this.pushBackLastChar();
                }
                if (nextChar == 'n') {
                    newToken.setType(1);
                } else {
                    newToken.setType(8);
                }
                newToken.setEnd(this.getOffset());
                break block33;
            }
            do {
                if ((nextChar = this.getNextChar()) != '\u0000') continue;
                if (newToken.getStart() != this.getOffset()) {
                    newToken.setEnd(this.getOffset());
                    this.m_messages.addError(bundle.messageString("NoMatchingQuoteFound.fmt.txt", newToken));
                    return newToken;
                }
                return null;
            } while (nextChar != this.m_identifierQuoteEnd.charAt(0));
            newToken.setStart(newToken.getStart() + this.m_identifierQuoteStart.length());
            newToken.setEnd(this.getOffset() - this.m_identifierQuoteEnd.length());
            newToken.setType(1);
        }
        FunctionList operatorList = this.m_operatorList.getSubsetByName(newToken.toString());
        if (operatorList.size() > 0) {
            newToken.setType(22);
            newToken.setSubType(0);
            newToken.setData((Operator)operatorList.elementAt(0));
        }
        if (newToken.getType() == 0) {
            String strTest = "," + newToken.toString() + ",";
            if (this.m_keywordList.indexOf(strTest = strTest.toUpperCase()) != -1) {
                boolean isNormalKeyword = true;
                if (newToken.preceedingChar() != '\u0000' && newToken.preceedingChar() == '.') {
                    isNormalKeyword = false;
                }
                if (newToken.succeedingChar() != '\u0000' && newToken.succeedingChar() == '.') {
                    isNormalKeyword = false;
                }
                if ("LEFT".equalsIgnoreCase(newToken.toString()) && newToken.succeedingChar() != '\u0000' && newToken.succeedingChar() == '(') {
                    isNormalKeyword = false;
                }
                if (isNormalKeyword) {
                    newToken.setType(2);
                }
            }
        }
        if (newToken.getType() == 0 && (functionList = this.m_functionList.getSubsetByName(newToken.toString().toUpperCase())).size() > 0) {
            if (functionList.elementAt(0) instanceof Operator) {
                newToken.setType(22);
            } else {
                newToken.setType(21);
            }
            newToken.setData(functionList.elementAt(0));
        }
        if (newToken.isType(0) || newToken.isType(1) || newToken.isType(21) || newToken.isType(8) && this.m_identifierQuoteStart.charAt(0) == '\"') {
            String testName = newToken.getUnquotedString();
            if (this.m_dataSource.getHasMultipleLayers()) {
                DataSourceContainer container = null;
                DataSourceContainerList list = this.m_dataSource.getItems();
                for (int index = 0; index < list.size(); ++index) {
                    if (!list.elementAt(index).getName().equalsIgnoreCase(testName)) continue;
                    container = list.elementAt(index);
                    break;
                }
                if (container != null) {
                    if (newToken.isFunctionName()) {
                        char peekAtNextChar = this.getNextChar();
                        this.pushBackLastChar();
                        if (peekAtNextChar != '(') {
                            newToken.setType(1);
                            newToken.setSubType(73);
                            newToken.setData(container);
                        }
                    } else {
                        newToken.setType(1);
                        newToken.setSubType(73);
                        newToken.setData(container);
                    }
                }
            }
        }
        if (newToken.toString().equalsIgnoreCase("Calculated") && this.m_dataSource.getDatabaseProductName().equalsIgnoreCase("SAS")) {
            return this.getNextToken();
        }
        return newToken;
    }

    protected void pushBackLastChar() {
        --this.m_offset;
    }

    protected char getNextChar() {
        if (this.m_bNextCharAlreadyPeeked) {
            ++this.m_offset;
            this.m_bNextCharAlreadyPeeked = false;
            return this.m_peekedChar;
        }
        try {
            char returnChar = this.m_strInput.charAt(this.m_offset);
            ++this.m_offset;
            return returnChar;
        }
        catch (StringIndexOutOfBoundsException e) {
            ++this.m_offset;
            return '\u0000';
        }
    }

    protected char peekNextChar() {
        if (this.m_bNextCharAlreadyPeeked) {
            return this.m_peekedChar;
        }
        this.m_bNextCharAlreadyPeeked = true;
        try {
            this.m_peekedChar = this.m_strInput.charAt(this.m_offset);
        }
        catch (StringIndexOutOfBoundsException e) {
            this.m_peekedChar = '\u0000';
        }
        return this.m_peekedChar;
    }

    protected int getOffset() {
        return this.m_offset;
    }

    public String getInputString() {
        return this.m_strInput;
    }

    protected void _resolveTokens(TokenList tokenList) {
        Function newOperator;
        int index;
        int i;
        for (i = tokenList.size() - 1; i > 1; --i) {
            if (!tokenList.elementAt(i).isOperator(">") || !tokenList.elementAt(i - 2).isOperator("<") || tokenList.elementAt(i - 2).getStart() + 1 != tokenList.elementAt(i - 1).getStart() || tokenList.elementAt(i - 1).getEnd() != tokenList.elementAt(i).getStart()) continue;
            tokenList.removeElementAt(i);
            tokenList.removeElementAt(i - 2);
            Token t = tokenList.elementAt(i - 2);
            t.setData("<" + t.getData() + ">");
            t.setStart(t.getStart() - 1);
            t.setEnd(t.getEnd() + 1);
            i -= 2;
        }
        for (i = 1; i < tokenList.size(); ++i) {
            Token maybeIs;
            Token pred;
            if (!tokenList.elementAt(i).toString().equalsIgnoreCase("BETWEEN") && !tokenList.elementAt(i).toString().equalsIgnoreCase("IN") && !tokenList.elementAt(i).toString().equalsIgnoreCase("CONTAINS") && !tokenList.elementAt(i).toString().equalsIgnoreCase("LIKE") || !(pred = tokenList.elementAt(i - 1)).toString().equalsIgnoreCase("NOT")) continue;
            tokenList.elementAt(i).setParserData(1);
            tokenList.removeElementAt(i - 1);
            if (--i <= 0 || !(maybeIs = tokenList.elementAt(i - 1)).toString().equalsIgnoreCase("IS")) continue;
            tokenList.removeElementAt(i - 1);
            --i;
        }
        block2: for (i = 0; i < tokenList.size(); ++i) {
            if (!tokenList.elementAt(i).toString().equalsIgnoreCase("BETWEEN")) continue;
            for (int j = i + 1; j < tokenList.size(); ++j) {
                if (!tokenList.elementAt(j).toString().equalsIgnoreCase("AND")) continue;
                tokenList.elementAt(j).setParserData(2);
                continue block2;
            }
        }
        if (this.m_dataSource.getProperties().supports_GT_LT_NE_GE_LE_EQ()) {
            for (index = 0; index < tokenList.size(); ++index) {
                Function newOperator2;
                Token token = tokenList.elementAt(index);
                if (token.getType() != 0) continue;
                if (token.toString().equalsIgnoreCase("GT")) {
                    newOperator2 = this.m_functionList.findFunction(12, ">", 65535, 65535, 2);
                    if (newOperator2 != null) {
                        token.setType(22);
                        token.setData(newOperator2);
                    } else {
                        this.m_messages.addInternalError(bundle.getString("dataSourceMissingGTOperator.txt"));
                    }
                    token.setSubType(0);
                    continue;
                }
                if (token.toString().equalsIgnoreCase("GE")) {
                    newOperator2 = this.m_functionList.findFunction(12, ">=", 65535, 65535, 2);
                    if (newOperator2 != null) {
                        token.setType(22);
                        token.setData(newOperator2);
                    } else {
                        this.m_messages.addInternalError(bundle.getString("dataSourceMissingGEOperator.txt"));
                    }
                    token.setSubType(0);
                    continue;
                }
                if (token.toString().equalsIgnoreCase("LT")) {
                    newOperator2 = this.m_functionList.findFunction(12, "<", 65535, 65535, 2);
                    if (newOperator2 != null) {
                        token.setType(22);
                        token.setData(newOperator2);
                    } else {
                        this.m_messages.addInternalError(bundle.getString("dataSourceMissingLTOperator.txt"));
                    }
                    token.setSubType(0);
                    continue;
                }
                if (token.toString().equalsIgnoreCase("LE")) {
                    newOperator2 = this.m_functionList.findFunction(12, "<=", 65535, 65535, 2);
                    if (newOperator2 != null) {
                        token.setType(22);
                        token.setData(newOperator2);
                    } else {
                        this.m_messages.addInternalError(bundle.getString("dataSourceMissingLEOperator.txt"));
                    }
                    token.setSubType(0);
                    continue;
                }
                if (token.toString().equalsIgnoreCase("EQ")) {
                    newOperator2 = this.m_functionList.findFunction(12, "=", 65535, 65535, 2);
                    if (newOperator2 != null) {
                        token.setType(22);
                        token.setData(newOperator2);
                    } else {
                        this.m_messages.addInternalError(bundle.getString("dataSourceMissingEQOperator.txt"));
                    }
                    token.setSubType(0);
                    continue;
                }
                if (!token.toString().equalsIgnoreCase("NE")) continue;
                String neFunctionName = this.m_dataSource.getProperties().logicalNotEqualsConditionalName();
                newOperator = this.m_functionList.findFunction(12, neFunctionName, 65535, 65535, 2);
                if (newOperator != null) {
                    token.setType(22);
                    token.setData(newOperator);
                } else {
                    this.m_messages.addInternalError(bundle.messageString("dataSourceMissingFunction.fmt.txt", neFunctionName));
                }
                token.setSubType(0);
            }
        }
        for (index = 0; index < tokenList.size(); ++index) {
            Function newOperator3;
            String neFunctionName;
            Token token = tokenList.elementAt(index);
            if (token.getType() != 13) continue;
            Token nextToken = index + 1 < tokenList.size() ? tokenList.elementAt(index + 1) : null;
            if (this.m_dataSource.getProperties().supportsBarAndAmpersandForLogicalAND_OR()) {
                if (token.getSubType() == 50) {
                    if (nextToken != null && nextToken.toString().equals("|")) break;
                    newOperator = this.m_functionList.findFunction(12, "OR", 65535, 65535, 2);
                    if (newOperator != null) {
                        token.setType(22);
                        token.setData(newOperator);
                    } else {
                        this.m_messages.addInternalError(bundle.getString("dataSourceMissingOR.txt"));
                    }
                    token.setSubType(0);
                } else if (token.getSubType() == 34) {
                    if (nextToken != null && nextToken.toString().equals("&")) break;
                    newOperator = this.m_functionList.findFunction(12, "AND", 65535, 65535, 2);
                    if (newOperator != null) {
                        token.setType(22);
                        token.setData(newOperator);
                    } else {
                        this.m_messages.addInternalError(bundle.getString("dataSourceMissingAND.txt"));
                    }
                    token.setSubType(0);
                }
            }
            if (token.getSubType() == 53 && nextToken != null && nextToken.toString().equals("=")) {
                neFunctionName = this.m_dataSource.getProperties().logicalNotEqualsConditionalName();
                newOperator3 = this.m_functionList.findFunction(12, neFunctionName, 65535, 65535, 2);
                if (newOperator3 != null) {
                    token.setType(22);
                    token.setData(newOperator3);
                } else {
                    this.m_messages.addInternalError(bundle.messageString("dataSourceMissingFunction.fmt.txt", neFunctionName));
                }
                token.setSubType(0);
                token.setEnd(nextToken.getEnd());
                tokenList.removeElementAt(index + 1);
            }
            if (token.getSubType() == 54 && nextToken != null && nextToken.toString().equals("=")) {
                neFunctionName = this.m_dataSource.getProperties().logicalNotEqualsConditionalName();
                newOperator3 = this.m_functionList.findFunction(12, neFunctionName, 65535, 65535, 2);
                if (newOperator3 != null) {
                    token.setType(22);
                    token.setData(newOperator3);
                } else {
                    this.m_messages.addInternalError(bundle.messageString("dataSourceMissingFunction.fmt.txt", neFunctionName));
                }
                token.setSubType(0);
                token.setEnd(nextToken.getEnd());
                tokenList.removeElementAt(index + 1);
            }
            if (token.getSubType() != 55 || nextToken == null || !nextToken.toString().equals("=")) continue;
            neFunctionName = this.m_dataSource.getProperties().logicalNotEqualsConditionalName();
            newOperator3 = this.m_functionList.findFunction(12, neFunctionName, 65535, 65535, 2);
            if (newOperator3 != null) {
                token.setType(22);
                token.setData(newOperator3);
            } else {
                this.m_messages.addInternalError(bundle.messageString("dataSourceMissingFunction.fmt.txt", neFunctionName));
            }
            token.setSubType(0);
            token.setEnd(nextToken.getEnd());
            tokenList.removeElementAt(index + 1);
        }
    }

    protected void _resolvePairedTokens(TokenList tokenList) {
        block0: for (int index = 0; index < tokenList.size(); ++index) {
            Function m_isnullFunction;
            Token token = tokenList.elementAt(index);
            Token nextToken = null;
            if (index + 1 < tokenList.size()) {
                nextToken = tokenList.elementAt(index + 1);
            }
            Token nextnextToken = null;
            if (index + 2 < tokenList.size()) {
                nextnextToken = tokenList.elementAt(index + 2);
            }
            if ((token.isKeyword("ORDER") || token.isKeyword("GROUP")) && nextToken != null && nextToken.isKeyword("BY")) {
                token.setType(2);
                String firstTokenOriginalString = token.toString().trim();
                String secondTokenOriginalString = nextToken.toString().trim();
                token.setEnd(nextToken.getEnd());
                token.fixupOriginalStringToBeThis(firstTokenOriginalString + " " + secondTokenOriginalString);
                tokenList.removeElementAt(index + 1);
                continue;
            }
            if (token.isKeyword("IS") && nextToken != null && (nextToken.isKeyword("NULL") || nextToken.isKeyword("MISSING"))) {
                token.setType(21);
                m_isnullFunction = this.m_functionList.findFunction(32, "ISNULL", 65535, 32768, 1);
                token.setEnd(nextToken.getEnd());
                token.setData(m_isnullFunction);
                tokenList.removeElementAt(index + 1);
                continue;
            }
            if (token.isKeyword("IS") && nextToken != null && nextToken.isKeyword("NOT") && nextnextToken != null && (nextnextToken.isKeyword("NULL") || nextnextToken.isKeyword("MISSING"))) {
                nextnextToken.setType(21);
                m_isnullFunction = this.m_functionList.findFunction(32, "ISNULL", 65535, 32768, 1);
                nextnextToken.setData(m_isnullFunction);
                nextnextToken.setParserData(1);
                nextnextToken.setStart(token.getStart());
                tokenList.removeElementAt(index);
                tokenList.removeElementAt(index);
                continue;
            }
            if (token.toString().equals("/") && nextToken != null && nextToken.toString().equals("*") && token.getEnd() == nextToken.getStart() && token.m_tokenizer.m_dataSource.getProperties().supportsCStyleBlockCommentsInSQL()) {
                Token closeCommentStar = null;
                Token closeCommentSlash = null;
                for (int startOffset = 2; startOffset < tokenList.size() - index + 1; ++startOffset) {
                    closeCommentStar = tokenList.elementAt(index + startOffset);
                    closeCommentSlash = tokenList.elementAt(index + startOffset + 1);
                    if (!closeCommentStar.toString().equals("*") || !closeCommentSlash.toString().equals("/") || closeCommentStar.getEnd() != closeCommentSlash.getStart()) continue;
                    for (int i = index; i <= index + startOffset + 1; ++i) {
                        tokenList.removeElementAt(index);
                    }
                    continue block0;
                }
                continue;
            }
            if (token.isType(22) && nextToken != null && nextToken.isType(22)) {
                Operator newOperator = (Operator)this.m_functionList.findFunction(12, token.toString() + nextToken.toString(), 65535, 65535, 2);
                if (newOperator != null) {
                    token.setType(22);
                    token.setSubType(0);
                    token.setEnd(nextToken.getEnd());
                    token.setData(newOperator);
                    tokenList.removeElementAt(index + 1);
                    continue;
                }
                if (token.toString().equals("*") && nextToken.toString().equals("*")) {
                    token.setType(0);
                    token.setSubType(0);
                    token.setEnd(nextToken.getEnd());
                    tokenList.removeElementAt(index + 1);
                    continue;
                }
                if (token.toString().equals("=") && nextToken.toString().equals("*")) {
                    token.setType(0);
                    token.setSubType(0);
                    token.setEnd(nextToken.getEnd());
                    tokenList.removeElementAt(index + 1);
                    continue;
                }
                if (token.toString().equals("=") && nextToken.toString().equals(">") && this.m_dataSource.getProperties().supportsFlippedGreaterLessThanEqualInput()) {
                    newOperator = (Operator)this.m_functionList.findFunction(12, ">=", 65535, 65535, 2);
                    if (newOperator != null) {
                        token.setType(22);
                        token.setData(newOperator);
                    } else {
                        this.m_messages.addInternalError(bundle.getString("dataSourceMissingGEOperator.txt"));
                        token.setType(0);
                    }
                    token.setSubType(0);
                    token.setEnd(nextToken.getEnd());
                    tokenList.removeElementAt(index + 1);
                    continue;
                }
                if (!token.toString().equals("=") || !nextToken.toString().equals("<") || !this.m_dataSource.getProperties().supportsFlippedGreaterLessThanEqualInput()) continue;
                newOperator = (Operator)this.m_functionList.findFunction(12, "<=", 65535, 65535, 2);
                if (newOperator != null) {
                    token.setType(22);
                    token.setData(newOperator);
                } else {
                    this.m_messages.addInternalError(bundle.getString("dataSourceMissingLEOperator.txt"));
                    token.setType(0);
                }
                token.setSubType(0);
                token.setEnd(nextToken.getEnd());
                tokenList.removeElementAt(index + 1);
                continue;
            }
            if (token.toString().equals("|") && nextToken.toString().equals("|")) {
                String opname = this.m_dataSource.getProperties().stringConcatenationOperatorName();
                Operator newOperator = (Operator)this.m_functionList.findFunction(12, opname, 65535, 65535, 2);
                if (newOperator != null) {
                    token.setType(22);
                    token.setData(newOperator);
                } else {
                    this.m_messages.addInternalError(bundle.messageString("dataSourceMissingFunction.fmt.txt", opname));
                    token.setType(0);
                }
                token.setSubType(0);
                token.setEnd(nextToken.getEnd());
                tokenList.removeElementAt(index + 1);
                continue;
            }
            if (!token.isType(1, 73) || nextToken == null || !nextToken.isType(13, 42) || index + 2 >= tokenList.size()) continue;
            Token lastToken = tokenList.elementAt(index + 2);
            String testName = lastToken.getUnquotedString();
            DataSourceContainerList tableList = ((DataSourceContainer)token.getData()).getItems();
            for (int tableIndex = 0; tableIndex < tableList.size(); ++tableIndex) {
                DataSourceTable table = (DataSourceTable)tableList.elementAt(tableIndex);
                String tableName = table.getName();
                if (!testName.equalsIgnoreCase(tableName)) continue;
                token.setStart(lastToken.getStart());
                token.setEnd(lastToken.getEnd());
                token.setType(1);
                token.setSubType(72);
                token.setData(table);
                tokenList.removeElementAt(index + 2);
                tokenList.removeElementAt(index + 1);
                continue block0;
            }
        }
    }

    public static void resolveDataSourceTables(TokenList tokenList, Query query, DataSource dataSource) {
        Token token;
        char quoteChar = dataSource.getProperties().getIdentifierQuoteStart().charAt(0);
        for (int index = 0; index < tokenList.size() && !(token = tokenList.elementAt(index)).isType(1, 72); ++index) {
            DataSourceTable table;
            Token nextToken = null;
            if (index + 1 < tokenList.size()) {
                nextToken = tokenList.elementAt(index + 1);
            }
            if (!token.isType(0) && !token.isType(1) && (!token.isType(8) || quoteChar != '\"')) continue;
            String testName = token.getUnquotedString();
            try {
                table = dataSource.getTable(testName);
            }
            catch (Exception e) {
                table = null;
            }
            if (table != null) {
                token.setType(1);
                token.setSubType(72);
                token.setData(table);
                continue;
            }
            if (!token.isType(1, 73) || nextToken == null || !nextToken.isType(13, 42) || index + 2 >= tokenList.size()) continue;
            Token lastToken = tokenList.elementAt(index + 2);
            testName = lastToken.getUnquotedString();
            testName = ((DataSourceContainer)token.getData()).getName() + "." + testName;
            try {
                table = dataSource.getTable(testName);
            }
            catch (Exception e) {
                table = null;
            }
            if (table == null) continue;
            token.setStart(lastToken.getStart());
            token.setEnd(lastToken.getEnd());
            token.setType(1);
            token.setSubType(72);
            token.setData(table);
            tokenList.removeElementAt(index + 2);
            tokenList.removeElementAt(index + 1);
        }
    }

    public static void resolveTables(TokenList tokenList, Query query) {
        TableList tableList = query.getReferableTables();
        int cTables = tableList.size();
        block0: for (int index = 0; index < tokenList.size(); ++index) {
            Token token = tokenList.elementAt(index);
            Token nextToken = null;
            if (index < tokenList.size() - 1) {
                nextToken = tokenList.elementAt(index + 1);
            }
            if (!token.isType(1) && !token.isType(0) && !token.isType(8) && !token.isType(21)) continue;
            for (int tableIndex = 0; tableIndex < cTables; ++tableIndex) {
                Table table = tableList.elementAt(tableIndex);
                String testName = token.getUnquotedString();
                if (!testName.toString().equalsIgnoreCase(table.getDisplayName())) continue;
                if (nextToken != null && nextToken.isType(13, 36)) continue block0;
                token.setType(1);
                token.setSubType(71);
                token.setData(table);
                continue block0;
            }
        }
    }

    public static void resolveColumns(TokenList tokenList, Query query) {
        Tokenizer.resolveTables(tokenList, query);
        ColumnList columnList = query.getReferableColumns();
        block0: for (int index = 0; index < tokenList.size(); ++index) {
            Column column;
            Token token = tokenList.elementAt(index);
            Token nextToken = null;
            if (index + 1 < tokenList.size()) {
                nextToken = tokenList.elementAt(index + 1);
            }
            if ((token.isType(1, 71) || token.isType(0)) && nextToken != null && nextToken.isType(13, 42) && index + 2 < tokenList.size()) {
                Token lastToken = tokenList.elementAt(index + 2);
                String testName = lastToken.getUnquotedString();
                for (int columnIndex = 0; columnIndex < columnList.size(); ++columnIndex) {
                    Column column2 = columnList.elementAt(columnIndex);
                    String tableName = column2.getParent().getDisplayName();
                    if (token.getData() == null || !(token.getData() instanceof Table) || !((Table)token.getData()).getDisplayName().equalsIgnoreCase(tableName) || !testName.equalsIgnoreCase(column2.getName())) continue;
                    token.setStart(lastToken.getStart());
                    token.setEnd(lastToken.getEnd());
                    token.setType(1);
                    token.setSubType(70);
                    token.setData(column2);
                    tokenList.removeElementAt(index + 2);
                    tokenList.removeElementAt(index + 1);
                    break;
                }
                if (!lastToken.toString().equals("*")) continue;
                token.setEnd(lastToken.getEnd());
                token.setType(1);
                token.setSubType(70);
                ColumnStar newcol = new ColumnStar(query, (Table)token.getData());
                token.setData(newcol);
                tokenList.removeElementAt(index + 2);
                tokenList.removeElementAt(index + 1);
                continue;
            }
            if (token.isType(0)) {
                for (int columnIndex = 0; columnIndex < columnList.size(); ++columnIndex) {
                    column = columnList.elementAt(columnIndex);
                    if (!token.toString().equalsIgnoreCase(column.getName())) continue;
                    token.setType(1);
                    token.setSubType(70);
                    token.setData(column);
                    continue block0;
                }
                continue;
            }
            if (!token.isType(21)) continue;
            for (int columnIndex = 0; columnIndex < columnList.size(); ++columnIndex) {
                column = columnList.elementAt(columnIndex);
                if (!token.toString().equalsIgnoreCase(column.getName())) continue;
                if (nextToken != null && nextToken.isType(13, 36)) continue block0;
                token.setType(1);
                token.setSubType(70);
                token.setData(column);
                continue block0;
            }
        }
    }

    public static void resolveFunctions(TokenList tokenList, Query query) {
    }

    protected void _findMatchingParens(TokenList tokenList) {
        Stack<Token> stack = new Stack<Token>();
        for (int index = 0; index < tokenList.size(); ++index) {
            Token token = tokenList.elementAt(index);
            if (token.getType() == 13 && token.getSubType() == 36) {
                stack.push(token);
                continue;
            }
            if (token.getType() != 13 || token.getSubType() != 37) continue;
            if (stack.empty()) {
                this.m_messages.addError(bundle.messageString("ExtraRightParen.fmt.txt", new Integer(token.getStart())));
                continue;
            }
            Token leftParen = (Token)stack.pop();
            leftParen.setData(token);
        }
        if (!stack.empty()) {
            Token token = (Token)stack.pop();
            this.m_messages.addError(bundle.messageString("ExtraLeftParen.fmt.txt", new Integer(token.getStart())));
        }
        int startIndex = 1;
        while (startIndex < tokenList.size()) {
            int i = startIndex;
            while (i < tokenList.size()) {
                Token leftParen;
                Token token = tokenList.elementAt(i);
                if (token.isKeyword("SELECT") && (leftParen = tokenList.elementAt(i - 1)).isType(13, 36)) {
                    Token rightParen = (Token)leftParen.getData();
                    TokenList subqueryTokenList = new TokenList(tokenList.getOriginalString());
                    for (int j = i; j < tokenList.size(); ++j) {
                        int k;
                        Token potentialMatchingRightParen = tokenList.elementAt(j);
                        if (potentialMatchingRightParen != rightParen) continue;
                        for (k = i - 1; k <= j; ++k) {
                            subqueryTokenList.addElement(tokenList.elementAt(k));
                        }
                        for (k = i; k <= j; ++k) {
                            tokenList.removeElementAt(i);
                        }
                        leftParen.setData(subqueryTokenList);
                        leftParen.setType(23);
                        leftParen.setEnd(potentialMatchingRightParen.getEnd());
                        startIndex = j + 1;
                    }
                }
                ++i;
                ++startIndex;
            }
        }
    }
}

