/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.parser;

import com.sas.query.datasources.Function;
import com.sas.query.models.Expression;
import com.sas.query.parser.Token;
import com.sas.query.parser.TokenConstants;
import com.sas.query.parser.TokenList;
import java.util.Vector;

public class TokenAndExpressionList
implements TokenConstants {
    private Vector m_list;
    private TokenList m_originalTokenList;

    public TokenAndExpressionList(TokenList t) {
        this.m_originalTokenList = t.duplicate();
        this.m_list = new Vector();
        for (int i = 0; i < t.size(); ++i) {
            this.m_list.addElement(t.elementAt(i));
        }
    }

    public TokenAndExpressionList(TokenAndExpressionList master, int beginIndex, int endIndex) {
        this.m_originalTokenList = master.m_originalTokenList.duplicate();
        this.m_list = new Vector();
        for (int i = beginIndex; i <= endIndex; ++i) {
            this.m_list.addElement(master.elementAt(i));
        }
    }

    public String toString(boolean unresolveFirstToken) {
        boolean firstNotFlushedYet = true;
        if (this.size() == 0) {
            return "";
        }
        String retValue = "";
        TokenList thisPiece = new TokenList(this.getUnderlyingTokenList().getOriginalString());
        for (int i = 0; i < this.size(); ++i) {
            if (this.m_list.elementAt(i) instanceof Expression) {
                if (thisPiece.size() > 0) {
                    retValue = firstNotFlushedYet && unresolveFirstToken ? retValue + thisPiece.unresolvedToString() : retValue + thisPiece.toString();
                    firstNotFlushedYet = false;
                }
                if (retValue.length() > 0) {
                    retValue = retValue + " ";
                }
                Expression thisOne = (Expression)this.m_list.elementAt(i);
                retValue = retValue + thisOne.toString();
                firstNotFlushedYet = false;
                continue;
            }
            thisPiece.addElement((Token)this.m_list.elementAt(i));
        }
        if (thisPiece.size() > 0) {
            retValue = firstNotFlushedYet && unresolveFirstToken ? retValue + thisPiece.unresolvedToString() : retValue + thisPiece.toString();
        }
        firstNotFlushedYet = false;
        return retValue;
    }

    public String toString() {
        return this.toString(false);
    }

    public String unresolvedToString() {
        return this.toString(true);
    }

    public int size() {
        return this.m_list.size();
    }

    public synchronized void addElement(Token object) {
        this.m_list.addElement(object);
    }

    public synchronized void addElement(Expression exp) {
        this.m_list.addElement(exp);
    }

    public synchronized Object elementAt(int index) {
        return this.m_list.elementAt(index);
    }

    public final int indexOf(Token elem) {
        return this.m_list.indexOf(elem);
    }

    public final synchronized void removeAllElements() {
        this.m_list.removeAllElements();
    }

    public final boolean contains(Token elem) {
        return this.m_list.contains(elem);
    }

    public boolean hasCONDITIONAL() {
        return this.indexOfNextCONDITIONAL() != -1;
    }

    public int indexOfNextCONDITIONAL() {
        for (int i = 0; i < this.m_list.size(); ++i) {
            Function function;
            Token tok;
            Object x = this.m_list.elementAt(i);
            if (!(x instanceof Token) || !(tok = (Token)x).isType(21) || (function = (Function)tok.getData()).getFunctionType() != 32) continue;
            return i;
        }
        return -1;
    }

    public boolean hasAND() {
        return this.indexOfNextAND() != -1;
    }

    public int indexOfNextAND() {
        for (int i = 0; i < this.m_list.size(); ++i) {
            Object x = this.m_list.elementAt(i);
            if (!(x instanceof Token)) continue;
            Token tok = (Token)x;
            if (tok.isKeyword("AND") && tok.getParserData() != 2) {
                return i;
            }
            if (!tok.isOperator("AND") || tok.getParserData() == 2) continue;
            return i;
        }
        return -1;
    }

    public int indexOfNextBETWEENAND() {
        for (int i = 0; i < this.m_list.size(); ++i) {
            Object x = this.m_list.elementAt(i);
            if (!(x instanceof Token)) continue;
            Token tok = (Token)x;
            if (tok.isOperator("AND") && tok.getParserData() == 2) {
                return i;
            }
            if (!tok.isKeyword("AND") || tok.getParserData() != 2) continue;
            return i;
        }
        return -1;
    }

    public boolean hasOR() {
        return this.indexOfNextOR() != -1;
    }

    public int indexOfNextOR() {
        for (int i = 0; i < this.m_list.size(); ++i) {
            Object x = this.m_list.elementAt(i);
            if (!(x instanceof Token)) continue;
            Token tok = (Token)x;
            if (tok.isKeyword("OR")) {
                return i;
            }
            if (!tok.isOperator("OR")) continue;
            return i;
        }
        return -1;
    }

    public boolean hasEXISTS() {
        return this.indexOfNextEXISTS() != -1;
    }

    public int indexOfNextEXISTS() {
        for (int i = 0; i < this.m_list.size(); ++i) {
            Object x = this.m_list.elementAt(i);
            if (!(x instanceof Token)) continue;
            Token tok = (Token)x;
            if (tok.isKeyword("EXISTS")) {
                return i;
            }
            if (!tok.isOperator("EXISTS")) continue;
            return i;
        }
        return -1;
    }

    public boolean hasNOT() {
        return this.indexOfNextNOT() != -1;
    }

    public int indexOfNextNOT() {
        for (int i = 0; i < this.m_list.size(); ++i) {
            Token tok;
            Object x = this.m_list.elementAt(i);
            if (!(x instanceof Token) || !(tok = (Token)x).isKeyword("NOT")) continue;
            return i;
        }
        return -1;
    }

    public boolean hasCommas() {
        return this.indexOfNextComma() != -1;
    }

    public int indexOfNextComma() {
        for (int i = 0; i < this.m_list.size(); ++i) {
            Token tok;
            Object x = this.m_list.elementAt(i);
            if (!(x instanceof Token) || !(tok = (Token)x).isType(13, 40)) continue;
            return i;
        }
        return -1;
    }

    public int indexOfNextCommaRespectingParens(int currentIndex) {
        for (int i = currentIndex + 1; i < this.m_list.size(); ++i) {
            Object x = this.m_list.elementAt(i);
            if (!(x instanceof Token)) continue;
            Token tok = (Token)x;
            if (tok.isType(13, 36)) {
                i = this.indexOfCorrespondingRightParen(i);
                continue;
            }
            if (tok.isType(13, 37)) {
                return -1;
            }
            if (!tok.isType(13, 40)) continue;
            return i;
        }
        return -1;
    }

    public boolean hasSubquery() {
        return this.indexOfNextSubquery() != -1;
    }

    public int indexOfNextSubquery() {
        for (int i = 0; i < this.m_list.size(); ++i) {
            Token tok;
            Object x = this.m_list.elementAt(i);
            if (!(x instanceof Token) || !(tok = (Token)x).isType(23)) continue;
            return i;
        }
        return -1;
    }

    public boolean hasCountStar() {
        return this.indexOfNextCountStar() != -1;
    }

    public int indexOfNextCountStar() {
        int i = 0;
        while (i + 3 < this.m_list.size()) {
            Token tok;
            Object x = this.m_list.elementAt(i);
            if (!(x instanceof Token && !(tok = (Token)x).toString().equalsIgnoreCase("COUNT") || (x = this.m_list.elementAt(i + 1)) instanceof Token && !(tok = (Token)x).toString().equalsIgnoreCase("(") || (x = this.m_list.elementAt(i + 2)) instanceof Token && !(tok = (Token)x).toString().equalsIgnoreCase("*") || !((x = this.m_list.elementAt(i + 3)) instanceof Token) || !(tok = (Token)x).toString().equalsIgnoreCase(")"))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean hasLeftParen() {
        return this.indexOfNextLeftParen() != -1;
    }

    public int indexOfNextLeftParen() {
        for (int i = 0; i < this.m_list.size(); ++i) {
            Token tok;
            Object x = this.m_list.elementAt(i);
            if (!(x instanceof Token) || !(tok = (Token)x).isType(13, 36)) continue;
            return i;
        }
        return -1;
    }

    public int indexOfCorrespondingRightParen(int leftParenIndex) {
        Token l = (Token)this.elementAt(leftParenIndex);
        Token r = (Token)l.getData();
        if (r == null) {
            return -1;
        }
        return this.indexOf(r);
    }

    public void replaceRange(int left, int right, Expression replacement) {
        for (int i = right; i > left; --i) {
            this.m_list.removeElementAt(i);
        }
        this.m_list.setElementAt(replacement, left);
    }

    public final synchronized void removeElementAt(int index) {
        this.m_list.removeElementAt(index);
    }

    public TokenList getUnderlyingTokenList() {
        return this.m_originalTokenList;
    }
}

