/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.ibm.xml.parsers.NonValidatingDOMParser;
import com.sas.query.Query;
import com.sas.query.QueryException;
import com.sas.query.datasources.DataSource;
import com.sas.query.models.ConnectionHandler;
import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.QueryResource;
import java.io.FileReader;
import java.io.FileWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.helpers.ParserFactory;

public class XmlUtil {
    static QueryResource bundle = new QueryResource(XmlUtil.class);

    public static void writeXml(String path, Query query, MessageHandler messages) {
        String xmlFile = path;
        try {
            FileWriter output = new FileWriter(xmlFile);
            XmlUtil.writeXml(output, query, messages);
            output.close();
        }
        catch (Exception e) {
            messages.addInternalError(e.toString());
        }
    }

    public static void writeXml(FileWriter output, Query query, MessageHandler messages) {
        String selectString = query.getSql();
        try {
            output.write("<?xml version='1.0' ?>\n");
            output.write("<!DOCTYPE sasQuery  >\n\n");
            output.write("<sasQuery duplicateRows=\"");
            output.write(new Integer(query.getDuplicateRowsRule()).toString());
            output.write("\" limits=\"");
            output.write(new Integer(query.getLimits()).toString());
            output.write("\">\n");
            DataSource dataSource = query.getDataSource();
            output.write("\t<dataSource \tDisplayString=\"");
            output.write(dataSource.getName());
            output.write("\"");
            output.write(">\n");
            output.write("\t</dataSource>\n");
            output.write("\t<select>\n\t\t");
            output.write(selectString);
            output.write("\n\t</select>\n");
            output.write("</sasQuery>\n");
        }
        catch (Exception e) {
            messages.addInternalError(e.getMessage());
        }
    }

    public static Query readXml(String path, Query query, MessageHandler messages) {
        String xmlFile = path;
        try {
            FileReader input = new FileReader(xmlFile);
            XmlUtil.readXml(input, query, messages);
        }
        catch (Exception e) {
            messages.addInternalError(e.toString());
        }
        return query;
    }

    public static Query readXml(FileReader input, Query query, MessageHandler messages) {
        InputSource source = new InputSource(input);
        String parserClass = "com.ibm.xml.parsers.NonValidatingDOMParser";
        try {
            DataSource dataSource;
            Parser parser = ParserFactory.makeParser(parserClass);
            parser.parse(source);
            Document doc = ((NonValidatingDOMParser)parser).getDocument();
            Element savedQueryElement = doc.getDocumentElement();
            if (!"sasQuery".equals(savedQueryElement.getNodeName())) {
                messages.addError(bundle.messageString("model.savedqueryObj.fmt.txt", savedQueryElement.getNodeName()));
                return query;
            }
            String limitsString = savedQueryElement.getAttribute("limits");
            int limits = new Integer(limitsString);
            Element dataSourceElement = null;
            Element selectElement = null;
            NodeList children = savedQueryElement.getChildNodes();
            int cChildren = children.getLength();
            for (int index = 0; index < cChildren; ++index) {
                Node child = children.item(index);
                if ("dataSource".equals(child.getNodeName())) {
                    dataSourceElement = (Element)child;
                }
                if (!"select".equals(child.getNodeName())) continue;
                selectElement = (Element)child;
            }
            if (selectElement == null) {
                messages.addError(bundle.messageString("model.selectObjNotFound.txt"));
            }
            if (dataSourceElement == null) {
                messages.addError(bundle.messageString("model.datasrcObjNotFound.txt"));
            }
            String displayString = dataSourceElement.getAttribute("DisplayString");
            try {
                dataSource = ConnectionHandler.openDataSourcebyName(displayString, messages);
            }
            catch (QueryException e) {
                dataSource = null;
            }
            if (dataSource == null) {
                query.getMessageHandler().addWarning(bundle.messageString("XmUtil.UnableToFindDatasource.fmt.txt", displayString));
                dataSource = query.getDataSource();
            }
            String selectString = "";
            children = selectElement.getChildNodes();
            cChildren = children.getLength();
            for (int index = 0; index < cChildren; ++index) {
                Text text;
                String textData;
                Node child = children.item(index);
                if (child.getNodeType() != 3 || (textData = (text = (Text)child).getData()) == null || textData.length() <= 0) continue;
                selectString = selectString + text.getData();
            }
            if (query == null) {
                query = new Query(dataSource, messages, limits);
            } else {
                query.clear();
                query.setLimits(limits);
                query.setDataSource(dataSource);
            }
            messages.firePropertyChanges();
            query.setSQL(selectString.trim());
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
        return query;
    }

    protected static void displayElement(Node element, int indent) {
        if (element == null) {
            return;
        }
        XmlUtil.println(element.getNodeName() + " is type " + element.getNodeName(), indent);
        NamedNodeMap attributes = element.getAttributes();
        for (int index = 0; attributes != null && index < attributes.getLength(); ++index) {
            Node node = attributes.item(index);
            XmlUtil.println(node.getNodeName() + " = " + node.getNodeValue(), indent);
        }
        NodeList children = element.getChildNodes();
        for (int index = 0; children != null && index < children.getLength(); ++index) {
            Node child = children.item(index);
            XmlUtil.displayElement(child, indent + 1);
        }
    }

    protected static void println(String text, int indent) {
        for (int index = 0; index < indent; ++index) {
            System.out.print(" ");
        }
        System.out.print(text);
        System.out.println();
    }
}

