/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.Query;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.DataSourceColumnList;
import com.sas.query.datasources.DataSourceTable;
import com.sas.query.datasources.RelationshipList;
import com.sas.query.models.Column;
import com.sas.query.models.ColumnList;
import com.sas.query.models.PhysicalColumn;
import com.sas.query.models.RefreshMapTable;
import com.sas.query.models.StandardModel;

public class Table
extends StandardModel {
    static final long serialVersionUID = 8226636137491971574L;
    public static final String correlationNamePropertyChange = "correlationName";
    protected String m_strCorrelationName = null;
    protected DataSourceTable m_datasourceTable;
    protected transient ColumnList m_physicalColumns = null;

    public Table(Query query, DataSourceTable datasourceTable) {
        super(query);
        this.m_datasourceTable = datasourceTable;
        this.m_datasourceTable.initialize();
    }

    public String getDisplayName() {
        if (this.m_strCorrelationName != null) {
            return this.m_strCorrelationName;
        }
        return this.getName();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getName() {
        return this.m_datasourceTable.getName();
    }

    public String getCorrelationName() {
        return this.m_strCorrelationName;
    }

    public void setCorrelationName(String strCorrelationName) {
        String strOldName = this.m_strCorrelationName;
        this.m_strCorrelationName = strCorrelationName;
        this.queueDataChange(8, correlationNamePropertyChange, strOldName);
    }

    public void refresh(DataSource dataSource, RefreshMapTable mapTable) {
        if (this.m_datasourceTable != null && mapTable.containsKey(this.m_datasourceTable)) {
            this.m_datasourceTable = (DataSourceTable)mapTable.get(this.m_datasourceTable);
        }
    }

    public void getDefaultRefreshMapping(DataSource dataSource, RefreshMapTable mapTable) {
        try {
            mapTable.put(this.m_datasourceTable, dataSource.getTable(this.m_datasourceTable.getQualifiedName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Table[] getTables() {
        Table[] tableList = new Table[]{this};
        return tableList;
    }

    public RelationshipList getRelationships() {
        return this.m_datasourceTable.getRelationships();
    }

    public int getColumnCount() {
        return this.m_datasourceTable.getColumnCount();
    }

    public ColumnList getColumns() {
        if (this.m_physicalColumns == null) {
            int numCols = this.getColumnCount();
            DataSourceColumnList datasourceColumnList = this.m_datasourceTable.getColumns();
            this.m_physicalColumns = new ColumnList(numCols);
            for (int index = 0; index < numCols; ++index) {
                this.m_physicalColumns.addElement(new PhysicalColumn(this, datasourceColumnList.elementAt(index)));
            }
        }
        return this.m_physicalColumns;
    }

    public DataSourceTable getDataSourceTable() {
        return this.m_datasourceTable;
    }

    public Column getColumn(String strColumnName) {
        ColumnList columnList = this.getColumns();
        for (int index = 0; index < columnList.size(); ++index) {
            Column column = columnList.elementAt(index);
            if (!this.getSqlLogic().identifierEquals(column.getName(), strColumnName)) continue;
            return column;
        }
        return null;
    }
}

