/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.Query;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.SqlLogic;
import com.sas.query.datasources.SqlProperties;
import com.sas.query.models.ModelChangeListener;
import com.sas.query.models.PropertyChangeConstants;
import com.sas.query.models.SimpleModel;

public abstract class StandardModel
extends SimpleModel
implements PropertyChangeConstants {
    static final long serialVersionUID = -162664987085140252L;
    protected transient Query m_query;

    public StandardModel(Query query) {
        this.m_query = query == null ? (Query)this : query;
    }

    public StandardModel(StandardModel model) {
        this(model.getQuery());
    }

    public Query getQuery() {
        return this.m_query;
    }

    public SqlProperties getSqlProperties() {
        return this.m_query.getSqlProperties();
    }

    public SqlLogic getSqlLogic() {
        return this.m_query.getSqlLogic();
    }

    public DataSource getDataSource() {
        return this.m_query.getDataSource();
    }

    public void addError(String message) {
        this.m_query.getMessageHandler().addError(message);
    }

    public boolean failureHasOccurred() {
        return this.m_query.getMessageHandler().failureHasOccurred();
    }

    public void addPropertyListener(ModelChangeListener listener) {
        this.m_query.getPropertyChangeHandler().addPropertyListener(listener);
    }

    public void addPropertyListener(ModelChangeListener listener, int area) {
        this.m_query.getPropertyChangeHandler().addPropertyListener(listener, area);
    }

    public void addPropertyListener(ModelChangeListener listener, int area, int propertyClass) {
        this.m_query.getPropertyChangeHandler().addPropertyListener(listener, area, propertyClass);
    }

    public void removePropertyListener(ModelChangeListener listener) {
        this.m_query.getPropertyChangeHandler().removePropertyListener(listener);
    }

    public void queueDataChange(int area, String changedAttribute, Object oldValue) {
        this.m_query.getPropertyChangeHandler().queueDataChange(area, (Object)this, changedAttribute, oldValue);
    }

    public void queueStructureChange(int area, int type, Object newValue) {
        this.m_query.getPropertyChangeHandler().queueStructureChange(area, type, this, newValue);
    }

    public void queueStructureChange(int area) {
        this.m_query.getPropertyChangeHandler().queueStructureChange(area);
    }
}

