/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.collection.OrderedCollection;
import com.sas.collection.StaticOrderedCollectionInterface;
import com.sas.models.Node;
import com.sas.models.NodeInterface;
import com.sas.models.SimpleNodeInterface;
import com.sas.models.TreeInterface;
import com.sas.query.Query;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.ModelChangeListener;
import com.sas.query.models.ReferableTreeTable;
import com.sas.query.models.StandardModel;
import com.sas.query.models.TableList;
import com.sas.query.visuals.QueryResource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;

public class ReferableTree
extends StandardModel
implements ModelChangeListener,
TreeInterface,
NodeInterface {
    public static final String RootPropertyChange = "root";
    protected static QueryResource bundle = new QueryResource(ReferableTree.class);
    protected String m_name = bundle.getString("metadata.Tree.Title.txt");
    protected transient Vector m_propertyListenerList;
    protected OrderedCollection m_tableCollection;

    public ReferableTree(Query query) {
        super(query);
        query.addPropertyListener(this, 24);
        this.refresh();
        this.firePropertyChange(RootPropertyChange, null, null);
    }

    public NodeInterface getRoot() {
        Node rootN = new Node(this.m_name, "SASSystem");
        rootN.setNodeChildren((StaticOrderedCollectionInterface)this.m_tableCollection);
        return rootN;
    }

    public ReferableTreeTable getTableByName(String tableName) {
        for (int index = 0; index < this.m_tableCollection.count(); ++index) {
            ReferableTreeTable table = (ReferableTreeTable)this.m_tableCollection.get(index);
            if (!tableName.equals(table.getText())) continue;
            return table;
        }
        return null;
    }

    public void refresh() {
        TableList referableTables = this.m_query.getReferableTables();
        int cTables = referableTables.size();
        this.m_tableCollection = new OrderedCollection();
        for (int tableIndex = 0; tableIndex < cTables; ++tableIndex) {
            ReferableTreeTable table = new ReferableTreeTable(referableTables.elementAt(tableIndex));
            this.m_tableCollection.add((Object)table);
        }
    }

    public String getNodeType() {
        return "DataSource";
    }

    public String getNodeExpandedText() {
        return this.getText();
    }

    public String getNodeText() {
        return this.getText();
    }

    public int getNodeChildCount() {
        return this.m_tableCollection.count();
    }

    public OrderedCollection getChildren() {
        return this.m_tableCollection;
    }

    public String getExpandedText() {
        return this.m_name;
    }

    public String getText() {
        return this.m_name;
    }

    public boolean hasChildren() {
        return this.m_tableCollection.count() > 0;
    }

    public void setExpandedText(String expandedText) {
    }

    public void setNodeType(String type) {
    }

    public void setText(String text) {
    }

    public boolean isLeafNode() {
        return false;
    }

    public SimpleNodeInterface getNodeChild(int index) {
        return (SimpleNodeInterface)this.m_tableCollection.get(index);
    }

    public SimpleNodeInterface[] getNodeChildren(int startIndex, int count) {
        OrderedCollection oc = this.getChildren();
        Object[] array = oc.toArray();
        if (array != null) {
            NodeInterface[] sni = new NodeInterface[array.length];
            for (int i = 0; i < array.length; ++i) {
                if (!(array[i] instanceof NodeInterface)) continue;
                sni[i] = (NodeInterface)array[i];
            }
            return sni;
        }
        return null;
    }

    public int countNodeChildren(int maximumChildCount) {
        if (this.m_tableCollection.count() > maximumChildCount) {
            return maximumChildCount;
        }
        if (this.m_tableCollection.count() == maximumChildCount) {
            return -maximumChildCount;
        }
        return this.m_tableCollection.count();
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
        this.refresh();
        if (event.isStructureChange()) {
            this.firePropertyChange(RootPropertyChange, null, null);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.m_propertyListenerList == null) {
            this.m_propertyListenerList = new Vector();
        }
        for (int index = 0; index < this.m_propertyListenerList.size(); ++index) {
            if (this.m_propertyListenerList.elementAt(index) != listener) continue;
            return;
        }
        this.m_propertyListenerList.addElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        Vector targets;
        if (oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        ReferableTree referableTree = this;
        synchronized (referableTree) {
            if (this.m_propertyListenerList == null) {
                return;
            }
            targets = (Vector)this.m_propertyListenerList.clone();
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (int index = 0; index < targets.size(); ++index) {
            PropertyChangeListener target = (PropertyChangeListener)targets.elementAt(index);
            target.propertyChange(event);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.m_propertyListenerList == null) {
            return;
        }
        this.m_propertyListenerList.removeElement(listener);
    }
}

