/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.DataSourceColumn;
import com.sas.query.models.Column;
import com.sas.query.models.RefreshInterface;
import com.sas.query.models.RefreshMapTable;
import com.sas.query.models.Table;
import java.util.Vector;

public class PhysicalColumn
extends Column
implements RefreshInterface {
    protected DataSourceColumn m_column;

    public PhysicalColumn(Table parent, DataSourceColumn column) {
        super(parent);
        this.m_parent = parent;
        this.m_column = column;
        this.m_strAlias = column.getLabel();
    }

    @Override
    public void refresh(DataSource dataSource, RefreshMapTable mapTable) {
        if (this.m_column != null && mapTable.containsKey(this.m_column)) {
            this.m_column = (DataSourceColumn)mapTable.get(this.m_column);
        }
    }

    @Override
    public void getDefaultRefreshMapping(DataSource dataSource, RefreshMapTable mapTable) {
        mapTable.put(this.m_column, dataSource.getColumn(this.m_column.getQualifiedName()));
    }

    public DataSourceColumn getDataSourceColumn() {
        return this.m_column;
    }

    public void setDataSourceColumn(DataSourceColumn column) {
        this.m_column = column;
    }

    @Override
    public String getName() {
        return this.m_column.getName();
    }

    @Override
    public int getDataType() {
        return this.m_column.getDataType();
    }

    @Override
    public int getSqlType() {
        return this.m_column.getSqlType();
    }

    @Override
    public boolean isNullable() {
        return this.m_column.isNullable();
    }

    @Override
    public boolean isIndexed() {
        return this.m_column.isIndexed();
    }

    @Override
    public String getFormat() {
        return this.m_column.getFormat();
    }

    @Override
    public String getInformat() {
        return this.m_column.getInformat();
    }

    @Override
    public int getLength() {
        return this.m_column.getLength();
    }

    @Override
    public boolean supportsDistinctValues() {
        return this.m_column.supportsDistinctValues();
    }

    @Override
    public Vector getDistinctValues() {
        return this.m_column.getDistinctValues();
    }

    @Override
    public Vector getDistinctValueSet(int nSetSize) {
        return this.m_column.getDistinctValueSet(nSetSize);
    }

    @Override
    public Vector getNextValueSet(int nSetSize) {
        return this.m_column.getNextValueSet(nSetSize);
    }

    @Override
    public boolean isThereAnotherDistinctValue() {
        return this.m_column.isThereAnotherDistinctValue();
    }
}

