/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.Query;
import com.sas.query.models.Expression;
import com.sas.query.models.ResultItem;
import com.sas.query.models.StandardModel;

public class OrderItem
extends StandardModel {
    static final long serialVersionUID = -4031851485453371591L;
    public static final String ExpressionProperty = "expression";
    public static final String ResultItemProperty = "resultItem";
    public static final String DirectionProperty = "direction";
    public static final int OC_DEFAULT = 0;
    public static final int OC_ASC = 1;
    public static final int OC_DESC = 2;
    protected ResultItem m_resultItem = null;
    protected boolean m_bIsThisANumber = false;
    protected Expression m_expression = null;
    protected int m_sortingDirection = 0;

    public OrderItem(Query query, Expression expression) {
        super(query);
        this.m_expression = expression;
    }

    public OrderItem(ResultItem resultItem) {
        this(resultItem, false);
    }

    public OrderItem(ResultItem resultItem, boolean bIsThisANumber) {
        super(resultItem);
        this.m_resultItem = resultItem;
        this.m_bIsThisANumber = bIsThisANumber;
    }

    public OrderItem(Query query, int nPosition, int sortingDirection) {
        super(query);
        ResultItem resultItem;
        this.m_resultItem = resultItem = query.getResultItem(nPosition);
        this.m_sortingDirection = sortingDirection;
        this.m_bIsThisANumber = true;
    }

    public String getDisplayString() {
        if (this.m_expression != null) {
            return this.m_expression.getDisplayString();
        }
        return this.m_resultItem.getDisplayString();
    }

    public Expression getExpression() {
        if (this.m_expression != null) {
            return this.m_expression;
        }
        return this.m_resultItem.getExpression();
    }

    public void setExpression(Expression expression) {
        Expression oldExpression = this.m_expression;
        this.m_expression = expression;
        this.m_resultItem = null;
        this.queueDataChange(256, ExpressionProperty, oldExpression);
    }

    public boolean isThisANumber() {
        return this.m_bIsThisANumber;
    }

    public ResultItem getResultItem() {
        return this.m_resultItem;
    }

    public void setResultItem(ResultItem resultItem) {
        ResultItem oldResultItem = this.m_resultItem;
        this.m_expression = null;
        this.m_resultItem = resultItem;
        this.queueDataChange(256, ResultItemProperty, oldResultItem);
    }

    public int getSortingDirection() {
        return this.m_sortingDirection;
    }

    public void setSortingDirection(int newDirection) {
        int oldDirection = this.m_sortingDirection;
        this.m_sortingDirection = newDirection;
        this.queueDataChange(256, DirectionProperty, new Integer(oldDirection));
    }
}

