/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.models.Join;
import com.sas.query.models.JoinRelationshipList;
import com.sas.query.models.SimpleModel;
import com.sas.query.models.Table;
import java.util.Vector;

public class JoinList
extends SimpleModel {
    protected Vector m_list;

    public JoinList() {
        this.m_list = new Vector();
    }

    public JoinList(int initialSize) {
        this.m_list = new Vector(initialSize);
    }

    public int size() {
        return this.m_list.size();
    }

    public synchronized void addElement(Join object) {
        this.m_list.addElement(object);
    }

    public synchronized Join elementAt(int index) {
        return (Join)this.m_list.elementAt(index);
    }

    public synchronized Join getJoin(Table table) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.elementAt(i).getTable() != table) continue;
            return this.elementAt(i);
        }
        return null;
    }

    public final synchronized void insertElementAt(Join object, int index) {
        this.m_list.insertElementAt(object, index);
    }

    public final int indexOf(Join elem) {
        return this.m_list.indexOf(elem);
    }

    public final synchronized void removeAllElements() {
        this.m_list.removeAllElements();
    }

    public final boolean contains(Join elem) {
        return this.m_list.contains(elem);
    }

    public final synchronized void removeElementAt(int index) {
        this.m_list.removeElementAt(index);
    }

    public synchronized void removeElement(Join object) {
        this.m_list.removeElement(object);
    }

    public boolean moveJoinDown(Join join, JoinRelationshipList relationshipList) {
        int joinPosition = 0;
        for (int i = 0; i < this.m_list.size(); ++i) {
            if (join != this.elementAt(i)) continue;
            joinPosition = i;
            break;
        }
        if (joinPosition == this.m_list.size() - 1 || this.elementAt(joinPosition + 1).getNewJoinGroupValue()) {
            return false;
        }
        Join tempJoin = this.elementAt(joinPosition);
        this.removeElementAt(joinPosition);
        this.insertElementAt(tempJoin, joinPosition + 1);
        if (tempJoin.getNewJoinGroupValue()) {
            this.elementAt(joinPosition + 1).setNewJoinGroupValue(false);
            this.elementAt(joinPosition).setNewJoinGroupValue(true);
        }
        this.setAllRelationships(relationshipList);
        return true;
    }

    public boolean moveJoinUp(Join join, JoinRelationshipList relationshipList) {
        int joinPosition = this.m_list.size() - 1;
        for (int i = 0; i < this.m_list.size(); ++i) {
            if (join != this.elementAt(i)) continue;
            joinPosition = i;
            break;
        }
        if (joinPosition == 0 || this.elementAt(joinPosition - 1).getNewJoinGroupValue()) {
            return false;
        }
        Join tempJoin = this.elementAt(joinPosition);
        this.removeElementAt(joinPosition);
        this.insertElementAt(tempJoin, joinPosition - 1);
        if (this.elementAt(joinPosition).getNewJoinGroupValue()) {
            this.elementAt(joinPosition).setNewJoinGroupValue(false);
            tempJoin.setNewJoinGroupValue(true);
        }
        this.setAllRelationships(relationshipList);
        return true;
    }

    public void groupJoinsFromAdd(Table firstTable, Table otherTable, JoinRelationshipList masterList) {
        int i;
        int i2;
        int hiIndex;
        int loIndex;
        int firstIndex = 0;
        int otherIndex = 0;
        int hiGroupCount = 0;
        JoinList tempHiList = new JoinList();
        for (int i3 = 0; i3 < this.m_list.size(); ++i3) {
            if (this.elementAt(i3).getTable() == firstTable) {
                firstIndex = i3;
                continue;
            }
            if (this.elementAt(i3).getTable() != otherTable) continue;
            otherIndex = i3;
        }
        JoinList firstTableList = this.elementAt(firstIndex).getTableRelationships();
        JoinList otherTableList = this.elementAt(otherIndex).getTableRelationships();
        firstTableList.addElement(this.elementAt(otherIndex));
        this.elementAt(firstIndex).setTableRelationships(firstTableList);
        otherTableList.addElement(this.elementAt(firstIndex));
        this.elementAt(otherIndex).setTableRelationships(otherTableList);
        if (firstIndex < otherIndex) {
            loIndex = firstIndex;
            hiIndex = otherIndex;
        } else {
            loIndex = otherIndex;
            hiIndex = firstIndex;
        }
        for (i2 = loIndex + 1; i2 <= hiIndex && !this.elementAt(i2).getNewJoinGroupValue(); ++i2) {
            if (i2 != hiIndex) continue;
            this.orderJoins();
            this.setAllRelationships(masterList);
            return;
        }
        for (i2 = loIndex + 1; i2 < this.m_list.size(); ++i2) {
            if (!this.elementAt(i2).getNewJoinGroupValue()) continue;
            loIndex = i2 - 1;
            break;
        }
        if (this.elementAt(hiIndex).getNewJoinGroupValue()) {
            this.elementAt(hiIndex).setNewJoinGroupValue(false);
            for (i2 = hiIndex + 1; i2 < this.m_list.size() && !this.elementAt(i2).getNewJoinGroupValue(); ++i2) {
                ++hiGroupCount;
            }
        } else {
            int i4;
            int hiListCount = 0;
            int hiTableIndex = hiIndex;
            for (i4 = hiIndex; i4 >= 0; --i4) {
                tempHiList.addElement(this.elementAt(i4));
                ++hiListCount;
                if (!this.elementAt(i4).getNewJoinGroupValue()) continue;
                hiIndex = i4;
                this.elementAt(i4).setNewJoinGroupValue(false);
                for (i4 = hiIndex + 1; i4 < this.m_list.size() && !this.elementAt(i4).getNewJoinGroupValue(); ++i4) {
                    ++hiGroupCount;
                }
                break;
            }
            for (i4 = hiTableIndex + 1; i4 < this.m_list.size(); ++i4) {
                tempHiList.addElement(this.elementAt(i4));
                if (!this.elementAt(i4).getNewJoinGroupValue()) {
                    continue;
                }
                break;
            }
        }
        JoinList tempList = new JoinList();
        for (i = 0; i <= loIndex; ++i) {
            tempList.addElement(this.elementAt(i));
        }
        if (tempHiList.size() > 0) {
            for (int k = 0; k < tempHiList.size(); ++k) {
                tempList.addElement(tempHiList.elementAt(k));
            }
        } else {
            for (i = hiIndex; i <= hiIndex + hiGroupCount; ++i) {
                tempList.addElement(this.elementAt(i));
            }
        }
        for (i = 0; i <= hiGroupCount; ++i) {
            this.m_list.removeElement(this.elementAt(hiIndex));
        }
        for (i = loIndex + 1; i < this.m_list.size(); ++i) {
            tempList.addElement(this.elementAt(i));
        }
        this.m_list = tempList.m_list;
        this.orderJoins();
        this.setAllRelationships(masterList);
    }

    public void groupJoinsFromList(JoinRelationshipList masterList) {
        int i;
        for (i = 0; i < this.m_list.size(); ++i) {
            this.elementAt(i).setNewJoinGroupValue(true);
            if (this.elementAt(i).getRelationships() != null) {
                this.elementAt(i).getRelationships().removeAllElements();
            }
            if (this.elementAt(i).getTableRelationships() == null) continue;
            this.elementAt(i).getTableRelationships().removeAllElements();
        }
        for (i = 0; i < masterList.size(); ++i) {
            this.groupJoinsFromAdd(masterList.elementAt(i).getLeftTable(), masterList.elementAt(i).getRightTable(), masterList);
        }
    }

    public void orderJoins() {
        JoinList groupList = new JoinList();
        JoinList tempList = new JoinList();
        for (int i = 0; i < this.m_list.size(); ++i) {
            groupList.addElement(this.elementAt(i));
            if (i != this.m_list.size() - 1 && !this.elementAt(i + 1).getNewJoinGroupValue()) continue;
            groupList = this._orderJoins(groupList);
            for (int j = 0; j < groupList.size(); ++j) {
                tempList.addElement(groupList.elementAt(j));
            }
            groupList.removeAllElements();
        }
        this.m_list = tempList.m_list;
    }

    private JoinList _orderJoins(JoinList groupList) {
        JoinList orderedJoins = new JoinList();
        for (int i = 0; i < groupList.size(); ++i) {
            Join currentJoin = groupList.elementAt(i);
            boolean fromRawList = true;
            if (orderedJoins.contains(currentJoin)) {
                groupList.removeElement(currentJoin);
                i = -1;
                continue;
            }
            if (currentJoin.getNewJoinGroupValue()) {
                orderedJoins.addElement(currentJoin);
                if (currentJoin.getTableRelationships().size() == 0) {
                    i = -1;
                    continue;
                }
                orderedJoins.addElement(currentJoin.getTableRelationships().elementAt(0));
                currentJoin = currentJoin.getTableRelationships().elementAt(0);
                fromRawList = false;
            }
            if (fromRawList) {
                for (int j = 0; j < currentJoin.getTableRelationships().size(); ++j) {
                    if (!orderedJoins.contains(currentJoin.getTableRelationships().elementAt(j))) continue;
                    orderedJoins.addElement(currentJoin);
                    fromRawList = false;
                    break;
                }
                if (fromRawList) {
                    i = -1;
                    continue;
                }
            }
            if (fromRawList) continue;
            boolean moreJoins = true;
            block2: while (moreJoins) {
                for (int j = 0; j < currentJoin.getTableRelationships().size(); ++j) {
                    if (orderedJoins.contains(currentJoin.getTableRelationships().elementAt(j))) continue;
                    orderedJoins.addElement(currentJoin.getTableRelationships().elementAt(j));
                    currentJoin = currentJoin.getTableRelationships().elementAt(j);
                    continue block2;
                }
                moreJoins = false;
            }
            i = -1;
        }
        groupList.m_list = orderedJoins.m_list;
        return groupList;
    }

    public boolean isJoinListValid() {
        return this.getFirstTableWithNoRelationships() == null;
    }

    public Join getFirstTableWithNoRelationships() {
        for (int i = 0; i < this.m_list.size(); ++i) {
            if (this.elementAt(i).getNewJoinGroupValue() || this.elementAt(i).getRelationships().size() != 0) continue;
            return this.elementAt(i);
        }
        return null;
    }

    public void setAllRelationships(JoinRelationshipList masterList) {
        int startIndex = 0;
        for (int i = 0; i < this.m_list.size(); ++i) {
            if (this.elementAt(i).getNewJoinGroupValue()) {
                startIndex = i;
                this.elementAt(i).setRelationships(null);
                continue;
            }
            Table joinTable = this.elementAt(i).getTable();
            JoinRelationshipList subList = new JoinRelationshipList();
            for (int k = startIndex; k < i; ++k) {
                for (int j = 0; j < masterList.size(); ++j) {
                    if (masterList.elementAt(j).getLeftTable() != joinTable && masterList.elementAt(j).getRightTable() != joinTable || masterList.elementAt(j).getLeftTable() != this.elementAt(k).getTable() && masterList.elementAt(j).getRightTable() != this.elementAt(k).getTable()) continue;
                    subList.addElement(masterList.elementAt(j));
                }
            }
            this.elementAt(i).setRelationships(subList);
        }
    }

    public Object deepClone() throws CloneNotSupportedException {
        JoinList newList = new JoinList(this.m_list.size());
        for (int index = 0; index < this.m_list.size(); ++index) {
            newList.addElement((Join)this.elementAt(index).clone());
        }
        return newList;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        JoinList newList = new JoinList(this.m_list.size());
        for (int index = 0; index < this.m_list.size(); ++index) {
            newList.addElement(this.elementAt(index));
        }
        return newList;
    }
}

