/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.Query;
import com.sas.query.models.Column;
import com.sas.query.models.ColumnList;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.ModelChangeListener;
import com.sas.query.models.ResultItem;
import com.sas.query.models.ResultItemList;
import com.sas.query.models.StandardModel;
import com.sas.query.models.Table;
import com.sas.query.models.TableList;
import com.sas.query.visuals.QueryResource;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JReferableTree
extends StandardModel
implements TreeModel,
ModelChangeListener {
    public static final int INCLUDE_RESULT_ITEMS = 1;
    public static final int NO_INCLUDE_RESULT_ITEMS = 2;
    public static final transient String RootPropertyChange = "root";
    protected static transient QueryResource bundle = new QueryResource(JReferableTree.class);
    protected transient String m_name;
    protected transient String m_rootString;
    protected transient String m_computedString;
    protected transient Vector m_modelListenerList = null;
    protected transient TableList m_referableTables;
    protected transient int m_cTables;
    protected transient boolean m_bIncludeResultItems;
    protected transient ResultItemList m_computedResultColumns;
    protected transient int m_cComputedColumns = -1;

    public JReferableTree(Query query) {
        this(query, 1);
    }

    public JReferableTree(Query query, int flags) {
        super(query);
        this.m_bIncludeResultItems = flags != 2;
        query.addPropertyListener(this, 28);
        this.m_name = bundle.getString("JReferableTree.Tree.Title.txt");
        this.m_rootString = bundle.getString("JReferableTree.Root.txt");
        this.m_computedString = bundle.getString("JReferableTree.ResultColumns.txt");
        this.refresh();
    }

    @Override
    public Object getRoot() {
        return new String(this.m_rootString);
    }

    @Override
    public Object getChild(Object parent, int index) {
        Object returnValue = null;
        if (parent instanceof Table) {
            returnValue = ((Table)parent).getColumns().elementAt(index);
        } else if (parent instanceof String) {
            returnValue = this.m_rootString.equals((String)parent) ? (index == 0 && this.m_cComputedColumns != 0 ? this.m_computedString : (this.m_cComputedColumns != 0 ? this.m_referableTables.elementAt(index - 1) : this.m_referableTables.elementAt(index))) : this.m_computedResultColumns.elementAt(index);
        }
        return returnValue;
    }

    @Override
    public int getChildCount(Object parent) {
        int returnValue = 0;
        if (parent instanceof Table) {
            returnValue = ((Table)parent).getColumnCount();
        } else if (parent instanceof String) {
            if (this.m_rootString.equals((String)parent)) {
                returnValue = this.m_referableTables.size();
                if (this.m_cComputedColumns != 0) {
                    ++returnValue;
                }
            } else {
                returnValue = this.m_cComputedColumns;
            }
        }
        return returnValue;
    }

    @Override
    public boolean isLeaf(Object node) {
        boolean returnValue = false;
        if (node instanceof Column || node instanceof ResultItem) {
            returnValue = true;
        }
        return returnValue;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int returnValue;
        block5: {
            block6: {
                returnValue = 0;
                if (!(parent instanceof Table)) break block6;
                ColumnList list = ((Table)parent).getColumns();
                for (int index = 0; index < list.size(); ++index) {
                    if (child != list.elementAt(index)) continue;
                    returnValue = index;
                    break block5;
                }
                break block5;
            }
            if (!(parent instanceof String)) break block5;
            if (this.m_rootString.equals((String)parent)) {
                for (int index = 0; index < this.m_cTables; ++index) {
                    if (child != this.m_referableTables.elementAt(index)) continue;
                    returnValue = index + 1;
                    break;
                }
            } else {
                for (int index = 0; index < this.m_cComputedColumns; ++index) {
                    if (child != this.m_computedResultColumns.elementAt(index)) continue;
                    returnValue = index;
                    break;
                }
            }
        }
        return returnValue;
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        if (this.m_modelListenerList == null) {
            this.m_modelListenerList = new Vector();
        }
        for (int index = 0; index < this.m_modelListenerList.size(); ++index) {
            if (this.m_modelListenerList.elementAt(index) != listener) continue;
            return;
        }
        this.m_modelListenerList.addElement(listener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        if (this.m_modelListenerList == null) {
            return;
        }
        this.m_modelListenerList.removeElement(listener);
    }

    public void refresh() {
        this.m_referableTables = this.m_query.getReferableTables();
        this.m_cTables = this.m_referableTables.size();
        if (this.m_bIncludeResultItems) {
            this.m_computedResultColumns = this.m_query.getResultItems();
            this.m_cComputedColumns = this.m_computedResultColumns.size();
        } else if (this.m_cComputedColumns != 0) {
            this.m_cComputedColumns = 0;
            this.m_computedResultColumns = new ResultItemList();
        }
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
        this.refresh();
        this.fireTreeStructureChange(RootPropertyChange, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeStructureChange(String propertyName, Object oldValue, Object newValue) {
        Vector targets;
        if (oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        JReferableTree jReferableTree = this;
        synchronized (jReferableTree) {
            if (this.m_modelListenerList == null) {
                return;
            }
            targets = (Vector)this.m_modelListenerList.clone();
        }
        TreeModelEvent event = new TreeModelEvent((Object)this, new TreePath(this));
        for (int index = 0; index < targets.size(); ++index) {
            TreeModelListener target = (TreeModelListener)targets.elementAt(index);
            target.treeStructureChanged(event);
        }
    }
}

