/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.Query;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.DataSourceColumn;
import com.sas.query.datasources.DataSourceColumnList;
import com.sas.query.datasources.DataSourceContainer;
import com.sas.query.datasources.DataSourceContainerList;
import com.sas.query.datasources.DataSourceTable;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.ModelChangeListener;
import com.sas.query.models.StandardModel;
import com.sas.query.visuals.QueryResource;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JDataSourceTree
extends StandardModel
implements TreeModel,
ModelChangeListener {
    public static final String RootPropertyChange = "root";
    public static final int TABLES = 1;
    public static final int VIEWS = 2;
    public static final int TABLES_AND_VIEWS = 3;
    protected static QueryResource bundle = new QueryResource(JDataSourceTree.class);
    protected transient Vector m_modelListenerList = null;
    protected transient DataSource m_dataSource;
    protected transient boolean m_bDisplayColumns;
    protected transient int m_types;

    public JDataSourceTree(Query query, DataSource dataSource, boolean bDisplayColumns) {
        this(query, dataSource, bDisplayColumns, 3);
    }

    public JDataSourceTree(Query query, DataSource dataSource, boolean bDisplayColumns, int types) {
        super(query);
        this.m_dataSource = dataSource;
        this.m_bDisplayColumns = bDisplayColumns;
        this.m_types = types;
        query.addPropertyListener(this, 1024);
        this.refresh();
    }

    @Override
    public Object getRoot() {
        return this.m_dataSource;
    }

    @Override
    public Object getChild(Object parent, int index) {
        Object returnValue = null;
        if (parent instanceof DataSourceTable) {
            returnValue = ((DataSourceTable)parent).getColumns().elementAt(index);
        } else if (parent instanceof DataSourceContainer) {
            returnValue = ((DataSourceContainer)parent).getItems().elementAt(index);
        }
        return returnValue;
    }

    @Override
    public int getChildCount(Object parent) {
        int returnValue = 0;
        if (parent instanceof DataSourceColumn) {
            returnValue = 0;
        } else if (parent instanceof DataSourceTable) {
            if (this.m_bDisplayColumns) {
                returnValue = ((DataSourceTable)parent).getColumnCount();
            }
        } else if (parent instanceof DataSourceContainer) {
            returnValue = ((DataSourceContainer)parent).getItemCount();
        }
        return returnValue;
    }

    @Override
    public boolean isLeaf(Object node) {
        boolean returnValue = false;
        if (node instanceof DataSourceColumn) {
            returnValue = true;
        } else if (node instanceof DataSourceTable && !this.m_bDisplayColumns) {
            returnValue = true;
        }
        return returnValue;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int returnValue;
        block2: {
            block3: {
                returnValue = 0;
                if (!(parent instanceof DataSourceTable)) break block3;
                DataSourceColumnList list = ((DataSourceTable)parent).getColumns();
                for (int index = 0; index < list.size(); ++index) {
                    if (child != list.elementAt(index)) continue;
                    returnValue = index;
                    break block2;
                }
                break block2;
            }
            if (!(parent instanceof DataSourceContainer)) break block2;
            DataSourceContainerList list = ((DataSourceContainer)parent).getItems();
            for (int index = 0; index < list.size(); ++index) {
                if (child != list.elementAt(index)) continue;
                returnValue = index;
                break;
            }
        }
        return returnValue;
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        if (this.m_modelListenerList == null) {
            this.m_modelListenerList = new Vector();
        }
        for (int index = 0; index < this.m_modelListenerList.size(); ++index) {
            if (this.m_modelListenerList.elementAt(index) != listener) continue;
            return;
        }
        this.m_modelListenerList.addElement(listener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        if (this.m_modelListenerList == null) {
            return;
        }
        this.m_modelListenerList.removeElement(listener);
    }

    public void refresh() {
        this.m_dataSource = this.m_query.getDataSource();
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
        this.refresh();
        this.fireTreeStructureChange(RootPropertyChange, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeStructureChange(String propertyName, Object oldValue, Object newValue) {
        Vector targets;
        if (oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        JDataSourceTree jDataSourceTree = this;
        synchronized (jDataSourceTree) {
            if (this.m_modelListenerList == null) {
                return;
            }
            targets = (Vector)this.m_modelListenerList.clone();
        }
        TreeModelEvent event = new TreeModelEvent((Object)this, new TreePath(this));
        for (int index = 0; index < targets.size(); ++index) {
            TreeModelListener target = (TreeModelListener)targets.elementAt(index);
            target.treeStructureChanged(event);
        }
    }
}

