/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.models.FilterNetworkAtomExpression;
import com.sas.query.models.FilterNetworkConnector;
import com.sas.query.models.FilterNetworkConstants;
import com.sas.query.models.FilterNode;

public class FilterNetworkAtom
implements FilterNetworkConstants {
    protected FilterNetworkConnector m_pred = null;
    protected FilterNetworkConnector m_succ = null;
    protected boolean m_mark = false;
    protected FilterNetworkAtomExpression m_contents = new FilterNetworkAtomExpression();

    public FilterNetworkAtom(FilterNode fn) {
        this.m_contents.addElement(fn);
    }

    public String toString() {
        return "FNAtom wrapping" + this.m_contents.toString();
    }

    public void setMark() {
        if (!this.m_mark) {
            this.m_mark = true;
            if (this.m_pred != null) {
                this.m_pred.getPredecessors().setMark();
            }
        }
    }

    public boolean isMarked() {
        return this.m_mark;
    }

    public FilterNetworkConnector getSuccessor() {
        return this.m_succ;
    }

    public FilterNetworkConnector getPredecessor() {
        return this.m_pred;
    }

    public void setSuccessor(FilterNetworkConnector succ) {
        if (this.m_succ != null) {
            this.m_succ.removePredecessor(this);
        }
        this.m_succ = succ;
        if (this.m_succ != null) {
            this.m_succ.addPredecessor(this);
        }
    }

    public void setPredecessor(FilterNetworkConnector pred) {
        if (this.m_pred != null) {
            this.m_pred.removeSuccessor(this);
        }
        this.m_pred = pred;
        if (this.m_pred != null) {
            this.m_pred.addSuccessor(this);
        }
    }

    public FilterNetworkAtomExpression getContents() {
        return this.m_contents;
    }

    public FilterNetworkAtomExpression generateRemaindingNetworkContents() {
        FilterNetworkAtomExpression retVal = new FilterNetworkAtomExpression();
        retVal.append(this.getContents());
        FilterNetworkAtomExpression followon = this.getSuccessor().generateRemaindingNetworkContents();
        if (!followon.isEmpty()) {
            retVal = retVal.appropriatelyWrappedList(" AND");
            retVal.addElement(" AND");
            retVal.append(followon);
        }
        return retVal;
    }

    public void setContents(FilterNetworkAtomExpression newcontent) {
        this.m_contents = newcontent;
    }
}

