/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.Query;
import com.sas.query.models.FilterNetworkAtom;
import com.sas.query.models.FilterNetworkAtomExpression;
import com.sas.query.models.FilterNetworkAtomList;
import com.sas.query.models.FilterNetworkConnector;
import com.sas.query.models.FilterNetworkConstants;
import com.sas.query.models.FilterNode;
import com.sas.query.models.FilterTree;
import java.util.Hashtable;
import java.util.Vector;

public class FilterNetwork
implements FilterNetworkConstants {
    protected transient Query m_query = null;
    protected transient FilterTree m_filterTree = null;
    protected transient Hashtable nodesToAtoms = null;
    protected transient FilterNetworkConnector StartOfNetworkConnector = null;
    protected transient FilterNetworkConnector EndOfNetworkConnector = null;

    public FilterNetwork() {
        this._initialize();
    }

    private void _initialize() {
        this.m_query = null;
        this.nodesToAtoms = null;
        this.StartOfNetworkConnector = null;
        this.EndOfNetworkConnector = null;
    }

    public void setQuery(Query query) {
        this.m_query = query;
    }

    public FilterTree getFilterTree() {
        return this.m_filterTree;
    }

    public FilterNetworkAtomExpression simplify() {
        FilterNetworkAtomList allAtomsInNetwork = new FilterNetworkAtomList();
        Vector nodesVector2 = new Vector();
        this.getFilterTree().getNodesVector(nodesVector2, this.getFilterTree().getRoot());
        for (int i = 0; i < nodesVector2.size(); ++i) {
            FilterNode aFilterNode = (FilterNode)nodesVector2.elementAt(i);
            FilterNetworkAtom hisAtom = (FilterNetworkAtom)this.nodesToAtoms.get(aFilterNode);
            if (hisAtom == null || !hisAtom.isMarked()) continue;
            allAtomsInNetwork.insertElementAt(hisAtom, 0);
        }
        int previousNetworkSize = this.NetworkConnectorNodeCount();
        int currentNetworkSize = previousNetworkSize++;
        while (currentNetworkSize < previousNetworkSize) {
            previousNetworkSize = currentNetworkSize;
            while (this.convertedCAC(allAtomsInNetwork)) {
            }
            while (this.convertedCAAC(allAtomsInNetwork)) {
            }
            while (this.convertedACA(allAtomsInNetwork)) {
            }
            while (this.convertedCAC(allAtomsInNetwork)) {
            }
            while (this.convertedCAAC(allAtomsInNetwork)) {
            }
            while (this.convertedACA(allAtomsInNetwork)) {
            }
            currentNetworkSize = this.NetworkConnectorNodeCount();
        }
        if (this.StartToEndLength() == 1) {
            return this.StartOfNetworkConnector.getContents();
        }
        return this.StartOfNetworkConnector.generateRemaindingNetworkContents();
    }

    public boolean convertedCAC(FilterNetworkAtomList allAtomsInNetwork) {
        boolean ret = false;
        for (int i = allAtomsInNetwork.size(); i > 0; --i) {
            FilterNetworkAtom current = allAtomsInNetwork.getElement(i - 1);
            FilterNetworkConnector pred = current.getPredecessor();
            FilterNetworkConnector succ = current.getSuccessor();
            if (succ.getPredecessors().size() != 1 || pred.getSuccessors().size() != 1) continue;
            ret = true;
            pred.setSuccessors((FilterNetworkAtomList)succ.getSuccessors().clone());
            pred.setContents(pred.getContents().and(current.getContents(), succ.getContents()));
            current.setPredecessor(null);
            current.setSuccessor(null);
            allAtomsInNetwork.removeElement(current);
        }
        return ret;
    }

    public boolean convertedCAAC(FilterNetworkAtomList allAtomsInNetwork) {
        boolean ret = false;
        for (int i = allAtomsInNetwork.size(); i > 0; --i) {
            int j;
            FilterNetworkAtomList mergeList = new FilterNetworkAtomList();
            FilterNetworkAtom current = allAtomsInNetwork.getElement(i - 1);
            FilterNetworkConnector currentpred = current.getPredecessor();
            FilterNetworkConnector currentsucc = current.getSuccessor();
            mergeList.addElement(current);
            for (j = allAtomsInNetwork.size(); j > 0; --j) {
                FilterNetworkAtom undertest = allAtomsInNetwork.getElement(j - 1);
                FilterNetworkConnector undertestpred = undertest.getPredecessor();
                FilterNetworkConnector undertestsucc = undertest.getSuccessor();
                if (currentpred != undertestpred || currentsucc != undertestsucc || undertest == current) continue;
                ret = true;
                mergeList.addElement(undertest);
                undertest.setPredecessor(null);
                undertest.setSuccessor(null);
            }
            if (!ret) continue;
            current.setContents(FilterNetworkAtomExpression.or(mergeList));
            for (j = mergeList.size(); j > 0; --j) {
                if (mergeList.getElement(j - 1) == current) continue;
                allAtomsInNetwork.removeElement(mergeList.getElement(j - 1));
            }
            return ret;
        }
        return ret;
    }

    public boolean convertedACA(FilterNetworkAtomList allAtomsInNetwork) {
        boolean ret = false;
        for (int i = allAtomsInNetwork.size(); i > 0; --i) {
            FilterNetworkAtom current = allAtomsInNetwork.getElement(i - 1);
            FilterNetworkConnector succ = current.getSuccessor();
            FilterNetworkConnector pred = current.getPredecessor();
            FilterNetworkAtom follower = null;
            if (succ.getPredecessors().size() != 1 || succ.getSuccessors().size() != 1) continue;
            follower = succ.getSuccessors().getElement(0);
            ret = true;
            follower.setContents(current.getContents().and(succ.getContents(), follower.getContents()));
            pred.getSuccessors().removeIfFound(current);
            follower.setPredecessor(pred);
            allAtomsInNetwork.removeElementAt(i - 1);
        }
        return ret;
    }

    public int StartToEndLength() {
        Vector<FilterNetworkConnector> traversedList = new Vector<FilterNetworkConnector>();
        FilterNetworkConnector current = this.StartOfNetworkConnector;
        traversedList.addElement(current);
        int currentCount = 1;
        while (current.getSuccessors().size() != 0) {
            if (traversedList.contains(current = current.getFirstSuccessorConnector())) {
                return 0;
            }
            traversedList.addElement(current);
            ++currentCount;
        }
        return currentCount;
    }

    public int NetworkConnectorNodeCount() {
        int currentCount = 0;
        Vector traversedList = new Vector();
        if (this.StartOfNetworkConnector == null) {
            return currentCount;
        }
        return this.StartOfNetworkConnector.NetworkConnectorNodeCount(traversedList);
    }

    public FilterNetworkAtomExpression generateOptimizedFilterClause(Query query, FilterTree filterTree) {
        return this.generateOptimizedFilterClause(query, filterTree, null);
    }

    public FilterNetworkAtomExpression generateOptimizedFilterClause(Query query, FilterTree filterTree, FilterNode finalNode) {
        this.setQuery(query);
        this.m_filterTree = filterTree;
        if (this.generateNetworkAndAtomList(finalNode)) {
            FilterNetworkAtomExpression ret = this.simplify();
            return ret;
        }
        return null;
    }

    public boolean generateNetworkAndAtomList(FilterNode finalNode) {
        FilterNetworkAtom hisAtom;
        FilterNode aFilterNode;
        int i;
        this.StartOfNetworkConnector = new FilterNetworkConnector();
        this.EndOfNetworkConnector = new FilterNetworkConnector();
        this.nodesToAtoms = new Hashtable();
        Vector nodesVector = new Vector();
        this.getFilterTree().getNodesVector(nodesVector, this.getFilterTree().getRoot());
        for (int i2 = 0; i2 < nodesVector.size(); ++i2) {
            FilterNode aFilterNode2 = (FilterNode)nodesVector.elementAt(i2);
            FilterNetworkAtom anewAtom = new FilterNetworkAtom(aFilterNode2);
            this.nodesToAtoms.put(aFilterNode2, anewAtom);
            new FilterNetworkConnector(anewAtom);
        }
        FilterNode root = this.getFilterTree().getRoot();
        if (root == null) {
            return false;
        }
        FilterNetworkAtom rootAtom = (FilterNetworkAtom)this.nodesToAtoms.get(root);
        if (rootAtom == null) {
            return false;
        }
        rootAtom.setPredecessor(this.StartOfNetworkConnector);
        for (i = 0; i < nodesVector.size(); ++i) {
            aFilterNode = (FilterNode)nodesVector.elementAt(i);
            if (aFilterNode.getAnd() != null) continue;
            hisAtom = (FilterNetworkAtom)this.nodesToAtoms.get(aFilterNode);
            if (hisAtom == null) {
                return false;
            }
            hisAtom.setSuccessor(this.EndOfNetworkConnector);
        }
        for (i = 0; i < nodesVector.size(); ++i) {
            aFilterNode = (FilterNode)nodesVector.elementAt(i);
            if (aFilterNode.getAndParents().size() <= 0) continue;
            hisAtom = (FilterNetworkAtom)this.nodesToAtoms.get(aFilterNode);
            if (hisAtom == null) {
                return false;
            }
            FilterNode firstParent = (FilterNode)aFilterNode.getAndParents().elementAt(0);
            FilterNetworkAtom parentAtom = (FilterNetworkAtom)this.nodesToAtoms.get(firstParent);
            if (parentAtom == null) {
                return false;
            }
            FilterNetworkConnector postParent = parentAtom.getSuccessor();
            postParent.addSuccessor(hisAtom);
        }
        for (i = 0; i < nodesVector.size(); ++i) {
            aFilterNode = (FilterNode)nodesVector.elementAt(i);
            if (aFilterNode.getAndParents().size() <= 1) continue;
            hisAtom = (FilterNetworkAtom)this.nodesToAtoms.get(aFilterNode);
            if (hisAtom == null) {
                return false;
            }
            FilterNetworkConnector preMe = hisAtom.getPredecessor();
            for (int j = 1; j < aFilterNode.getAndParents().size(); ++j) {
                FilterNode anotherParent = (FilterNode)aFilterNode.getAndParents().elementAt(j);
                FilterNetworkAtom anotherParentAtom = (FilterNetworkAtom)this.nodesToAtoms.get(anotherParent);
                if (anotherParentAtom == null) {
                    return false;
                }
                anotherParentAtom.setSuccessor(preMe);
            }
        }
        Vector<FilterNode> deferredOrChildren = new Vector<FilterNode>();
        for (int i3 = 0; i3 < nodesVector.size(); ++i3) {
            FilterNode aFilterNode3 = (FilterNode)nodesVector.elementAt(i3);
            if (aFilterNode3.getOrParent() == null) continue;
            FilterNetworkAtom hisAtom2 = (FilterNetworkAtom)this.nodesToAtoms.get(aFilterNode3);
            if (hisAtom2 == null) {
                return false;
            }
            FilterNode orParent = aFilterNode3.getOrParent();
            FilterNetworkAtom orParentAtom = (FilterNetworkAtom)this.nodesToAtoms.get(orParent);
            if (orParentAtom == null) {
                return false;
            }
            FilterNetworkConnector preOrParent = orParentAtom.getPredecessor();
            if (preOrParent != null) {
                preOrParent.addSuccessor(hisAtom2);
                continue;
            }
            deferredOrChildren.addElement(aFilterNode3);
        }
        while (deferredOrChildren.size() > 0) {
            Vector<FilterNode> deferredAgainOrChildren = new Vector<FilterNode>();
            for (int i4 = 0; i4 < deferredOrChildren.size(); ++i4) {
                FilterNode aFilterNode4 = (FilterNode)deferredOrChildren.elementAt(i4);
                if (aFilterNode4.getOrParent() == null) continue;
                FilterNetworkAtom hisAtom3 = (FilterNetworkAtom)this.nodesToAtoms.get(aFilterNode4);
                if (hisAtom3 == null) {
                    return false;
                }
                FilterNode orParent = aFilterNode4.getOrParent();
                FilterNetworkAtom orParentAtom = (FilterNetworkAtom)this.nodesToAtoms.get(orParent);
                if (orParentAtom == null) {
                    return false;
                }
                FilterNetworkConnector preOrParent = orParentAtom.getPredecessor();
                if (preOrParent != null) {
                    preOrParent.addSuccessor(hisAtom3);
                    continue;
                }
                deferredAgainOrChildren.addElement(aFilterNode4);
            }
            deferredOrChildren = deferredAgainOrChildren;
        }
        if (finalNode != null) {
            FilterNetworkAtom finalNodeAtom = (FilterNetworkAtom)this.nodesToAtoms.get(finalNode);
            if (finalNodeAtom == null) {
                return false;
            }
            finalNodeAtom.setMark();
            this.StartOfNetworkConnector.sweepForward();
            FilterNetworkAtomList newPreTerm = new FilterNetworkAtomList();
            newPreTerm.addElement(finalNodeAtom);
            this.EndOfNetworkConnector.setPredecessors(newPreTerm);
        } else {
            this.EndOfNetworkConnector.getPredecessors().setMark();
        }
        return true;
    }
}

