/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.Query;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.Function;
import com.sas.query.datasources.FunctionConstants;
import com.sas.query.datasources.FunctionList;
import com.sas.query.datasources.SqlLogic;
import com.sas.query.models.ColumnList;
import com.sas.query.models.CompoundExpression;
import com.sas.query.models.ConstantExpression;
import com.sas.query.models.ExpressionConstants;
import com.sas.query.models.ExpressionList;
import com.sas.query.models.FilterNodeWrapper;
import com.sas.query.models.RefreshInterface;
import com.sas.query.models.RefreshMapTable;
import com.sas.query.models.ResultItem;
import com.sas.query.models.SimpleModel;
import com.sas.query.models.UnparsedExpression;
import com.sas.query.parser.Parser;
import com.sas.query.parser.ParserException;
import com.sas.query.parser.Token;
import com.sas.query.parser.TokenConstants;
import com.sas.query.parser.TokenList;
import com.sas.query.parser.Tokenizer;
import com.sas.query.visuals.QueryResource;

public abstract class Expression
extends SimpleModel
implements ExpressionConstants,
FunctionConstants,
RefreshInterface,
TokenConstants {
    protected static QueryResource bundle = new QueryResource(Expression.class);
    static final long serialVersionUID = 2140826142496082243L;
    static Parser staticParser = new Parser();
    protected int m_dataType = 0;
    protected boolean m_bUnaryNegated = false;

    public Expression() {
    }

    public Expression(Expression guyToCopy) {
        this.m_dataType = guyToCopy.m_dataType;
        this.m_bUnaryNegated = guyToCopy.m_bUnaryNegated;
    }

    public void toggleLogicalNegation(Function andFunction, Function orFunction) throws ParserException {
        throw new ParserException("toggleLogicalNegation not implemented for this type of expression");
    }

    public String getDisplayString() {
        return this.toString();
    }

    public String getDisplayString(int viewType, Query query, int declareOrReference) {
        if (viewType == 1) {
            return this.toString();
        }
        if (query != null) {
            return this.generateSQL(query.getSqlLogic(), declareOrReference);
        }
        return this.toString();
    }

    public abstract String toString();

    public boolean equivalentTo(Query query, Expression otherExpression) {
        String otherSql;
        String thisSql = this.generateSQL(query.getSqlLogic(), 1);
        return thisSql.equals(otherSql = otherExpression.generateSQL(query.getSqlLogic(), 1));
    }

    public String getAlias(SqlLogic sqlLogic) {
        String retString = null;
        ResultItem item = sqlLogic.getQuery().getResultItem(this);
        if (item != null) {
            retString = item.getAlias();
        }
        if (retString != null) {
            retString = sqlLogic.genIdentifier(retString);
        }
        return retString;
    }

    public int getDataType() {
        return this.m_dataType;
    }

    public void setDataType(int dataType) {
        this.m_dataType = dataType;
    }

    public boolean isParsed() {
        return true;
    }

    public boolean returnsNulls() {
        return true;
    }

    public ColumnList getReferencedColumns() {
        return new ColumnList();
    }

    public FunctionList getReferencedFunctions() {
        FunctionList functionList = new FunctionList();
        return functionList;
    }

    @Override
    public void refresh(DataSource dso, RefreshMapTable mapTable) {
    }

    @Override
    public void getDefaultRefreshMapping(DataSource dataSource, RefreshMapTable mapTable) {
    }

    public boolean isAggregation() {
        return false;
    }

    public boolean hasAggregation() {
        return this.isAggregation();
    }

    public boolean isAggregatable() {
        return !this.hasAggregation();
    }

    public String getAggregationType() {
        return null;
    }

    public Expression addAggregation(Function aggregateFunction) {
        if (this.isAggregatable()) {
            CompoundExpression wrappedExpression = new CompoundExpression(aggregateFunction, this);
            return wrappedExpression;
        }
        return null;
    }

    public Expression addAggregation(Query myQuery, String aggregateType) {
        return this.addAggregation(myQuery, aggregateType, "");
    }

    public Expression addAggregation(Query myQuery, String aggregateType, String distinctAll) {
        if (this.isAggregatable()) {
            Function aggregateFunction = myQuery.getDataSourceFunction(1, aggregateType, this.getDataType(), 0, -1);
            if (aggregateFunction == null) {
                return null;
            }
            boolean isLiteral = true;
            ConstantExpression distinct = new ConstantExpression(distinctAll, 4, isLiteral);
            CompoundExpression wrappedExpression = new CompoundExpression(aggregateFunction, distinct, this);
            return wrappedExpression;
        }
        myQuery.getMessageHandler().addError(bundle.messageString("Message.Expression.CantAggregate.fmt.txt", this.toString()));
        return null;
    }

    public void replaceChildExpression(Expression fromExp, Expression toExp) {
    }

    public Function getOperator(Query myQuery, String OperatorString) {
        Function operatorFunction = myQuery.getDataSourceFunction(12, OperatorString, this.getDataType(), this.getDataType(), -1);
        return operatorFunction;
    }

    public Function getOperator(Query myQuery, String OperatorString, int numParms) {
        Function operatorFunction = myQuery.getDataSourceFunction(12, OperatorString, this.getDataType(), this.getDataType(), numParms);
        return operatorFunction;
    }

    public Expression deleteAggregation() {
        return this;
    }

    public boolean equals(Object otherGuy) {
        if (otherGuy instanceof Expression) {
            return this.getDisplayString().equals(((Expression)otherGuy).getDisplayString());
        }
        return super.equals(otherGuy);
    }

    public boolean isValid(Query query) {
        return true;
    }

    public abstract String generateSQL(SqlLogic var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Expression createInstance(Query query, String string) {
        query.getMessageHandler().removeAllMessages();
        Expression retExp = null;
        try {
            retExp = staticParser.parseExpression(query, string);
        }
        catch (Throwable t) {
            retExp = new UnparsedExpression(string);
        }
        finally {
            staticParser.reset();
        }
        return retExp;
    }

    public static ExpressionList createInstanceList(Query query, String originalContent) {
        query.getMessageHandler().removeAllMessages();
        ExpressionList retList = new ExpressionList();
        Tokenizer tokenizer = new Tokenizer(query.getDataSource(), originalContent, query.getMessageHandler());
        TokenList tokenList = tokenizer.getTokens();
        TokenList currentTokenQueue = new TokenList(originalContent);
        for (int i = 0; i < tokenList.size(); ++i) {
            Token t = tokenList.elementAt(i);
            if (t.getType() == 13) {
                if (t.getSubType() == 40) {
                    if (currentTokenQueue.size() <= 0) continue;
                    Expression piece = Expression.createInstance(query, currentTokenQueue.toString());
                    retList.addElement(piece);
                    currentTokenQueue.removeAllElements();
                    continue;
                }
                currentTokenQueue.addElement(t);
                continue;
            }
            currentTokenQueue.addElement(t);
        }
        if (currentTokenQueue.size() > 0) {
            Expression piece = Expression.createInstance(query, currentTokenQueue.toString());
            retList.addElement(piece);
            currentTokenQueue.removeAllElements();
        }
        return retList;
    }

    public static final int getDataType(Expression exp) {
        if (exp == null) {
            return 0;
        }
        return exp.getDataType();
    }

    public static final String getExpectedTypeString(int i) {
        switch (i) {
            case 0: {
                return bundle.getString("model.typestring.EXP_TYPE_UNKNOWN.notrans");
            }
            case 1: {
                return bundle.getString("model.typestring.EXP_TYPE_BITSTRING.notrans");
            }
            case 2: {
                return bundle.getString("model.typestring.EXP_TYPE_NUMERIC.notrans");
            }
            case 4: {
                return bundle.getString("model.typestring.EXP_TYPE_CHARACTER.notrans");
            }
            case 8: {
                return bundle.getString("model.typestring.EXP_TYPE_CHOICE.notrans");
            }
            case 16: {
                return bundle.getString("model.typestring.EXP_TYPE_DATE.notrans");
            }
            case 32: {
                return bundle.getString("model.typestring.EXP_TYPE_TIME.notrans");
            }
            case 64: {
                return bundle.getString("model.typestring.EXP_TYPE_TIMESTAMP.notrans");
            }
            case 128: {
                return bundle.getString("model.typestring.EXP_TYPE_INTERVAL_YM.notrans");
            }
            case 256: {
                return bundle.getString("model.typestring.EXP_TYPE_INTERVAL_DT.notrans");
            }
            case 32768: {
                return bundle.getString("model.typestring.EXP_TYPE_BOOLEAN.notrans");
            }
        }
        return bundle.getString("model.typestring.missing-error.notrans");
    }

    public static final String getExpectedTypeStringHuman(int i) {
        switch (i) {
            case 0: {
                return bundle.getString("model.humanstring.EXP_TYPE_UNKNOWN.txt");
            }
            case 1: {
                return bundle.getString("model.humanstring.EXP_TYPE_BITSTRING.txt");
            }
            case 2: {
                return bundle.getString("model.humanstring.EXP_TYPE_NUMERIC.txt");
            }
            case 4: {
                return bundle.getString("model.humanstring.EXP_TYPE_CHARACTER.txt");
            }
            case 8: {
                return bundle.getString("model.humanstring.EXP_TYPE_CHOICE.txt");
            }
            case 16: {
                return bundle.getString("model.humanstring.EXP_TYPE_DATE.txt");
            }
            case 32: {
                return bundle.getString("model.humanstring.EXP_TYPE_TIME.txt");
            }
            case 64: {
                return bundle.getString("model.humanstring.EXP_TYPE_TIMESTAMP.txt");
            }
            case 128: {
                return bundle.getString("model.humanstring.EXP_TYPE_INTERVAL_YM.txt");
            }
            case 256: {
                return bundle.getString("model.humanstring.EXP_TYPE_INTERVAL_DT.txt");
            }
            case 32768: {
                return bundle.getString("model.humanstring.EXP_TYPE_BOOLEAN.txt");
            }
        }
        return bundle.getString("model.humanstring.Missing-Bug.txt");
    }

    public FilterNodeWrapper generateFilterNodes(Query query, Function andFunction, Function orFunction) {
        return new FilterNodeWrapper(query, this);
    }

    public static boolean isWrappedWithOrIsNull(Expression exp, Query m_query) {
        CompoundExpression cOrExp = null;
        CompoundExpression cIsNull = null;
        CompoundExpression cRealexp = null;
        if (exp.getDataType() != 32768) {
            return false;
        }
        if (!(exp instanceof CompoundExpression)) {
            return false;
        }
        cOrExp = (CompoundExpression)exp;
        if (cOrExp.getCurrentFunction().getFunctionName() != "OR") {
            return false;
        }
        if (cOrExp.getCurrentNumberOfOperands() < 2) {
            return false;
        }
        if (!(cOrExp.getParameter(0) instanceof CompoundExpression)) {
            return false;
        }
        cIsNull = (CompoundExpression)cOrExp.getParameter(0);
        if (!(cOrExp.getParameter(1) instanceof CompoundExpression)) {
            return false;
        }
        cRealexp = (CompoundExpression)cOrExp.getParameter(1);
        if (cIsNull.getCurrentFunction().getFunctionName() != "ISNULL") {
            return false;
        }
        Expression realLHS = cIsNull.getParameter(0);
        return cRealexp.getParameter(0).equals(realLHS);
    }

    public static Expression wrapWithOrIsNull(Expression exp, Query m_query) {
        if (Expression.isWrappedWithOrIsNull(exp, m_query)) {
            return exp;
        }
        Expression goodie = ((CompoundExpression)exp).getParameter(0);
        CompoundExpression isNullNode = new CompoundExpression(m_query.getDataSourceFunction(32, "ISNULL", goodie.getDataType(), 32768, 1), goodie);
        CompoundExpression orNode = new CompoundExpression(m_query.getDataSourceFunction(8, "OR", 32768, 32768, 2), isNullNode, exp);
        return orNode;
    }

    public static Expression unwrapIfHasOrIsNull(Expression exp, Query m_query) {
        if (!Expression.isWrappedWithOrIsNull(exp, m_query)) {
            return exp;
        }
        CompoundExpression temp = (CompoundExpression)exp;
        return temp.getParameter(1);
    }

    public boolean isFormatOfCorrectType(String strFormat, int overrideType) {
        boolean returnValue = true;
        int dataType = this.getDataType();
        if (overrideType != 0) {
            dataType = overrideType;
        }
        int characterType = 4;
        if (dataType != 0 && strFormat != null && strFormat.length() > 0 && (dataType == characterType && !strFormat.startsWith("$") || dataType != characterType && strFormat.startsWith("$"))) {
            returnValue = false;
        }
        return returnValue;
    }
}

