/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.QueryUtils;
import com.sas.query.datasources.SqlLogic;
import com.sas.query.models.Expression;

public class ConstantExpression
extends Expression {
    protected String m_strConstantValue = null;
    protected boolean m_isLiteralString = false;

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new ConstantExpression(this);
    }

    public ConstantExpression() {
    }

    public ConstantExpression(ConstantExpression guyToCopy) throws CloneNotSupportedException {
        super(guyToCopy);
        this.m_strConstantValue = guyToCopy.m_strConstantValue != null ? new String(guyToCopy.m_strConstantValue) : null;
        this.m_isLiteralString = guyToCopy.m_isLiteralString;
    }

    public ConstantExpression(String strExpression, int type) {
        this.setValue(strExpression, type);
    }

    public ConstantExpression(String strExpression, int type, boolean isLiteral) {
        this.m_isLiteralString = isLiteral;
        this.setValue(strExpression, type);
    }

    @Override
    public String toString() {
        return this.m_strConstantValue;
    }

    public static ConstantExpression newPlaceHolder(int ofType) {
        boolean isLiteral = true;
        return new ConstantExpression("<-" + ConstantExpression.placeHolderString(ofType) + "->", ofType, isLiteral);
    }

    private static String placeHolderString(int ofType) {
        if (ofType == 2) {
            return bundle.getString("model.placeholder.number.txt");
        }
        if (ofType == 4) {
            return bundle.getString("model.placeholder.characterValue.txt");
        }
        if (ofType == 16) {
            return bundle.getString("model.placeholder.date.txt");
        }
        if (ofType == 32) {
            return bundle.getString("model.placeholder.time.txt");
        }
        if (ofType == 64) {
            return bundle.getString("model.placeholder.timestamp.txt");
        }
        return bundle.getString("model.placeholder.error.txt");
    }

    @Override
    public String generateSQL(SqlLogic sqlLogic, int declareOrReference) {
        String sqlString = null;
        if (declareOrReference == 2 && (sqlString = super.getAlias(sqlLogic)) != null) {
            return sqlString;
        }
        switch (this.getDataType()) {
            case 4: {
                if (this.m_isLiteralString) {
                    sqlString = this.m_strConstantValue;
                    break;
                }
                sqlString = " '" + QueryUtils.stripAndDouble(this.m_strConstantValue) + "'";
                break;
            }
            case 16: {
                sqlString = sqlLogic.genDateValue(this.m_strConstantValue);
                break;
            }
            case 32: {
                sqlString = sqlLogic.genTimeValue(this.m_strConstantValue);
                break;
            }
            case 64: {
                sqlString = sqlLogic.genTimestampValue(this.m_strConstantValue);
                break;
            }
            case 256: {
                sqlString = " {I'" + QueryUtils.stripAndDouble(this.m_strConstantValue) + "'}";
                break;
            }
            case 128: {
                sqlString = " {I'" + QueryUtils.stripAndDouble(this.m_strConstantValue) + "'}";
                break;
            }
            default: {
                sqlString = this.toString();
            }
        }
        return sqlString;
    }

    public void setValue(String value, int dataType) {
        String temp;
        this.m_strConstantValue = value;
        this.m_dataType = dataType;
        if (dataType == 4 && this.m_isLiteralString && (temp = value.trim()).length() > 0 && temp.charAt(0) == '\'' && temp.charAt(temp.length() - 1) == '\'' && temp.length() > 0) {
            this.m_strConstantValue = temp.substring(1, temp.length() - 1);
            this.m_isLiteralString = false;
        }
    }

    public void setType(int dataType) {
        this.m_dataType = dataType;
    }
}

