/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.models;

import com.sas.query.Query;
import com.sas.query.QueryException;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.DataSourceClassInfo;
import com.sas.query.datasources.DataSourceClassInfoList;
import com.sas.query.models.DefinedConnection;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.SavedQueryObject;
import com.sas.query.visuals.QueryResource;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;

public class ConnectionHandler {
    protected static QueryResource bundle = new QueryResource(ConnectionHandler.class);
    protected static QueryResource systemConnectProperties = new QueryResource("com.sas.query.Connection");
    protected static Properties userConnectProperties;
    protected static Properties userRecentProperties;
    protected static String userConnectPath;
    protected static String userRecentPath;
    static boolean m_bLocalDefineAccessable;

    public static boolean isLocalDefineAccessable() {
        return m_bLocalDefineAccessable;
    }

    public static void addDefinedConnection(DefinedConnection newConnection, MessageHandler messages) {
        Vector existingList = ConnectionHandler.getUserDefinedConnectionList(messages);
        existingList.insertElementAt(newConnection, 0);
        ConnectionHandler._writeDefinedConnections(existingList, messages);
    }

    public static void changeDefinedConnection(DefinedConnection connectToChange, DefinedConnection newConnect, MessageHandler messages) {
        Vector existingList = ConnectionHandler.getUserDefinedConnectionList(messages);
        int size = existingList.size();
        for (int index = 0; index < size; ++index) {
            DefinedConnection connect = (DefinedConnection)existingList.elementAt(index);
            if (!connect.equals(connectToChange)) continue;
            existingList.removeElementAt(index);
            existingList.insertElementAt(newConnect, index);
            break;
        }
        ConnectionHandler._writeDefinedConnections(existingList, messages);
    }

    public static void deleteDefinedConnection(DefinedConnection connectToDelete, MessageHandler messages) {
        Vector existingList = ConnectionHandler.getUserDefinedConnectionList(messages);
        existingList.removeElement(connectToDelete);
        ConnectionHandler._writeDefinedConnections(existingList, messages);
    }

    protected static void _writeDefinedConnections(Vector existingList, MessageHandler messages) {
        try {
            FileWriter output = new FileWriter(userConnectPath);
            output.write("# " + bundle.getString("Connection.Header.txt"));
            output.write("\n");
            output.write("# " + new Date());
            output.write("\n");
            int size = existingList.size();
            for (int index = 0; index < size; ++index) {
                DefinedConnection connect = (DefinedConnection)existingList.elementAt(index);
                connect.dump(output, index);
            }
            output.close();
        }
        catch (Exception e) {
            messages.addInternalError(bundle.getString("Message.ConnectionHandler.SaveError.txt") + "\n" + e);
        }
    }

    public static Vector getDefinedConnectionList(MessageHandler messages) {
        Vector returnList = new Vector();
        returnList = ConnectionHandler.getUserDefinedConnectionList(messages);
        Vector systemList = ConnectionHandler.getSystemDefinedConnectionList(messages);
        for (int index = 0; index < systemList.size(); ++index) {
            returnList.addElement(systemList.elementAt(index));
        }
        return returnList;
    }

    public static Vector getUserDefinedConnectionList(MessageHandler messages) {
        Vector<DefinedConnection> returnList = new Vector<DefinedConnection>();
        try {
            if (userConnectPath == null) {
                userConnectPath = System.getProperty("user.home") + System.getProperty("file.separator") + "_QueryConnection.properties";
                m_bLocalDefineAccessable = true;
            }
        }
        catch (Exception e) {
            if (!e.getClass().getName().equals("sun.applet.AppletSecurityException")) {
                messages.addInternalError(bundle.getString("Message.ConnectionHandler.LoadError.txt") + "\n" + e);
            }
            return returnList;
        }
        try {
            FileInputStream input = new FileInputStream(userConnectPath);
            userConnectProperties = new Properties();
            userConnectProperties.load(input);
            ((InputStream)input).close();
        }
        catch (Exception e) {
            if (!(e instanceof FileNotFoundException)) {
                messages.addInternalError(bundle.getString("Message.ConnectionHandler.LoadError.txt") + "\n" + e);
            }
            return returnList;
        }
        int index = 0;
        while (userConnectProperties != null) {
            DefinedConnection connect = new DefinedConnection(userConnectProperties, index);
            if (connect.m_displayString == null || connect.m_displayString.length() <= 0) break;
            returnList.addElement(connect);
            ++index;
        }
        return returnList;
    }

    public static Vector getSystemDefinedConnectionList(MessageHandler messages) {
        Vector<DefinedConnection> returnList = new Vector<DefinedConnection>();
        int index = 0;
        while (systemConnectProperties != null) {
            DefinedConnection connect = new DefinedConnection(systemConnectProperties, index);
            if (connect.m_displayString == null || connect.m_displayString.length() <= 0) break;
            returnList.addElement(connect);
            ++index;
        }
        return returnList;
    }

    public static void addRecentQuery(String connectionName, String strPath, String type, MessageHandler messages) {
        String displayString = strPath;
        int index = strPath.lastIndexOf(System.getProperty("file.separator"));
        if (index > 0) {
            displayString = strPath.substring(index + 1);
        }
        SavedQueryObject newRecentQuery = new SavedQueryObject(strPath, displayString, type, connectionName);
        Vector existingList = ConnectionHandler.getUserDefinedRecentQueryList(messages);
        existingList.insertElementAt(newRecentQuery, 0);
        ConnectionHandler._writeRecentQueryList(existingList, messages);
    }

    public static void deleteSavedQuery(Object recentQuery, MessageHandler messages) {
        Vector existingList = ConnectionHandler.getUserDefinedRecentQueryList(messages);
        existingList.removeElement(recentQuery);
        ConnectionHandler._writeDefinedConnections(existingList, messages);
    }

    protected static void _writeRecentQueryList(Vector existingList, MessageHandler messages) {
        try {
            FileWriter output = new FileWriter(userRecentPath);
            output.write("# " + bundle.getString("RecentQueryList.Header.txt"));
            output.write("\n");
            output.write("# " + new Date());
            output.write("\n");
            int size = existingList.size();
            for (int index = 0; index < size; ++index) {
                SavedQueryObject connect = (SavedQueryObject)existingList.elementAt(index);
                connect.dump(output, index);
            }
            output.close();
        }
        catch (Exception e) {
            messages.addInternalError(bundle.getString("Message.ConnectionHandler.SaveError.txt") + "\n" + e);
        }
    }

    public static Vector getUserDefinedRecentQueryList(MessageHandler messages) {
        Vector<SavedQueryObject> returnList = new Vector<SavedQueryObject>();
        int index = 0;
        try {
            if (userRecentPath == null) {
                userRecentPath = System.getProperty("user.home") + System.getProperty("file.separator") + "_RecentQueries.properties";
                m_bLocalDefineAccessable = true;
            }
        }
        catch (Exception e) {
            if (!e.getClass().getName().equals("sun.applet.AppletSecurityException")) {
                messages.addInternalError(bundle.getString("Message.ConnectionHandler.LoadError.txt") + "\n" + e);
            }
            return returnList;
        }
        try {
            FileInputStream input = new FileInputStream(userRecentPath);
            userRecentProperties = new Properties();
            userRecentProperties.load(input);
            ((InputStream)input).close();
        }
        catch (Exception e) {
            if (!(e instanceof FileNotFoundException)) {
                messages.addInternalError(bundle.getString("Message.ConnectionHandler.LoadError.txt") + "\n" + e);
            }
            return returnList;
        }
        while (true) {
            SavedQueryObject connect = new SavedQueryObject(userRecentProperties, index);
            if (connect.m_displayString == null || connect.m_displayString.length() <= 0) break;
            returnList.addElement(connect);
            ++index;
        }
        return returnList;
    }

    public static DataSource openDataSourcebyName(String displayname, MessageHandler messages) throws QueryException {
        Vector userDataSources = ConnectionHandler.getUserDefinedConnectionList(messages);
        for (int i = 0; i < userDataSources.size(); ++i) {
            DefinedConnection connection = (DefinedConnection)userDataSources.elementAt(i);
            if (!connection.getDisplayString().equalsIgnoreCase(displayname)) continue;
            return ConnectionHandler.openDataSource(connection, messages);
        }
        Vector systemDataSources = ConnectionHandler.getSystemDefinedConnectionList(messages);
        for (int i = 0; i < systemDataSources.size(); ++i) {
            DefinedConnection connection = (DefinedConnection)systemDataSources.elementAt(i);
            if (!connection.getDisplayString().equalsIgnoreCase(displayname)) continue;
            return ConnectionHandler.openDataSource(connection, messages);
        }
        return null;
    }

    public static DataSource openDataSource(Object connectParm, MessageHandler messages) throws QueryException {
        DefinedConnection connect = (DefinedConnection)connectParm;
        DataSource returnValue = null;
        DataSourceClassInfoList classList = new DataSourceClassInfoList();
        DataSourceClassInfo classInfo = (DataSourceClassInfo)classList.get(connect.m_type);
        if (classInfo == null) {
            messages.addError(bundle.messageString("Message.ConnectionHandler.TypeError.fmt.txt", connect.m_type));
            return null;
        }
        try {
            Class<?> dataSourceClass = Class.forName(classInfo.getClassName());
            Class[] signature = new Class[]{DefinedConnection.class, MessageHandler.class};
            Constructor<?> constructor = dataSourceClass.getConstructor(signature);
            Object[] args = new Object[]{connect, messages};
            returnValue = (DataSource)constructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof QueryException) {
                throw (QueryException)e.getTargetException();
            }
            messages.addError(bundle.getString("Message.ConnectionHandler.LoadError.txt") + "\n" + e.getMessage());
            return null;
        }
        catch (Exception e) {
            messages.addError(bundle.getString("Message.ConnectionHandler.LoadError.txt") + "\n" + e.getMessage());
            return null;
        }
        returnValue.setName(connect.getDisplayString());
        return returnValue;
    }

    public static Query openSavedQuery(Object queryInfoParm, MessageHandler messages) {
        SavedQueryObject queryInfo = (SavedQueryObject)queryInfoParm;
        Query returnValue = null;
        StringBuffer sqlText = new StringBuffer();
        if ("FILE".equalsIgnoreCase(queryInfo.m_type)) {
            try {
                int cCharsRead;
                InputStreamReader input = new InputStreamReader(new FileInputStream(queryInfo.m_location));
                char[] charArray = new char[500];
                while ((cCharsRead = input.read(charArray)) > 0) {
                    sqlText.append(charArray, 0, cCharsRead);
                }
            }
            catch (Exception e) {
                messages.addError(e, bundle.getString("Message.ConnectionHandler.LoadError.txt"));
                return null;
            }
        }
        DataSource dataSource = null;
        try {
            dataSource = ConnectionHandler.openDataSourcebyName(queryInfo.m_connectionName, messages);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dataSource == null) {
            messages.addError(bundle.getString("Message.ConnectionHandler.LoadError.txt"));
        } else {
            returnValue = new Query(dataSource, messages);
            if ("VIEW".equalsIgnoreCase(queryInfo.m_type)) {
                returnValue.openQueryFromView(null, true, queryInfo.m_location);
            } else {
                returnValue.setSQL(sqlText.toString());
            }
        }
        return returnValue;
    }
}

