/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.query.datasources.DataSourceResultSet;
import com.sas.query.datasources.WebAfDataSource;
import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.QueryResource;
import com.sas.rmi.Connection;
import com.sas.rmi.Rocf;
import com.sas.sasserver.dataset.DataSetInterface;
import com.sas.table.TableException;

public class WebAfResultSet
extends DataSourceResultSet {
    protected static QueryResource bundle = new QueryResource(WebAfResultSet.class);
    protected String m_strQuery;
    protected Connection m_connection;
    protected Rocf m_rocf;
    protected transient DataSetInterface m_resultSet;
    protected transient int m_cColumns;
    protected transient int m_cRows = -1;
    public String m_tableName;

    public WebAfResultSet(WebAfDataSource dataSource, MessageHandler messageHandler, String strQuery) {
        super(dataSource, messageHandler);
        this.m_strQuery = strQuery;
    }

    protected void setTable(String name, String previousLogMessages) {
        try {
            Class<DataSetInterface> dsi = DataSetInterface.class;
            this.m_resultSet = (DataSetInterface)this.m_rocf.newInstance(dsi, this.m_connection);
            this.m_resultSet.setDataSet(name);
            this.m_cRows = this.countRows(this.m_dataSource.getMaximumSetSize());
            this.m_cColumns = this.countColumns(0);
            if (this.m_cRows == this.m_dataSource.getMaximumSetSize()) {
                this.m_messageHandler.addWarning(bundle.messageString("WebAfMaxRowsReturned.txt"));
            }
        }
        catch (Exception e) {
            if (previousLogMessages == null || previousLogMessages.trim().length() == 0) {
                this.m_messageHandler.addInternalError(bundle.messageString("WebAfResultSet.Message.CreateError.fmt.txt", e.getMessage()));
            }
            this.m_messageHandler.addError(previousLogMessages);
        }
    }

    @Override
    public int countColumns(int maxCount) {
        int retVal = 0;
        try {
            if (this.m_resultSet != null) {
                retVal = this.m_resultSet.getColumnCount();
            }
        }
        catch (TableException e) {
            this.m_messageHandler.addInternalError((Exception)((Object)e));
        }
        return retVal;
    }

    @Override
    public int countRows(int maxCount) {
        this.m_cRows = 0;
        try {
            if (this.m_resultSet != null) {
                this.m_cRows = this.m_resultSet.countRows(maxCount);
            }
        }
        catch (TableException e) {
            this.m_messageHandler.addInternalError((Exception)((Object)e));
        }
        return this.m_cRows;
    }

    @Override
    public Object[] getRow(int index) {
        Object[] retArr;
        try {
            retArr = this.m_resultSet.getRow(index);
        }
        catch (TableException e) {
            retArr = null;
            this.m_messageHandler.addInternalError((Exception)((Object)e));
        }
        return retArr;
    }

    @Override
    public Object getCell(int rowIndex, int columnIndex) {
        String retCell;
        try {
            retCell = this.m_resultSet.getFormattedCell(rowIndex, columnIndex);
        }
        catch (TableException e) {
            this.m_messageHandler.addInternalError((Exception)((Object)e));
            retCell = null;
        }
        return retCell;
    }

    @Override
    public int getRowCount() {
        return this.m_cRows;
    }

    public int getColumnCount() {
        try {
            if (this.m_cColumns == 0) {
                this.m_cColumns = this.m_resultSet.getColumnCount();
            }
        }
        catch (TableException e) {
            this.m_messageHandler.addInternalError(bundle.messageString("WebAfResultSet.Message.retColCount.fmt.txt", e.toString()));
            this.m_cColumns = 0;
        }
        return this.m_cColumns;
    }

    @Override
    public boolean isColumnLabelsSupported() {
        return true;
    }

    @Override
    public String getColumnLabel(int index) {
        String retVal;
        try {
            retVal = (String)this.m_resultSet.getColumnInfo(index, "LABEL");
        }
        catch (Throwable e) {
            retVal = "";
        }
        return retVal;
    }

    @Override
    public String getColumnName(int index) {
        String x = "";
        try {
            x = (String)this.m_resultSet.getColumnInfo(index, "NAME");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return x;
    }

    @Override
    public Object[] getColumnLabels(int startIndex, int count) {
        Object[] retArr = null;
        try {
            return this.m_resultSet.getColumnLabels(startIndex, count);
        }
        catch (TableException e) {
            retArr = null;
            this.m_messageHandler.addInternalError((Exception)((Object)e));
            return retArr;
        }
    }

    @Override
    public boolean _getNextRow() {
        return true;
    }

    @Override
    public void close() {
        try {
            if (this.m_resultSet != null) {
                this.m_resultSet.setDataSet(null);
                this.m_resultSet.close();
                this.m_resultSet = null;
            }
        }
        catch (Throwable t) {
            this.m_resultSet = null;
            this.m_connection = null;
        }
        if (this.m_connection != null) {
            try {
                String tStr = "drop " + ((WebAfDataSource)this.m_dataSource).getTableOrView() + " " + this.m_tableName;
                ((WebAfDataSource)this.m_dataSource).execute(tStr, false);
            }
            catch (Exception e) {
                this.m_messageHandler.addInternalError(bundle.messageString("WebAfResultSet.Message.closingError.fmt.txt", e.toString()));
            }
            this.m_connection = null;
        }
    }

    @Override
    public void initialize() {
        WebAfDataSource dataSource = (WebAfDataSource)this.m_dataSource;
        this.m_connection = dataSource.getConnection();
        this.m_rocf = dataSource.getRocf();
        String logString = dataSource.executeRC("reset inobs=0;\n" + this.m_strQuery, true);
        if (!dataSource.getMessageHandler().failureHasOccurred()) {
            this.m_tableName = dataSource.generateTableName(dataSource.getDefaultTableName());
            String tmpQuery = "create " + dataSource.getTableOrView() + " " + this.m_tableName + " as \n" + this.m_strQuery;
            dataSource.execute(tmpQuery, true);
            this.setTable(this.m_tableName, logString);
            this.m_rowIndex = 1;
        }
    }
}

