/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.MissingValues;
import com.sas.query.Query;
import com.sas.query.QueryConfiguration;
import com.sas.query.QueryException;
import com.sas.query.QueryUtils;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.DataSourceColumn;
import com.sas.query.datasources.DataSourceColumnList;
import com.sas.query.datasources.DataSourceContainer;
import com.sas.query.datasources.DataSourceContainerList;
import com.sas.query.datasources.DataSourceResultSet;
import com.sas.query.datasources.DataSourceTable;
import com.sas.query.datasources.RelationshipList;
import com.sas.query.datasources.SasFormatUtil;
import com.sas.query.datasources.SasSqlLogic;
import com.sas.query.datasources.SasSqlProperties;
import com.sas.query.datasources.SqlLogic;
import com.sas.query.datasources.SqlProperties;
import com.sas.query.datasources.WebAfResultSet;
import com.sas.query.models.DefinedConnection;
import com.sas.query.models.ExpressionConstants;
import com.sas.query.models.MessageHandler;
import com.sas.query.parser.Token;
import com.sas.query.parser.TokenList;
import com.sas.query.parser.Tokenizer;
import com.sas.query.visuals.FilterTreeView;
import com.sas.query.visuals.QueryResource;
import com.sas.rmi.Connection;
import com.sas.rmi.Rocf;
import com.sas.sasserver.dataset.DataSetInterface;
import com.sas.sasserver.datasetinfo.DataSetInfoInterface;
import com.sas.sasserver.librarylist.LibraryListInterface;
import com.sas.sasserver.sasfilelist.DataSetListInterface;
import com.sas.sasserver.sclfuncs.SclfuncsV2Interface;
import com.sas.sasserver.submit.SubmitInterface;
import com.sas.table.TableException;
import java.awt.Frame;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;

public class WebAfDataSource
extends DataSource
implements ExpressionConstants {
    protected Connection m_connection;
    protected Rocf m_rocf;
    protected String m_host;
    protected transient SqlProperties m_properties;
    protected transient SqlLogic m_sqlLogic;
    protected transient boolean m_bHasSchemas = false;
    protected transient boolean m_rocfConnected = false;
    protected transient String[] m_strTableTypes = new String[]{"DATA", "VIEW"};
    protected transient boolean m_bInitDone;
    protected transient DataSourceContainerList m_containerList;
    protected transient Vector m_names;
    protected transient String m_defaultTableName;
    protected transient String m_strTableOrView;
    protected static transient boolean m_nonV8DescribeViewWarningShown = false;
    protected static transient boolean m_makeMixedCaseLibnames = QueryConfiguration.getConfigurationBoolean("WebAfDataSource.makeMixedCaseLibnames.notrans", true);
    protected transient Hashtable passwdTable;
    protected transient Hashtable m_columnIndex;
    protected transient Hashtable m_tableOrViewTable;
    protected transient DataSetInterface m_allTableData;
    private transient DataSetInterface m_allViewsInSession;
    private transient DataSetInterface allIndexData;
    protected transient SubmitInterface m_subI;
    protected transient DataSetInfoInterface m_dsInfo;
    protected transient SclfuncsV2Interface m_sclv2Interface;
    protected static QueryResource bundle = new QueryResource(WebAfDataSource.class);
    protected static QueryResource visualsBundle = new QueryResource(FilterTreeView.class);

    public WebAfDataSource(Connection conn, MessageHandler messages) throws QueryException {
        super(messages);
        this.setConnection(conn);
        this._initialize();
    }

    public WebAfDataSource(Connection conn, MessageHandler messages, String strTableName) throws QueryException {
        super(messages);
        this.setConnection(conn);
        this._initialize();
    }

    public WebAfDataSource() throws QueryException {
        this._initialize();
    }

    public static String encodeQueryForRemember(String originalQuery, Query query, String passwordOnView) {
        String encodedString = originalQuery;
        if (QueryConfiguration.getConfigurationBoolean("rememberingStripNewLines.notrans", false)) {
            String suffix;
            String prefix;
            int nl;
            while (encodedString.indexOf(10) != -1) {
                nl = encodedString.indexOf(10);
                prefix = encodedString.substring(0, nl);
                suffix = "";
                if (encodedString.length() > nl) {
                    suffix = encodedString.substring(nl + 1);
                }
                encodedString = prefix + " " + suffix;
            }
            while (encodedString.indexOf(13) != -1) {
                nl = encodedString.indexOf(13);
                prefix = encodedString.substring(0, nl);
                suffix = "";
                if (encodedString.length() > nl) {
                    suffix = encodedString.substring(nl + 1);
                }
                encodedString = prefix + suffix;
            }
        }
        encodedString = WebAfDataSource.encodeQueryPasswords(encodedString, query, passwordOnView);
        encodedString = "<SQL>" + encodedString + "</SQL>";
        return encodedString;
    }

    public static String encodeQueryPasswords(String originalQuery, Query query, String passwordOnView) {
        int i;
        Tokenizer tokenizer = new Tokenizer(query.getDataSource(), originalQuery, query.getMessageHandler());
        TokenList tokens = tokenizer.getSimpleTokens();
        String strippedString = "";
        int lastprocessed = 0;
        TokenList accumulator = new TokenList(tokens, 0, 0, false);
        for (i = 0; i < tokens.size() - 2; ++i) {
            Token first = tokens.elementAt(i);
            Token second = tokens.elementAt(i + 1);
            Token third = tokens.elementAt(i + 2);
            if (second.toString().equals("=")) {
                if (first.toString().equalsIgnoreCase("PW") || first.toString().equalsIgnoreCase("READ") || first.toString().equalsIgnoreCase("ALTER") || first.toString().equalsIgnoreCase("WRITE")) {
                    strippedString = strippedString + accumulator.toString();
                    strippedString = passwordOnView != null && passwordOnView.length() > 0 ? strippedString + first.toString() + "=" + QueryUtils.safeEncrypt(third.toString()) + " " : strippedString + first.toString() + "=XXX ";
                    accumulator.removeAllElements();
                    lastprocessed = i + 2;
                    i += 2;
                    continue;
                }
                accumulator.addElement(first);
                lastprocessed = i;
                continue;
            }
            accumulator.addElement(first);
            lastprocessed = i;
        }
        if (lastprocessed + 1 < tokens.size()) {
            for (i = lastprocessed + 1; i < tokens.size(); ++i) {
                accumulator.addElement(tokens.elementAt(i));
            }
        }
        strippedString = strippedString + accumulator.toString();
        return strippedString;
    }

    public static String decodeQueryPasswords(Frame frame, boolean prompt, String encodedQuery, Query query, String passwordOnView) {
        if (!prompt) {
            return encodedQuery;
        }
        if (query == null) {
            return encodedQuery;
        }
        if (encodedQuery == null) {
            return encodedQuery;
        }
        Vector<DataSourceTable> protectedTablesAlreadyProcessed = new Vector<DataSourceTable>();
        Tokenizer tokenizer = new Tokenizer(query.getDataSource(), encodedQuery, query.getMessageHandler());
        TokenList tokens = tokenizer.getTokens();
        String strippedString = "";
        boolean lastprocessed = false;
        TokenList accumulator = new TokenList(tokens, 0, 0, false);
        String flushedOutput = "";
        if (tokens.size() > 0) {
            accumulator.addElement(tokens.elementAt(0));
        }
        if (tokens.size() > 1) {
            accumulator.addElement(tokens.elementAt(1));
        }
        for (int i = 2; i < tokens.size(); ++i) {
            Token currentToken = tokens.elementAt(i);
            Token backOneToken = tokens.elementAt(i - 1);
            Token backTwoToken = tokens.elementAt(i - 2);
            if (backOneToken.toString().equalsIgnoreCase("=") && (backTwoToken.toString().equalsIgnoreCase("PW") || backTwoToken.toString().equalsIgnoreCase("READ") || backTwoToken.toString().equalsIgnoreCase("ALTER") || backTwoToken.toString().equalsIgnoreCase("WRITE"))) {
                Token parenCandidate;
                Token leftParen = null;
                for (int j = i - 3; j > 0 && !(parenCandidate = tokens.elementAt(j)).toString().equals(")"); --j) {
                    if (!parenCandidate.toString().equals("(")) continue;
                    leftParen = parenCandidate;
                    break;
                }
                if (leftParen != null) {
                    int indexOfParen = tokens.indexOf(leftParen);
                    if (indexOfParen > 0) {
                        String password;
                        DataSourceTable table;
                        Token tableName = tokens.elementAt(indexOfParen - 1);
                        if (tableName.getSubType() == 72) {
                            table = (DataSourceTable)tableName.getData();
                        } else {
                            Token dotToken = null;
                            if (indexOfParen - 2 >= 0) {
                                dotToken = tokens.elementAt(indexOfParen - 2);
                            }
                            Token schemaToken = null;
                            if (indexOfParen - 3 >= 0) {
                                schemaToken = tokens.elementAt(indexOfParen - 3);
                            }
                            if (dotToken != null && schemaToken != null && dotToken.toString().equals(".")) {
                                tableName.setStart(schemaToken.getStart());
                            }
                            String potentialTableName = tableName.toString();
                            try {
                                table = query.getDataSource().getTable(potentialTableName);
                            }
                            catch (Exception e) {
                                table = null;
                            }
                        }
                        if (table == null) {
                            accumulator.addElement(currentToken);
                            continue;
                        }
                        if (protectedTablesAlreadyProcessed.contains(table)) {
                            accumulator.removeElementAt(accumulator.size() - 1);
                            accumulator.removeElementAt(accumulator.size() - 1);
                            continue;
                        }
                        if (table.getReadPassword() && !table.isPasswordSet()) {
                            password = null;
                            if (currentToken.toString().equalsIgnoreCase("XXX")) {
                                password = JOptionPane.showInputDialog(frame, visualsBundle.messageString("JDataSourceTreeView.enterReadPasswordMsg.fmt.txt", table.getName()), visualsBundle.getString("JDataSourceTreeView.passwordDialogTitle.txt"), 3);
                            } else {
                                String encodedString = currentToken.toString();
                                password = QueryUtils.safeDecrypt(encodedString);
                            }
                            if (password != null) {
                                table.addPassword(password);
                                accumulator.removeElementAt(accumulator.size() - 1);
                                accumulator.removeElementAt(accumulator.size() - 1);
                                flushedOutput = flushedOutput + accumulator.toString();
                                accumulator.removeAllElements();
                                flushedOutput = flushedOutput + "PW=";
                                flushedOutput = flushedOutput + password;
                                protectedTablesAlreadyProcessed.addElement(table);
                                continue;
                            }
                            accumulator.addElement(currentToken);
                            continue;
                        }
                        password = (String)query.getDataSource().m_passwordList.get(table);
                        flushedOutput = flushedOutput + accumulator.toString();
                        accumulator.removeAllElements();
                        flushedOutput = flushedOutput + password;
                        continue;
                    }
                    accumulator.addElement(currentToken);
                    continue;
                }
                accumulator.addElement(currentToken);
                continue;
            }
            accumulator.addElement(currentToken);
        }
        protectedTablesAlreadyProcessed.removeAllElements();
        if (accumulator.size() > 0) {
            flushedOutput = flushedOutput + accumulator.toString();
            accumulator.removeAllElements();
        }
        return flushedOutput;
    }

    public static String decodeQueryForRemember(Frame parent, boolean prompt, String encodedQuery, Query myQuery, String passwordOnView) {
        String retString = null;
        if (encodedQuery == null) {
            return null;
        }
        if (encodedQuery.length() < 11) {
            return null;
        }
        int indexStart = encodedQuery.indexOf("<SQL>", 0);
        int indexEnd = encodedQuery.lastIndexOf("</SQL>");
        if (indexStart > -1 && indexEnd > 4 && indexStart <= indexEnd) {
            retString = encodedQuery.substring(indexStart + 5, indexEnd);
        }
        retString = WebAfDataSource.decodeQueryPasswords(parent, prompt, retString, myQuery, passwordOnView);
        return retString;
    }

    public WebAfDataSource(String host, MessageHandler messages) throws QueryException {
        super(messages);
        this.m_host = host;
        this.m_name = host;
        this.m_description = host;
        this.m_connection = this.createConnection(host);
        this._initialize();
    }

    public WebAfDataSource(DefinedConnection connect, MessageHandler messages) throws QueryException {
        super(messages);
        this.m_connection = this.createConnection(connect.getConnectString());
        this._initialize();
        this.m_host = this.m_connection.getHost();
        this.m_name = connect.getConnectString();
        this.m_description = connect.getConnectString();
    }

    @Override
    public void close() {
        Runtime.getRuntime().gc();
        if (this.m_rocf != null) {
            this.m_rocf.stop();
            this.m_rocf = null;
        }
        if (this.m_connection != null) {
            this.m_connection.stop();
            this.m_connection = null;
        }
    }

    @Override
    public boolean supportsSingleThreadDataAccessOnly() {
        return true;
    }

    protected WebAfExecuteProcSqlStruct executeProcSql(String sqlString) {
        String retString = "";
        String submitString = sqlString.trim();
        if (submitString.length() > 0 && submitString.charAt(submitString.length() - 1) != ';') {
            submitString = submitString + ";";
        }
        double remoteRc = -1.0;
        double remoteErrorCode = -1.0;
        try {
            String tStr = "Proc sql;";
            this.m_subI.setProgramText(tStr);
            tStr = this.m_subI.getLastLogText();
            this.m_subI.setProgramText(submitString);
            retString = this.m_subI.getLastLogText();
            this.m_subI.setProgramText("quit;");
            remoteRc = this.m_sclv2Interface.symgetn("SQLRC");
            remoteErrorCode = this.m_sclv2Interface.symgetn("SYSERR");
        }
        catch (Exception e) {
            this.m_messages.addInternalError(e);
        }
        WebAfExecuteProcSqlStruct resultStruct = new WebAfExecuteProcSqlStruct();
        resultStruct.m_logResult = this.scrubLogMessage(retString);
        resultStruct.m_submittedString = submitString;
        resultStruct.m_sqlrc = remoteRc;
        resultStruct.m_syserr = remoteErrorCode;
        return resultStruct;
    }

    @Override
    public void execute(String executeStr) {
        this.execute(executeStr, true);
    }

    String executeRC(String executeStr, boolean checkForErrors) {
        if (executeStr.trim().length() < 1) {
            return "";
        }
        WebAfExecuteProcSqlStruct result = this.executeProcSql(executeStr);
        if (checkForErrors) {
            this.checkSqlLog(result);
        }
        return result.m_logResult;
    }

    void execute(String executeStr, boolean checkForErrors) {
        this.executeRC(executeStr, checkForErrors);
    }

    private void checkSqlLog(WebAfExecuteProcSqlStruct result) {
        if (result.m_sqlrc > 4.0) {
            this.m_messages.addError(result.m_logResult);
        }
    }

    @Override
    public boolean isValidSql(Query query) {
        boolean isvalid = true;
        if (query.isParsable() && (query.getResultItemCount() == 0 || query.getTableCount() == 0)) {
            return isvalid;
        }
        Query tmpQuery = query.getQuery();
        String sqlString = tmpQuery.getSql();
        String vString = "Validate \n";
        WebAfExecuteProcSqlStruct result = this.executeProcSql(vString + sqlString);
        String retString = result.m_logResult;
        if (result.m_sqlrc > 4.0) {
            this.m_messages.addWarning(retString);
            isvalid = false;
        } else if (result.m_sqlrc < 0.0) {
            this.m_messages.addWarning(bundle.messageString("didNotGetExpectedResponseFromValidate.fmt.txt", sqlString, retString));
        }
        return isvalid;
    }

    public String getViewSql(String qualifiedViewName, Query myQuery) {
        return this.getViewSql(null, false, qualifiedViewName, myQuery);
    }

    @Override
    public String getViewSql(Frame parentFrame, boolean promptForPasswords, String qualifiedViewName, Query query) {
        return this.getViewSql(parentFrame, promptForPasswords, qualifiedViewName, query, null);
    }

    @Override
    public String getViewSql(Frame parentFrame, boolean promptForPasswords, String qualifiedViewName, Query myQuery, String password) {
        String retString = null;
        try {
            SubmitInterface subI = (SubmitInterface)this.m_rocf.newInstance(SubmitInterface.class, this.m_connection);
            DataSetInterface dataSetInterface1 = (DataSetInterface)this.m_rocf.newInstance(DataSetInterface.class, this.m_connection);
            String randomUnusedViewName = "WORK." + this.generateTableName("_rtext10");
            String tempViewName = QueryConfiguration.getConfigurationString("getRememberingTempViewName.txt", randomUnusedViewName);
            String upcasedLibDotMember = qualifiedViewName.toUpperCase();
            int indexofdot = qualifiedViewName.indexOf(46);
            String lib = qualifiedViewName.substring(0, indexofdot);
            lib = lib.toUpperCase();
            String member = qualifiedViewName.substring(indexofdot + 1);
            member = member.toUpperCase();
            boolean hasAlterPasswordSet = false;
            String tStrTemplate = QueryConfiguration.getConfigurationString("webAFgetAlterpassword.fmt.notrans", "proc sql; create view {0} as select protect from SASHELP.VTABLE where libname=\"{1}\" and memname=\"{2}\" and memtype=\"VIEW\" and protect like \"__A\";quit;");
            Object[] args = new Object[]{tempViewName, lib, member};
            String getIfAlterPassword = MessageFormat.format(tStrTemplate, args);
            try {
                subI.setProgramText(getIfAlterPassword);
                dataSetInterface1.setDataSet(tempViewName);
                int rowcount = dataSetInterface1._countRows(100);
                if (rowcount > 0) {
                    hasAlterPasswordSet = true;
                }
                dataSetInterface1.close();
            }
            catch (Throwable rowcount) {
                // empty catch block
            }
            String alterPasswordForView = null;
            if (password == null) {
                if (parentFrame != null && promptForPasswords && hasAlterPasswordSet) {
                    alterPasswordForView = JOptionPane.showInputDialog(parentFrame, visualsBundle.messageString("JDataSourceTreeView.enterAlterPasswordMsg.fmt.txt", qualifiedViewName), visualsBundle.getString("JDataSourceTreeView.passwordDialogForViewOpenTitle.txt"), 3);
                }
            } else {
                alterPasswordForView = password;
            }
            try {
                String sasVersion = this.getDatabaseProductVersion();
                if (!sasVersion.startsWith("6") && !sasVersion.startsWith("7")) {
                    retString = this.getViewSqlByRemember(parentFrame, promptForPasswords, qualifiedViewName, myQuery, alterPasswordForView);
                }
                if (retString == null || retString.length() == 0) {
                    retString = this.getViewSqlByDescribe(parentFrame, promptForPasswords, qualifiedViewName, myQuery, alterPasswordForView);
                    if (retString != null && retString.length() != 0) {
                        this.m_messages.removeAllMessages();
                    }
                    if ((sasVersion.startsWith("6") || sasVersion.startsWith("7")) && !m_nonV8DescribeViewWarningShown && !QueryConfiguration.getConfigurationBoolean("WebAfDisableV6ViewWarning.notrans", false)) {
                        m_nonV8DescribeViewWarningShown = true;
                        this.m_messages.addWarning(bundle.getString("WebAfDataSource.v6DescribeViewWarning.txt"));
                    }
                }
            }
            catch (Exception e) {
                this.m_messages.addInternalError(e);
            }
        }
        catch (Exception ee) {
            this.m_messages.addError(ee);
        }
        return retString;
    }

    public String getViewSqlByDescribe(Frame parent, boolean bPrompt, String qualifiedViewName, Query myQuery, String alterPasswordOnView) {
        String retString = null;
        try {
            SubmitInterface subI = (SubmitInterface)this.m_rocf.newInstance(SubmitInterface.class, this.m_connection);
            String tStr = "Proc sql; describe view ";
            tStr = tStr + qualifiedViewName;
            if (alterPasswordOnView != null && alterPasswordOnView.length() > 0) {
                tStr = tStr + "(ALTER=" + alterPasswordOnView + ")";
            }
            tStr = tStr + ";";
            subI.setProgramText(tStr);
            retString = subI.getLastLogText();
            subI.setProgramText("quit;");
            double remoteRc = this.m_sclv2Interface.symgetn("SQLRC");
            int semiColonCountSentDown = QueryUtils.charCount(tStr, ';');
            int semiColonCountGotBack = QueryUtils.charCount(retString, ';');
            if (semiColonCountGotBack < semiColonCountSentDown) {
                String error = bundle.messageString("didNotGetExpectedResponseFromDescribeView.fmt.txt", retString);
                this.m_messages.addError(error);
                retString = null;
            } else {
                for (int i = 0; i < semiColonCountSentDown; ++i) {
                    retString = retString.substring(retString.indexOf(59) + 1);
                }
                String selectString = "SELECT";
                String viewName = qualifiedViewName.toUpperCase();
                int selectCountInViewName = 0;
                while (viewName.indexOf(selectString) > -1) {
                    ++selectCountInViewName;
                    viewName = viewName.substring(viewName.indexOf(selectString) + selectString.length());
                }
                String upcasedRetString = retString.toUpperCase();
                for (int i = 0; i < selectCountInViewName; ++i) {
                    int indexToStartNextChunkFrom = upcasedRetString.indexOf(selectString) + selectString.length();
                    retString = retString.substring(indexToStartNextChunkFrom);
                    upcasedRetString = upcasedRetString.substring(indexToStartNextChunkFrom);
                }
                int beginningOfOutput = upcasedRetString.indexOf(selectString);
                if (beginningOfOutput > -1) {
                    int endOfSql = (retString = retString.substring(beginningOfOutput)).lastIndexOf(";");
                    if (endOfSql > -1) {
                        retString = retString.substring(0, endOfSql).trim();
                    }
                } else if (remoteRc > 4.0) {
                    this.m_messages.addError(retString);
                    retString = null;
                } else {
                    String error = bundle.messageString("didNotGetExpectedResponseFromDescribeView.fmt.txt", retString);
                    this.m_messages.addError(error);
                    retString = null;
                }
            }
        }
        catch (Exception e) {
            this.m_messages.addInternalError(e);
        }
        retString = WebAfDataSource.decodeQueryPasswords(parent, bPrompt, retString, myQuery, alterPasswordOnView);
        return retString;
    }

    public String getViewSqlByRemember(Frame parent, boolean bPrompt, String qualifiedViewName, Query myQuery, String alterPasswordOnView) {
        String retString;
        block8: {
            retString = null;
            if (!QueryConfiguration.getConfigurationBoolean("Queries.GetViewSqlByRemember.Enabled.notrans", true)) {
                return retString;
            }
            try {
                SubmitInterface subI = (SubmitInterface)this.m_rocf.newInstance(SubmitInterface.class, this.m_connection);
                DataSetInterface dataSetInterface2 = (DataSetInterface)this.m_rocf.newInstance(DataSetInterface.class, this.m_connection);
                String randomUnusedViewName = "WORK." + this.generateTableName("_rtext10");
                String tempViewName = QueryConfiguration.getConfigurationString("getRememberingTempViewName.txt", randomUnusedViewName);
                String upcasedLibDotMember = qualifiedViewName.toUpperCase();
                int indexofdot = qualifiedViewName.indexOf(46);
                String lib = qualifiedViewName.substring(0, indexofdot);
                lib = lib.toUpperCase();
                String member = qualifiedViewName.substring(indexofdot + 1);
                member = member.toUpperCase();
                boolean hasAlterPasswordSet = alterPasswordOnView != null && alterPasswordOnView.length() > 0;
                String tStrTemplate = hasAlterPasswordSet ? QueryConfiguration.getConfigurationString("getRememberingAlterProtectedQueryString.fmt.notrans", "proc sql; create table {0} as select offset,rtext from dictionary.remember where libname=''{1}'' and memname=''{2}'' and pw=''{4}''; quit;") : QueryConfiguration.getConfigurationString("getRememberingQueryString.fmt.notrans", "proc sql; create table {0} as select offset,rtext from dictionary.remember where libname=''{1}'' and memname=''{2}''; quit;");
                Object[] args = new Object[]{tempViewName, lib, member, upcasedLibDotMember, alterPasswordOnView};
                String tStr = MessageFormat.format(tStrTemplate, args);
                subI.setProgramText(tStr);
                double remoteRc = this.m_sclv2Interface.symgetn("SQLRC");
                String logString = subI.getLastLogText();
                if (remoteRc > 4.0) {
                    this.m_messages.addError(logString);
                    break block8;
                }
                dataSetInterface2.setDataSet(tempViewName);
                try {
                    int rowcount = dataSetInterface2._countRows(100);
                    String originalString = "";
                    for (int i = 1; i <= rowcount; ++i) {
                        Object[] row = dataSetInterface2.getRow(i);
                        originalString = originalString + row[1];
                    }
                    dataSetInterface2.close();
                    retString = WebAfDataSource.decodeQueryForRemember(parent, bPrompt, originalString, myQuery, alterPasswordOnView);
                }
                catch (Throwable t) {
                    this.m_messages.addInternalError(t);
                }
                String cleanupCommand = QueryConfiguration.getConfigurationString("getRememberingQueryString2.fmt.notrans", "proc sql;drop table {0};quit;");
                cleanupCommand = MessageFormat.format(cleanupCommand, args);
                subI.setProgramText(cleanupCommand);
                logString = subI.getLastLogText();
                remoteRc = this.m_sclv2Interface.symgetn("SQLRC");
                if (remoteRc > 4.0) {
                    this.m_messages.addError(logString);
                }
            }
            catch (Exception e) {
                this.m_messages.addError(e);
            }
        }
        return retString;
    }

    public boolean supportsExecutingStatements() {
        return true;
    }

    @Override
    public DataSourceResultSet getResultSet(String strQuery) {
        return new WebAfResultSet(this, this.m_messages, strQuery);
    }

    @Override
    public void createTable(String strQuery, String tableName) {
        super.createTable(strQuery, tableName);
        this.refresh();
    }

    @Override
    public void createView(String strQuery, String tableName, String passwordForViewDefinition) {
        if (tableName == null) {
            tableName = this.m_defaultTableName;
        }
        super.createView(strQuery, tableName, passwordForViewDefinition);
        String sasVersion = this.getDatabaseProductVersion();
        if ((sasVersion.startsWith("6") || sasVersion.startsWith("7")) && !m_nonV8DescribeViewWarningShown && !QueryConfiguration.getConfigurationBoolean("WebAfDisableV6ViewWarning.notrans", false)) {
            m_nonV8DescribeViewWarningShown = true;
            this.m_messages.addWarning(bundle.getString("WebAfDataSource.v6DescribeViewWarning.txt"));
        }
        this.refresh();
    }

    private String scrubLogMessage(String inputString) {
        if (inputString == null || inputString.trim().length() == 0) {
            return "";
        }
        String leftovers = inputString;
        Vector<String> lines = new Vector<String>();
        while (leftovers.indexOf(10) > -1) {
            String aLine = leftovers.substring(0, leftovers.indexOf(10) + 1);
            lines.addElement(aLine);
            leftovers = leftovers.substring(leftovers.indexOf(10) + 1);
        }
        if (leftovers.length() > 0) {
            lines.addElement(leftovers);
        }
        int index = 0;
        while (index < lines.size()) {
            String aLine = (String)lines.elementAt(index);
            if (aLine.toUpperCase().indexOf("INOBS=") != -1) {
                lines.removeElementAt(index);
                if (index >= lines.size()) continue;
                aLine = (String)lines.elementAt(index);
                while (aLine.length() > 0 && aLine.charAt(0) == ' ') {
                    lines.removeElementAt(index);
                    if (lines.size() < index) {
                        aLine = (String)lines.elementAt(index);
                        continue;
                    }
                    aLine = "";
                }
                continue;
            }
            if (aLine.toUpperCase().indexOf("NOEXEC") != -1) {
                lines.removeElementAt(index);
                if (index >= lines.size()) continue;
                aLine = (String)lines.elementAt(index);
                while (aLine.length() > 0 && aLine.charAt(0) == ' ') {
                    lines.removeElementAt(index);
                    if (lines.size() < index) {
                        aLine = (String)lines.elementAt(index);
                        continue;
                    }
                    aLine = "";
                }
                continue;
            }
            if (aLine.toUpperCase().indexOf("NOTE:") != -1) {
                lines.removeElementAt(index);
                if (index >= lines.size()) continue;
                aLine = (String)lines.elementAt(index);
                while (aLine.length() > 0 && aLine.charAt(0) == ' ') {
                    lines.removeElementAt(index);
                    if (lines.size() < index) {
                        aLine = (String)lines.elementAt(index);
                        continue;
                    }
                    aLine = "";
                }
                continue;
            }
            ++index;
        }
        String returnString = "";
        for (int i = 0; i < lines.size(); ++i) {
            returnString = returnString + (String)lines.elementAt(i);
        }
        return returnString;
    }

    public synchronized void setConnection(Connection conn) {
        this.m_connection = conn;
        this.m_name = conn.getHost();
        this.m_description = conn.getHost();
        this.m_host = conn.getHost();
    }

    public synchronized Connection getConnection() {
        return this.m_connection;
    }

    public synchronized Rocf getRocf() {
        return this.m_rocf;
    }

    public synchronized boolean getRocfConnected() {
        return this.m_rocfConnected;
    }

    private Connection createConnection(String host) {
        Connection returnValue = null;
        try {
            returnValue = new Connection();
            returnValue.setLogTrap(false);
            returnValue.setHost(host);
            String cmd = QueryConfiguration.getConfigurationString("webafConnectString.notrans", "sas -dmr -comamid tcp -noterminal -cleanup ");
            returnValue.setCommand(cmd);
            this.m_rocf = returnValue.getClassFactory();
            this.m_rocf.connect(returnValue);
        }
        catch (Exception e) {
            this.m_messages.addInternalError(e);
        }
        return returnValue;
    }

    public void createROCFComponents() {
        try {
            if (this.m_connection == null) {
                String cmd = QueryConfiguration.getConfigurationString("webafConnectString.notrans", "sas -dmr -comamid tcp -noterminal -cleanup ");
                String host = "bug We shouldn't get here";
                this.m_connection = this.createConnection(host);
                this.m_connection.setCommand(cmd);
            }
            if (this.m_rocf == null) {
                this.m_rocf = this.m_connection.getClassFactory();
            }
            this.m_rocf.connect(this.m_connection);
            this.m_rocfConnected = true;
            this.m_subI = (SubmitInterface)this.m_rocf.getInstance(SubmitInterface.class, this.m_connection);
            this.m_dsInfo = (DataSetInfoInterface)this.m_rocf.getInstance(DataSetInfoInterface.class, this.m_connection);
            this.m_sclv2Interface = (SclfuncsV2Interface)this.m_rocf.getInstance(SclfuncsV2Interface.class, this.m_connection);
            String version = "unknown";
            try {
                Double sasVersion = new Double(this.m_connection.getSASVersion());
                version = sasVersion.toString();
            }
            catch (Exception e) {
                version = "6.12";
            }
            this.m_databaseProductVersion = version;
        }
        catch (Exception e) {
            this.m_messages.addInternalError(e);
        }
    }

    protected void refreshAllTableData(String tableName) {
        if (!this.m_rocfConnected) {
            return;
        }
        this.refreshViewData();
    }

    private void refreshViewData() {
        if (this.m_allViewsInSession == null) {
            this._initViewTable();
        } else {
            this.m_allViewsInSession.refresh();
        }
        try {
            int numRows = this.m_allViewsInSession.countRows(this.getMaximumSetSize());
            this.m_tableOrViewTable = new Hashtable(numRows + 1);
            int libIndex = this.m_allViewsInSession.getColumnIndex("libname");
            int memIndex = this.m_allViewsInSession.getColumnIndex("memname");
            for (int i = 1; i <= numRows; ++i) {
                Object[] curRow = this.m_allViewsInSession.getRow(i);
                String libname = (String)curRow[libIndex - 1];
                String memname = (String)curRow[memIndex - 1];
                String rowKey = libname.trim() + "." + memname.trim();
                this.m_tableOrViewTable.put(rowKey, "VIEW");
            }
        }
        catch (TableException e) {
            this.m_messages.addInternalError((Exception)((Object)e));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void _initViewTable() {
        try {
            if (this.m_allViewsInSession == null) {
                this.m_allViewsInSession = (DataSetInterface)this.m_rocf.newInstance(DataSetInterface.class, this.m_connection);
                this.m_allViewsInSession.setDataSet("sashelp.vsview");
            }
        }
        catch (Exception e) {
            this.m_messages.addInternalError(e);
        }
    }

    protected void refreshAllIndexData() {
        if (!this.m_rocfConnected) {
            return;
        }
        try {
            if (this.allIndexData == null) {
                this.allIndexData = (DataSetInterface)this.m_rocf.newInstance(DataSetInterface.class, this.m_connection);
                this.allIndexData.setDataSet("sashelp.vindex");
                String[] dispCols = new String[]{"LIBNAME", "MEMNAME", "NAME", "INDXPOS"};
                this.allIndexData.setDisplayedColumns(dispCols);
                this.allIndexData.setWhere("indxpos in (0,.)");
            } else {
                this.allIndexData.refresh();
            }
            int numRows = this.allIndexData.countRows(this.getMaximumSetSize());
            int indxposIndex = this.allIndexData.getColumnIndex("indxpos");
            int libIndex = this.allIndexData.getColumnIndex("libname");
            int memIndex = this.allIndexData.getColumnIndex("memname");
            int colIndex = this.allIndexData.getColumnIndex("name");
            this.m_columnIndex = new Hashtable(numRows + 1);
            for (int i = 1; i <= numRows; ++i) {
                Object[] curRow = this.allIndexData.getRow(i);
                String libname = (String)curRow[libIndex - 1];
                String memname = (String)curRow[memIndex - 1];
                String colName = (String)curRow[colIndex - 1];
                Object indxObj = curRow[indxposIndex - 1];
                Double isIndex = indxObj instanceof MissingValues ? new Double(0.0) : (Double)indxObj;
                String rowKey = libname.trim() + "." + memname.trim() + "." + colName.trim();
                if (isIndex != 0.0) continue;
                this.m_columnIndex.put(rowKey, isIndex);
            }
        }
        catch (Exception e) {
            this.m_messages.addInternalError(e);
        }
    }

    @Override
    public void initialize() {
    }

    public void _initialize() {
        this.createROCFComponents();
        this.passwdTable = new Hashtable(10);
        this.m_databaseProductName = "Sas";
        this.m_properties = new SasSqlProperties(this);
        this.m_sqlLogicProp = new SasSqlLogic(this.m_properties);
        this.m_bInitDone = false;
        this.refresh();
        this.m_bInitDone = true;
        this.setDefaultTableName("_wbqry");
        this.setTableOrView("view");
        if (QueryConfiguration.getConfigurationBoolean("WebAfDataSource.forceValidVarNameAny.notrans", false)) {
            this.m_subI.setProgramText("options validvarname=any;");
        }
    }

    public void setDefaultTableName(String newName) {
        this.m_defaultTableName = newName;
    }

    public String getDefaultTableName() {
        return this.m_defaultTableName;
    }

    public void setTableOrView(String temp) {
        this.m_strTableOrView = temp.toLowerCase().equals("view") ? "view" : "table";
    }

    public String getTableOrView() {
        return this.m_strTableOrView;
    }

    @Override
    public void refresh() {
        String tempName;
        int index;
        boolean bSomethingChanged = false;
        this.m_tableOrViewTable = null;
        this.m_columnIndex = null;
        this.m_names = new Vector();
        if (!this.m_rocfConnected) {
            return;
        }
        try {
            Class<LibraryListInterface> lsi = LibraryListInterface.class;
            LibraryListInterface libraryList = (LibraryListInterface)this.m_rocf.newInstance(lsi, this.m_connection);
            Enumeration enumer = libraryList.getItems();
            while (enumer.hasMoreElements()) {
                String s = (String)enumer.nextElement();
                if (m_makeMixedCaseLibnames && (s = s.toLowerCase()).length() > 0) {
                    char c = s.charAt(0);
                    char C = Character.toUpperCase(c);
                    s = "" + C + s.substring(1);
                }
                this.m_names.addElement(s);
            }
        }
        catch (Exception e) {
            this.m_messages.addInternalError(e);
        }
        boolean bNeedToCheckForOldNames = true;
        if (this.m_containerList == null) {
            this.m_containerList = new DataSourceContainerList();
            bNeedToCheckForOldNames = false;
        }
        int len = this.m_names.size();
        for (index = 0; index < len; ++index) {
            tempName = (String)this.m_names.elementAt(index);
            if (this.m_containerList.contains(this.m_sqlLogicProp, tempName)) continue;
            this.m_containerList.addElement(new WebAfDataSourceContainer(tempName));
            bSomethingChanged = true;
        }
        if (bNeedToCheckForOldNames) {
            len = this.m_containerList.size();
            for (index = len - 1; index >= 0; --index) {
                WebAfDataSourceContainer container = (WebAfDataSourceContainer)this.m_containerList.elementAt(index);
                boolean bStillExists = false;
                int nameLen = this.m_names.size();
                for (int nameIndex = 0; nameIndex < nameLen; ++nameIndex) {
                    tempName = (String)this.m_names.elementAt(nameIndex);
                    if (!this.m_sqlLogicProp.identifierEquals(container.getName(), tempName)) continue;
                    bStillExists = true;
                }
                if (bStillExists) continue;
                this.m_containerList.removeElementAt(index);
                bSomethingChanged = true;
            }
        }
        len = this.m_containerList.size();
        for (index = 0; index < len; ++index) {
            WebAfDataSourceContainer container = (WebAfDataSourceContainer)this.m_containerList.elementAt(index);
            container._refresh();
        }
        if (bSomethingChanged) {
            this.m_messages.queueStructureChange(1024);
        }
    }

    @Override
    public SqlLogic getSqlLogic(Query query) {
        if (this.m_sqlLogicQuery == null) {
            this.m_sqlLogicQuery = new SasSqlLogic(query, this.m_passwordList);
        }
        this.m_sqlLogicQuery.setQuery(query);
        return this.m_sqlLogicQuery;
    }

    @Override
    public boolean getHasMultipleLayers() {
        return true;
    }

    @Override
    public SqlProperties getProperties() {
        return this.m_properties;
    }

    @Override
    public DataSourceContainer getParent() {
        return null;
    }

    @Override
    public String[] getItemNames() {
        int len = this.m_names.size();
        String[] names = new String[len];
        for (int i = 0; i < len; ++i) {
            names[i] = (String)this.m_names.elementAt(i);
        }
        return names;
    }

    @Override
    public DataSourceContainerList getItems() {
        return this.m_containerList;
    }

    @Override
    public int getItemCount() {
        return this.m_containerList.size();
    }

    @Override
    public String getQualifiedName() {
        return this.getName();
    }

    public String generateTableName(String baseTable) {
        String retVal = "";
        try {
            Class<DataSetListInterface> dsi = DataSetListInterface.class;
            boolean hasIt = false;
            DataSetListInterface dList = (DataSetListInterface)this.m_rocf.newInstance(dsi, this.m_connection);
            dList.setLibrary("WORK");
            Enumeration dItems = dList.getItems();
            Vector<String> items = new Vector<String>();
            while (dItems.hasMoreElements()) {
                String tempDs = (String)dItems.nextElement();
                tempDs = tempDs.substring(5);
                if (!hasIt) {
                    hasIt = tempDs.equals(baseTable.toUpperCase());
                }
                items.addElement(tempDs);
            }
            if (!hasIt) {
                retVal = baseTable;
            } else {
                String tempBase = baseTable.toUpperCase();
                String temp2 = "";
                int size = items.size();
                if (tempBase.length() > 6) {
                    tempBase = tempBase.substring(0, 5);
                }
                for (int i = 0; i < size + 1; ++i) {
                    String comp;
                    temp2 = tempBase + Integer.toHexString(i);
                    for (int i2 = 0; i2 < size && !(comp = (String)items.elementAt(i2)).equals(temp2); ++i2) {
                    }
                    if (i <= 255) continue;
                    this.m_messages.addError(bundle, "openRsltSets.txt");
                }
                retVal = temp2;
            }
        }
        catch (Exception e) {
            this.m_messages.addInternalError(e);
            retVal = "";
        }
        return retVal;
    }

    class WebAfExecuteProcSqlStruct {
        public String m_submittedString;
        public String m_logResult;
        public double m_sqlrc = -1.0;
        public double m_syserr = -1.0;
    }

    class WebAfDataSourceTable
    extends DataSourceTable {
        protected DataSourceContainer m_library;
        protected String m_tableName;
        protected String m_qualifiedName;
        protected String m_librefName;
        protected boolean m_bColumnInfoReadYet;
        protected int m_cColumns;
        protected DataSourceColumnList m_columns;

        public WebAfDataSourceTable(DataSourceContainer library, String tableName, String tablePass) {
            this._commonInit(library, tableName, tablePass);
        }

        @Override
        public void initialize() {
        }

        public boolean resetInfo(boolean bIsView) {
            boolean bChanged = false;
            if (this.m_bIsView != bIsView) {
                bChanged = true;
            }
            this.m_bIsView = bIsView;
            return bChanged;
        }

        @Override
        public String getName() {
            return this.m_tableName;
        }

        @Override
        public String getQualifiedName() {
            if (this.m_qualifiedName == null) {
                this.m_qualifiedName = this.m_librefName + "." + this.m_tableName;
            }
            return this.m_qualifiedName;
        }

        @Override
        public DataSourceContainer getParent() {
            return this.m_library;
        }

        @Override
        public RelationshipList getRelationships() {
            return null;
        }

        @Override
        public DataSourceColumnList getColumns() {
            if (!this.m_bColumnInfoReadYet) {
                this._readColumnInfo(null);
            }
            return this.m_columns;
        }

        @Override
        public int getColumnCount() {
            if (!this.m_bColumnInfoReadYet) {
                this._readColumnInfo(null);
            }
            return this.m_cColumns;
        }

        @Override
        public boolean getReadPassword() {
            if (!this.m_pwRead) {
                WebAfDataSource.this.m_dsInfo.setDataSet(this.getQualifiedName());
                String dsname = WebAfDataSource.this.m_dsInfo.getDataSet();
                if (dsname.length() == 0) {
                    String command = "%macro jqgrpw_;\n";
                    command = command + "%global _jqrpw;\n";
                    command = command + "%let _jqrpw = 0; \n";
                    command = command + "%let jqrc = %sysfunc(open(";
                    command = command + this.getQualifiedName();
                    command = command + "));\n";
                    command = command + "%if &jqrc ne 0 %then %let jqtmp = %sysfunc(close( &jqrc )); \n";
                    command = command + "%else %do;\n";
                    command = command + "   %let jqrc = %sysfunc(sysrc());\n";
                    command = command + "   %if %sysevalf(&jqrc = %sysrc(_SEBAUTH )) %then %let _jqrpw = 1; \n ";
                    command = command + "   %end;\n";
                    command = command + "%mend jqgrpw_ ;\n";
                    command = command + "%jqgrpw_; \n";
                    WebAfDataSource.this.m_subI.setProgramText(command);
                    double remoteErrorCode = WebAfDataSource.this.m_sclv2Interface.symgetn("_jqrpw");
                    if (remoteErrorCode != 0.0) {
                        this.m_pwRead = true;
                    }
                }
            }
            return this.m_pwRead;
        }

        protected void _commonInit(DataSourceContainer library, String tableName, String tablePass) {
            if (WebAfDataSource.this.passwdTable == null || WebAfDataSource.this.m_tableOrViewTable == null) {
                WebAfDataSource.this.refreshAllTableData(tableName);
            }
            if (WebAfDataSource.this.m_columnIndex == null) {
                WebAfDataSource.this.refreshAllIndexData();
            }
            this.m_library = library;
            this.m_librefName = this.m_library.getName();
            this.m_tableName = tableName;
            String fullname = this.m_librefName + "." + this.m_tableName;
            if (tablePass == null) {
                tablePass = (String)WebAfDataSource.this.passwdTable.get(fullname);
            }
            if (tablePass != null && !tablePass.equals("---")) {
                this.m_pwRead = tablePass.indexOf("R") != -1;
                this.m_pwWrite = tablePass.indexOf("W") != -1;
                this.m_pwAlter = tablePass.indexOf("A") != -1;
            }
            this.m_bColumnInfoReadYet = false;
            String memType = (String)WebAfDataSource.this.m_tableOrViewTable.get(fullname);
            this.m_bIsView = memType != null && memType.equalsIgnoreCase("VIEW");
        }

        protected boolean _readColumnInfo(Vector columnNames) {
            boolean bNeedToCheckForOldNames = true;
            if (this.m_columns == null) {
                this.m_columns = new DataSourceColumnList();
                bNeedToCheckForOldNames = false;
            }
            boolean bSomethingChanged = false;
            String tableName = this.m_librefName.trim() + "." + this.getName().trim();
            try {
                String password = (String)WebAfDataSource.this.m_passwordList.get(this);
                if (password != null) {
                    tableName = tableName + "(PW=" + password + ")";
                }
                DataSetInfoInterface dsInfo = (DataSetInfoInterface)WebAfDataSource.this.m_rocf.newInstance(DataSetInfoInterface.class, WebAfDataSource.this.m_connection);
                dsInfo.setDataSet(tableName);
                bSomethingChanged = this._createColumns(columnNames, dsInfo);
                if (this.m_cColumns == 0) {
                    WebAfDataSource.this.m_messages.addError(bundle.messageString("tableContents.fmt.txt", tableName));
                } else {
                    this.m_bColumnInfoReadYet = true;
                }
                dsInfo.setDataSet("");
                dsInfo = null;
            }
            catch (Exception e) {
                WebAfDataSource.this.m_messages.addInternalError(bundle.messageString("tableContents.fmt.txt", tableName));
            }
            return bSomethingChanged;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean _createColumns(Vector columnNames, DataSetInfoInterface dsI) {
            boolean hasChanged = false;
            try {
                String dsName = dsI.getDataSet();
                int numcol = dsI.count();
                for (int i = 1; i <= numcol; ++i) {
                    String varName = dsI.getVariableName(i);
                    boolean isIndex = false;
                    if (WebAfDataSource.this.m_columnIndex != null) {
                        isIndex = WebAfDataSource.this.m_columnIndex.get(dsName + "." + varName) != null;
                    }
                    String label = dsI.getVariableLabel(i);
                    String format = dsI.getVariableFormat(i);
                    String informat = dsI.getVariableInformat(i);
                    int varPos = i;
                    Class varClass = dsI.getVariableClass(i);
                    int type = varClass == String.class ? 2 : 1;
                    if (this.addNewColumn(varName, type = type == 1 ? SasFormatUtil.getNumericSqlType(format) : 1, varPos, label, format, informat, isIndex)) {
                        hasChanged = true;
                    }
                    if (columnNames == null) continue;
                    columnNames.addElement(varName);
                }
                this.m_cColumns = numcol;
                return this.m_cColumns != 0;
            }
            catch (Exception e) {
                WebAfDataSource.this.m_messages.addInternalError(e);
                hasChanged = false;
                return hasChanged;
            }
            finally {
                return hasChanged;
            }
        }

        private boolean _createColumns(Vector columnNames, DataSetInterface conDsi) throws Exception {
            boolean hasChanged = false;
            int numRows = conDsi.countRows(WebAfDataSource.this.getMaximumSetSize());
            String tableName = conDsi.getDataSetName();
            int nameIdx = conDsi.getColumnIndex("NAME") - 1;
            int labelIdx = conDsi.getColumnIndex("LABEL") - 1;
            int formatIdx = conDsi.getColumnIndex("FORMAT") - 1;
            int informatIdx = conDsi.getColumnIndex("INFORMAT") - 1;
            int typeIdx = conDsi.getColumnIndex("TYPE") - 1;
            int varPosIdx = conDsi.getColumnIndex("VARNUM") - 1;
            for (int i = 1; i <= numRows; ++i) {
                Double varPosI;
                int varPos;
                Object[] testArr = conDsi.getRow(i);
                String varName = ((String)testArr[nameIdx]).trim();
                boolean isIndex = WebAfDataSource.this.m_columnIndex.get(tableName + "." + varName) != null;
                String label = (String)testArr[labelIdx];
                String format = (String)testArr[formatIdx];
                String informat = (String)testArr[informatIdx];
                String typeName = (String)testArr[typeIdx];
                int type = 1;
                if (typeName.toUpperCase().equals("CHAR")) {
                    type = 2;
                }
                if (this.addNewColumn(varName, type = type == 1 ? SasFormatUtil.getNumericSqlType(format) : 1, varPos = (varPosI = (Double)testArr[varPosIdx]).intValue(), label, format, informat, isIndex)) {
                    hasChanged = true;
                }
                if (columnNames == null) continue;
                columnNames.addElement(varName);
            }
            this.m_cColumns = numRows;
            return hasChanged;
        }

        private boolean addNewColumn(String varName, int type, int varPos, String label, String format, String informat, boolean isIndex) {
            boolean bSomethingChanged = false;
            int existingIndex = this.m_columns.indexOf(WebAfDataSource.this.m_sqlLogicProp, varName);
            if (existingIndex >= 0) {
                WebAfDataSourceColumn existingColumn = (WebAfDataSourceColumn)this.m_columns.elementAt(existingIndex);
                if (existingColumn.resetInfo(varName, type, varPos, label, format, informat, isIndex)) {
                    bSomethingChanged = true;
                }
            } else {
                this.m_columns.addElement(new WebAfDataSourceColumn(varName, type, varPos, label, format, informat, isIndex));
                bSomethingChanged = true;
            }
            return bSomethingChanged;
        }

        @Override
        public void refresh() {
            WebAfDataSource.this.m_tableOrViewTable = null;
            WebAfDataSource.this.m_columnIndex = null;
            this._refresh();
        }

        protected void _refresh() {
            if (!this.m_bColumnInfoReadYet) {
                return;
            }
            boolean bNeedToCheckForOldNames = true;
            if (this.m_columns == null) {
                this.m_columns = new DataSourceColumnList();
                bNeedToCheckForOldNames = false;
            }
            Vector columnNames = new Vector();
            boolean bSomethingChanged = this._readColumnInfo(columnNames);
            if (bNeedToCheckForOldNames) {
                int len = this.m_columns.size();
                for (int index = len - 1; index >= 0; --index) {
                    WebAfDataSourceColumn column = (WebAfDataSourceColumn)this.m_columns.elementAt(index);
                    boolean bStillExists = false;
                    int nameLen = columnNames.size();
                    for (int nameIndex = 0; nameIndex < nameLen; ++nameIndex) {
                        String tempName = (String)columnNames.elementAt(nameIndex);
                        if (!WebAfDataSource.this.m_sqlLogicProp.identifierEquals(column.getName(), tempName)) continue;
                        bStillExists = true;
                    }
                    if (bStillExists) continue;
                    this.m_columns.removeElementAt(index);
                    bSomethingChanged = true;
                }
            }
            if (bSomethingChanged) {
                WebAfDataSource.this.m_messages.queueStructureChange(1024);
            }
        }

        class WebAfDataSourceColumn
        extends DataSourceColumn {
            protected transient boolean m_fIsThereAnotherValue = false;
            protected transient String m_name;
            protected transient int m_type;
            protected transient int m_length;
            protected transient int m_nullable;
            protected transient String m_label;
            protected transient int m_indexPos;
            protected transient String m_format;
            protected transient String m_informat;
            protected transient boolean m_isIndex;
            protected transient int lastUniqueValueIndex;
            protected transient boolean readThruUniqueValues;
            protected transient boolean useUniqueCache;
            protected String[] uniqueValues;

            public WebAfDataSourceColumn(String colName, int colType, int indexPos, String label, String format, String informat, boolean isIndex) {
                this.resetInfo(colName, colType, indexPos, label, format, informat, isIndex);
            }

            public boolean resetInfo(String colName, int colType, int indexPos, String label, String format, String informat, boolean isIndex) {
                boolean bChanged = false;
                if (!(WebAfDataSource.this.m_sqlLogicProp.identifierEquals(this.m_name, colName.trim()) && this.m_type == colType && this.m_indexPos == indexPos && WebAfDataSource.this.m_sqlLogicProp.identifierEquals(this.m_label, label.trim()) && WebAfDataSource.this.m_sqlLogicProp.identifierEquals(this.m_format, format.trim()) && WebAfDataSource.this.m_sqlLogicProp.identifierEquals(this.m_informat, informat.trim()) && this.m_isIndex == isIndex)) {
                    bChanged = true;
                }
                this.m_name = colName.trim();
                this.m_type = colType;
                this.m_indexPos = indexPos;
                this.readThruUniqueValues = false;
                this.setUseUniqueCache(true);
                this.setLabel(label);
                this.setFormat(format);
                this.setInformat(informat);
                this.m_isIndex = isIndex;
                return bChanged;
            }

            public void setUseUniqueCache(boolean useIt) {
                this.useUniqueCache = useIt;
            }

            public boolean getUseUniqueCache() {
                return this.useUniqueCache;
            }

            public void setLabel(String label) {
                if (label != null) {
                    this.m_label = label.trim();
                    if (this.m_label.length() == 0) {
                        this.m_label = null;
                    }
                } else {
                    this.m_label = null;
                }
            }

            public void setFormat(String format) {
                if (format != null) {
                    this.m_format = format.trim();
                    if (this.m_format.length() == 0) {
                        this.m_format = null;
                    }
                } else {
                    this.m_format = null;
                }
            }

            public void setInformat(String informat) {
                if (informat != null) {
                    this.m_informat = informat.trim();
                    if (this.m_informat.length() == 0) {
                        this.m_informat = null;
                    }
                } else {
                    this.m_informat = null;
                }
            }

            @Override
            public String getName() {
                return this.m_name;
            }

            @Override
            public String getQualifiedName() {
                return this.getParent().getName() + "." + this.getName();
            }

            @Override
            public DataSourceTable getParent() {
                return WebAfDataSourceTable.this;
            }

            @Override
            public int getSqlType() {
                return this.m_type;
            }

            @Override
            public int getLength() {
                return this.m_length;
            }

            @Override
            public boolean isNullable() {
                return true;
            }

            @Override
            public boolean isIndexed() {
                return this.m_isIndex;
            }

            @Override
            public String getLabel() {
                return this.m_label;
            }

            @Override
            public String getFormat() {
                return this.m_format;
            }

            @Override
            public String getInformat() {
                return this.m_informat;
            }

            @Override
            public boolean supportsDistinctValues() {
                return true;
            }

            @Override
            public Vector getDistinctValues() {
                this.lastUniqueValueIndex = 0;
                this.readThruUniqueValues = false;
                return this.getNextValueSet(WebAfDataSource.this.getMaximumSetSize());
            }

            @Override
            public Vector getDistinctValueSet(int nSetSize) {
                this.lastUniqueValueIndex = 0;
                this.readThruUniqueValues = false;
                return this.getNextValueSet(nSetSize);
            }

            @Override
            public Vector getNextValueSet(int nSetSize) {
                if (this.uniqueValues == null) {
                    this.createUniqueValueList();
                    this.lastUniqueValueIndex = 0;
                    this.readThruUniqueValues = false;
                }
                Vector<String> retVector = new Vector<String>();
                int limit = nSetSize + this.lastUniqueValueIndex;
                int len = this.uniqueValues.length;
                if (limit > len) {
                    limit = len;
                }
                for (int i = this.lastUniqueValueIndex; i < limit; ++i) {
                    retVector.addElement(this.uniqueValues[i]);
                }
                this.lastUniqueValueIndex = limit;
                if (limit == len) {
                    if (!this.useUniqueCache) {
                        this.uniqueValues = null;
                    }
                    this.lastUniqueValueIndex = 0;
                    this.readThruUniqueValues = true;
                }
                return retVector;
            }

            @Override
            public boolean isThereAnotherDistinctValue() {
                boolean retVal = false;
                if (this.useUniqueCache) {
                    retVal = !this.readThruUniqueValues;
                } else if (this.uniqueValues != null) {
                    retVal = this.lastUniqueValueIndex < this.uniqueValues.length;
                }
                return retVal;
            }

            protected String generateName() {
                String name = this.getName().trim();
                if (name.indexOf(" ") > -1) {
                    name = "'" + name + "'n";
                }
                return name;
            }

            protected void createUniqueValueList() {
                try {
                    String tmpData = WebAfDataSource.this.generateTableName("_wbuvl");
                    String newFormat = this.m_type > 0 ? SasFormatUtil.getNormalizedFormat(this.m_type) : SasFormatUtil.getNormalizedFormat(this.m_format);
                    if (newFormat != null && !newFormat.equals("")) {
                        newFormat = " format=" + newFormat;
                    }
                    int inobs = QueryConfiguration.getConfigurationInt("WebAfDataSource.DistinctValues.Inobs.num.notrans", 10000);
                    int outobs = QueryConfiguration.getConfigurationInt("WebAfDataSource.DistinctValues.Outobs.num.notrans", 250);
                    String maxobs = "outobs=" + outobs + " inobs=" + inobs;
                    String tableName = WebAfDataSourceTable.this.m_librefName + "." + WebAfDataSourceTable.this.m_tableName;
                    if (WebAfDataSourceTable.this.m_pwRead) {
                        tableName = tableName + "(PW=" + WebAfDataSource.this.m_passwordList.get(WebAfDataSource.this) + ")";
                    }
                    String subSql = "proc sql " + maxobs + "; create table " + tmpData + " as \n select distinct " + this.generateName() + newFormat + " \n from " + tableName + "\n order by " + this.generateName() + "; quit;";
                    Class<DataSetInfoInterface> d2 = DataSetInfoInterface.class;
                    DataSetInfoInterface conInf = (DataSetInfoInterface)WebAfDataSource.this.m_rocf.newInstance(d2, WebAfDataSource.this.m_connection);
                    SubmitInterface subI = (SubmitInterface)WebAfDataSource.this.m_rocf.newInstance(SubmitInterface.class, WebAfDataSource.this.m_connection);
                    SclfuncsV2Interface sclv2Interface = (SclfuncsV2Interface)WebAfDataSource.this.m_rocf.getInstance(SclfuncsV2Interface.class, WebAfDataSource.this.m_connection);
                    subI.setProgramText(subSql);
                    String log = subI.getLastLogText();
                    double remoteRc = sclv2Interface.symgetn("SQLRC");
                    if (remoteRc > 4.0) {
                        WebAfDataSource.this.m_messages.addError(log);
                    }
                    conInf.setDataSet(tmpData);
                    this.uniqueValues = conInf.getVariableUniqueValues(1);
                }
                catch (Throwable e) {
                    WebAfDataSource.this.m_messages.addInternalError(bundle.messageString("uniqueRslts.fmt.txt", this.m_name));
                }
            }
        }
    }

    public class WebAfDataSourceContainer
    extends DataSourceContainer {
        protected String m_strName;
        protected boolean m_bDetailInfoReadYet = false;
        protected int m_cTables;
        protected DataSourceContainerList m_children;

        public WebAfDataSourceContainer(String strName) {
            this.m_strName = strName;
            this.m_bDetailInfoReadYet = false;
        }

        @Override
        public void initialize() {
            this._readDetailInfo();
        }

        @Override
        public String getName() {
            return this.m_strName;
        }

        @Override
        public String getQualifiedName() {
            return this.getName();
        }

        @Override
        public DataSourceContainer getParent() {
            return WebAfDataSource.this;
        }

        public Connection getConnection() {
            return WebAfDataSource.this.m_connection;
        }

        @Override
        public DataSourceContainerList getItems() {
            if (!this.m_bDetailInfoReadYet) {
                this.initialize();
            }
            return this.m_children;
        }

        @Override
        public int getItemCount() {
            if (!this.m_bDetailInfoReadYet) {
                this.initialize();
            }
            return this.m_cTables;
        }

        @Override
        public String[] getItemNames() {
            String[] strList = new String[this.m_cTables];
            for (int index = 0; index < this.m_cTables; ++index) {
                strList[index] = this.m_children.elementAt(index).getName();
            }
            return strList;
        }

        protected void _readDetailInfo() {
            try {
                if (this.m_children == null) {
                    this.m_children = new DataSourceContainerList();
                }
                Class<DataSetListInterface> dsLi = DataSetListInterface.class;
                DataSetListInterface dataSetList = (DataSetListInterface)WebAfDataSource.this.m_rocf.newInstance(dsLi, WebAfDataSource.this.m_connection);
                Vector dataSetNames = this._loadLibrary(dataSetList, this.m_strName);
                int len = dataSetNames.size();
                for (int index = 0; index < len; ++index) {
                    this._saveDetailInfo(dataSetNames, index);
                }
                this.m_bDetailInfoReadYet = true;
                this.m_cTables = this.m_children.size();
            }
            catch (Exception e) {
                WebAfDataSource.this.m_messages.addInternalError(e);
            }
        }

        protected boolean _saveDetailInfo(Vector dataSetNames, int index) {
            boolean bAdded = false;
            String tname = (String)dataSetNames.elementAt(index);
            String strTableName = tname.substring(tname.indexOf(".") + 1);
            if (WebAfDataSource.this.m_tableOrViewTable == null) {
                WebAfDataSource.this.refreshAllTableData(tname);
            }
            if (WebAfDataSource.this.m_columnIndex == null) {
                WebAfDataSource.this.refreshAllIndexData();
            }
            String strTablePass = null;
            if (!this.m_children.contains(WebAfDataSource.this.m_sqlLogicProp, strTableName)) {
                this.m_children.addElement(new WebAfDataSourceTable(this, strTableName.trim(), strTablePass));
                bAdded = true;
            } else {
                WebAfDataSourceTable table = (WebAfDataSourceTable)this.m_children.elementAt(WebAfDataSource.this.m_sqlLogicProp, strTableName);
                if (table != null) {
                    boolean bIsView;
                    String memType = (String)WebAfDataSource.this.m_tableOrViewTable.get(table.getQualifiedName());
                    boolean bl = bIsView = memType != null && memType.equalsIgnoreCase("VIEW");
                    if (table.resetInfo(bIsView)) {
                        bAdded = true;
                    }
                }
            }
            return bAdded;
        }

        protected Vector _loadLibrary(DataSetListInterface dsi, String librefName) {
            Vector returnValue = new Vector();
            dsi.setLibrary(librefName);
            Enumeration dataSets = dsi.getItems();
            while (dataSets.hasMoreElements()) {
                returnValue.addElement(dataSets.nextElement());
            }
            return returnValue;
        }

        @Override
        public void refresh() {
            WebAfDataSource.this.m_tableOrViewTable = null;
            WebAfDataSource.this.m_columnIndex = null;
            this._refresh();
        }

        protected void _refresh() {
            if (!this.m_bDetailInfoReadYet) {
                return;
            }
            boolean bSomethingChanged = false;
            try {
                WebAfDataSourceTable table;
                int index;
                Class<DataSetListInterface> dsLi = DataSetListInterface.class;
                DataSetListInterface dataSetList = (DataSetListInterface)WebAfDataSource.this.m_rocf.newInstance(dsLi, WebAfDataSource.this.m_connection);
                Vector dataSetNames = this._loadLibrary(dataSetList, this.m_strName);
                int len = dataSetNames.size();
                for (int index2 = 0; index2 < len; ++index2) {
                    if (!this._saveDetailInfo(dataSetNames, index2)) continue;
                    bSomethingChanged = true;
                }
                len = this.m_children.size();
                for (index = len - 1; index >= 0; --index) {
                    table = (WebAfDataSourceTable)this.m_children.elementAt(index);
                    boolean bStillExists = false;
                    int nameLen = dataSetNames.size();
                    for (int nameIndex = 0; nameIndex < nameLen; ++nameIndex) {
                        String tempName = (String)dataSetNames.elementAt(nameIndex);
                        if (!WebAfDataSource.this.m_sqlLogicProp.identifierEquals(table.getQualifiedName(), tempName)) continue;
                        bStillExists = true;
                        break;
                    }
                    if (bStillExists) continue;
                    this.m_children.removeElementAt(index);
                    bSomethingChanged = true;
                }
                len = this.m_children.size();
                for (index = 0; index < len; ++index) {
                    table = (WebAfDataSourceTable)this.m_children.elementAt(index);
                    table._refresh();
                }
                this.m_bDetailInfoReadYet = true;
                this.m_cTables = this.m_children.size();
            }
            catch (Exception e) {
                WebAfDataSource.this.m_messages.addInternalError(e);
            }
            if (bSomethingChanged) {
                WebAfDataSource.this.m_messages.queueStructureChange(1024);
            }
        }
    }
}

