/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.query.Query;
import com.sas.query.QueryUtils;
import com.sas.query.datasources.DataSourceContainer;
import com.sas.query.datasources.SqlProperties;
import com.sas.query.models.Column;
import com.sas.query.models.Expression;
import com.sas.query.models.ExpressionConstants;
import com.sas.query.models.FilterNetwork;
import com.sas.query.models.FilterNetworkAtomExpression;
import com.sas.query.models.FilterNode;
import com.sas.query.models.FilterTree;
import com.sas.query.models.GroupItem;
import com.sas.query.models.GroupItemList;
import com.sas.query.models.Join;
import com.sas.query.models.JoinList;
import com.sas.query.models.JoinRelationshipList;
import com.sas.query.models.OrderItem;
import com.sas.query.models.OrderItemList;
import com.sas.query.models.ResultItem;
import com.sas.query.models.ResultItemList;
import com.sas.query.models.Table;
import com.sas.query.visuals.QueryResource;
import java.util.Hashtable;

public class SqlLogic
implements ExpressionConstants {
    protected static int JS_INT = 50;
    protected static int JS_CHAR = 25;
    protected static int JS_INDEXED = 50;
    public static int JS_HIGHEST_CONFIDENCE = JS_INT * 2 + JS_INDEXED * 2;
    protected transient Query m_query;
    protected transient SqlProperties m_properties;
    protected transient boolean m_fMultipleTables;
    protected Hashtable m_passwordList = null;
    protected static QueryResource bundle = new QueryResource(SqlLogic.class);
    protected boolean useQualifiedName;

    public SqlLogic(Query query, Hashtable passwordList) {
        this.setQuery(query);
        this.m_passwordList = passwordList;
    }

    public SqlLogic(SqlProperties sqlProperties) {
        this.m_properties = sqlProperties;
        this.m_fMultipleTables = true;
    }

    public SqlLogic() {
    }

    public void initQuery(Query query, Hashtable passwordList) {
        this.setQuery(query);
        this.m_passwordList = passwordList;
    }

    public void initProperties(SqlProperties sqlProperties) {
        this.m_properties = sqlProperties;
        this.m_fMultipleTables = true;
    }

    public void setQuery(Query query) {
        this.m_query = query;
        this.m_properties = query.getSqlProperties();
        this.m_fMultipleTables = this.m_properties.getAlwaysQualifyColumnNames() ? true : query.getTableCount() > 1;
    }

    public Query getQuery() {
        return this.m_query;
    }

    public boolean identifierEquals(String firstName, String secondName) {
        return QueryUtils.equalsIgnoreCase(firstName, secondName);
    }

    public int getJoinSuitability(Column column) {
        int confidence = 0;
        if (column.getSqlType() == 4 || column.getSqlType() == 5 || column.getSqlType() == -6 || column.getSqlType() == -5) {
            confidence += JS_INT;
        } else if (column.getSqlType() == 1 || column.getSqlType() == 12) {
            confidence += JS_CHAR;
        }
        if (column.isIndexed()) {
            confidence += JS_INDEXED;
        }
        return confidence;
    }

    public String genCreateTable(String strQuery, String tableName) {
        String createTabStr = "create table " + tableName + " as " + strQuery;
        return createTabStr;
    }

    public String genCreateView(String strQuery, String viewName, String passwordForViewDefinition) {
        String createViewStr = "create view " + viewName;
        if (passwordForViewDefinition != null) {
            createViewStr = createViewStr + "(ALTER=" + passwordForViewDefinition + ")";
        }
        createViewStr = createViewStr + " as " + strQuery;
        return createViewStr;
    }

    public String genQuery(Query query) {
        return this.genQuery(query, null, null);
    }

    public String genQuery(Query query, FilterNode finalWhereNode, FilterNode finalHavingNode) {
        this.setQuery(query);
        String strQuery = "SELECT " + this.genSelectedColumnList();
        String nextSection = this.genFromClause();
        if (nextSection != null && nextSection.length() > 0) {
            strQuery = strQuery + " FROM " + nextSection;
        }
        if ((nextSection = this.genWhereClause(finalWhereNode)) != null && nextSection.length() > 0) {
            strQuery = strQuery + " WHERE " + nextSection;
        }
        if ((nextSection = this.genGroupByClause()) != null && nextSection.length() > 0) {
            strQuery = strQuery + " GROUP BY " + nextSection;
        }
        if ((nextSection = this.genHavingClause(finalHavingNode)) != null && nextSection.length() > 0) {
            strQuery = strQuery + " HAVING " + nextSection;
        }
        if ((nextSection = this.genOrderByClause()) != null && nextSection.length() > 0) {
            strQuery = strQuery + " ORDER BY " + nextSection;
        }
        if (this.m_query.getUnion() != null) {
            if (this.m_query.getUnionType() == 0) {
                strQuery = strQuery + " UNION ";
            } else if (this.m_query.getUnionType() == 1) {
                strQuery = strQuery + " UNION ALL ";
            } else if (this.m_query.getUnionType() == 2) {
                strQuery = strQuery + " INTERSECT ";
            } else if (this.m_query.getUnionType() == 3) {
                strQuery = strQuery + " EXCEPT ";
            }
            strQuery = strQuery + this.genQuery(this.m_query.getUnion());
        }
        return strQuery;
    }

    public String genSelectedColumnList() {
        String strSelect = "";
        if (this.m_query.getDuplicateRowsRule() == 2) {
            strSelect = strSelect + "ALL ";
        } else if (this.m_query.getDuplicateRowsRule() == 0) {
            strSelect = strSelect + "DISTINCT ";
        }
        ResultItemList columnList = this.m_query.getResultItems();
        int cColumns = columnList.size();
        for (int columnIndex = 0; columnIndex < cColumns; ++columnIndex) {
            if (columnIndex > 0) {
                strSelect = strSelect + ", ";
            }
            strSelect = strSelect + this.genColumnNameInSelectList(columnList.elementAt(columnIndex));
            if (columnList.elementAt(columnIndex).getAlias() == null) continue;
            strSelect = strSelect + " AS " + this.genIdentifier(columnList.elementAt(columnIndex).getAlias());
        }
        return strSelect;
    }

    public String genFromClause() {
        String sqlString = "";
        JoinList joinList = this.m_query.getJoins();
        sqlString = this.genSQLForJoin(joinList);
        return sqlString;
    }

    protected String genSQLForJoin(JoinList joinList) {
        String sqlString = "";
        for (int i = 0; i < joinList.size(); ++i) {
            Join join = joinList.elementAt(i);
            if (join.getNewJoinGroupValue()) {
                if (i > 0) {
                    sqlString = sqlString + ", ";
                }
                String leftTableString = this.genSQLForTable(join.getTable());
                sqlString = sqlString + leftTableString;
                continue;
            }
            int joinType = join.getJoinType();
            JoinRelationshipList conditions = join.getRelationships();
            if (conditions.size() == 0) {
                sqlString = sqlString + ", ";
            } else if (joinType == 0) {
                sqlString = sqlString + " INNER JOIN ";
            } else if (joinType == 1) {
                sqlString = sqlString + " LEFT JOIN ";
            } else if (joinType == 2) {
                sqlString = sqlString + " RIGHT JOIN ";
            } else if (joinType == 3) {
                sqlString = sqlString + " FULL JOIN ";
            }
            String rightTableString = this.genSQLForTable(join.getTable());
            sqlString = sqlString + rightTableString;
            for (int j = 0; j < conditions.size(); ++j) {
                sqlString = j == 0 ? sqlString + " ON (" : sqlString + " AND ";
                sqlString = sqlString + conditions.elementAt(j).getComparisonDetails().generateSQL(this, 1);
            }
            if (conditions.size() <= 0) continue;
            sqlString = sqlString + ") ";
        }
        return sqlString;
    }

    protected String genSQLForTable(Table table) {
        String sqlString = "";
        if (table == null) {
            return "";
        }
        if (table.getDataSourceTable().getDataSource().getHasMultipleLayers()) {
            DataSourceContainer parent = table.getDataSourceTable().getParent();
            String schemaName = null;
            if (parent != null) {
                schemaName = parent.getName();
            }
            if (schemaName != null && schemaName.length() > 0) {
                sqlString = sqlString + this.genIdentifier(schemaName) + ".";
            }
        }
        sqlString = sqlString + this.genIdentifier(table.getName());
        String strName = table.getCorrelationName();
        if (strName != null && strName.length() > 0) {
            sqlString = sqlString + " AS " + this.genIdentifier(strName);
        }
        return sqlString;
    }

    public String genWhereClause() {
        return this.genWhereClause(null);
    }

    public String genWhereClause(FilterNode finalNode) {
        FilterTree filterTree = this.m_query.getWhereFilterTree();
        if (filterTree == null) {
            return null;
        }
        String sqlString = this.genSQLForFilterTree(filterTree, finalNode);
        return sqlString;
    }

    protected String genSQLForFilterTreeBruteForce(FilterTree filterTree) {
        return this.genSQLForFilterTreeNotOrChildNodeBruteForce(filterTree, filterTree.getRoot());
    }

    protected String genSQLForFilterTreeNotOrChildNodeBruteForce(FilterTree filterTree, FilterNode node) {
        String sqlString = "";
        sqlString = node.getOr() != null ? "(" + this.genSQLForFilterTreeOrChildNodeBruteForce(filterTree, node) + ")" : this.genSQLForFilterTreeOrChildNodeBruteForce(filterTree, node);
        return sqlString;
    }

    protected String genSQLForFilterTreeOrChildNodeBruteForce(FilterTree filterTree, FilterNode node) {
        String sqlString = "";
        sqlString = node.getAnd() != null ? "( " + this.genNodeOnlySql(filterTree, node) + " AND " + this.genSQLForFilterTreeNotOrChildNodeBruteForce(filterTree, node.getAnd()) + ")" : this.genNodeOnlySql(filterTree, node);
        if (node.getOr() != null) {
            sqlString = sqlString + " OR ";
            sqlString = sqlString + this.genSQLForFilterTreeOrChildNodeBruteForce(filterTree, node.getOr());
        }
        return sqlString;
    }

    protected String genNodeOnlySql(FilterTree filterTree, FilterNode node) {
        String sqlString = "";
        Expression expression = node.getNodeData();
        if (expression != null) {
            int useAlias = this.useQualifiedName ? 1 : 2;
            sqlString = sqlString + expression.generateSQL(this, useAlias);
        }
        return sqlString;
    }

    public String genSQLForFilterTree(FilterTree filterTree) {
        return this.genSQLForFilterTree(filterTree, null);
    }

    public String genSQLForFilterTree(FilterTree filterTree, FilterNode finalNode) {
        String sqlString = "";
        if (filterTree == null) {
            return sqlString;
        }
        FilterNetwork fn = new FilterNetwork();
        FilterNetworkAtomExpression list = fn.generateOptimizedFilterClause(this.m_query, filterTree, finalNode);
        if (list == null) {
            if (filterTree.getRoot() != null) {
                sqlString = this.genSQLForFilterTreeBruteForce(filterTree);
            }
            return sqlString;
        }
        for (int index = 0; index < list.size(); ++index) {
            Object item = list.elementAt(index);
            if (item instanceof String) {
                sqlString = sqlString + (String)item + " ";
                continue;
            }
            if (!(item instanceof FilterNode)) continue;
            FilterNode node = (FilterNode)item;
            Expression expression = node.getNodeData();
            if (expression != null) {
                int useAlias = this.useQualifiedName ? 1 : 2;
                sqlString = sqlString + expression.generateSQL(this, useAlias);
                continue;
            }
            sqlString = sqlString + " INCOMPLETE FILTER NODE SPECIFICATION";
        }
        return sqlString;
    }

    public String genGroupByClause() {
        String strSQL = "";
        GroupItemList groupList = this.m_query.getGroupItems();
        for (int index = 0; index < groupList.size(); ++index) {
            Object alias = null;
            if (index > 0) {
                strSQL = strSQL + ", ";
            }
            GroupItem item = groupList.elementAt(index);
            int useAlias = this.useQualifiedName ? 1 : 2;
            strSQL = strSQL + item.getExpression().generateSQL(this, useAlias);
        }
        return strSQL;
    }

    public String genHavingClause() {
        return this.genHavingClause(null);
    }

    public String genHavingClause(FilterNode finalNode) {
        FilterTree filterTree = this.m_query.getHavingFilterTree();
        if (filterTree == null) {
            return null;
        }
        String sqlString = this.genSQLForFilterTree(filterTree, finalNode);
        return sqlString;
    }

    public String genOrderByClause() {
        String strSQL = "";
        OrderItemList orderList = this.m_query.getOrderItems();
        for (int index = 0; index < orderList.size(); ++index) {
            OrderItem item;
            Object alias = null;
            if (index > 0) {
                strSQL = strSQL + ", ";
            }
            if ((item = orderList.elementAt(index)).isThisANumber()) {
                ResultItemList columnList = this.m_query.getResultItems();
                for (int resultIndex = 0; resultIndex < columnList.size(); ++resultIndex) {
                    if (!columnList.elementAt(resultIndex).equals(item.getResultItem())) continue;
                    strSQL = strSQL + resultIndex;
                    break;
                }
            } else {
                int useAlias = this.useQualifiedName ? 1 : 2;
                strSQL = strSQL + item.getExpression().generateSQL(this, useAlias);
            }
            if (item.getSortingDirection() == 1) {
                strSQL = strSQL + " ASC";
                continue;
            }
            if (item.getSortingDirection() != 2) continue;
            strSQL = strSQL + " DESC";
        }
        return strSQL;
    }

    protected String genColumnNameInSelectList(ResultItem columnInfo) {
        String sqlString = "";
        Expression expression = columnInfo.getExpression();
        sqlString = sqlString + expression.generateSQL(this, 1);
        return sqlString;
    }

    public String genColumnName(Column column) {
        String strColumn = "";
        if (this.m_fMultipleTables) {
            String strTableName = column.getParent().getCorrelationName();
            if (strTableName == null || strTableName.length() == 0) {
                strTableName = column.getParent().getName();
            }
            strColumn = strColumn + this.genIdentifier(strTableName) + ".";
        }
        strColumn = strColumn + this.genIdentifier(column.getName());
        return strColumn;
    }

    public String genIdentifier(String name) {
        String strUnquotedChars = this.m_properties.getUnquotedNameCharacters();
        String strStartQuote = this.m_properties.getIdentifierQuoteStart();
        String strEndQuote = this.m_properties.getIdentifierQuoteEnd();
        String strIndentifier = name;
        if (name.equals("*")) {
            return name;
        }
        for (int index = 0; index < name.length(); ++index) {
            if (strUnquotedChars.indexOf(name.charAt(index)) != -1) continue;
            strIndentifier = strStartQuote + name + strEndQuote;
            break;
        }
        return strIndentifier;
    }

    public String genDateValue(String strValue) {
        if (this.m_properties.getDateStringFormat() == 1) {
            return " '" + QueryUtils.stripAndDouble(strValue) + "'d";
        }
        return " {D'" + QueryUtils.stripAndDouble(strValue) + "'}";
    }

    public String genTimeValue(String strValue) {
        if (this.m_properties.getDateStringFormat() == 1) {
            return " '" + QueryUtils.stripAndDouble(strValue) + "'t";
        }
        return " {T'" + QueryUtils.stripAndDouble(strValue) + "'}";
    }

    public String genTimestampValue(String strValue) {
        if (this.m_properties.getDateStringFormat() == 1) {
            return " '" + QueryUtils.stripAndDouble(strValue) + "'dt";
        }
        return " {TS'" + QueryUtils.stripAndDouble(strValue) + "'}";
    }

    public String getFormatPrefix(int expType) {
        switch (expType) {
            case 32: {
                return "{T'";
            }
            case 16: {
                return "{D'";
            }
            case 64: {
                return "{TS'";
            }
            case 4: {
                return "'";
            }
        }
        return "";
    }

    public String getFormatSuffix(int expType) {
        switch (expType) {
            case 32: {
                return "'}";
            }
            case 16: {
                return "'}";
            }
            case 64: {
                return "'}";
            }
            case 4: {
                return "'";
            }
        }
        return "";
    }

    public String getFormatExample(int expType) {
        switch (expType) {
            case 32: {
                return "{T'HH:MM:SS'}";
            }
            case 16: {
                return "{D'YYYY-MM-DD'}";
            }
            case 64: {
                return "{TS'YYYY-MM-DD HH:MM:SS'}";
            }
            case 4: {
                return bundle.messageString("SqlLogic.characterFormatExample.txt");
            }
        }
        return null;
    }

    public String getQualifiedName(String name) {
        return name;
    }

    public void setQualifiedNameUsed(boolean useQualifiedName) {
        this.useQualifiedName = useQualifiedName;
    }

    public boolean isQualifiedNameUsed() {
        return this.useQualifiedName;
    }
}

