/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.Function;
import com.sas.query.datasources.FunctionList;
import com.sas.query.datasources.FunctionParameter;
import com.sas.query.datasources.Operator;
import com.sas.query.datasources.SqlProperties;
import com.sas.query.visuals.QueryResource;

public class SasSqlProperties
extends SqlProperties {
    protected static QueryResource bundle = new QueryResource(SasSqlProperties.class);
    static String[] distinctDef = new String[]{"DISTINCT", ""};
    static FunctionParameter fipsExpressionParam = new FunctionParameter("expression", 2, "Numeric expression representing a U.S. FIPS code.");
    static FunctionParameter statePostalParam = new FunctionParameter("postal-code", 4, "Character expression containing two-character state postal code");
    static FunctionParameter zipParam = new FunctionParameter("zip-code", 4, "Character expression representing a U.S. FIPS code.");
    static FunctionParameter periodParam = new FunctionParameter("period", 2, "Period for which calculation is to be done.");
    static FunctionParameter accValueParam = new FunctionParameter("value", 2, "Depreciable inital value of the asset.");
    static FunctionParameter yearsParam = new FunctionParameter("years", 2, "Lifetime of the asset.");
    static FunctionParameter rateParam = new FunctionParameter("rate", 2, "Rate of depreciation expressed as a decimal.");
    static FunctionParameter numArgParam = new FunctionParameter("argument", 2, "Numeric value to examine.");
    static FunctionParameter numArgCommaListParam = new FunctionParameter("argument", 2, "Numeric value to examine.", false, true, 0, null);
    static FunctionParameter numSeedParam = new FunctionParameter("seed", 2, "Integer seed value.");
    static FunctionParameter numArgParam1to1 = new FunctionParameter("argument", 2, "Numeric value between -1 and 1.");
    static Function[] extendedFunctions = new Function[]{new Function(0x400000, "MEAN", "MEAN()", 1, "MEAN({0})", "mean of {0}", 2, new FunctionParameter("listOfValues", 4095, "Value to examine.", false, true, 0, null), "SasFunction.Long.MEAN.txt"), new Function(0x400000, "MEAN DISTINCT", "MEAN(Distinct X)", 1, "MEAN(DISTINCT {0})", "mean of all distinct values of {0}", 2, new FunctionParameter("listOfValues", 4095, "Value to examine.", false, true, 0, null), "SasFunction.Long.MEANDISTINCT.txt"), new Function(0x400000, "N", "N()", 1, "N({0})", "number of non-missing values from {0} ", 2, new FunctionParameter("listOfValues", 4095, "Value to examine.", false, true, 0, null), "SasFunction.Long.N.txt"), new Function(0x400000, "N DISTINCT", "N(Distinct X)", 1, "N(DISTINCT {0})", "number of distinct non-missing values from {0} ", 2, new FunctionParameter("listOfValues", 4095, "Value to examine.", false, true, 0, null), "SasFunction.Long.NDISTINCT.txt"), new Function(0x400000, "NMISS", "NMISS()", 1, "NMISS({0})", "return number of missing values from {0} ", 2, new FunctionParameter("listOfValues", 4095, "Value to examine.", false, true, 0, null), "SasFunction.Long.NMISS.txt"), new Function(0x400000, "NMISS DISTINCT", "NMISS(Distinct X)", 1, "NMISS(DISTINCT {0})", "return number of missing values from {0} ", 2, new FunctionParameter("listOfValues", 4095, "Value to examine.", false, true, 0, null), "SasFunction.Long.NMISSDISTINCT.txt"), new Function(0x400000, "FREQ", "FREQ()", 1, "FREQ({0})", " returns the frequency of {0}", 2, new FunctionParameter("value", "Value to search.", 4095), "SasFunction.Long.FREQ.txt"), new Function(0x400000, "CSS", "CSS()", 1, "CSS({0})", "corrected sum of squares of {0}", 2, new FunctionParameter("listOfValues", 2, "Value to examine.", false, true, 0, null), "SasFunction.Long.CSS.txt"), new Function(0x400000, "CSS DISTINCT", "CSS(Distinct X)", 1, "CSS(DISTINCT {0})", "corrected sum of squares of distinct values in {0}", 2, new FunctionParameter("listOfValues", 2, "Value to examine.", false, true, 0, null), "SasFunction.Long.CSSDISTINCT.txt"), new Function(0x400000, "CV", "CV()", 1, "CV({0})", "coefficient of variation of {0}", 2, new FunctionParameter("listOfValues", 2, "Value to examine.", false, true, 0, null), "SasFunction.Long.CV.txt"), new Function(0x400000, "CV DISTINCT", "CV(Distinct X)", 1, "CV(DISTINCT {0})", "coefficient of variation of distinct values in {0}", 2, new FunctionParameter("listOfValues", 2, "Value to examine.", false, true, 0, null), "SasFunction.Long.CVDISTINCT.txt"), new Function(0x400000, "PRT", "PRT()", 1, "PRT({0})", " probablility of a greater absolute value of {0}", 2, new FunctionParameter("value", "Value to search.", 2), "SasFunction.Long.PRT.txt"), new Function(0x400000, "PRT DISTINCT", "PRT(Distinct X)", 1, "PRT(DISTINCT {0})", " probablility of a greater absolute value of {0}", 2, new FunctionParameter("value", "Value to search.", 2), "SasFunction.Long.PRTDISTINCT.txt"), new Function(0x400000, "RANGE", "RANGE()", 1, "RANGE({0})", "range of values of {0}", 2, new FunctionParameter("listOfValues", 2, "Value to examine.", false, true, 0, null), "SasFunction.Long.RANGE.txt"), new Function(0x400000, "STD", "STD()", 1, "STD({0})", "standard deviation of {0}", 2, new FunctionParameter("listOfValues", 2, "Value to examine.", false, true, 0, null), "SasFunction.Long.STD.txt"), new Function(0x400000, "STD DISTINCT", "STD(Distinct X)", 1, "STD(DISTINCT {0})", "standard deviation of distinct values in {0}", 2, new FunctionParameter("listOfValues", 2, "Value to examine.", false, true, 0, null), "SasFunction.Long.STDDISTINCT.txt"), new Function(0x400000, "STDERR", "STDERR()", 1, "STDERR({0})", "standard error of the mean of {0}", 2, new FunctionParameter("listOfValues", 2, "Value to examine.", false, true, 0, null), "SasFunction.Long.STDERR.txt"), new Function(0x400000, "STDERR DISTINCT", "STDERR(Distinct X)", 1, "STDERR(DISTINCT {0})", "standard error of the mean of distinct values in {0}", 2, new FunctionParameter("listOfValues", 2, "Value to examine.", false, true, 0, null), "SasFunction.Long.STDERRDISTINCT.txt"), new Function(0x400000, "SUMWGT", "SUMWGT()", 1, "SUMWGT({0})", " sum of the WEIGHT variable values of {0}", 2, new FunctionParameter("value", "Value to search.", 2), "SasFunction.Long.SUMWGT.txt"), new Function(0x400000, "SUMWGT DISTINCT", "SUMWGT(Distinct X)", 1, "SUMWGT(DISTINCT {0})", " sum of the WEIGHT variable values of distinct values in {0}", 2, new FunctionParameter("value", "Value to search.", 2), "SasFunction.Long.SUMWGTDISTINCT.txt"), new Function(0x400000, "T", "T()", 1, "T({0})", " t value test for zero for {0}", 2, new FunctionParameter("value", "Value to search.", 2), "SasFunction.Long.T.txt"), new Function(0x400000, "T DISTINCT", "T(Distinct X)", 1, "T(DISTINCT {0})", "t value test for zero for distinct values in {0}", 2, new FunctionParameter("value", "Value to search.", 2), "SasFunction.Long.TDISTINCT.txt"), new Function(0x400000, "USS", "USS()", 1, "USS({0})", "uncorrected sum of squares of {0}", 2, new FunctionParameter("listOfValues", 2, "Value to examine.", false, true, 0, null), "SasFunction.Long.USS.txt"), new Function(0x400000, "USS DISTINCT", "USS(Distinct X)", 1, "USS(DISTINCT {0})", "uncorrected sum of squares of {0}", 2, new FunctionParameter("listOfValues", 2, "Value to examine.", false, true, 0, null), "SasFunction.Long.USSDISTINCT.txt"), new Function(0x400000, "VAR", "VAR()", 1, "VAR({0})", "the variance of {0}", 2, new FunctionParameter("listOfValues", 2, "Value to examine.", false, true, 0, null), "SasFunction.Long.VAR.txt"), new Function(0x400000, "VAR DISTINCT", "VAR(Distinct X)", 1, "VAR(DISTINCT {0})", "the variance of distinct values in {0}", 2, new FunctionParameter("listOfValues", 2, "Value to examine.", false, true, 0, null), "SasFunction.Long.VARDISTINCT.txt"), new Operator("**", bundle.messageString("raisedPowerOperatorDescription.txt"), "{0} ** {1}", "{0} ** {1}", 2, 2, 2, bundle.messageString("raisedPowerOperatorLongDescription.txt")), new Operator("=*", bundle.messageString("soundsLikeOperatorDescription.txt"), "{0} =* {1}", "{0} =* {1}", 32768, 4, 4, bundle.messageString("soundsLikeOperatorLongDescription.txt")), new Operator("^=", bundle.messageString("notEqualsOperatorDescription.txt"), "{0} ^= {1}", "{0} ^= {1}", 32768, 4095, 4095, bundle.messageString("notEqualsOperatorLongDescription.txt")), new Function(0x800000, "CONTAINS", bundle.getString("containOperatorDescription.txt"), 32, "{0} CONTAINS {1}", "{0} Contains {1}", 32768, new FunctionParameter("value", 4, "Value to examine."), new FunctionParameter("pattern", 4, "Pattern to match."), 1, "SasFunction.Long.CONTAINS.txt"), new Operator("<>", bundle.messageString("minimumScalarOperatorDescription.txt"), "{0} <> {1}", "{0} <> {1}", 4095, 4095, 4095, bundle.messageString("minimumScalarOperatorLongDescription.txt")), new Operator("><", bundle.messageString("maximumScalarOperatorDescription.txt"), "{0} >< {1}", "{0} >< {1}", 4095, 4095, 4095, bundle.messageString("maximumScalarOperatorLongDescription.txt")), new Function(1, "ABS", "ABS(argument)", 2, "ABS({0})", "ABS({0})", 2, new FunctionParameter("argument", 2, "Value to examine."), "SasFunction.Long.ABS.txt"), new Function(1, "MAX", "MAX(argument,argument, ...)", 2, "MAX({0}, {1})", "MAX({0}, {1})", 2, numArgParam, numArgCommaListParam, 0, "SasFunction.Long.MAX.txt"), new Function(1, "MIN", "MIN(argument,argument, ...)", 2, "MIN({0}, {1})", "MIN({0}, {1})", 2, numArgParam, numArgCommaListParam, 0, "SasFunction.Long.MIN.txt"), new Function(1, "MOD", "MOD(argument-1, argument-2)", 2, "MOD({0}, {1})", "MOD({0}, {1})", 2, new FunctionParameter("argument-1", 2, "Numeric value."), new FunctionParameter("argument-2", 2, "Numeric value and cannot be zero."), 0, "SasFunction.Long.MOD.txt"), new Function(1, "SIGN", "SIGN(argument)", 2, "SIGN({0})", "SIGN({0})", 2, numArgParam, "SasFunction.Long.SIGN.txt"), new Function(1, "SQRT", "SQRT(argument)", 2, "SQRT({0})", "SQRT({0})", 2, numArgParam, "SasFunction.Long.SQRT.txt"), new Function(2, "BETAINV", "BETAINV(p,a,b)", 2, "BETAINV({0}, {1}, {2})", "BETAINV({0}, {1}, {2})", 2, new FunctionParameter("p", 2, "Value to examine."), new FunctionParameter("a", 2, "Value to examine."), new FunctionParameter("b", 2, "Value to examine."), 0, "SasFunction.Long.BETAINV.txt"), new Function(2, "CINV", "CINV(p,df<,nc>)", 2, "CINV({0}, {1}, {2})", "CINV({0}, {1}, {2})", 2, new FunctionParameter("p", 2, "Value to examine."), new FunctionParameter("df", 2, "Value to examine."), new FunctionParameter("nc", 2, "Value to examine."), 0, "SasFunction.Long.CINV.txt"), new Function(2, "FINV", "FINV(p,ndf,ddf<,nc>)", 2, "FINV({0}, {1}, {2}, {3})", "FINV({0}, {1}, {2}, {3})", 2, new FunctionParameter[]{new FunctionParameter("p", 2, "Value to examine."), new FunctionParameter("ndf", 2, "Value to examine."), new FunctionParameter("ddf", 2, "Value to examine."), new FunctionParameter("nc", 2, "Value to examine.")}, 0, "SasFunction.Long.FINV.txt"), new Function(2, "GAMINV", "GAMINV(p,a)", 2, "GAMINV({0}, {1})", "GAMINV({0}, {1})", 2, new FunctionParameter("p", 2, "Value to examine."), new FunctionParameter("a", 2, "Value to examine."), 0, "SasFunction.Long.GAMINV.txt"), new Function(2, "PROBIT", "PROBIT(p)", 2, "PROBIT({0})", "PROBIT({0})", 2, new FunctionParameter("p", 2, "Value to examine."), "SasFunction.Long.PROBIT.txt"), new Function(2, "TINV", "TINV(p,df<,nc>)", 2, "TINV({0}, {1}, {2})", "TINV({0}, {1}, {2})", 2, new FunctionParameter("p", 2, "Value to examine."), new FunctionParameter("df", 2, "Value to examine."), new FunctionParameter("nc", 2, "Value to examine."), 0, "SasFunction.Long.TINV.txt"), new Function(4, "BAND", "BAND(argument-1,argument-2)", 2, "BAND({0}, {1})", "BAND({0}, {1})", 2, new FunctionParameter("argument-1", 2, "Value to examine."), new FunctionParameter("argument-2", 2, "Value to examine."), 0, "SasFunction.Long.BAND.txt"), new Function(4, "BLSHIFT", "BLSHIFT(argument-1,argument-2)", 2, "BLSHIFT({0}, {1})", "BLSHIFT({0}, {1})", 2, new FunctionParameter("argument-1", 2, "Value to examine."), new FunctionParameter("argument-2", 2, "Value to examine."), 0, "SasFunction.Long.BLSHIFT.txt"), new Function(4, "BNOT", "BNOT(argument)", 2, "BNOT({0})", "BNOT({0})", 2, numArgParam, "SasFunction.Long.BNOT.txt"), new Function(4, "BOR", "BOR(argument-1,argument-2)", 2, "BOR({0}, {1})", "BOR({0}, {1})", 2, new FunctionParameter("argument-1", 2, "Value to examine."), new FunctionParameter("argument-2", 2, "Value to examine."), 0, "SasFunction.Long.BOR.txt"), new Function(4, "BRSHIFT", "BRSHIFT(argument-1,argument-2)", 2, "BRSHIFT({0}, {1})", "BRSHIFT({0}, {1})", 2, new FunctionParameter("argument-1", 2, "Value to examine."), new FunctionParameter("argument-2", 2, "Value to examine."), 0, "SasFunction.Long.BRSHIFT.txt"), new Function(4, "BXOR", "BXOR(argument-1,argument-2)", 2, "BXOR({0}, {1})", "BXOR({0}, {1})", 2, new FunctionParameter("argument-1", 2, "Value to examine."), new FunctionParameter("argument-2", 2, "Value to examine."), 0, "SasFunction.Long.BXOR.txt"), new Function(8, "CDF", "CDF('dist',quantile,parm-1,...,parm-k)", 2, "CDF({0}, {1}, {2})", "CDF({0}, {1}, {2})", 2, new FunctionParameter[]{new FunctionParameter("dist", 4, "Value to examine."), new FunctionParameter("quantile", 2, "Value to examine."), new FunctionParameter("parms", 2, "Value to examine.", false, true, 0, null)}, 0, "SasFunction.Long.CDF.txt"), new Function(8, "LOGPMF", "LOGPMF('dist',quantile,parm-1,...,parm-k)", 2, "LOGPMF({0}, {1}, {2})", "LOGPMF({0}, {1}, {2})", 2, new FunctionParameter[]{new FunctionParameter("'dist'", 4, "Value to examine."), new FunctionParameter("quantile", 2, "Value to examine."), new FunctionParameter("parms", 2, "Value to examine.", false, true, 0, null)}, 0, "SasFunction.Long.LOGPMF.txt"), new Function(8, "LOGPDF", "LOGPDF('dist',quantile,parm-1,...,parm-k)", 2, "LOGPDF({0}, {1}, {2})", "LOGPDF({0}, {1}, {2})", 2, new FunctionParameter[]{new FunctionParameter("'dist'", 4, "Value to examine."), new FunctionParameter("quantile", 2, "Value to examine."), new FunctionParameter("parms", 2, "Value to examine.", false, true, 0, null)}, 0, "SasFunction.Long.LOGPDF.txt"), new Function(8, "LOGSDF", "LOGSDF('dist',quantile,parm-1,...,parm-k)", 2, "LOGSDF({0}, {1}, {2})", "LOGSDF({0}, {1}, {2})", 2, new FunctionParameter[]{new FunctionParameter("'dist'", 4, "Value to examine."), new FunctionParameter("quantile", 2, "Value to examine."), new FunctionParameter("parms", 2, "Value to examine.", false, true, 0, null)}, 0, "SasFunction.Long.LOGSDF.txt"), new Function(8, "PDF", "PDF('dist',quantile,parm-1,...,parm-k)", 2, "PDF({0}, {1}, {2})", "PDF({0}, {1}, {2})", 2, new FunctionParameter[]{new FunctionParameter("'dist'", 4, "Value to examine."), new FunctionParameter("quantile", 2, "Value to examine."), new FunctionParameter("parms", 2, "Value to examine.", false, true, 0, null)}, 0, "SasFunction.Long.PDF.txt"), new Function(8, "PMF", "PMF('dist',quantile,parm-1,...,parm-k)", 2, "PMF({0}, {1}, {2})", "PMF({0}, {1}, {2})", 2, new FunctionParameter[]{new FunctionParameter("'dist'", 4, "Value to examine."), new FunctionParameter("quantile", 2, "Value to examine."), new FunctionParameter("parms", 2, "Value to examine.", false, true, 0, null)}, 0, "SasFunction.Long.PMF.txt"), new Function(8, "POISSON", "POISSON(m,n)", 2, "POISSON({0}, {1})", "POISSON({0}, {1})", 2, new FunctionParameter("m", 2, "Value to examine."), new FunctionParameter("n", 2, "Value to examine."), 0, "SasFunction.Long.POISSON.txt"), new Function(8, "PROBBETA", "PROBBETA(x,a,b)", 2, "PROBBETA({0}, {1}, {2})", "PROBBETA({0}, {1}, {2})", 2, new FunctionParameter("x", 2, "Value to examine."), new FunctionParameter("a", 2, "Value to examine."), new FunctionParameter("b", 2, "Value to examine."), 0, "SasFunction.Long.PROBBETA.txt"), new Function(8, "PROBBNML", "PROBBNML(p,n,m)", 2, "PROBBNML({0}, {1}, {2})", "PROBBNML({0}, {1}, {2})", 2, new FunctionParameter("p", 2, "Value to examine."), new FunctionParameter("n", 2, "Value to examine."), new FunctionParameter("m", 2, "Value to examine."), 0, "SasFunction.Long.PROBBNML.txt"), new Function(8, "PROBCHI", "PROBCHI(x,df<,nc>)", 2, "PROBCHI({0}, {1}, {2})", "PROBCHI({0}, {1}, {2})", 2, new FunctionParameter("x", 2, "Value to examine."), new FunctionParameter("df", 2, "Value to examine."), new FunctionParameter("nc", 2, "Value to examine."), 0, "SasFunction.Long.PROBCHI.txt"), new Function(8, "PROBF", "PROBF(x,ndf,ddf<,nc>)", 2, "PROBF({0}, {1}, {2}, {3})", "PROBF({0}, {1}, {2}, {3})", 2, new FunctionParameter[]{new FunctionParameter("x", 2, "Value to examine."), new FunctionParameter("ndf", 2, "Value to examine."), new FunctionParameter("ddf", 2, "Value to examine."), new FunctionParameter("nc", 2, "Value to examine.")}, 0, "SasFunction.Long.PROBF.txt"), new Function(8, "PROBGAM", "PROBGAM(x,a)", 2, "PROBGAM({0}, {1})", "PROBGAM({0}, {1})", 2, new FunctionParameter("x", 2, "Value to examine."), new FunctionParameter("a", 2, "Value to examine."), 0, "SasFunction.Long.PROBGAM.txt"), new Function(8, "PROBHYPR", "PROBHYPR(N,K,n,x<,r>)", 2, "PROBHYPR({0}, {1}, {2}, {3}, {4})", "PROBHYPR({0}, {1}, {2}, {3}, {4})", 2, new FunctionParameter[]{new FunctionParameter("N", 2, "Value to examine."), new FunctionParameter("K", 2, "Value to examine."), new FunctionParameter("n", 2, "Value to examine."), new FunctionParameter("x", 2, "Value to examine."), new FunctionParameter("r", 2, "Value to examine.")}, 0, "SasFunction.Long.PROBHYPR.txt"), new Function(8, "PROBNEGB", "PROBNEGB(p,n,m)", 2, "PROBNEGB({0}, {1}, {2})", "PROBNEGB({0}, {1}, {2})", 2, new FunctionParameter("p", 2, "Value to examine."), new FunctionParameter("n", 2, "Value to examine."), new FunctionParameter("m", 2, "Value to examine."), 0, "SasFunction.Long.PROBNEGB.txt"), new Function(8, "PROBBNRM", "PROBBNRM(x,y,r)", 2, "PROBBNRM({0}, {1}, {2})", "PROBBNRM({0}, {1}, {2})", 2, new FunctionParameter("x", 2, "Value to examine."), new FunctionParameter("y", 2, "Value to examine."), new FunctionParameter("r", 2, "Value to examine."), 0, "SasFunction.Long.PROBBNRM.txt"), new Function(8, "PROBNORM", "PROBNORM(x)", 2, "PROBNORM({0})", "PROBNORM({0})", 2, new FunctionParameter("x", 2, "Value to examine."), "SasFunction.Long.PROBNORM.txt"), new Function(8, "PROBT", "PROBT(x,df<,nc>)", 2, "PROBT({0}, {1}, {2})", "PROBT({0}, {1}, {2})", 2, new FunctionParameter("x", 2, "Value to examine."), new FunctionParameter("df", 2, "Value to examine."), new FunctionParameter("nc", 2, "Value to examine."), 0, "SasFunction.Long.PROBT.txt"), new Function(8, "SDF", "SDF('dist',quantile,parm-1,...,parm-k)", 2, "SDF({0}, {1}, {2})", "SDF({0}, {1}, {2})", 2, new FunctionParameter[]{new FunctionParameter("'dist'", 4, "Value to examine."), new FunctionParameter("quantile", 2, "Value to examine."), new FunctionParameter("parms", 2, "Value to examine.", false, true, 0, null)}, 0, "SasFunction.Long.SDF.txt"), new Function(16, "BYTE", "BYTE(n)", 2, "BYTE({0})", "BYTE({0})", 4, new FunctionParameter("n", 2, "Value to examine."), "SasFunction.Long.BYTE.txt"), new Function(16, "COLLATE", "COLLATE(start-position<,end-position>)", 2, "COLLATE({0}, {1})", "COLLATE({0}, {1})", 4, new FunctionParameter("start-position", 2, "Value to examine."), new FunctionParameter("end-position", 2, "Value to examine."), 0, "SasFunction.Long.COLLATE.txt"), new Function(16, "COMPBL", "COMPBL(source)", 2, "COMPBL({0})", "COMPBL({0})", 4, new FunctionParameter("source", 4, "Character value to examine."), "SasFunction.Long.COMPBL.txt"), new Function(16, "COMPRESS", "COMPRESS(source<,characters-to-remove>)", 2, "COMPRESS({0}, {1})", "COMPRESS({0}, {1})", 4, new FunctionParameter("source", 4, "Character value to examine."), new FunctionParameter("characters-to-remove", 4, "Character value to remove."), 0, "SasFunction.Long.COMPRESS.txt"), new Function(16, "DEQUOTE", "DEQUOTE(argument)", 2, "DEQUOTE({0})", "DEQUOTE({0})", 4, new FunctionParameter("argument", 4, "Character value to examine."), "SasFunction.Long.DEQUOTE.txt"), new Function(16, "INDEX", "INDEX(source,excerpt)", 2, "INDEX({0}, {1})", "INDEX({0}, {1})", 2, new FunctionParameter("source", 4, "Character value to examine."), new FunctionParameter("excerpt", 4, "Character value to find."), 0, "SasFunction.Long.INDEX.txt"), new Function(16, "INDEXC", "INDEXC(source,excerpt-1<, ... excerpt-n>)", 2, "INDEXC({0}, {1})", "INDEXC({0}, {1})", 2, new FunctionParameter("source", 4, "Character value to examine."), new FunctionParameter("excerpt-1<, ... excerpt-n>", 4, "Character value(s) to find.", false, true, 0, null), 0, "SasFunction.Long.INDEXC.txt"), new Function(16, "INDEXW", "INDEXW(source,excerpt)", 2, "INDEXW({0}, {1})", "INDEXW({0}, {1})", 2, new FunctionParameter("source", 4, "Character value to examine."), new FunctionParameter("excerpt", 4, "Character value to find."), 0, "SasFunction.Long.INDEXW.txt"), new Function(16, "LEFT", "LEFT(argument)", 2, "LEFT({0})", "LEFT({0})", 4, new FunctionParameter("argument", 4, "Character value to examine."), "SasFunction.Long.LEFT.txt"), new Function(16, "LENGTH", "LENGTH(argument)", 2, "LENGTH({0})", "LENGTH({0})", 2, new FunctionParameter("argument", 4, "Character value to examine."), "SasFunction.Long.LENGTH.txt"), new Function(16, "LOWCASE", "LOWCASE(argument)", 2, "LOWCASE({0})", "LOWCASE({0})", 4, new FunctionParameter("argument", 4, "Character value to examine."), "SasFunction.Long.LOWCASE.txt"), new Function(16, "QUOTE", "QUOTE(argument)", 2, "QUOTE({0})", "QUOTE({0})", 4, new FunctionParameter("argument", 4, "Character value to examine."), "SasFunction.Long.QUOTE.txt"), new Function(16, "RANK", "RANK(x)", 2, "RANK({0})", "RANK({0})", 2, new FunctionParameter("x", 4, "Single character value to examine."), "SasFunction.Long.RANK.txt"), new Function(16, "REPEAT", "REPEAT(argument,n)", 2, "REPEAT({0}, {1})", "REPEAT({0}, {1})", 4, new FunctionParameter("argument", 4, "Character value to examine."), new FunctionParameter("n", 2, "Number of times to repeat character."), 0, "SasFunction.Long.REPEAT.txt"), new Function(16, "REVERSE", "REVERSE(argument)", 2, "REVERSE({0})", "REVERSE({0})", 4, new FunctionParameter("argument", 4, "Character value to examine."), "SasFunction.Long.REVERSE.txt"), new Function(16, "RIGHT", "RIGHT(argument)", 2, "RIGHT({0})", "RIGHT({0})", 4, new FunctionParameter("argument", 4, "Character value to examine."), "SasFunction.Long.RIGHT.txt"), new Function(16, "SCAN", "SCAN(argument,n<,delimiters>)", 2, "SCAN({0}, {1}, {2})", "SCAN({0}, {1}, {2})", 4, new FunctionParameter("argument", 4, "Character value to examine."), new FunctionParameter("n", 2, "Value to examine."), new FunctionParameter("delimiters", 4, "Value to examine."), 0, "SasFunction.Long.SCAN.txt"), new Function(16, "SOUNDEX", "SOUNDEX(argument)", 2, "SOUNDEX({0})", "SOUNDEX({0})", 4, new FunctionParameter("argument", 4, "Character value to examine."), "SasFunction.Long.SOUNDEX.txt"), new Function(16, "SUBSTR", "SUBSTR(argument,position<,n>)=characters-to-replace", 2, "SUBSTR({0}, {1}, {2})", "SUBSTR({0}, {1}, {2})", 4, new FunctionParameter("argument", 4, "Character value to examine."), new FunctionParameter("position", 2, "Value to examine."), new FunctionParameter("n", 2, "Value to examine."), 0, "SasFunction.Long.SUBSTR.txt"), new Function(16, "SUBSTR", "SUBSTR(argument,position<,n>)", 2, "SUBSTR({0}, {1}, {2})", "SUBSTR({0}, {1}, {2})", 4, new FunctionParameter("argument", 4, "Character value to examine."), new FunctionParameter("position", 2, "Starting offset within argument."), new FunctionParameter("n", 2, "Length of substring."), 0, "SasFunction.Long.EXTRACTSUBSTR.txt"), new Function(16, "TRANSLATE", "TRANSLATE(source,to-1,from-1<,...to-n,from-n>)", 2, "TRANSLATE({0}, {1}, {2})", "TRANSLATE({0}, {1}, {2})", 4, new FunctionParameter[]{new FunctionParameter("source", 4, "Value to examine."), new FunctionParameter("to-1", 4, "Value to examine."), new FunctionParameter("from-1<,...to-n,from-n>", 4, "Value to examine.", false, true, 0, null)}, 0, "SasFunction.Long.TRANSLATE.txt"), new Function(16, "TRANWRD", "TRANWRD(source,target,replacement)", 2, "TRANWRD({0}, {1}, {2})", "TRANWRD({0}, {1}, {2})", 4, new FunctionParameter("source", 4, "Character value to examine."), new FunctionParameter("target", 4, "Character value to remove."), new FunctionParameter("replacement", 4, "Replacement string."), 0, "SasFunction.Long.TRANWRD.txt"), new Function(16, "TRIM", "TRIM(argument)", 2, "TRIM({0})", "TRIM({0})", 4, new FunctionParameter("argument", 4, "Character value to examine."), "SasFunction.Long.TRIM.txt"), new Function(16, "TRIMN", "TRIMN(argument)", 2, "TRIMN({0})", "TRIMN({0})", 4, new FunctionParameter("argument", 4, "Character value to examine."), "SasFunction.Long.TRIMN.txt"), new Function(16, "UPCASE", "UPCASE(argument)", 2, "UPCASE({0})", "UPCASE({0})", 4, new FunctionParameter("argument", 4, "Character value to trim."), "SasFunction.Long.UPCASE.txt"), new Function(16, "VERIFY", "VERIFY(source,excerpt-1<,...excerpt-n)", 2, "VERIFY({0}, {1})", "VERIFY({0}, {1})", 2, new FunctionParameter("source", 4, "Value to examine."), new FunctionParameter("excerpt-1<, ... excerpt-n>", 4, "Character value(s) to find.", false, true, 0, null), 0, "SasFunction.Long.VERIFY.txt"), new Function(32, "RXMATCH", "RXMATCH(rx, string)", 2, "RXMATCH({0}, {1})", "RXMATCH({0}, {1})", 2, new FunctionParameter("rx", 2, "Value to examine."), new FunctionParameter("string", 4, "Value to examine."), 0, "SasFunction.Long.RXMATCH.txt"), new Function(32, "RXPARSE", "RXPARSE(pattern-expression)", 2, "RXPARSE({0})", "RXPARSE({0})", 2, new FunctionParameter("pattern-expression", 4, "Character value to examine."), "SasFunction.Long.RXPARSE.txt"), new Function(64, "NORMAL", "NORMAL(seed)", 2, "NORMAL({0})", "NORMAL({0})", 2, numSeedParam, "SasFunction.Long.NORMAL.txt"), new Function(64, "RANBIN", "RANBIN(seed,n,p)", 2, "RANBIN({0}, {1}, {2})", "RANBIN({0}, {1}, {2})", 2, numSeedParam, new FunctionParameter("n", 2, "Numeric probability of success."), new FunctionParameter("p", 2, "Integer number of independent Bernoulli trials."), 0, "SasFunction.Long.RANBIN.txt"), new Function(64, "RANCAU", "RANCAU(seed)", 2, "RANCAU({0})", "RANCAU({0})", 2, numSeedParam, "SasFunction.Long.RANCAU.txt"), new Function(64, "RANEXP", "RANEXP(seed)", 2, "RANEXP({0})", "RANEXP({0})", 2, numSeedParam, "SasFunction.Long.RANEXP.txt"), new Function(64, "RANGAM", "RANGAM(seed,a)", 2, "RANGAM({0}, {1})", "RANGAM({0}, {1})", 2, numSeedParam, new FunctionParameter("a", 2, "Numeric shape parameter."), 0, "SasFunction.Long.RANGAM.txt"), new Function(64, "RANNOR", "RANNOR(seed)", 2, "RANNOR({0})", "RANNOR({0})", 2, numSeedParam, "SasFunction.Long.RANNOR.txt"), new Function(64, "RANPOI", "RANPOI(seed,m)", 2, "RANPOI({0}, {1})", "RANPOI({0}, {1})", 2, numSeedParam, new FunctionParameter("m", 2, "Numeric mean value."), 0, "SasFunction.Long.RANPOI.txt"), new Function(64, "RANTBL", "RANTBL(seed,p1,..pi,..pn)", 2, "RANTBL({0}, {1})", "RANTBL({0}, {1})", 2, numSeedParam, new FunctionParameter("p1,..pi,..pn", 2, "Numeric value between 0 and 1.", false, true, 0, null), 0, "SasFunction.Long.RANTBL.txt"), new Function(64, "RANTRI", "RANTRI(seed,h)", 2, "RANTRI({0}, {1})", "RANTRI({0}, {1})", 2, numSeedParam, new FunctionParameter("h", 2, "Numeric value between 0 and 1."), 0, "SasFunction.Long.RANTRI.txt"), new Function(64, "RANUNI", "RANUNI(seed)", 2, "RANUNI({0})", "RANUNI({0})", 2, numSeedParam, "SasFunction.Long.RANUNI.txt"), new Function(64, "UNIFORM", "UNIFORM(seed)", 2, "UNIFORM({0})", "UNIFORM({0})", 2, numSeedParam, "SasFunction.Long.UNIFORM.txt"), new Function(256, "CSS", "CSS(argument,argument,...)", 2, "CSS({0}, {1})", "CSS({0}, {1})", 2, numArgParam, numArgCommaListParam, 0, "SasFunction.Long.CSS.txt"), new Function(256, "CV", "CV(argument,argument,...)", 2, "CV({0}, {1})", "CV({0}, {1})", 2, numArgParam, numArgCommaListParam, 0, "SasFunction.Long.CV.txt"), new Function(256, "KURTOSIS", "KURTOSIS(argument,argument,...)", 2, "KURTOSIS({0}, {1}, {2}, {3})", "KURTOSIS({0}, {1}, {2}, {3})", 2, new FunctionParameter[]{numArgParam, numArgParam, numArgParam, numArgCommaListParam}, 0, "SasFunction.Long.KURTOSIS.txt"), new Function(256, "MAX", "MAX(argument,argument, ...)", 2, "MAX({0}, {1})", "MAX({0}, {1})", 2, numArgParam, numArgCommaListParam, 0, "SasFunction.Long.STATMAX.txt"), new Function(256, "MIN", "MIN(argument,argument, ...)", 2, "MIN({0}, {1})", "MIN({0}, {1})", 2, numArgParam, numArgCommaListParam, 0, "SasFunction.Long.STATMIN.txt"), new Function(256, "MEAN", "MEAN(argument,argument, ...)", 2, "MEAN({0}, {1})", "MEAN({0}, {1})", 2, numArgParam, numArgCommaListParam, 0, "SasFunction.Long.STATMEAN.txt"), new Function(256, "N", "N(argument,argument, ....)", 2, "N({0}, {1})", "N({0}, {1})", 2, numArgParam, numArgCommaListParam, 0, "SasFunction.Long.STATN.txt"), new Function(256, "NMISS", "NMISS(argument,argument, ...)", 2, "NMISS({0}, {1})", "NMISS({0}, {1})", 2, numArgParam, numArgCommaListParam, 0, "SasFunction.Long.STATNMISS.txt"), new Function(256, "ORDINAL", "ORDINAL(count,argument,argument,...)", 2, "ORDINAL({0}, {1}, {2})", "ORDINAL({0}, {1}, {2})", 2, new FunctionParameter[]{new FunctionParameter("count", 2, "Integer less than the number of elements in the list of aurguments."), numArgParam, numArgCommaListParam}, 0, "SasFunction.Long.STATORDINAL.txt"), new Function(256, "RANGE", "RANGE(argument,argument,...)", 2, "RANGE({0}, {1})", "RANGE({0}, {1})", 2, numArgParam, numArgCommaListParam, 0, "SasFunction.Long.STATRANGE.txt"), new Function(256, "SKEWNESS", "SKEWNESS(argument,argument,argument,...)", 2, "SKEWNESS({0}, {1}, {2})", "SKEWNESS({0}, {1}, {2})", 2, new FunctionParameter[]{numArgParam, numArgParam, numArgCommaListParam}, 0, "SasFunction.Long.STATSKEWNESS.txt"), new Function(256, "STD", "STD(argument,argument,...)", 2, "STD({0}, {1})", "STD({0}, {1})", 2, numArgParam, numArgCommaListParam, 0, "SasFunction.Long.STATSTD.txt"), new Function(256, "STDERR", "STDERR(argument,argument,...)", 2, "STDERR({0}, {1})", "STDERR({0}, {1})", 2, numArgParam, numArgCommaListParam, 0, "SasFunction.Long.STATSTDERR.txt"), new Function(256, "SUM", "SUM(argument,argument,...)", 2, "SUM({0}, {1})", "SUM({0}, {1})", 2, numArgParam, numArgCommaListParam, 0, "SasFunction.Long.STATSUM.txt"), new Function(256, "USS", "USS(argument,argument,...)", 2, "USS({0}, {1})", "USS({0}, {1})", 2, numArgParam, numArgCommaListParam, 0, "SasFunction.Long.STATUSS.txt"), new Function(256, "VAR", "VAR(argument,argument,...)", 2, "VAR({0}, {1})", "VAR({0}, {1})", 2, numArgParam, numArgCommaListParam, 0, "SasFunction.Long.STATVAR.txt"), new Function(512, "DATDIF", "DATDIF(sdate,edate,basis)", 2, "DATDIF({0}, {1}, {2})", "DATDIF({0}, {1}, {2})", 2, new FunctionParameter("sdate", 16, "Value to examine."), new FunctionParameter("edate", 16, "Value to examine."), new FunctionParameter("basis", 4, "Value to examine."), 0, "SasFunction.Long.DATDIF.txt"), new Function(512, "DATE", "DATE()", 2, "DATE()", "DATE()", 16, "SasFunction.Long.DATE.txt"), new Function(512, "DATEJUL", "DATEJUL(julian-date)", 2, "DATEJUL({0})", "DATEJUL({0})", 16, new FunctionParameter("julian-date", 2, "Numeric expression representing a Julian date."), "SasFunction.Long.DATEJUL.txt"), new Function(512, "DATEPART", "DATEPART(datetime)", 2, "DATEPART({0})", "DATEPART({0})", 16, new FunctionParameter("datetime", 64, "SAS expression representing a SAS datetime value."), "SasFunction.Long.DATEPART.txt"), new Function(512, "DATETIME", "DATETIME()", 2, "DATETIME()", "DATETIME()", 64, "SasFunction.Long.DATETIME.txt"), new Function(512, "DAY", "DAY(date)", 2, "DAY({0})", "DAY({0})", 2, new FunctionParameter("date", 16, "SAS expression representing a SAS date value."), "SasFunction.Long.DAY.txt"), new Function(512, "DHMS", "DHMS(date,hour,minute,second)", 2, "DHMS({0}, {1}, {2}, {3})", "DHMS({0}, {1}, {2}, {3})", 64, new FunctionParameter[]{new FunctionParameter("date", 16, "SAS expression representing a SAS date value."), new FunctionParameter("hour", 2, "Integer from 0 to 23."), new FunctionParameter("minute", 2, "Integer from 0 to 59."), new FunctionParameter("second", 2, "Integer from 0 to 59.")}, 0, "SasFunction.Long.DHMS.txt"), new Function(512, "HMS", "HMS(hour,minute,second)", 2, "HMS({0}, {1}, {2})", "HMS({0}, {1}, {2})", 32, new FunctionParameter("hour", 2, "Integer from 0 to 23."), new FunctionParameter("minute", 2, "Integer from 0 to 59."), new FunctionParameter("second", 2, "Integer from 0 to 59."), 0, "SasFunction.Long.HMS.txt"), new Function(512, "HOUR", "HOUR(<time | datetime>)", 2, "HOUR({0})", "HOUR({0})", 2, new FunctionParameter("time | datetime", 80, "Value to examine."), "SasFunction.Long.HOUR.txt"), new Function(512, "INTCK", "INTCK('interval',from,to)", 2, "INTCK({0}, {1}, {2})", "INTCK({0}, {1}, {2})", 2, new FunctionParameter("'interval'", 4, "Character constant describing the interval."), new FunctionParameter("from", 112, "Beginning of specified time span."), new FunctionParameter("to", 112, "End of specified time span."), 0, "SasFunction.Long.INTCK.txt"), new Function(512, "INTNX", "INTNX('interval',start-from,increment<,'alignment'>)", 2, "INTNX({0}, {1}, {2}, {3})", "INTNX({0}, {1}, {2}, {3})", 2, new FunctionParameter[]{new FunctionParameter("'interval'", 4, "Character constant describing the interval."), new FunctionParameter("start-from", 112, "Identifies the starting point."), new FunctionParameter("increment", 2, "Number of time intervals."), new FunctionParameter("'alignment'", 4, "Value to examine.")}, 0, "SasFunction.Long.INTNX.txt"), new Function(512, "JULDATE", "JULDATE(date)", 2, "JULDATE({0})", "JULDATE({0})", 2, new FunctionParameter("date", 16, "SAS expression representing a SAS date value."), "SasFunction.Long.JULDATE.txt"), new Function(512, "MDY", "MDY(month,day,year)", 2, "MDY({0}, {1}, {2})", "MDY({0}, {1}, {2})", 16, new FunctionParameter("month", 2, "Integer between 1 and 12."), new FunctionParameter("day", 2, "Integer between 1 and 31."), new FunctionParameter("year", 2, "Integer identifying a specific year."), 0, "SasFunction.Long.MDY.txt"), new Function(512, "MINUTE", "MINUTE(time | datetime)", 2, "MINUTE({0})", "MINUTE({0})", 2, new FunctionParameter("time | datetime", 96, "SAS expression representing a SAS time or datetime value."), "SasFunction.Long.MINUTE.txt"), new Function(512, "MONTH", "MONTH(date)", 2, "MONTH({0})", "MONTH({0})", 2, new FunctionParameter("date", 16, "SAS expression representing a SAS date value."), "SasFunction.Long.MONTH.txt"), new Function(512, "QTR", "QTR(date)", 2, "QTR({0})", "QTR({0})", 2, new FunctionParameter("date", 16, "SAS expression representing a SAS date value."), "SasFunction.Long.QTR.txt"), new Function(512, "SECOND", "SECOND(time | datetime)", 2, "SECOND({0})", "SECOND({0})", 2, new FunctionParameter("time | datetime", 96, "SAS expression representing a SAS time or datetime value."), "SasFunction.Long.SECOND.txt"), new Function(512, "TIME", "TIME()", 2, "TIME()", "TIME()", 32, "SasFunction.Long.TIME.txt"), new Function(512, "TIMEPART", "TIMEPART(datetime)", 2, "TIMEPART({0})", "TIMEPART({0})", 32, new FunctionParameter("datetime", 64, "SAS expression representing a SAS datetime value."), "SasFunction.Long.TIMEPART.txt"), new Function(512, "TODAY", "TODAY()", 2, "TODAY()", "TODAY()", 16, "SasFunction.Long.TODAY.txt"), new Function(512, "WEEKDAY", "WEEKDAY(date)", 2, "WEEKDAY({0})", "WEEKDAY({0})", 2, new FunctionParameter("date", 16, "SAS expression representing a SAS date value."), "SasFunction.Long.WEEKDAY.txt"), new Function(512, "YEAR", "YEAR(date)", 2, "YEAR({0})", "YEAR({0})", 2, new FunctionParameter("date", 16, "SAS expression representing a SAS date value."), "SasFunction.Long.YEAR.txt"), new Function(512, "YRDIF", "YRDIF(sdate,edate,basis)", 2, "YRDIF({0}, {1}, {2})", "YRDIF({0}, {1}, {2})", 2, new FunctionParameter("sdate", 16, "Value to examine."), new FunctionParameter("edate", 16, "Value to examine."), new FunctionParameter("basis", 4, "Value to examine."), 0, "SasFunction.Long.YRDIF.txt"), new Function(512, "YYQ", "YYQ(year,quarter)", 2, "YYQ({0}, {1})", "YYQ({0}, {1})", 16, new FunctionParameter("year", 2, "Integer identifying a specific year."), new FunctionParameter("quarter", 2, "Integer between 1 and 4, identifying a specific quarter."), 0, "SasFunction.Long.YYQ.txt"), new Function(2048, "PUT", "PUT(source,format.)", 2, "PUT({0}, {1})", "PUT({0}, {1})", 2, new FunctionParameter("source", 2, "Numeric variable or constant to format."), new FunctionParameter("format.", 0, "SAS format to be applied to the variable."), 0, "SasFunction.Long.PUTNUMERIC.txt"), new Function(2048, "PUT", "PUT(source,format.)", 2, "PUT({0}, {1})", "PUT({0}, {1})", 4, new FunctionParameter("source", 4, "Character variable or constant to format."), new FunctionParameter("format.", 0, "SAS format to be applied to the variable."), 0, "SasFunction.Long.PUTCHAR.txt"), new Function(2048, "PUTC", "PUTC(source,format.)", 2, "PUTC({0}, {1})", "PUTC({0}, {1})", 4, new FunctionParameter("source", 4, "Character variable or constant to format."), new FunctionParameter("format.", 4, "SAS format to be applied to the variable."), 0, "SasFunction.Long.PUTC.txt"), new Function(2048, "PUTN", "PUTN(source,format.)", 2, "PUTN({0}, {1})", "PUTN({0}, {1})", 2, new FunctionParameter("source", 2, "Numeric variable or constant to format."), new FunctionParameter("format.", 4, "SAS format to be applied to the variable."), 0, "SasFunction.Long.PUTN.txt"), new Function(2048, "RESOLVE", "RESOLVE(argument)", 2, "RESOLVE({0})", "RESOLVE({0})", 2, new FunctionParameter("argument", 0, "Value to examine."), "SasFunction.Long.RESOLVE.txt"), new Function(2048, "SPEDIS", "SPEDIS(query,keyword)", 2, "SPEDIS({0}, {1})", "SPEDIS({0}, {1})", 2, new FunctionParameter("query", 4, "Value to examine."), new FunctionParameter("keyword", 4, "Value to examine."), 0, "SasFunction.Long.SPEDIS.txt"), new Function(2048, "SYMGET", "SYMGET(argument)", 2, "SYMGET({0})", "SYMGET({0})", 2, new FunctionParameter("argument", 0, "Value to examine."), "SasFunction.Long.SYMGET.txt"), new Function(2048, "SYSGET", "SYSGET(environment-variable)", 2, "SYSGET({0})", "SYSGET({0})", 4, new FunctionParameter("environment-variable", 0, "Value to examine."), "SasFunction.Long.SYSGET.txt"), new Function(2048, "SYSMSG", "SYSMSG()", 2, "SYSMSG()", "SYSMSG()", 4, "SasFunction.Long.SYSMSG.txt"), new Function(2048, "SYSPARM", "SYSPARM()", 2, "SYSPARM()", "SYSPARM()", 4, "SasFunction.Long.SYSPARM.txt"), new Function(2048, "SYSPROD", "SYSPROD(product-name)", 2, "SYSPROD({0})", "SYSPROD({0})", 2, new FunctionParameter("product-name", 0, "Code for a SAS product."), "SasFunction.Long.SYSPROD.txt"), new Function(2048, "SYSRC", "SYSRC()", 2, "SYSRC()", "SYSRC()", 2, "SasFunction.Long.SYSRC.txt"), new Function(4096, "PATHNAME", "PATHNAME(fileref | libref)", 2, "PATHNAME({0})", "PATHNAME({0})", 4, new FunctionParameter("fileref | libref", 0, "Reference to file or SAS data library."), "SasFunction.Long.PATHNAME.txt"), new Function(8192, "FIPNAME", "FIPNAME(expression)", 2, "FIPNAME({0})", "FIPNAME({0})", 4, fipsExpressionParam, "SasFunction.Long.FIPNAME.txt"), new Function(8192, "FIPNAMEL", "FIPNAMEL(expression)", 2, "FIPNAMEL({0})", "FIPNAMEL({0})", 4, fipsExpressionParam, "SasFunction.Long.FIPNAMEL.txt"), new Function(8192, "FIPSTATE", "FIPSTATE(expression)", 2, "FIPSTATE({0})", "FIPSTATE({0})", 4, fipsExpressionParam, "SasFunction.Long.FIPSTATE.txt"), new Function(8192, "STFIPS", "STFIPS(postal-code)", 2, "STFIPS({0})", "STFIPS({0})", 4, statePostalParam, "SasFunction.Long.STFIPS.txt"), new Function(8192, "STNAME", "STNAME(postal-code)", 2, "STNAME({0})", "STNAME({0})", 4, statePostalParam, "SasFunction.Long.STNAME.txt"), new Function(8192, "STNAMEL", "STNAMEL(postal-code)", 2, "STNAMEL({0})", "STNAMEL({0})", 4, statePostalParam, "SasFunction.Long.STNAMEL.txt"), new Function(8192, "ZIPFIPS", "ZIPFIPS(zip-code)", 2, "ZIPFIPS({0})", "ZIPFIPS({0})", 4, zipParam, "SasFunction.Long.ZIPFIPS.txt"), new Function(8192, "ZIPNAME", "ZIPNAME(zip-code)", 2, "ZIPNAME({0})", "ZIPNAME({0})", 4, zipParam, "SasFunction.Long.ZIPNAME.txt"), new Function(8192, "ZIPNAMEL", "ZIPNAMEL(zip-code)", 2, "ZIPNAMEL({0})", "ZIPNAMEL({0})", 4, zipParam, "SasFunction.Long.ZIPNAMEL.txt"), new Function(8192, "ZIPSTATE", "ZIPSTATE(zip-code)", 2, "ZIPSTATE({0})", "ZIPSTATE({0})", 4, zipParam, "SasFunction.Long.ZIPSTATE.txt"), new Function(16384, "COMPOUND", "COMPOUND(amount,future,rate,number)", 2, "COMPOUND({0}, {1}, {2}, {3})", "COMPOUND({0}, {1}, {2}, {3})", 2, new FunctionParameter[]{new FunctionParameter("amount", 2, "Value to examine."), new FunctionParameter("future", 2, "Value to examine."), rateParam, new FunctionParameter("number", 2, "Value to examine.")}, 0, "SasFunction.Long.COMPOUND.txt"), new Function(16384, "CONVX", "CONVX(y,f,c(1),...,C(k))", 2, "CONVX({0}, {1}, {2})", "CONVX({0}, {1}, {2})", 2, new FunctionParameter[]{new FunctionParameter("y", 2, "Value to examine."), new FunctionParameter("f", 2, "Value to examine."), new FunctionParameter("c(1),...,C(k)", 2, "Value to examine.", false, true, 0, null)}, 0, "SasFunction.Long.CONVX.txt"), new Function(16384, "CONVXP", "CONVXP(A,C,n,K,k0,y)", 2, "CONVXP({0}, {1}, {2}, {3}, {4}, {5})", "CONVXP({0}, {1}, {2}, {3}, {4}, {5})", 2, new FunctionParameter[]{new FunctionParameter("A", 2, "Value to examine."), new FunctionParameter("C", 2, "Value to examine."), new FunctionParameter("n", 2, "Value to examine."), new FunctionParameter("K", 2, "Value to examine."), new FunctionParameter("k0", 2, "Value to examine."), new FunctionParameter("y", 2, "Value to examine.")}, 0, "SasFunction.Long.CONVXP.txt"), new Function(16384, "DACCDB", "DACCDB(period,value,years,rate)", 2, "DACCDB({0}, {1}, {2}, {3})", "DACCDB({0}, {1}, {2}, {3})", 2, new FunctionParameter[]{periodParam, accValueParam, yearsParam, rateParam}, 0, "SasFunction.Long.DACCDB.txt"), new Function(16384, "DACCDBSL", "DACCDBSL(period,value,years,rate)", 2, "DACCDBSL({0}, {1}, {2}, {3})", "DACCDBSL({0}, {1}, {2}, {3})", 2, new FunctionParameter[]{periodParam, accValueParam, yearsParam, rateParam}, 0, "SasFunction.Long.DACCDBSL.txt"), new Function(16384, "DACCSL", "DACCSL(period,value,years)", 2, "DACCSL({0}, {1}, {2})", "DACCSL({0}, {1}, {2})", 2, periodParam, accValueParam, yearsParam, 0, "SasFunction.Long.DACCSL.txt"), new Function(16384, "DACCSYD", "DACCSYD(period,value,years)", 2, "DACCSYD({0}, {1}, {2})", "DACCSYD({0}, {1}, {2})", 2, periodParam, accValueParam, yearsParam, 0, "SasFunction.Long.DACCSYD.txt"), new Function(16384, "DACCTAB", "DACCTAB(period,value,t1,...tn)", 2, "DACCTAB({0}, {1}, {2})", "DACCTAB({0}, {1}, {2})", 2, new FunctionParameter[]{periodParam, accValueParam, new FunctionParameter("t1,...tn", 2, "Value to examine.", false, true, 0, null)}, 0, "SasFunction.Long.DACCTAB.txt"), new Function(16384, "DEPDB", "DEPDB(period,value,years,rate)", 2, "DEPDB({0}, {1}, {2}, {3})", "DEPDB({0}, {1}, {2}, {3})", 2, new FunctionParameter[]{periodParam, accValueParam, yearsParam, rateParam}, 0, "SasFunction.Long.DEPDB.txt"), new Function(16384, "DEPDBSL", "DEPDBSL(period,value,years,rate)", 2, "DEPDBSL({0}, {1}, {2}, {3})", "DEPDBSL({0}, {1}, {2}, {3})", 2, new FunctionParameter[]{periodParam, accValueParam, yearsParam, rateParam}, 0, "SasFunction.Long.DEPDBSL.txt"), new Function(16384, "DEPSL", "DEPSL(period,value,years)", 2, "DEPSL({0}, {1}, {2})", "DEPSL({0}, {1}, {2})", 2, periodParam, accValueParam, yearsParam, 0, "SasFunction.Long.DEPSL.txt"), new Function(16384, "DEPSYD", "DEPSYD(period,value,years)", 2, "DEPSYD({0}, {1}, {2})", "DEPSYD({0}, {1}, {2})", 2, periodParam, accValueParam, yearsParam, 0, "SasFunction.Long.DEPSYD.txt"), new Function(16384, "DEPTAB", "DEPTAB(period,value,t1,...,tn)", 2, "DEPTAB({0}, {1}, {2})", "DEPTAB({0}, {1}, {2})", 2, new FunctionParameter[]{periodParam, accValueParam, new FunctionParameter("t1,...tn", 2, "Value to examine.", false, true, 0, null)}, 0, "SasFunction.Long.DEPTAB.txt"), new Function(16384, "DUR", "DUR(y,f,c(1),...c(k))", 2, "DUR({0}, {1}, {2})", "DUR({0}, {1}, {2})", 2, new FunctionParameter[]{new FunctionParameter("y", 2, "Value to examine."), new FunctionParameter("f", 2, "Value to examine."), new FunctionParameter("c(1),...c(k)", 2, "Value to examine.", false, true, 0, null)}, 0, "SasFunction.Long.DUR.txt"), new Function(16384, "DURP", "DURP(A,c,n,K,k0,y)", 2, "DURP({0}, {1}, {2}, {3}, {4}, {5})", "DURP({0}, {1}, {2}, {3}, {4}, {5})", 2, new FunctionParameter[]{new FunctionParameter("A", 2, "Value to examine."), new FunctionParameter("c", 2, "Value to examine."), new FunctionParameter("n", 2, "Value to examine."), new FunctionParameter("K", 2, "Value to examine."), new FunctionParameter("k0", 2, "Value to examine."), new FunctionParameter("y", 2, "Value to examine.")}, 0, "SasFunction.Long.DURP.txt"), new Function(16384, "INTRR", "INTRR(frequency,c0,c1,...,cn)", 2, "INTRR({0}, {1}, {2})", "INTRR({0}, {1}, {2})", 2, new FunctionParameter[]{new FunctionParameter("frequency", 2, "Value to examine."), new FunctionParameter("c0", 2, "Value to examine."), new FunctionParameter("c1,...cn", 2, "Value to examine.", false, true, 0, null)}, 0, "SasFunction.Long.INTRR.txt"), new Function(16384, "IRR", "IRR(frequency,c0,c1,...,cn)", 2, "IRR({0}, {1}, {2})", "IRR({0}, {1}, {2})", 2, new FunctionParameter[]{new FunctionParameter("frequency", 2, "Value to examine."), new FunctionParameter("c0", 2, "Value to examine."), new FunctionParameter("c1,...cn", 2, "Value to examine.", false, true, 0, null)}, 0, "SasFunction.Long.IRR.txt"), new Function(16384, "MORT", "MORT(amount,payment,rate,number)", 2, "MORT({0}, {1}, {2}, {3})", "MORT({0}, {1}, {2}, {3})", 2, new FunctionParameter[]{new FunctionParameter("amount", 2, "Value to examine."), new FunctionParameter("payment", 2, "Value to examine."), rateParam, new FunctionParameter("number", 2, "Value to examine.")}, 0, "SasFunction.Long.MORT.txt"), new Function(16384, "NETPV", "NETPV(rate,frequency,c0,c1,...,cn)", 2, "NETPV({0}, {1}, {2}, {3})", "NETPV({0}, {1}, {2}, {3})", 2, new FunctionParameter[]{rateParam, new FunctionParameter("frequency", 2, "Value to examine."), new FunctionParameter("c0", 2, "Value to examine."), new FunctionParameter("c1,...cn", 2, "Value to examine.", false, true, 0, null)}, 0, "SasFunction.Long.NETPV.txt"), new Function(16384, "NPV", "NPV(rate,frequency,c0,c1,...,cn)", 2, "NPV({0}, {1}, {2}, {3})", "NPV({0}, {1}, {2}, {3})", 2, new FunctionParameter[]{rateParam, new FunctionParameter("frequency", 2, "Value to examine."), new FunctionParameter("c0", 2, "Value to examine."), new FunctionParameter("c1", 2, "Value to examine."), new FunctionParameter("cn", 2, "Value to examine.", false, true, 0, null)}, 0, "SasFunction.Long.NPV.txt"), new Function(16384, "PVP", "PVP(A,c,n,K,k0,y)", 2, "PVP({0}, {1}, {2}, {3}, {4}, {5})", "PVP({0}, {1}, {2}, {3}, {4}, {5})", 2, new FunctionParameter[]{new FunctionParameter("A", 2, "Value to examine."), new FunctionParameter("c", 2, "Value to examine."), new FunctionParameter("n", 2, "Value to examine."), new FunctionParameter("K", 2, "Value to examine."), new FunctionParameter("k0", 2, "Value to examine."), new FunctionParameter("y", 2, "Value to examine.")}, 0, "SasFunction.Long.PVP.txt"), new Function(16384, "SAVING", "SAVING(future,payment,rate,number)", 2, "SAVING({0}, {1}, {2}, {3})", "SAVING({0}, {1}, {2}, {3})", 2, new FunctionParameter[]{new FunctionParameter("future", 2, "Value to examine."), new FunctionParameter("payment", 2, "Value to examine."), new FunctionParameter("rate", 2, "Value to examine."), new FunctionParameter("number", 2, "Value to examine.")}, 0, "SasFunction.Long.SAVING.txt"), new Function(16384, "YIELDP", "YIELDP(A,c,n,K,k0,p)", 2, "YIELDP({0}, {1}, {2}, {3}, {4}, {5})", "YIELDP({0}, {1}, {2}, {3}, {4}, {5})", 2, new FunctionParameter[]{new FunctionParameter("A", 2, "Value to examine."), new FunctionParameter("c", 2, "Value to examine."), new FunctionParameter("n", 2, "Value to examine."), new FunctionParameter("K", 2, "Value to examine."), new FunctionParameter("k0", 2, "Value to examine."), new FunctionParameter("p", 2, "Value to examine.")}, 0, "SasFunction.Long.YIELDP.txt"), new Function(32768, "ARCOS", "ARCOS(argument)", 2, "ARCOS({0})", "ARCOS({0})", 2, numArgParam1to1, "SasFunction.Long.ARCOS.txt"), new Function(32768, "ARSIN", "ARSIN(argument)", 2, "ARSIN({0})", "ARSIN({0})", 2, numArgParam1to1, "SasFunction.Long.ARSIN.txt"), new Function(32768, "ATAN", "ATAN(argument)", 2, "ATAN({0})", "ATAN({0})", 2, numArgParam, "SasFunction.Long.ATAN.txt"), new Function(32768, "COS", "COS(argument)", 2, "COS({0})", "COS({0})", 2, numArgParam, "SasFunction.Long.COS.txt"), new Function(32768, "COSH", "COSH(argument)", 2, "COSH({0})", "COSH({0})", 2, numArgParam, "SasFunction.Long.COSH.txt"), new Function(32768, "SIN", "SIN(argument)", 2, "SIN({0})", "SIN({0})", 2, numArgParam, "SasFunction.Long.SIN.txt"), new Function(32768, "SINH", "SINH(argument)", 2, "SINH({0})", "SINH({0})", 2, numArgParam, "SasFunction.Long.SINH.txt"), new Function(32768, "TAN", "TAN(argument)", 2, "TAN({0})", "TAN({0})", 2, new FunctionParameter("argument", 2, "Numeric value spcified in radians, and is not an odd multiple of PI/2."), "SasFunction.Long.TAN.txt"), new Function(32768, "TANH", "TANH(argument)", 2, "TANH({0})", "TANH({0})", 2, numArgParam, "SasFunction.Long.TANH.txt"), new Function(131072, "CEIL", "CEIL(argument)", 2, "CEIL({0})", "CEIL({0})", 2, numArgParam, "SasFunction.Long.CEIL.txt"), new Function(131072, "FLOOR", "FLOOR(argument)", 2, "FLOOR({0})", "FLOOR({0})", 2, numArgParam, "SasFunction.Long.FLOOR.txt"), new Function(131072, "FUZZ", "FUZZ(argument)", 2, "FUZZ({0})", "FUZZ({0})", 2, numArgParam, "SasFunction.Long.FUZZ.txt"), new Function(131072, "INT", "INT(argument)", 2, "INT({0})", "INT({0})", 2, numArgParam, "SasFunction.Long.INT.txt"), new Function(131072, "ROUND", "ROUND(argument,round-off-unit)", 2, "ROUND({0}, {1})", "ROUND({0}, {1})", 2, numArgParam, new FunctionParameter("round-off-unit", 2, "Numeric and nonnegative value."), 0, "SasFunction.Long.ROUND.txt"), new Function(131072, "TRUNC", "TRUNC(number, length)", 2, "TRUNC({0}, {1})", "TRUNC({0}, {1})", 2, new FunctionParameter("number", 2, "Numeric value."), new FunctionParameter("length", 2, "Integer value."), 0, "SasFunction.Long.TRUNC.txt"), new Function(262144, "AIRY", "AIRY(x)", 2, "AIRY({0})", "AIRY({0})", 2, new FunctionParameter("x", 2, "Value to examine."), "SasFunction.Long.AIRY.txt"), new Function(262144, "DAIRY", "DAIRY(x)", 2, "DAIRY({0})", "DAIRY({0})", 2, new FunctionParameter("x", 2, "Value to examine."), "SasFunction.Long.DAIRY.txt"), new Function(262144, "DIGAMMA", "DIGAMMA(argument)", 2, "DIGAMMA({0})", "DIGAMMA({0})", 2, numArgParam, "SasFunction.Long.DIGAMMA.txt"), new Function(262144, "ERF", "ERF(argument)", 2, "ERF({0})", "ERF({0})", 2, numArgParam, "SasFunction.Long.ERF.txt"), new Function(262144, "ERFC", "ERFC(argument)", 2, "ERFC({0})", "ERFC({0})", 2, numArgParam, "SasFunction.Long.ERFC.txt"), new Function(262144, "EXP", "EXP(argument)", 2, "EXP({0})", "EXP({0})", 2, numArgParam, "SasFunction.Long.EXP.txt"), new Function(262144, "GAMMA", "GAMMA(argument)", 2, "GAMMA({0})", "GAMMA({0})", 2, numArgParam, "SasFunction.Long.GAMMA.txt"), new Function(262144, "IBESSEL", "IBESSEL(nu,x,kode)", 2, "IBESSEL({0}, {1}, {2})", "IBESSEL({0}, {1}, {2})", 2, new FunctionParameter("nu", 2, "Value to examine."), new FunctionParameter("x", 2, "Value to examine."), new FunctionParameter("kode", 2, "Value to examine."), 0, "SasFunction.Long.IBESSEL.txt"), new Function(262144, "JBESSEL", "JBESSEL(nu,x)", 2, "JBESSEL({0}, {1})", "JBESSEL({0}, {1})", 2, new FunctionParameter("nu", 2, "Value to examine."), new FunctionParameter("x", 2, "Value to examine."), 0, "SasFunction.Long.JBESSEL.txt"), new Function(262144, "LGAMMA", "LGAMMA(argument)", 2, "LGAMMA({0})", "LGAMMA({0})", 2, new FunctionParameter("argument", 2, "Positive numeric value."), "SasFunction.Long.LGAMMA.txt"), new Function(262144, "LOG", "LOG(argument)", 2, "LOG({0})", "LOG({0})", 2, new FunctionParameter("argument", 2, "Positive numeric value."), "SasFunction.Long.LOG.txt"), new Function(262144, "LOG2", "LOG2(argument)", 2, "LOG2({0})", "LOG2({0})", 2, new FunctionParameter("argument", 2, "Positive numeric value."), "SasFunction.Long.LOG2.txt"), new Function(262144, "LOG10", "LOG10(argument)", 2, "LOG10({0})", "LOG10({0})", 2, new FunctionParameter("argument", 2, "Positive numeric value."), "SasFunction.Long.LOG10.txt"), new Function(262144, "TRIGAMMA", "TRIGAMMA(argument)", 2, "TRIGAMMA({0})", "TRIGAMMA({0})", 2, new FunctionParameter("argument", 2, "Positive numeric value."), "SasFunction.Long.TRIGAMMA.txt"), new Function(524288, "KCOMPARE", "KCOMPARE(source, <pos, <count,>> findstr)", 2, "KCOMPARE({0}, {1}, {2}, {3})", "KCOMPARE({0}, {1}, {2}, {3})", 4, new FunctionParameter[]{new FunctionParameter("source", 4, "Value to examine."), new FunctionParameter("pos", 2, "Value to examine."), new FunctionParameter("count", 2, "Value to examine."), new FunctionParameter("findstr", 4, "Value to examine.")}, 0, "SasFunction.Long.KCOMPARE.txt"), new Function(524288, "KCOMPRESS", "KCOMPRESS(source <,characters-to-remove>)", 2, "KCOMPRESS({0}, {1})", "KCOMPRESS({0}, {1})", 4, new FunctionParameter("source", 4, "Value to examine."), new FunctionParameter("characters-to-remove", 4, "Value to examine."), 0, "SasFunction.Long.KCOMPRESS.txt"), new Function(524288, "KCOUNT", "KCOUNT(source)", 2, "KCOUNT({0})", "KCOUNT({0})", 2, new FunctionParameter("source", 4, "Value to examine."), "SasFunction.Long.KCOUNT.txt"), new Function(524288, "KINDEX", "KINDEX(source, excerpt)", 2, "KINDEX({0}, {1})", "KINDEX({0}, {1})", 2, new FunctionParameter("source", 4, "Value to examine."), new FunctionParameter("excerpt", 4, "Value to examine."), 0, "SasFunction.Long.KINDEX.txt"), new Function(524288, "KINDEXC", "KINDEXC(source, excerpt-1<, ...excerpt-n>)", 2, "KINDEXC({0}, {1})", "KINDEXC({0}, {1})", 2, new FunctionParameter("source", 4, "Value to examine."), new FunctionParameter("excerpts", 4, "Value to examine.", false, true, 0, null), 0, "SasFunction.Long.KINDEXC.txt"), new Function(524288, "KLEFT", "KLEFT(argument)", 2, "KLEFT({0})", "KLEFT({0})", 4, new FunctionParameter("argument", 4, "Value to examine."), "SasFunction.Long.KLEFT.txt"), new Function(524288, "KLENGTH", "KLENGTH(argument)", 2, "KLENGTH({0})", "KLENGTH({0})", 2, new FunctionParameter("argument", 4, "Value to examine."), "SasFunction.Long.KLENGTH.txt"), new Function(524288, "KLOWCASE", "KLOWCASE(argument)", 2, "KLOWCASE({0})", "KLOWCASE({0})", 4, new FunctionParameter("argument", 4, "Value to examine."), "SasFunction.Long.KLOWCASE.txt"), new Function(524288, "KREVERSE", "KREVERSE(argument)", 2, "KREVERSE({0})", "KREVERSE({0})", 4, new FunctionParameter("argument", 4, "Value to examine."), "SasFunction.Long.KREVERSE.txt"), new Function(524288, "KRIGHT", "KRIGHT(argument)", 2, "KRIGHT({0})", "KRIGHT({0})", 4, new FunctionParameter("argument", 4, "Value to examine."), "SasFunction.Long.KRIGHT.txt"), new Function(524288, "KSCAN", "KSCAN(argument, n<, delimiters>)", 2, "KSCAN({0}, {1}, {2})", "KSCAN({0}, {1}, {2})", 2, new FunctionParameter("argument", 4, "Value to examine."), new FunctionParameter("n", 2, "Value to examine."), new FunctionParameter("delimiters", 4, "Value to examine."), 0, "SasFunction.Long.KSCAN.txt"), new Function(524288, "KSTRCAT", "KSTRCAT(argument-1, argument-2<, ...argument-n>)", 2, "KSTRCAT({0}, {1}, {2})", "KSTRCAT({0}, {1}, {2})", 2, new FunctionParameter("argument-1", 4, "Value to examine."), new FunctionParameter("argument-2", 4, "Value to examine."), new FunctionParameter("argument-n", 4, "Value to examine."), 0, "SasFunction.Long.KSTRCAT.txt"), new Function(524288, "KSUBSTR", "KSUBSTR(argument, position<, n>)", 2, "KSUBSTR({0}, {1}, {2})", "KSUBSTR({0}, {1}, {2})", 2, new FunctionParameter("argument", 4, "Value to examine."), new FunctionParameter("position", 2, "Value to examine."), new FunctionParameter("n", 2, "Value to examine."), 0, "SasFunction.Long.KSUBSTR.txt"), new Function(524288, "KSUBSTRB", "KSUBSTRB(argument, position<, n>)", 2, "KSUBSTRB({0}, {1}, {2})", "KSUBSTRB({0}, {1}, {2})", 2, new FunctionParameter("argument", 4, "Value to examine."), new FunctionParameter("position", 2, "Value to examine."), new FunctionParameter("n", 2, "Value to examine."), 0, "SasFunction.Long.KSUBSTRB.txt"), new Function(524288, "KTRANSLATE", "KTRANSLATE(source, to-1, from-1<, ...to-n, from-n>)", 2, "KTRANSLATE({0}, {1}, {2}, {3}, {4})", "KTRANSLATE({0}, {1}, {2}, {3}, {4})", 2, new FunctionParameter[]{new FunctionParameter("source", 4, "Value to examine."), new FunctionParameter("to-1", 4, "Value to examine."), new FunctionParameter("from-1", 4, "Value to examine."), new FunctionParameter("...to-n", 4, "Value to examine."), new FunctionParameter("from-n", 4, "Value to examine.")}, 0, "SasFunction.Long.KTRANSLATE.txt"), new Function(524288, "KTRIM", "KTRIM(argument)", 2, "KTRIM({0})", "KTRIM({0})", 4, new FunctionParameter("argument", 4, "Value to examine."), "SasFunction.Long.KTRIM.txt"), new Function(524288, "KTRUNCATE", "KTRUNCATE(number, length)", 2, "KTRUNCATE({0}, {1})", "KTRUNCATE({0}, {1})", 2, new FunctionParameter("number", 4, "Value to examine."), new FunctionParameter("length", 2, "Value to examine."), 0, "SasFunction.Long.KTRUNCATE.txt"), new Function(524288, "KUPCASE", "KUPCASE(argument)", 2, "KUPCASE({0})", "KUPCASE({0})", 4, new FunctionParameter("argument", 4, "Value to examine."), "SasFunction.Long.KUPCASE.txt"), new Function(524288, "KUPDATE", "KUPDATE(argument, position, n<, characters-to-replace>)", 2, "KUPDATE({0}, {1}, {2}, {3})", "KUPDATE({0}, {1}, {2}, {3})", 2, new FunctionParameter[]{new FunctionParameter("argument", 4, "Value to examine."), new FunctionParameter("position", 2, "Value to examine."), new FunctionParameter("n", 2, "Value to examine."), new FunctionParameter("characters-to-replace", 4, "Value to examine.")}, 0, "SasFunction.Long.KUPDATE.txt"), new Function(524288, "KUPDATE", "KUPDATE(argument, position<, n>, characters-to-replace)", 2, "KUPDATE({0}, {1}, {2}, {3})", "KUPDATE({0}, {1}, {2}, {3})", 2, new FunctionParameter[]{new FunctionParameter("argument", 4, "Value to examine."), new FunctionParameter("position", 2, "Value to examine."), new FunctionParameter("n", 2, "Value to examine."), new FunctionParameter("characters-to-replace", 4, "Value to examine.")}, 0, "SasFunction.Long.KUPDATE2.txt"), new Function(524288, "KUPDATEB", "KUPDATEB(argument, position, n<, characters-to-replace>)", 2, "KUPDATEB({0}, {1}, {2}, {3})", "KUPDATEB({0}, {1}, {2}, {3})", 2, new FunctionParameter[]{new FunctionParameter("argument", 4, "Value to examine."), new FunctionParameter("position", 2, "Value to examine."), new FunctionParameter("n", 2, "Value to examine."), new FunctionParameter("characters-to-replace", 4, "Value to examine.")}, 0, "SasFunction.Long.KUPDATEB.txt"), new Function(524288, "KUPDATEB", "KUPDATEB(argument, position<, n>, characters-to-replace)", 2, "KUPDATEB({0}, {1}, {2}, {3})", "KUPDATEB({0}, {1}, {2}, {3})", 2, new FunctionParameter[]{new FunctionParameter("argument", 4, "Value to examine."), new FunctionParameter("position", 2, "Value to examine."), new FunctionParameter("n", 2, "Value to examine."), new FunctionParameter("characters-to-replace", 4, "Value to examine.")}, 0, "SasFunction.Long.KUPDATEB2.txt"), new Function(524288, "KVERIFY", "KVERIFY(source, excerpt-1<, ...excerpt-n>)", 2, "KVERIFY({0}, {1}, {2})", "KVERIFY({0}, {1}, {2})", 2, new FunctionParameter("source", 4, "Value to examine."), new FunctionParameter("excerpt-1", 4, "Value to examine."), new FunctionParameter("excerpt-n", 4, "Character value(s) to find.", false, true, 0, null), 0, "SasFunction.Long.KVERIFY.txt"), new Function(0x200000, "CNONCT", "CNONCT(x,df,prob)", 2, "CNONCT({0}, {1}, {2})", "CNONCT({0}, {1}, {2})", 2, new FunctionParameter("x", 2, "Value to examine."), new FunctionParameter("df", 2, "Value to examine."), new FunctionParameter("prob", 2, "Value to examine."), 0, "SasFunction.Long.CNONCT.txt"), new Function(0x200000, "FNONCT", "FNONCT(x,ndf,ddf,prob)", 2, "FNONCT({0}, {1}, {2}, {3})", "FNONCT({0}, {1}, {2}, {3})", 2, new FunctionParameter[]{new FunctionParameter("x", 2, "Value to examine."), new FunctionParameter("ndf", 2, "Value to examine."), new FunctionParameter("ddf", 2, "Value to examine."), new FunctionParameter("prob", 2, "Value to examine.")}, 0, "SasFunction.Long.FNONCT.txt"), new Function(0x200000, "TNONCT", "TNONCT(x,df,prob)", 2, "TNONCT({0}, {1}, {2})", "TNONCT({0}, {1}, {2})", 2, new FunctionParameter("x", 2, "Value to examine."), new FunctionParameter("df", 2, "Value to examine."), new FunctionParameter("prob", 2, "Value to examine."), 0, "SasFunction.Long.TNONCT.txt")};

    public SasSqlProperties(DataSource dataSource) {
        super(dataSource);
    }

    public SasSqlProperties() {
    }

    @Override
    public String getSqlKeywords() {
        return "SELECT,FROM,WHERE,GROUP,ORDER,BY,HAVING,JOIN,INNER,OUTER,VALIDATE,RESET";
    }

    @Override
    public String getUnquotedNameCharacters() {
        return super.getUnquotedNameCharacters();
    }

    @Override
    public boolean getAlwaysQualifyColumnNames() {
        return false;
    }

    @Override
    public boolean supportsFormats() {
        return true;
    }

    @Override
    public boolean supportsReplacingTables(int type) {
        return 1 == type;
    }

    @Override
    public boolean supportsReplacingViews(int type) {
        return 2 == type;
    }

    @Override
    public boolean supportsGettingViewSql() {
        return true;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return Short.MAX_VALUE;
    }

    @Override
    public String getIdentifierQuoteStart() {
        return "'";
    }

    @Override
    public String getIdentifierQuoteEnd() {
        return "'n";
    }

    @Override
    public String logicalNotEqualsConditionalName() {
        return "^=";
    }

    @Override
    public int getMaxColumnNameLength() {
        String sasVersion = this.m_dataSource.getDatabaseProductVersion();
        if (sasVersion.equals("6") || sasVersion.startsWith("6.")) {
            return 8;
        }
        return 32;
    }

    @Override
    public int getMaxTableNameLength() {
        String sasVersion = this.m_dataSource.getDatabaseProductVersion();
        if (sasVersion.equals("6") || sasVersion.startsWith("6.")) {
            return 8;
        }
        return 32;
    }

    @Override
    public String[] getExcludedFunctions() {
        String[] removeFunctions = new String[]{"<>", "BIT_LENGTH", "CURRENT_TIMESTAMP", "CURRENT_TIME", "CURRENT_DATE", "CURRENT_USER", "LENGTH", "LOWER", "NULLIF", "POSITION", "SESSION_USER", "SYSTEM_USER", "TRIM", "UPPER"};
        return removeFunctions;
    }

    @Override
    public FunctionList getExtendedFunctionDefinitions() {
        FunctionList extFuncList = new FunctionList();
        extFuncList.add(extendedFunctions);
        return extFuncList;
    }
}

