/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.iom.SAS.ILanguageService;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControlSeqHolder;
import com.sas.iom.SAS.ILanguageServicePackage.LineTypeSeqHolder;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.WorkspaceFactory;
import com.sas.query.QueryException;
import com.sas.query.QueryUtils;
import com.sas.query.datasources.JdbcDataSource;
import com.sas.query.models.DefinedConnection;
import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.ConnectionPropertiesDefiner;
import com.sas.query.visuals.LogDialog;
import com.sas.query.visuals.SasITPropertyDefiner;
import com.sas.query.visuals.UidPwdDialog;
import com.sas.rio.MVAConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public class SasITDataSource
extends JdbcDataSource {
    protected IWorkspace m_workspace = null;
    protected ILanguageService m_language = null;

    public SasITDataSource(DefinedConnection connectProperties, MessageHandler messages) throws QueryException {
        super(messages);
        this.connect(connectProperties);
        if (this.m_messages.failureHasOccurred()) {
            return;
        }
        this._initialize();
    }

    public SasITDataSource(Connection connection, MessageHandler messages) throws QueryException {
        super(messages);
        try {
            if (connection != null && !connection.isClosed()) {
                this.setConnection(connection);
                this._initialize();
            }
        }
        catch (SQLException e) {
            this.m_messages.addError(bundle.messageString("Message.DataSource.connect.txt") + "\t" + e.getMessage());
        }
    }

    public SasITDataSource(String hostName, String port, String protocol, String remoteInitialSubmitFile, String localInitialSubmitStmts, String userName, String password, MessageHandler messages) throws QueryException {
        super(messages);
        DefinedConnection connectInfo = new DefinedConnection();
        Properties properties = new Properties();
        if (hostName != null) {
            properties.put("Host", hostName);
        }
        if (port != null) {
            properties.put("Port", port);
        }
        if (protocol != null) {
            properties.put("Protocol", protocol);
        }
        if (remoteInitialSubmitFile != null) {
            properties.put("RemoteInitialSubmitFile", remoteInitialSubmitFile);
        }
        if (localInitialSubmitStmts != null) {
            properties.put("LocalInitialSubmitStmts", localInitialSubmitStmts);
        }
        if (userName != null) {
            connectInfo.setUserName(userName);
        }
        if (password != null) {
            connectInfo.setPassword(QueryUtils.safeEncrypt(new String(password)));
        }
        connectInfo.setConnectionProperties(properties);
        this.connect(connectInfo);
        if (this.m_messages.failureHasOccurred()) {
            return;
        }
        this._initialize();
    }

    protected void connect(DefinedConnection connectProperties) throws QueryException {
        String tmppassword;
        boolean bConnected = false;
        Properties info = new Properties();
        boolean prompted = false;
        boolean remoteprocessed = false;
        String promptedUid = new String();
        String promptedPwd = new String();
        Properties sasITProperties = connectProperties.getConnectionProperties();
        String host = sasITProperties.getProperty("Host");
        String port = sasITProperties.getProperty("Port");
        String protocol = sasITProperties.getProperty("Protocol");
        String remoteInitialSubmitFile = sasITProperties.getProperty("RemoteInitialSubmitFile");
        String localInitialSubmitStmts = sasITProperties.getProperty("LocalInitialSubmitStmts");
        if (host == null || host.length() == 0) {
            throw new IllegalArgumentException(bundle.messageString("SasITDataSource.Message.hostRequired.fmt.txt", host));
        }
        if (port == null || port.length() == 0) {
            port = "5310";
        }
        if (protocol == null || protocol.length() == 0) {
            protocol = "BRIDGE";
        }
        info.put("host", host);
        info.put("port", port);
        info.put("protocol", protocol);
        String tmpuserid = connectProperties.getUserName();
        if (tmpuserid == null || tmpuserid.length() == 0 || tmpuserid.equalsIgnoreCase("<prompt>")) {
            UidPwdDialog dialog = new UidPwdDialog();
            dialog.show();
            if (dialog.getReturnValue() == 1) {
                promptedUid = tmpuserid = dialog.getUserid();
                promptedPwd = dialog.getPassword();
                prompted = true;
            } else {
                this.m_connection = null;
                QueryException exception = new QueryException(QueryException.USER_CANCELLED_CONNECTION, bundle.messageString("Message.DataSource.connectionCancelled.txt"));
                throw exception;
            }
        }
        info.put("userName", tmpuserid);
        tmppassword = prompted ? promptedPwd : ((tmppassword = connectProperties.getPassword()) != null && tmppassword.length() > 0 ? QueryUtils.safeDecrypt(tmppassword) : "");
        info.put("password", tmppassword);
        WorkspaceFactory myfactory = new WorkspaceFactory();
        try {
            this.m_workspace = myfactory.createWorkspaceByServer(info);
        }
        catch (Exception e) {
            this.m_messages.addInternalError(bundle.messageString("Message.DataSource.connect.txt") + e.getMessage());
            this.m_connection = null;
            return;
        }
        this.m_language = this.m_workspace.LanguageService();
        if (remoteInitialSubmitFile != null && remoteInitialSubmitFile.length() > 0) {
            try {
                String includeStmt = new String("%include '");
                includeStmt = includeStmt.concat(remoteInitialSubmitFile);
                includeStmt = includeStmt.concat("';");
                this.m_language.Submit(includeStmt);
            }
            catch (Exception e) {
                this.m_messages.addInternalError(bundle.messageString("Message.DataSource.connect.txt") + e.getMessage());
                this.m_connection = null;
                return;
            }
        }
        if (localInitialSubmitStmts != null && localInitialSubmitStmts.length() > 0) {
            try {
                this.m_language.Submit(QueryUtils.URLDecoder(localInitialSubmitStmts));
                remoteprocessed = true;
            }
            catch (Exception e) {
                this.m_messages.addInternalError(bundle.messageString("Message.DataSource.connect.txt") + e.getMessage());
                this.m_connection = null;
                return;
            }
        }
        if (remoteprocessed) {
            StringSeqHolder logHolder = new StringSeqHolder();
            try {
                this.m_language.FlushLogLines(Short.MAX_VALUE, new CarriageControlSeqHolder(), new LineTypeSeqHolder(), logHolder);
                this.m_language.Submit("%put(&SYSCC);");
                String rc = this.m_language.FlushLog(0);
                if (!rc.endsWith("(0)")) {
                    LogDialog dialog = new LogDialog(null, true, bundle.messageString("Message.DataSource.InitialSASErrWrn.txt"), logHolder.value);
                    dialog.show();
                    if (dialog.getReturnValue() == 2) {
                        this.m_connection = null;
                        return;
                    }
                }
            }
            catch (Exception e) {
                this.m_messages.addInternalError(bundle.messageString("Message.DataSource.connect.txt") + e.getMessage());
                this.m_connection = null;
                return;
            }
        }
        try {
            MVAConnection connection = new MVAConnection(this.m_workspace.DataService(), info);
            if (connection != null && !connection.isClosed()) {
                bConnected = true;
                this.setConnection((Connection)connection);
            } else {
                this.m_messages.addError(bundle.messageString("Message.DataSource.noConnection.txt"));
            }
        }
        catch (Exception e) {
            this.m_messages.addInternalError(bundle.messageString("Message.DataSource.connect.txt") + e.getMessage());
            this.m_connection = null;
            return;
        }
        if (bConnected) {
            this.m_messages.removeAllMessages();
        }
    }

    @Override
    public void close() {
        super.close();
        try {
            if (this.m_workspace != null) {
                this.m_workspace.Close();
                this.m_workspace = null;
            }
        }
        catch (Exception e) {
            this.m_messages.addError(bundle.messageString("Message.DataSource.closeConnection.txt") + e.getMessage());
        }
    }

    @Override
    public ConnectionPropertiesDefiner getConnectionPropertiesDefiner() {
        return new SasITPropertyDefiner();
    }
}

