/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import java.util.Hashtable;

public class SasFormatUtil {
    protected static Hashtable dateTimeFormats = null;

    protected static Hashtable getDateTimeFormats() {
        if (dateTimeFormats == null) {
            SasFormatUtil.initDateTime();
        }
        return dateTimeFormats;
    }

    public static int getNumericSqlType(String format) {
        Integer tempInt;
        int i2;
        if (dateTimeFormats == null) {
            SasFormatUtil.initDateTime();
        }
        int sLength = format.indexOf(46);
        for (i2 = 0; i2 < sLength && !Character.isDigit(format.charAt(i2)); ++i2) {
        }
        String baseFormat = format.trim();
        if (i2 > 0) {
            baseFormat = format.substring(0, i2);
        }
        int type = (tempInt = (Integer)dateTimeFormats.get(baseFormat)) != null ? tempInt : 8;
        return type;
    }

    public static String getNormalizedFormatName(String format) {
        String retVal = "";
        if (!format.startsWith("$")) {
            int fType = SasFormatUtil.getNumericSqlType(format);
            switch (fType) {
                case 91: {
                    retVal = "DATE";
                    break;
                }
                case 92: {
                    retVal = "TIME";
                    break;
                }
                case 93: {
                    retVal = "DATETIME";
                    break;
                }
                default: {
                    retVal = "BEST";
                }
            }
        }
        return retVal;
    }

    public static String getNormalizedFormat(String format) {
        String retVal = format;
        if (format != null) {
            if (!format.startsWith("$")) {
                int fType = SasFormatUtil.getNumericSqlType(format);
                retVal = SasFormatUtil.getNormalizedFormat(fType);
            }
        } else {
            retVal = "";
        }
        return retVal;
    }

    public static String getNormalizedFormat(int fType) {
        String retVal;
        switch (fType) {
            case 91: {
                retVal = "DATE9.";
                break;
            }
            case 92: {
                retVal = "TIME13.3";
                break;
            }
            case 93: {
                retVal = "DATETIME25.3";
                break;
            }
            case 1: {
                retVal = "";
                break;
            }
            default: {
                retVal = "BEST.";
            }
        }
        return retVal;
    }

    protected static void initDateTime() {
        Integer iDate = new Integer(91);
        Integer iTime = new Integer(92);
        Integer iStamp = new Integer(93);
        dateTimeFormats = new Hashtable(76);
        dateTimeFormats.put("DATE", iDate);
        dateTimeFormats.put("DATEAMPM", iStamp);
        dateTimeFormats.put("DATETIME", iStamp);
        dateTimeFormats.put("DAY", iDate);
        dateTimeFormats.put("DDMMYY", iDate);
        dateTimeFormats.put("DDMMY", iDate);
        dateTimeFormats.put("DDMMYYC", iDate);
        dateTimeFormats.put("DDMMYYD", iDate);
        dateTimeFormats.put("DDMMYYN", iDate);
        dateTimeFormats.put("DDMMYYP", iDate);
        dateTimeFormats.put("DDMMYYS", iDate);
        dateTimeFormats.put("DOWNAME", iDate);
        dateTimeFormats.put("EURDFDD", iDate);
        dateTimeFormats.put("EURDFDE", iDate);
        dateTimeFormats.put("EURDFDN", iDate);
        dateTimeFormats.put("EURDFDT", iDate);
        dateTimeFormats.put("EURDFDWN", iDate);
        dateTimeFormats.put("EURDFMN", iDate);
        dateTimeFormats.put("EURDFMY", iDate);
        dateTimeFormats.put("EURDFWDX", iDate);
        dateTimeFormats.put("EURDFWKX", iDate);
        dateTimeFormats.put("HHMM", iTime);
        dateTimeFormats.put("HOUR", iTime);
        dateTimeFormats.put("JULDAY", iDate);
        dateTimeFormats.put("JULIAN", iDate);
        dateTimeFormats.put("MINGUO", iDate);
        dateTimeFormats.put("MMDDYY", iDate);
        dateTimeFormats.put("MMSS", iTime);
        dateTimeFormats.put("MMYY", iDate);
        dateTimeFormats.put("MMYYC", iDate);
        dateTimeFormats.put("MMYYD", iDate);
        dateTimeFormats.put("MMYYN", iDate);
        dateTimeFormats.put("MMYYP", iDate);
        dateTimeFormats.put("MMYYS", iDate);
        dateTimeFormats.put("MONNAME", iDate);
        dateTimeFormats.put("MONTH", iDate);
        dateTimeFormats.put("MONYY", iDate);
        dateTimeFormats.put("NENGO", iDate);
        dateTimeFormats.put("PDJULG", iDate);
        dateTimeFormats.put("PDJULI", iDate);
        dateTimeFormats.put("QTR", iDate);
        dateTimeFormats.put("QTRR", iDate);
        dateTimeFormats.put("TIME", iTime);
        dateTimeFormats.put("TIMEAMPM", iTime);
        dateTimeFormats.put("TOD", iStamp);
        dateTimeFormats.put("WEEKDATE", iDate);
        dateTimeFormats.put("WEEKDATX", iDate);
        dateTimeFormats.put("WEEKDAY", iDate);
        dateTimeFormats.put("WORDDATE", iDate);
        dateTimeFormats.put("WORDDATX", iDate);
        dateTimeFormats.put("YEAR", iDate);
        dateTimeFormats.put("YYMM", iDate);
        dateTimeFormats.put("YYMMC", iDate);
        dateTimeFormats.put("YYMMD", iDate);
        dateTimeFormats.put("YYMMN", iDate);
        dateTimeFormats.put("YYMMP", iDate);
        dateTimeFormats.put("YYMMS", iDate);
        dateTimeFormats.put("YYMMDD", iDate);
        dateTimeFormats.put("YYMON", iDate);
        dateTimeFormats.put("YYQ", iDate);
        dateTimeFormats.put("YYQC", iDate);
        dateTimeFormats.put("YYQD", iDate);
        dateTimeFormats.put("YYQN", iDate);
        dateTimeFormats.put("YYQP", iDate);
        dateTimeFormats.put("YYQS", iDate);
        dateTimeFormats.put("YYQR", iDate);
        dateTimeFormats.put("YYQRC", iDate);
        dateTimeFormats.put("YYQRD", iDate);
        dateTimeFormats.put("YYQRN", iDate);
        dateTimeFormats.put("YYQRP", iDate);
        dateTimeFormats.put("YYQRS", iDate);
    }
}

