/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.query.datasources.SasFormatList;
import com.sas.query.models.ExpressionConstants;
import com.sas.query.visuals.QueryResource;

public class SasFormat
implements ExpressionConstants {
    static QueryResource bundle = new QueryResource("com.sas.query.datasources.SasFormatPropertyBundle");
    protected static SasFormatList m_standardFormatList;
    protected transient String m_name;
    protected transient int m_validCategories;
    protected transient int m_dataType;
    protected transient int m_validFunctionalAreas;
    protected transient String m_description;
    protected transient int m_minWidth;
    protected transient int m_maxWidth;
    protected transient int m_defaultWidth;
    protected transient boolean m_bDecimalAllowed;
    public static final int CAT_FORMAT = 1;
    public static final int CAT_INFORMAT = 2;
    public static final int TYPE_CHARACTER = 1;
    public static final int TYPE_NUMBER = 2;
    public static final int FA_SIMPLE = 1;
    public static final int FA_COMPLEX = 2;
    public static final int FA_NUMBERS = 4;
    public static final int FA_DATES = 8;
    public static final int FA_TIMES = 16;
    public static final int FA_DATETIMES = 32;

    public SasFormat(String name, int validCategories, int dataType, int validFunctionalAreas) {
        this.m_name = name;
        this.m_validCategories = validCategories;
        this.m_dataType = dataType;
        this.m_validFunctionalAreas = validFunctionalAreas;
    }

    public SasFormat(String name, int validCategories, int dataType, int validFunctionalAreas, int minWidth, int maxWidth, int defaultWidth, boolean bDecimalAllowed) {
        this.m_name = name;
        this.m_validCategories = validCategories;
        this.m_dataType = dataType;
        this.m_validFunctionalAreas = validFunctionalAreas;
        this.m_minWidth = minWidth;
        this.m_maxWidth = maxWidth;
        this.m_defaultWidth = defaultWidth;
        this.m_bDecimalAllowed = bDecimalAllowed;
    }

    public static SasFormatList getFormatList(int category, int type) {
        SasFormatList returnValue = new SasFormatList();
        if (m_standardFormatList == null) {
            SasFormat.initializeFormats();
        }
        returnValue.add(m_standardFormatList);
        return returnValue.getSubset(category, type);
    }

    public String toString() {
        String returnString = this.m_name;
        for (int index = this.m_name.length(); index < 12; ++index) {
            returnString = returnString + " ";
        }
        returnString = returnString + bundle.getString("SasFormat." + this.m_name + ".txt");
        return returnString;
    }

    public String getName() {
        return this.m_name;
    }

    public int getCategories() {
        return this.m_validCategories;
    }

    public int getDataType() {
        return this.m_dataType;
    }

    public int getWidthMin() {
        return this.m_minWidth;
    }

    public int getWidthMax() {
        return this.m_maxWidth;
    }

    public int getWidthDefault() {
        return this.m_defaultWidth;
    }

    public boolean isDecimalAllowed() {
        return this.m_bDecimalAllowed;
    }

    public String getSample() {
        return null;
    }

    protected static void initializeFormats() {
        m_standardFormatList = new SasFormatList();
        m_standardFormatList.addElement(new SasFormat("best", 1, 2, 7, 1, 32, 12, false));
        m_standardFormatList.addElement(new SasFormat("binary", 1, 2, 6, 1, 64, 8, false));
        m_standardFormatList.addElement(new SasFormat("comma", 1, 2, 5, 2, 32, 12, true));
        m_standardFormatList.addElement(new SasFormat("commax", 1, 2, 5, 2, 32, 12, true));
        m_standardFormatList.addElement(new SasFormat("d", 1, 2, 6, 1, 32, 12, false));
        m_standardFormatList.addElement(new SasFormat("date", 1, 2, 40, 5, 9, 7, false));
        m_standardFormatList.addElement(new SasFormat("datetime", 1, 2, 40, 7, 40, 7, true));
        m_standardFormatList.addElement(new SasFormat("day", 1, 2, 40, 2, 32, 2, false));
        m_standardFormatList.addElement(new SasFormat("ddmmyy", 1, 2, 40, 2, 10, 8, false));
        m_standardFormatList.addElement(new SasFormat("ddmmyyc", 1, 2, 40, 2, 10, 8, false));
        m_standardFormatList.addElement(new SasFormat("ddmmyyd", 1, 2, 40, 2, 10, 8, false));
        m_standardFormatList.addElement(new SasFormat("ddmmyyn", 1, 2, 40, 2, 10, 8, false));
        m_standardFormatList.addElement(new SasFormat("ddmmyyp", 1, 2, 40, 2, 10, 8, false));
        m_standardFormatList.addElement(new SasFormat("ddmmyys", 1, 2, 40, 2, 10, 8, false));
        m_standardFormatList.addElement(new SasFormat("dollar", 1, 2, 5, 2, 32, 12, true));
        m_standardFormatList.addElement(new SasFormat("dollarx", 1, 2, 5, 2, 32, 12, true));
        m_standardFormatList.addElement(new SasFormat("downame", 1, 2, 40, 1, 32, 9, false));
        m_standardFormatList.addElement(new SasFormat("e", 1, 2, 7, 7, 32, 12, false));
        m_standardFormatList.addElement(new SasFormat("float", 1, 2, 6, 4, 4, 4, true));
        m_standardFormatList.addElement(new SasFormat("fract", 1, 2, 7, 4, 32, 10, false));
        m_standardFormatList.addElement(new SasFormat("hex", 1, 2, 6, 1, 16, 8, false));
        m_standardFormatList.addElement(new SasFormat("hhmm", 1, 2, 48, 2, 20, 5, true));
        m_standardFormatList.addElement(new SasFormat("hour", 1, 2, 48, 2, 20, 2, true));
        m_standardFormatList.addElement(new SasFormat("ib", 1, 2, 6, 1, 8, 4, true));
        m_standardFormatList.addElement(new SasFormat("ibr", 1, 2, 6, 1, 8, 4, true));
        m_standardFormatList.addElement(new SasFormat("ieee", 1, 2, 6, 3, 8, 8, true));
        m_standardFormatList.addElement(new SasFormat("julday", 1, 2, 40, 3, 32, 3, false));
        m_standardFormatList.addElement(new SasFormat("julian", 1, 2, 40, 5, 7, 5, false));
        m_standardFormatList.addElement(new SasFormat("minguo", 1, 2, 40, 6, 10, 6, false));
        m_standardFormatList.addElement(new SasFormat("mmddyy", 1, 2, 40, 2, 10, 8, false));
        m_standardFormatList.addElement(new SasFormat("mmddyyc", 1, 2, 40, 2, 10, 8, false));
        m_standardFormatList.addElement(new SasFormat("mmddyyd", 1, 2, 40, 2, 10, 8, false));
        m_standardFormatList.addElement(new SasFormat("mmddyyn", 1, 2, 40, 2, 10, 8, false));
        m_standardFormatList.addElement(new SasFormat("mmddyyp", 1, 2, 40, 2, 10, 8, false));
        m_standardFormatList.addElement(new SasFormat("mmddyys", 1, 2, 40, 2, 10, 8, false));
        m_standardFormatList.addElement(new SasFormat("mmss", 1, 2, 48, 2, 20, 5, true));
        m_standardFormatList.addElement(new SasFormat("mmyy", 1, 2, 40, 5, 32, 7, false));
        m_standardFormatList.addElement(new SasFormat("mmyyc", 1, 2, 40, 5, 32, 7, false));
        m_standardFormatList.addElement(new SasFormat("mmyyd", 1, 2, 40, 5, 32, 7, false));
        m_standardFormatList.addElement(new SasFormat("mmyyn", 1, 2, 40, 5, 32, 7, false));
        m_standardFormatList.addElement(new SasFormat("mmyyp", 1, 2, 40, 5, 32, 7, false));
        m_standardFormatList.addElement(new SasFormat("mmyys", 1, 2, 40, 5, 32, 7, false));
        m_standardFormatList.addElement(new SasFormat("monname", 1, 2, 40, 1, 32, 9, false));
        m_standardFormatList.addElement(new SasFormat("month", 1, 2, 40, 2, 32, 2, false));
        m_standardFormatList.addElement(new SasFormat("monyy", 1, 2, 40, 5, 7, 5, false));
        m_standardFormatList.addElement(new SasFormat("mrb", 1, 2, 6, 2, 8, 4, true));
        m_standardFormatList.addElement(new SasFormat("negparen", 1, 2, 6, 1, 32, 6, true));
        m_standardFormatList.addElement(new SasFormat("nengo", 1, 2, 40, 2, 10, 10, false));
        m_standardFormatList.addElement(new SasFormat("octal", 1, 2, 6, 1, 24, 3, false));
        m_standardFormatList.addElement(new SasFormat("pd", 1, 2, 6, 1, 16, 1, true));
        m_standardFormatList.addElement(new SasFormat("pdjulg", 1, 2, 40, 4, 4, 4, false));
        m_standardFormatList.addElement(new SasFormat("pdjuli", 1, 2, 40, 4, 4, 4, false));
        m_standardFormatList.addElement(new SasFormat("percent", 1, 2, 7, 3, 32, 12, true));
        m_standardFormatList.addElement(new SasFormat("pib", 1, 2, 7, 1, 8, 1, true));
        m_standardFormatList.addElement(new SasFormat("pibr", 1, 2, 7, 1, 8, 1, true));
        m_standardFormatList.addElement(new SasFormat("pk", 1, 2, 6, 1, 16, 1, true));
        m_standardFormatList.addElement(new SasFormat("qtr", 1, 2, 40, 1, 32, 1, false));
        m_standardFormatList.addElement(new SasFormat("qtrr", 1, 2, 40, 3, 32, 3, false));
        m_standardFormatList.addElement(new SasFormat("rb", 1, 2, 6, 2, 8, 6, true));
        m_standardFormatList.addElement(new SasFormat("roman", 1, 2, 5, 2, 32, 12, false));
        m_standardFormatList.addElement(new SasFormat("ssn", 1, 2, 5, 11, 11, 11, false));
        m_standardFormatList.addElement(new SasFormat("s370fib", 1, 2, 6, 1, 8, 4, true));
        m_standardFormatList.addElement(new SasFormat("s370fibu", 1, 2, 6, 1, 8, 4, true));
        m_standardFormatList.addElement(new SasFormat("s370fpd", 1, 2, 6, 1, 16, 1, true));
        m_standardFormatList.addElement(new SasFormat("s370fpdu", 1, 2, 6, 1, 16, 1, true));
        m_standardFormatList.addElement(new SasFormat("s370fpib", 1, 2, 6, 1, 8, 4, true));
        m_standardFormatList.addElement(new SasFormat("s370frb", 1, 2, 6, 2, 8, 6, true));
        m_standardFormatList.addElement(new SasFormat("s370fzd", 1, 2, 6, 1, 32, 8, true));
        m_standardFormatList.addElement(new SasFormat("s370fzdl", 1, 2, 6, 1, 32, 8, true));
        m_standardFormatList.addElement(new SasFormat("s370fzds", 1, 2, 6, 1, 32, 8, true));
        m_standardFormatList.addElement(new SasFormat("s370fzdt", 1, 2, 6, 1, 32, 8, true));
        m_standardFormatList.addElement(new SasFormat("s370fzdu", 1, 2, 6, 1, 32, 8, true));
        m_standardFormatList.addElement(new SasFormat("time", 1, 2, 48, 2, 20, 8, true));
        m_standardFormatList.addElement(new SasFormat("tod", 1, 2, 48, 2, 20, 8, true));
        m_standardFormatList.addElement(new SasFormat("w.d", 1, 2, 5, 1, 32, 12, true));
        m_standardFormatList.addElement(new SasFormat("weekdate", 1, 2, 40, 3, 37, 29, false));
        m_standardFormatList.addElement(new SasFormat("weekdatx", 1, 2, 40, 3, 37, 29, false));
        m_standardFormatList.addElement(new SasFormat("weekday", 1, 2, 40, 1, 32, 9, false));
        m_standardFormatList.addElement(new SasFormat("worddate", 1, 2, 40, 3, 32, 32, false));
        m_standardFormatList.addElement(new SasFormat("worddatx", 1, 2, 40, 3, 32, 32, false));
        m_standardFormatList.addElement(new SasFormat("wordf", 1, 2, 6, 5, 200, 60, false));
        m_standardFormatList.addElement(new SasFormat("words", 1, 2, 6, 5, 200, 60, false));
        m_standardFormatList.addElement(new SasFormat("year", 1, 2, 40, 2, 32, 4, false));
        m_standardFormatList.addElement(new SasFormat("yen", 1, 2, 5, 1, 32, 1, true));
        m_standardFormatList.addElement(new SasFormat("yymm", 1, 2, 40, 5, 32, 7, false));
        m_standardFormatList.addElement(new SasFormat("yymmc", 1, 2, 40, 5, 32, 7, false));
        m_standardFormatList.addElement(new SasFormat("yymmd", 1, 2, 40, 5, 32, 7, false));
        m_standardFormatList.addElement(new SasFormat("yymmn", 1, 2, 40, 5, 32, 7, false));
        m_standardFormatList.addElement(new SasFormat("yymmp", 1, 2, 40, 5, 32, 7, false));
        m_standardFormatList.addElement(new SasFormat("yymms", 1, 2, 40, 5, 32, 7, false));
        m_standardFormatList.addElement(new SasFormat("yymmdd", 1, 2, 40, 2, 10, 8, false));
        m_standardFormatList.addElement(new SasFormat("yymmddc", 1, 2, 40, 2, 10, 8, false));
        m_standardFormatList.addElement(new SasFormat("yymmddd", 1, 2, 40, 2, 10, 8, false));
        m_standardFormatList.addElement(new SasFormat("yymmddn", 1, 2, 40, 2, 10, 8, false));
        m_standardFormatList.addElement(new SasFormat("yymmddp", 1, 2, 40, 2, 10, 8, false));
        m_standardFormatList.addElement(new SasFormat("yymmdds", 1, 2, 40, 2, 10, 8, false));
        m_standardFormatList.addElement(new SasFormat("yymon", 1, 2, 40, 5, 32, 7, false));
        m_standardFormatList.addElement(new SasFormat("yyq", 1, 2, 40, 4, 32, 6, false));
        m_standardFormatList.addElement(new SasFormat("yyqc", 1, 2, 40, 4, 32, 6, false));
        m_standardFormatList.addElement(new SasFormat("yyqd", 1, 2, 40, 4, 32, 6, false));
        m_standardFormatList.addElement(new SasFormat("yyqn", 1, 2, 40, 4, 32, 6, false));
        m_standardFormatList.addElement(new SasFormat("yyqp", 1, 2, 40, 4, 32, 6, false));
        m_standardFormatList.addElement(new SasFormat("yyqs", 1, 2, 40, 4, 32, 6, false));
        m_standardFormatList.addElement(new SasFormat("yyqr", 1, 2, 40, 4, 32, 8, false));
        m_standardFormatList.addElement(new SasFormat("yyqrc", 1, 2, 40, 4, 32, 8, false));
        m_standardFormatList.addElement(new SasFormat("yyqrd", 1, 2, 40, 4, 32, 8, false));
        m_standardFormatList.addElement(new SasFormat("yyqrn", 1, 2, 40, 4, 32, 8, false));
        m_standardFormatList.addElement(new SasFormat("yyqrp", 1, 2, 40, 4, 32, 8, false));
        m_standardFormatList.addElement(new SasFormat("yyqrs", 1, 2, 40, 4, 32, 8, false));
        m_standardFormatList.addElement(new SasFormat("z", 1, 2, 5, 1, 32, 8, true));
        m_standardFormatList.addElement(new SasFormat("zd", 1, 2, 5, 1, 32, 8, true));
        m_standardFormatList.addElement(new SasFormat("$", 1, 1, 0, 1, Short.MAX_VALUE, 8, false));
        m_standardFormatList.addElement(new SasFormat("$ascii", 1, 1, 0, 1, Short.MAX_VALUE, 12, false));
        m_standardFormatList.addElement(new SasFormat("$binary", 1, 1, 0, 1, Short.MAX_VALUE, 8, false));
        m_standardFormatList.addElement(new SasFormat("$char", 1, 1, 0, 1, Short.MAX_VALUE, 12, false));
        m_standardFormatList.addElement(new SasFormat("$ebcdic", 1, 1, 0, 1, Short.MAX_VALUE, 12, false));
        m_standardFormatList.addElement(new SasFormat("$hex", 1, 1, 0, 1, Short.MAX_VALUE, 4, false));
        m_standardFormatList.addElement(new SasFormat("$msgcase", 1, 1, 0, 1, Short.MAX_VALUE, 8, false));
        m_standardFormatList.addElement(new SasFormat("$octal", 1, 1, 0, 1, Short.MAX_VALUE, 8, false));
        m_standardFormatList.addElement(new SasFormat("$quote", 1, 1, 0, 1, Short.MAX_VALUE, 8, false));
        m_standardFormatList.addElement(new SasFormat("$upcase", 1, 1, 0, 1, Short.MAX_VALUE, 8, false));
        m_standardFormatList.addElement(new SasFormat("$varying", 1, 1, 0, 1, Short.MAX_VALUE, 8, false));
    }
}

