/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.net.connect.ConnectClient;
import com.sas.net.connect.TelnetConnectClient;
import com.sas.net.connect.TunneledConnectClient;
import com.sas.query.QueryException;
import com.sas.query.QueryUtils;
import com.sas.query.datasources.JdbcDataSource;
import com.sas.query.models.DefinedConnection;
import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.ConnectionPropertiesDefiner;
import com.sas.query.visuals.SasConnectPropertyDefiner;
import com.sas.query.visuals.UidPwdDialog;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public class SasConnectDataSource
extends JdbcDataSource {
    protected ConnectClient m_connectClient = null;

    public SasConnectDataSource(DefinedConnection connectProperties, MessageHandler messages) throws QueryException {
        super(messages);
        this.connect(connectProperties);
        if (this.m_messages.failureHasOccurred()) {
            return;
        }
        this._initialize();
    }

    public SasConnectDataSource(Connection connection, MessageHandler messages) throws QueryException {
        super(messages);
        try {
            if (connection != null && !connection.isClosed()) {
                this.setConnection(connection);
                this._initialize();
            }
        }
        catch (SQLException e) {
            this.m_messages.addError(e, bundle, "Message.DataSource.connect.txt");
        }
    }

    protected void connect(DefinedConnection connectProperties) throws QueryException {
        String passwordProperty;
        String passwordresponsekey;
        String useridProperty;
        Properties info;
        boolean bConnected = false;
        boolean prompted = false;
        String promptedUid = new String();
        String promptedPwd = new String();
        Properties sasconnectProperties = connectProperties.getConnectionProperties();
        String connectPropertiesLocation = sasconnectProperties.getProperty("ConnectPropertiesLocation");
        String remoteInitialSubmitFile = sasconnectProperties.getProperty("RemoteInitialSubmitFile");
        String localInitialSubmitStmts = sasconnectProperties.getProperty("LocalInitialSubmitStmts");
        try {
            FileInputStream connectPropertiesStream = new FileInputStream(connectPropertiesLocation);
            info = new Properties();
            info.load(connectPropertiesStream);
        }
        catch (Exception e) {
            this.m_messages.addInternalError(bundle.messageString("Message.DataSource.connect.txt") + e.getMessage());
            this.m_connection = null;
            return;
        }
        String useridresponsekey = info.getProperty("userNameResponse");
        if (useridresponsekey != null && ((useridProperty = info.getProperty(useridresponsekey)) == null || useridProperty.length() == 0)) {
            String tmpuserid = connectProperties.getUserName();
            if (tmpuserid == null || tmpuserid.length() == 0 || tmpuserid.equalsIgnoreCase("<prompt>")) {
                UidPwdDialog dialog = new UidPwdDialog();
                dialog.show();
                if (dialog.getReturnValue() == 1) {
                    promptedUid = tmpuserid = dialog.getUserid();
                    promptedPwd = dialog.getPassword();
                    prompted = true;
                } else {
                    this.m_connection = null;
                    QueryException exception = new QueryException(QueryException.USER_CANCELLED_CONNECTION, bundle.messageString("Message.DataSource.connectionCancelled.txt"));
                    throw exception;
                }
            }
            info.remove(useridresponsekey);
            info.put(useridresponsekey, tmpuserid);
        }
        if ((passwordresponsekey = info.getProperty("passwordResponse")) != null && ((passwordProperty = info.getProperty(passwordresponsekey)) == null || passwordProperty.length() == 0)) {
            String tmppassword = connectProperties.getPassword();
            info.remove(passwordresponsekey);
            if (prompted) {
                info.put(passwordresponsekey, promptedPwd);
            } else if (tmppassword != null && tmppassword.length() != 0) {
                info.put(passwordresponsekey, QueryUtils.safeDecrypt(tmppassword));
            } else {
                info.put(passwordresponsekey, "");
            }
        }
        if (info.getProperty("routerUrl") != null) {
            try {
                this.m_connectClient = new TunneledConnectClient(info);
            }
            catch (Exception e) {
                this.m_messages.addInternalError(bundle.messageString("Message.DataSource.connect.txt") + e.getMessage());
                this.m_connection = null;
                return;
            }
        }
        try {
            this.m_connectClient = new TelnetConnectClient(info);
        }
        catch (Exception e) {
            this.m_messages.addInternalError(bundle.messageString("Message.DataSource.connect.txt") + e.getMessage());
            this.m_connection = null;
            return;
        }
        int telnetPort = 23;
        String telnetPortStr = info.getProperty("port");
        if (telnetPortStr != null && !telnetPortStr.equals("0") && telnetPortStr.length() > 0) {
            telnetPort = Integer.parseInt(telnetPortStr);
        }
        try {
            this.m_connectClient.connect(info.getProperty("host"), telnetPort);
        }
        catch (Exception e) {
            this.m_messages.addInternalError(bundle.messageString("Message.DataSource.connect.txt") + e.getMessage());
            this.m_connection = null;
            return;
        }
        if (remoteInitialSubmitFile != null && remoteInitialSubmitFile.length() > 0) {
            try {
                String includeStmt = new String("%include '");
                includeStmt = includeStmt.concat(remoteInitialSubmitFile);
                includeStmt = includeStmt.concat("';");
                this.m_connectClient.rsubmit(includeStmt);
            }
            catch (Exception e) {
                this.m_messages.addInternalError(bundle.messageString("Message.DataSource.connect.txt") + e.getMessage());
                this.m_connection = null;
                return;
            }
        }
        if (localInitialSubmitStmts != null && localInitialSubmitStmts.length() > 0) {
            try {
                this.m_connectClient.rsubmit(QueryUtils.URLDecoder(localInitialSubmitStmts));
            }
            catch (Exception e) {
                this.m_messages.addInternalError(bundle.messageString("Message.DataSource.connect.txt") + e.getMessage());
                this.m_connection = null;
                return;
            }
        }
        try {
            Connection connection = this.m_connectClient.getSharenet();
            if (connection != null && !connection.isClosed()) {
                bConnected = true;
                this.setConnection(connection);
            } else {
                this.m_messages.addError(bundle, "Message.DataSource.noConnection.txt");
            }
        }
        catch (Exception e) {
            this.m_messages.addInternalError(bundle.messageString("Message.DataSource.connect.txt") + e.getMessage());
            this.m_connection = null;
            return;
        }
        if (bConnected) {
            this.m_messages.removeAllMessages();
        }
    }

    @Override
    public void close() {
        super.close();
        try {
            if (this.m_connectClient != null) {
                this.m_connectClient.disconnect();
                this.m_connectClient = null;
            }
        }
        catch (Exception e) {
            this.m_messages.addError(e, bundle, "Message.DataSource.closeConnection.txt");
        }
    }

    @Override
    public ConnectionPropertiesDefiner getConnectionPropertiesDefiner() {
        return new SasConnectPropertyDefiner();
    }
}

