/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.query.datasources.DataSource;
import com.sas.query.models.ColumnExpression;
import com.sas.query.models.CompoundExpression;
import com.sas.query.models.Expression;
import com.sas.query.models.JoinConstants;
import com.sas.query.models.PhysicalColumn;
import com.sas.query.models.Table;
import com.sas.query.models.UnparsedExpression;

public class Relationship
implements JoinConstants {
    public static final int REL_UNKNOWN = 1;
    public static final int REL_ONE_TO_ONE = 2;
    public static final int REL_ONE_TO_MANY = 4;
    public static final int REL_MANY_TO_MANY = 8;
    public static final int REL_MANY_TO_ONE = 16;
    protected String m_strQualifiedTable;
    protected String[] m_strQualifiedColumns;
    protected String m_strQualifiedForeignTable;
    protected String[] m_strQualifiedForeignColumns;
    protected int m_joinType;
    protected int m_mapping;
    protected boolean m_fRelationshipEnforced;

    public Relationship(String strQualifiedTable, String strQualifiedForeignTable) {
        this.m_strQualifiedTable = strQualifiedTable;
        this.m_strQualifiedForeignTable = strQualifiedForeignTable;
        this.m_joinType = 0;
        this.m_mapping = 1;
        this.m_fRelationshipEnforced = true;
    }

    public Relationship(String strQualifiedTable, String strQualifiedForeignTable, int joinType, int mapping, boolean fRelationshipEnforced) {
        this.m_strQualifiedTable = strQualifiedTable;
        this.m_strQualifiedForeignTable = strQualifiedForeignTable;
        this.m_joinType = joinType;
        this.m_mapping = mapping;
        this.m_fRelationshipEnforced = fRelationshipEnforced;
    }

    public String getTableName() {
        return this.m_strQualifiedTable;
    }

    public void setTablename(String strQualifiedTable) {
        this.m_strQualifiedTable = strQualifiedTable;
    }

    public String[] getColumnNames() {
        return this.m_strQualifiedColumns;
    }

    public void setColumnNames(String[] strQualifiedColumns) {
        this.m_strQualifiedColumns = strQualifiedColumns;
    }

    public String getForeignTableName() {
        return this.m_strQualifiedForeignTable;
    }

    public void setForeignTablename(String strQualifiedForeignTable) {
        this.m_strQualifiedForeignTable = strQualifiedForeignTable;
    }

    public String[] getForeignColumnNames() {
        return this.m_strQualifiedForeignColumns;
    }

    public void setForeignColumnNames(String[] strQualifiedForeignColumns) {
        this.m_strQualifiedForeignColumns = strQualifiedForeignColumns;
    }

    public int getRelationshipType() {
        return this.m_joinType;
    }

    public void setjoinType(int joinType) {
        this.m_joinType = joinType;
    }

    public int getMapping() {
        return this.m_mapping;
    }

    public void setMapping(int mapping) {
        this.m_mapping = mapping;
    }

    public boolean isRelationshipEnforced() {
        return this.m_fRelationshipEnforced;
    }

    public void setIsRelationshipEnforced(boolean fRelationshipEnforced) {
        this.m_fRelationshipEnforced = fRelationshipEnforced;
    }

    public int getComparisonType() {
        return 4;
    }

    public Expression getComparisonDetails(DataSource dataSource, Table table, Table foreignTable) {
        CompoundExpression completeExpression = null;
        for (int index = 0; index < this.m_strQualifiedColumns.length; ++index) {
            PhysicalColumn leftColumn = new PhysicalColumn(table, dataSource.getColumn(this.m_strQualifiedColumns[index]));
            PhysicalColumn rightColumn = new PhysicalColumn(foreignTable, dataSource.getColumn(this.m_strQualifiedForeignColumns[index]));
            ColumnExpression leftExpression = new ColumnExpression(leftColumn);
            ColumnExpression rightExpression = new ColumnExpression(rightColumn);
            CompoundExpression newExpression = new CompoundExpression(dataSource, leftExpression, "=", rightExpression);
            completeExpression = completeExpression == null ? newExpression : new CompoundExpression(dataSource, completeExpression, "AND", newExpression);
        }
        return completeExpression;
    }

    public Expression getComparisonDetails() {
        String strOnCondition = "";
        for (int index = 0; index < this.m_strQualifiedColumns.length; ++index) {
            if (strOnCondition.length() > 0) {
                strOnCondition = strOnCondition + " AND ";
            }
            strOnCondition = strOnCondition + this.m_strQualifiedColumns[index] + " = " + this.m_strQualifiedForeignColumns[index];
        }
        return new UnparsedExpression(strOnCondition);
    }
}

