/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.FunctionList;
import com.sas.query.datasources.SqlProperties;
import java.sql.DatabaseMetaData;

public class JdbcSqlProperties
extends SqlProperties {
    protected DatabaseMetaData m_metaData;

    public JdbcSqlProperties(DataSource source, DatabaseMetaData metaData) {
        super(source);
        this.m_metaData = metaData;
        this.setDateStringFormat(2);
    }

    @Override
    public String getCatalogSeparator() {
        try {
            return this.m_metaData.getCatalogSeparator();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getExtraNameCharacters() {
        try {
            return this.m_metaData.getExtraNameCharacters() + "_";
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getIdentifierQuoteStart() {
        try {
            return this.m_metaData.getIdentifierQuoteString().trim();
        }
        catch (Exception exception) {
            return "\"";
        }
    }

    @Override
    public String getIdentifierQuoteEnd() {
        try {
            return this.m_metaData.getIdentifierQuoteString().trim();
        }
        catch (Exception exception) {
            return "\"";
        }
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        try {
            return this.m_metaData.getMaxBinaryLiteralLength();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    @Override
    public int getMaxCharLiteralLength() {
        try {
            return this.m_metaData.getMaxCharLiteralLength();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        int returnValue = 0;
        try {
            returnValue = this.m_metaData.getMaxColumnsInOrderBy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (returnValue <= 0) {
            returnValue = 32;
        }
        return returnValue;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        int returnValue = 0;
        try {
            returnValue = this.m_metaData.getMaxColumnsInGroupBy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (returnValue <= 0) {
            returnValue = 32;
        }
        return returnValue;
    }

    @Override
    public int getMaxStatementLength() {
        try {
            return this.m_metaData.getMaxStatementLength();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    @Override
    public int getMaxTablesInSelect() {
        int returnValue = 0;
        try {
            returnValue = this.m_metaData.getMaxTablesInSelect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (returnValue <= 0) {
            returnValue = 32;
        }
        return returnValue;
    }

    @Override
    public String getSearchStringEscape() {
        try {
            return this.m_metaData.getSearchStringEscape();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getSqlKeywords() {
        try {
            return this.m_metaData.getSQLKeywords();
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public boolean isCatalogAtStart() {
        try {
            return this.m_metaData.isCatalogAtStart();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        try {
            return this.m_metaData.nullPlusNonNullIsNull();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        try {
            return this.m_metaData.storesLowerCaseIdentifiers();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        try {
            return this.m_metaData.storesLowerCaseQuotedIdentifiers();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        try {
            return this.m_metaData.storesMixedCaseIdentifiers();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        try {
            return this.m_metaData.storesMixedCaseQuotedIdentifiers();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        try {
            return this.m_metaData.storesUpperCaseIdentifiers();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        try {
            return this.m_metaData.storesUpperCaseQuotedIdentifiers();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        try {
            return this.m_metaData.supportsANSI92IntermediateSQL();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        try {
            return this.m_metaData.supportsCatalogsInDataManipulation();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsColumnAliasing() {
        try {
            return this.m_metaData.supportsColumnAliasing();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsConvert() {
        try {
            return this.m_metaData.supportsConvert();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        try {
            return this.m_metaData.supportsCorrelatedSubqueries();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        try {
            return this.m_metaData.supportsCoreSQLGrammar();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        try {
            return this.m_metaData.supportsDifferentTableCorrelationNames();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        try {
            return this.m_metaData.supportsExpressionsInOrderBy();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        try {
            return this.m_metaData.supportsExtendedSQLGrammar();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsFullOuterJoins() {
        try {
            return this.m_metaData.supportsFullOuterJoins();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsGroupBy() {
        try {
            return this.m_metaData.supportsGroupBy();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        try {
            return this.m_metaData.supportsGroupByBeyondSelect();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        try {
            return this.m_metaData.supportsGroupByUnrelated();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        try {
            return this.m_metaData.supportsIntegrityEnhancementFacility();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        try {
            return this.m_metaData.supportsLikeEscapeClause();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        try {
            return this.m_metaData.supportsLimitedOuterJoins();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        try {
            return this.m_metaData.supportsMinimumSQLGrammar();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        try {
            return this.m_metaData.supportsMixedCaseIdentifiers();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        try {
            return this.m_metaData.supportsMixedCaseQuotedIdentifiers();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        try {
            return this.m_metaData.supportsOrderByUnrelated();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsOuterJoins() {
        try {
            return this.m_metaData.supportsOuterJoins();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        try {
            return this.m_metaData.supportsSchemasInDataManipulation();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        try {
            return this.m_metaData.supportsSubqueriesInComparisons();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        try {
            return this.m_metaData.supportsSubqueriesInExists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        try {
            return this.m_metaData.supportsSubqueriesInIns();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        try {
            return this.m_metaData.supportsSubqueriesInQuantifieds();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        try {
            return this.m_metaData.supportsTableCorrelationNames();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsUnion() {
        try {
            return this.m_metaData.supportsUnion();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean supportsUnionAll() {
        try {
            return this.m_metaData.supportsUnionAll();
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected String _getAggregateFunctionNames() {
        return "SUM,COUNT(*),COUNT,AVG";
    }

    protected String _getNumericFunctionNames() {
        try {
            return this.m_metaData.getNumericFunctions();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String _getStringFunctionNames() {
        try {
            return this.m_metaData.getStringFunctions();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String _getSystemFunctionNames() {
        try {
            return this.m_metaData.getSystemFunctions();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String _getDateTimeFunctionNames() {
        try {
            return this.m_metaData.getTimeDateFunctions();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public FunctionList getExtendedFunctionDefinitions() {
        return null;
    }
}

