/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.query.Query;
import com.sas.query.QueryConfiguration;
import com.sas.query.QueryException;
import com.sas.query.QueryUtils;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.DataSourceColumn;
import com.sas.query.datasources.DataSourceColumnList;
import com.sas.query.datasources.DataSourceContainer;
import com.sas.query.datasources.DataSourceContainerList;
import com.sas.query.datasources.DataSourceResultSet;
import com.sas.query.datasources.DataSourceTable;
import com.sas.query.datasources.JdbcResultSet;
import com.sas.query.datasources.JdbcSqlLogic;
import com.sas.query.datasources.JdbcSqlProperties;
import com.sas.query.datasources.Relationship;
import com.sas.query.datasources.RelationshipList;
import com.sas.query.datasources.SqlLogic;
import com.sas.query.datasources.SqlProperties;
import com.sas.query.datasources.WebAfDataSource;
import com.sas.query.models.ColumnExpression;
import com.sas.query.models.Expression;
import com.sas.query.models.ExpressionConstants;
import com.sas.query.models.FilterNode;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.ResultItem;
import com.sas.query.models.ResultItemList;
import com.sas.query.visuals.QueryResource;
import java.awt.Frame;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class JdbcDataSource
extends DataSource
implements ExpressionConstants {
    protected Connection m_connection;
    protected DatabaseMetaData m_databaseMetaData;
    protected boolean m_bHasSchemas = false;
    protected String m_strPossibleTableTypes = ",DATA,TABLE,VIEW,";
    protected String[] m_strTableTypes;
    protected String m_strContext;
    protected DataSourceContainerList m_containerList;
    protected Vector m_namesVector = new Vector();
    protected transient Hashtable m_typeInfo;
    protected static String[] m_driverClassArray = new String[]{null, "com.sas.net.sharenet.ShareNetDriver", "sun.jdbc.odbc.JdbcOdbcDriver", "com.ms.jdbc.odbc.JdbcOdbcDriver"};
    protected static QueryResource bundle = new QueryResource(JdbcDataSource.class);

    public JdbcDataSource(MessageHandler messages) throws QueryException {
        super(messages);
    }

    public JdbcDataSource(String driverClass, String strDriverUrl, Properties connectProperties, MessageHandler messages) throws QueryException {
        super(messages);
        this.connect(driverClass, strDriverUrl, connectProperties);
        if (this.m_messages.failureHasOccurred()) {
            return;
        }
        this._initialize();
    }

    public JdbcDataSource(String strOdbcName, Properties connectProperties, MessageHandler messages) throws QueryException {
        super(messages);
        this.connect("sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:" + strOdbcName, connectProperties);
        if (this.m_messages.failureHasOccurred()) {
            return;
        }
        this._initialize();
    }

    public JdbcDataSource(Connection connection, MessageHandler messages) throws QueryException {
        super(messages);
        try {
            if (connection != null && !connection.isClosed()) {
                this.setConnection(connection);
                this._initialize();
            }
        }
        catch (SQLException e) {
            this.m_messages.addError(e, bundle, "Message.DataSource.connect.txt");
        }
    }

    protected void connect(String driverClass, String strDriverUrl, Properties connectProperties) {
        boolean bConnected = false;
        JdbcDataSource.m_driverClassArray[0] = driverClass;
        if (connectProperties == null) {
            connectProperties = new Properties();
        }
        for (int index = 0; !bConnected && index < m_driverClassArray.length; ++index) {
            try {
                Class.forName(m_driverClassArray[index]).newInstance();
                Connection connection = DriverManager.getConnection(strDriverUrl, connectProperties);
                if (connection != null && !connection.isClosed()) {
                    bConnected = true;
                    this.setConnection(connection);
                    continue;
                }
                this.m_messages.addError(bundle, "Message.DataSource.noConnection.txt");
                continue;
            }
            catch (ClassNotFoundException e) {
                this.m_messages.addError(bundle.messageString("Message.DataSource.thisJDBCDrvr.fmt.txt", driverClass, e.toString()));
                this.m_connection = null;
                continue;
            }
            catch (ClassFormatError e) {
                this.m_messages.addError(bundle.messageString("Message.DataSource.thisJDBCDrvr.fmt.txt", driverClass, e.toString()));
                this.m_connection = null;
                continue;
            }
            catch (SQLException e) {
                this.m_messages.removeAllMessages();
                this.m_messages.addError(e, bundle, "Message.DataSource.connect.txt");
                this.m_connection = null;
                continue;
            }
            catch (Exception e) {
                this.m_messages.addInternalError(e, bundle.messageString("Message.DataSource.connect.txt"));
                this.m_connection = null;
                return;
            }
            catch (Error e) {
                this.m_messages.addInternalError(bundle.messageString("Message.DataSource.connect.txt") + " " + e.getLocalizedMessage());
                this.m_connection = null;
                return;
            }
        }
        if (bConnected) {
            this.m_messages.removeAllMessages();
        }
    }

    @Override
    public void close() {
        this.m_databaseMetaData = null;
        try {
            if (this.m_connection != null) {
                this.m_connection.close();
            }
        }
        catch (SQLException e) {
            this.m_messages.addError(e, bundle, "Message.DataSource.closeConnection.txt");
        }
    }

    public Connection getConnection() {
        return this.m_connection;
    }

    protected String _getDatabaseProductName() {
        try {
            this.m_databaseProductName = this.m_databaseMetaData.getDatabaseProductName();
            this.m_databaseProductName = this.m_databaseProductName.substring(0, 1).toUpperCase() + this.m_databaseProductName.substring(1).toLowerCase();
        }
        catch (SQLException e) {
            this.m_messages.addError(e, bundle, "Message.DataSource.getDPName.txt");
            this.m_databaseProductName = null;
        }
        return this.m_databaseProductName;
    }

    protected String _getDatabaseProductVersion() {
        try {
            this.m_databaseProductVersion = this.m_databaseMetaData.getDatabaseProductVersion();
        }
        catch (SQLException e) {
            this.m_messages.addError(e, bundle, "Message.DataSource.getDPVersion.txt");
            this.m_databaseProductVersion = null;
        }
        return this.m_databaseProductVersion;
    }

    protected void _initialize() {
        block20: {
            ResultSet tableResultSet;
            this.setDefaultNameInfo();
            try {
                ResultSet schemaResultSet = this.m_databaseMetaData.getSchemas();
                if (schemaResultSet != null) {
                    this.m_bHasSchemas = true;
                    while (schemaResultSet.next()) {
                        String strSchemaName = schemaResultSet.getString(1);
                        this.m_namesVector.addElement(strSchemaName.trim());
                    }
                    schemaResultSet.close();
                    this.m_containerList = new DataSourceContainerList(this.getItemCount());
                    for (int index = 0; index < this.getItemCount(); ++index) {
                        this.m_containerList.addElement(new JdbcDataSourceContainer((String)this.m_namesVector.elementAt(index)));
                    }
                }
            }
            catch (SQLException e) {
                if (!"S1C00".equals(e.getSQLState())) {
                    this.m_messages.addError(e);
                    return;
                }
            }
            catch (Exception e) {
                this.m_messages.addInternalError(e);
                return;
            }
            try {
                tableResultSet = this.m_databaseMetaData.getTableTypes();
                Vector<String> stringVector = new Vector<String>();
                if (tableResultSet != null) {
                    while (tableResultSet.next()) {
                        String strTypeName = tableResultSet.getString(1);
                        if (strTypeName != null) {
                            strTypeName = strTypeName.trim().toUpperCase();
                        }
                        if (this.m_strPossibleTableTypes.indexOf("," + strTypeName + ",") == -1) continue;
                        stringVector.addElement(strTypeName);
                    }
                    tableResultSet.close();
                }
                this.m_strTableTypes = new String[stringVector.size()];
                for (int index = 0; index < stringVector.size(); ++index) {
                    this.m_strTableTypes[index] = (String)stringVector.elementAt(index);
                }
            }
            catch (SQLException e) {
                this.m_messages.addError(e);
                return;
            }
            catch (Exception e) {
                this.m_messages.addInternalError(e);
                return;
            }
            if (!this.m_bHasSchemas) {
                try {
                    tableResultSet = this.m_databaseMetaData.getTables(null, null, "%", this.m_strTableTypes);
                    if (tableResultSet == null) break block20;
                    this.m_containerList = new DataSourceContainerList();
                    while (tableResultSet.next()) {
                        boolean bIsView;
                        String strTablePass;
                        String strTableName;
                        block21: {
                            strTableName = tableResultSet.getString(3);
                            strTablePass = null;
                            bIsView = QueryUtils.equalsIgnoreCase("VIEW", tableResultSet.getString(4));
                            try {
                                strTablePass = tableResultSet.getString("TABLE_PASS");
                            }
                            catch (SQLException e) {
                                if ("S0022".equals(e.getSQLState()) || e.getErrorCode() == 182) break block21;
                                throw e;
                            }
                        }
                        strTableName = strTableName.trim();
                        this.m_namesVector.addElement(strTableName);
                        this.m_containerList.addElement(new JdbcDataSourceTable(strTableName, strTablePass, bIsView));
                    }
                    tableResultSet.close();
                }
                catch (Exception e) {
                    this.m_messages.addError(e, bundle, "Message.DataSource.getTables.txt");
                }
            }
        }
    }

    public void setConnection(Connection connection) {
        this.m_connection = connection;
        try {
            Class<?> LoadedClass;
            this.m_databaseMetaData = this.m_connection.getMetaData();
            this._getDatabaseProductName();
            this._getDatabaseProductVersion();
            try {
                LoadedClass = Class.forName("com.sas.query.datasources." + this.m_databaseProductName + "SqlProperties");
                this.m_properties = (SqlProperties)LoadedClass.newInstance();
                this.m_properties.setDataSource(this);
                this.m_properties.setDateStringFormat(2);
            }
            catch (Throwable e) {
                this.m_properties = new JdbcSqlProperties(this, this.m_databaseMetaData);
            }
            try {
                LoadedClass = Class.forName("com.sas.query.datasources." + this.m_databaseProductName + "SqlLogic");
                this.m_sqlLogicProp = (SqlLogic)LoadedClass.newInstance();
                this.m_sqlLogicProp.initProperties(this.m_properties);
            }
            catch (Throwable e) {
                this.m_sqlLogicProp = new JdbcSqlLogic(this.m_properties);
            }
        }
        catch (SQLException e) {
            this.m_messages.addError(e, bundle, "Message.DataSource.getDPVersion.txt");
            this.m_databaseMetaData = null;
        }
        catch (Exception e) {
            this.m_messages.addInternalError(e, bundle.messageString("Message.DataSource.getConnectMetadata.txt"));
            this.m_databaseMetaData = null;
        }
    }

    @Override
    public void initialize() {
    }

    private void setDefaultNameInfo() {
        try {
            this.m_name = this.m_connection.getCatalog();
            if (this.m_name == null || this.m_name.length() == 0) {
                this.m_name = this.m_connection.getMetaData().getURL();
            }
            this.m_description = this.m_connection.getMetaData().getURL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public String getQualifiedName() {
        return this.getName();
    }

    @Override
    public DataSourceContainer getParent() {
        return null;
    }

    @Override
    public SqlLogic getSqlLogic(Query query) {
        if (this.m_sqlLogicQuery == null) {
            try {
                Class<?> LoadedClass = Class.forName("com.sas.query.datasources." + this.m_databaseProductName + "SqlLogic");
                this.m_sqlLogicQuery = (SqlLogic)LoadedClass.newInstance();
                this.m_sqlLogicQuery.initQuery(query, this.m_passwordList);
            }
            catch (Throwable e) {
                this.m_sqlLogicQuery = new JdbcSqlLogic(query, this.m_passwordList);
            }
        }
        this.m_sqlLogicQuery.setQuery(query);
        return this.m_sqlLogicQuery;
    }

    public SqlLogic getSqlLogic(SqlProperties sqlProperties) {
        return this.m_sqlLogicProp;
    }

    @Override
    public SqlProperties getProperties() {
        return this.m_properties;
    }

    @Override
    public void execute(String executeStr) {
        try {
            Statement statement = this.m_connection.createStatement();
            statement.execute(executeStr);
        }
        catch (SQLException e) {
            this.m_messages.addError(bundle.messageString("Message.DataSource.execSQL.fmt.txt", e.toString()));
        }
    }

    @Override
    public String getViewSql(Frame parentFrame, boolean promptForPasswords, String qualifiedViewName, Query query) {
        return this.getViewSql(parentFrame, promptForPasswords, qualifiedViewName, query, null);
    }

    @Override
    public String getViewSql(Frame parent, boolean prompt, String qualifiedViewName, Query myQuery, String password) {
        String retString = "";
        try {
            Statement statement = this.m_connection.createStatement();
            String upcasedLibDotMember = qualifiedViewName.toUpperCase();
            int indexofdot = qualifiedViewName.indexOf(46);
            String lib = qualifiedViewName.substring(0, indexofdot);
            lib = lib.toUpperCase();
            String member = qualifiedViewName.substring(indexofdot + 1);
            member = member.toUpperCase();
            String tStrTemplate = QueryConfiguration.getConfigurationString("getRememberingQueryStringForJDBC.fmt.notrans", "select offset,rtext from dictionary.remember where libname=''{1}'' and memname=''{2}''");
            Object[] args = new Object[]{upcasedLibDotMember, lib, member};
            String m_strSql = MessageFormat.format(tStrTemplate, args);
            try {
                ResultSet rowSet = statement.executeQuery(m_strSql);
                ResultSetMetaData rowSetMetaData = rowSet.getMetaData();
                rowSetMetaData.getColumnCount();
                while (rowSet.next()) {
                    retString = retString + rowSet.getString(2);
                }
                if (retString != null) {
                    retString = WebAfDataSource.decodeQueryForRemember(parent, prompt, retString, myQuery, password);
                }
            }
            catch (SQLException e) {
                this.m_messages.addError(e);
            }
            catch (Exception e) {
                this.m_messages.addInternalError(e);
            }
        }
        catch (Exception e) {
            this.m_messages.addInternalError(e);
            e.printStackTrace();
        }
        if (retString == null || retString.length() == 0 && !this.m_messages.failureHasOccurred()) {
            this.m_messages.addError(bundle, "SQLnotavailable.txt");
        }
        return retString;
    }

    @Override
    public DataSourceTable getTable(String strQualifiedTableName) {
        if (this.m_bHasSchemas) {
            return super.getTable(strQualifiedTableName);
        }
        for (int index = 0; this.m_containerList != null && index < this.m_containerList.size(); ++index) {
            DataSourceTable table = (DataSourceTable)this.m_containerList.elementAt(index);
            if (!strQualifiedTableName.equalsIgnoreCase(table.getName())) continue;
            return table;
        }
        return null;
    }

    @Override
    public DataSourceResultSet getResultSet(String strSql) {
        return new JdbcResultSet(strSql, this, this.m_messages);
    }

    @Override
    public DataSourceResultSet getFormattedResultSet(Query query, FilterNode finalWhereNode, FilterNode finalHavingNode) {
        if (this._getDatabaseProductName().equalsIgnoreCase("SAS")) {
            int i;
            ResultItem resItem;
            String tmpViewName = new String("work._JQ" + Integer.toString(Math.round((float)(Math.random() * 10000.0))));
            while (this.getTable(tmpViewName) != null) {
                tmpViewName = new String("work._JQ" + Integer.toString(Math.round((float)(Math.random() * 10000.0))));
            }
            ResultItemList resItemList = query.getResultItems();
            Vector<ResultItem> changedResItems = new Vector<ResultItem>();
            int tempalias = 0;
            for (int i2 = 0; i2 < resItemList.size(); ++i2) {
                boolean genAlias = false;
                resItem = resItemList.elementAt(i2);
                if (resItem.getAlias() != null && resItem.getAlias().length() != 0) continue;
                if (resItem.getExpression() instanceof ColumnExpression) {
                    ColumnExpression col = (ColumnExpression)resItem.getExpression();
                    String colName = col.getColumn().getName();
                    String tmpcolname = null;
                    Expression tmpExp = null;
                    for (int j = 0; j < i2; ++j) {
                        tmpExp = resItemList.elementAt(j).getExpression();
                        tmpcolname = tmpExp instanceof ColumnExpression ? ((ColumnExpression)tmpExp).getColumn().getName() : "";
                        if (!tmpcolname.equals(colName)) continue;
                        genAlias = true;
                    }
                } else {
                    genAlias = true;
                }
                if (!genAlias) continue;
                String newalias = new String("_TEMV000");
                String numstr = Integer.toString(++tempalias);
                newalias = newalias.substring(1, newalias.length() - numstr.length());
                newalias = newalias.concat(numstr);
                resItem.setAlias(newalias);
                changedResItems.addElement(resItem);
            }
            this.createView(query.getSql(finalWhereNode, finalHavingNode), tmpViewName, null);
            String tmpQuery = new String("Select ");
            for (i = 0; i < resItemList.size(); ++i) {
                resItem = resItemList.elementAt(i);
                String alias = resItem.getAlias();
                String format = resItem.getFormat();
                if (i != 0) {
                    tmpQuery = tmpQuery.concat(", ");
                }
                if (format != null && format.length() != 0) {
                    tmpQuery = tmpQuery.concat("PUT( ");
                }
                tmpQuery = alias == null || alias.length() == 0 ? tmpQuery.concat(resItem.getSqlLogic().genIdentifier(((ColumnExpression)resItem.getExpression()).getColumn().getName())) : tmpQuery.concat(resItem.getAlias());
                if (format != null && format.length() != 0) {
                    tmpQuery = tmpQuery.concat(", ");
                    tmpQuery = tmpQuery.concat(format);
                    tmpQuery = tmpQuery.concat(" )");
                    tmpQuery = tmpQuery.concat(" AS ");
                    tmpQuery = alias == null || alias.length() == 0 ? tmpQuery.concat(resItem.getSqlLogic().genIdentifier(((ColumnExpression)resItem.getExpression()).getColumn().getName())) : tmpQuery.concat(resItem.getAlias());
                }
                if (resItem.getLabel() == null || resItem.getLabel().length() == 0) continue;
                tmpQuery = tmpQuery.concat(" Label= '");
                tmpQuery = tmpQuery.concat(resItem.getLabel());
                tmpQuery = tmpQuery.concat("' ");
            }
            tmpQuery = tmpQuery.concat(" From ");
            tmpQuery = tmpQuery.concat(tmpViewName);
            for (i = 0; i < changedResItems.size(); ++i) {
                ((ResultItem)changedResItems.elementAt(i)).setAlias(null);
            }
            return new TempViewResultSet(tmpQuery, this, this.m_messages, tmpViewName);
        }
        return this.getResultSet(query.getSql(finalWhereNode, finalHavingNode));
    }

    @Override
    public int getItemCount() {
        return this.m_namesVector.size();
    }

    @Override
    public String[] getItemNames() {
        String[] tableList = new String[this.m_namesVector.size()];
        for (int index = 0; index < this.m_namesVector.size(); ++index) {
            tableList[index] = (String)this.m_namesVector.elementAt(index);
        }
        return tableList;
    }

    @Override
    public boolean getHasMultipleLayers() {
        return this.m_bHasSchemas;
    }

    @Override
    public DataSourceContainerList getItems() {
        return this.m_containerList;
    }

    public class JdbcDataSourceTable
    extends DataSourceTable {
        protected DataSourceContainer m_schema;
        protected String m_tableName;
        protected boolean m_fColumnInfoReadYet;
        protected int m_cColumns;
        protected DataSourceColumnList m_columns;

        public JdbcDataSourceTable(DataSourceContainer schema, String tableName, String tablePass, boolean bIsView) {
            this._commonInit(schema, tableName, tablePass, bIsView);
        }

        public JdbcDataSourceTable(String tableName, String tablePass, boolean bIsView) {
            this._commonInit(null, tableName, tablePass, bIsView);
        }

        @Override
        public void initialize() {
            if (!this.m_fColumnInfoReadYet) {
                this._readColumnInfo();
            }
        }

        protected void _commonInit(DataSourceContainer schema, String tableName, String tablePass, boolean bIsView) {
            this.m_schema = schema;
            this.m_tableName = tableName;
            if (tablePass != null) {
                this.m_pwRead = tablePass.indexOf("READ") != -1;
                this.m_pwWrite = tablePass.indexOf("WRITE") != -1;
                this.m_pwAlter = tablePass.indexOf("ALTER") != -1;
            }
            this.m_bIsView = bIsView;
            this.m_fColumnInfoReadYet = false;
        }

        @Override
        public String getName() {
            return this.m_tableName;
        }

        @Override
        public String getQualifiedName() {
            if (this.m_schema != null) {
                return this.m_schema.getName() + "." + this.getName();
            }
            return this.getName();
        }

        @Override
        public DataSourceContainer getParent() {
            if (this.m_schema != null) {
                return this.m_schema;
            }
            return JdbcDataSource.this;
        }

        @Override
        public RelationshipList getRelationships() {
            RelationshipList relationshipList;
            block4: {
                relationshipList = new RelationshipList();
                try {
                    String schemaName = this.m_schema != null ? this.m_schema.getName() : null;
                    ResultSet resultSet = JdbcDataSource.this.m_databaseMetaData.getCrossReference(null, schemaName, this.getName(), null, null, null);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            String strPkCat = resultSet.getString("PKTABLE_CAT");
                            String strPkSchema = resultSet.getString("PKTABLE_SCHEM");
                            String strPkTable = resultSet.getString("PKTABLE_NAME");
                            String strPkColumn = resultSet.getString("PKCOLUMN_NAME");
                            String strFkCat = resultSet.getString("FKTABLE_CAT");
                            String strFkSchema = resultSet.getString("FKTABLE_SCHEM");
                            String strFkTable = resultSet.getString("FKTABLE_NAME");
                            String strFkColumn = resultSet.getString("FKCOLUMN_NAME");
                            int nKeySequence = resultSet.getInt("KEY_SEQ");
                            String strQualifiedTable = "";
                            strQualifiedTable = this._appendName(strQualifiedTable, strPkCat);
                            strQualifiedTable = this._appendName(strQualifiedTable, strPkSchema);
                            strQualifiedTable = this._appendName(strQualifiedTable, strPkTable);
                            String strQualifiedFkTable = "";
                            strQualifiedFkTable = this._appendName(strQualifiedFkTable, strFkCat);
                            strQualifiedFkTable = this._appendName(strQualifiedFkTable, strFkSchema);
                            strQualifiedFkTable = this._appendName(strQualifiedFkTable, strFkTable);
                            Relationship relationship = new Relationship(strQualifiedTable, strQualifiedFkTable);
                            String[] strQualifiedColumns = new String[1];
                            String[] strQualifiedForeignColumns = new String[1];
                            strQualifiedColumns[nKeySequence] = strPkColumn;
                            strQualifiedForeignColumns[nKeySequence] = strFkColumn;
                            relationship.setColumnNames(strQualifiedColumns);
                            relationship.setForeignColumnNames(strQualifiedForeignColumns);
                            relationshipList.addElement(relationship);
                        }
                        resultSet.close();
                    }
                }
                catch (SQLException ex) {
                    if ("IM001".equals(ex.getSQLState()) || ex.getErrorCode() == 95) break block4;
                    JdbcDataSource.this.m_messages.addError(ex, bundle, "Message.DataSource.getTypeInfo.txt");
                }
            }
            return relationshipList;
        }

        protected String _appendName(String strQualifier, String strName) {
            if (strQualifier == null || strQualifier.length() == 0) {
                return new String(strName);
            }
            return new String(strQualifier + '.' + strName);
        }

        @Override
        public DataSourceColumnList getColumns() {
            if (!this.m_fColumnInfoReadYet) {
                this._readColumnInfo();
            }
            return this.m_columns;
        }

        @Override
        public int getColumnCount() {
            if (!this.m_fColumnInfoReadYet) {
                this._readColumnInfo();
            }
            return this.m_cColumns;
        }

        protected void _readColumnInfo() {
            String columnName;
            DataSourceColumnList columnList = new DataSourceColumnList();
            this.m_fColumnInfoReadYet = true;
            String schemaName = this.m_schema != null ? this.m_schema.getName() : null;
            String tableName = this.getName();
            if (this.isPasswordSet()) {
                String password = (String)JdbcDataSource.this.m_passwordList.get(this);
                tableName = tableName + "(PW=" + password + ")";
            }
            Vector<String> indexedColumns = new Vector<String>();
            try {
                ResultSet tableResultSet = JdbcDataSource.this.m_databaseMetaData.getIndexInfo(null, schemaName, tableName, false, false);
                if (tableResultSet != null) {
                    while (tableResultSet.next()) {
                        columnName = tableResultSet.getString(9);
                        String position = tableResultSet.getString(8);
                        if (columnName == null || position != null && tableResultSet.getInt(8) > 1) continue;
                        indexedColumns.addElement(columnName.trim());
                    }
                    tableResultSet.close();
                }
            }
            catch (SQLException e) {
                if (e.getSQLState() != null) {
                    JdbcDataSource.this.m_messages.addError(e);
                    return;
                }
            }
            catch (Exception e) {
                JdbcDataSource.this.m_messages.addInternalError(e);
                return;
            }
            try {
                ResultSet resultSet = JdbcDataSource.this.m_databaseMetaData.getColumns(null, schemaName, tableName, "%");
                if (resultSet != null) {
                    while (resultSet.next()) {
                        columnName = resultSet.getString(4).trim();
                        boolean bIsIndexed = false;
                        for (int index = 0; index < indexedColumns.size(); ++index) {
                            if (!columnName.equals(indexedColumns.elementAt(index))) continue;
                            bIsIndexed = true;
                        }
                        JdbcDataSourceColumn tmpcol = new JdbcDataSourceColumn(columnName, resultSet.getInt(5), resultSet.getInt(7), resultSet.getInt(11), bIsIndexed, resultSet.getString(12));
                        if (JdbcDataSource.this._getDatabaseProductName().equalsIgnoreCase("SAS")) {
                            tmpcol.setFormat(resultSet.getString(6).trim());
                        }
                        columnList.addElement(tmpcol);
                    }
                    resultSet.close();
                }
                this.m_cColumns = columnList.size();
                this.m_columns = new DataSourceColumnList(this.m_cColumns);
                for (int index = 0; index < this.m_cColumns; ++index) {
                    this.m_columns.addElement(columnList.elementAt(index));
                }
            }
            catch (Exception ex) {
                JdbcDataSource.this.m_messages.addInternalError(ex);
            }
        }

        public class JdbcDataSourceColumn
        extends DataSourceColumn {
            protected transient boolean m_fIsThereAnotherValue = false;
            protected transient Statement m_statement = null;
            protected transient ResultSet m_valueRowSet = null;
            protected transient String m_name;
            protected transient int m_type;
            protected transient int m_length;
            protected transient int m_nullable;
            protected transient boolean m_bIndexed;
            protected transient String m_remarks;
            protected transient String m_format;

            public JdbcDataSourceColumn(String name, int type, int length, int nullable, boolean bIndexed, String remarks) {
                this.m_name = name;
                this.m_type = type;
                this.m_length = length;
                this.m_nullable = nullable;
                this.m_bIndexed = bIndexed;
                this.m_format = null;
                this.m_remarks = remarks != null ? remarks.trim() : remarks;
            }

            @Override
            public String getQualifiedName() {
                return this.getParent().getQualifiedName() + "." + this.getName();
            }

            @Override
            public DataSourceTable getParent() {
                return JdbcDataSourceTable.this;
            }

            @Override
            public boolean isIndexed() {
                return this.m_bIndexed;
            }

            public void setIndexed(boolean bIndexed) {
                this.m_bIndexed = bIndexed;
            }

            @Override
            public boolean isNullable() {
                return this.m_nullable != 0;
            }

            @Override
            public int getLength() {
                return this.m_length;
            }

            @Override
            public String getFormat() {
                return this.m_format;
            }

            public void setFormat(String format) {
                this.m_format = format == null || format.length() == 0 ? null : format;
            }

            @Override
            public String getName() {
                return this.m_name;
            }

            @Override
            public String getLabel() {
                return this.m_remarks;
            }

            @Override
            public int getSqlType() {
                return this.m_type;
            }

            public boolean isSearchable() {
                if (JdbcDataSource.this.m_typeInfo == null) {
                    this._readTypeInfo();
                }
                if (JdbcDataSource.this.m_typeInfo.get(new Integer(this.m_type)) != null) {
                    Integer temp = (Integer)JdbcDataSource.this.m_typeInfo.get(new Integer(this.m_type));
                    return temp == 3;
                }
                return false;
            }

            protected void _readTypeInfo() {
                try {
                    ResultSet resultSet = JdbcDataSource.this.m_databaseMetaData.getTypeInfo();
                    if (resultSet != null) {
                        JdbcDataSource.this.m_typeInfo = new Hashtable();
                        while (resultSet.next()) {
                            int type = resultSet.getInt("DATA_TYPE");
                            int searchable = resultSet.getInt("SEARCHABLE");
                            JdbcDataSource.this.m_typeInfo.put(new Integer(type), new Integer(searchable));
                        }
                        resultSet.close();
                    }
                }
                catch (Exception ex) {
                    JdbcDataSource.this.m_messages.addInternalError(ex, bundle.messageString("Message.DataSource.getTypeInfo.txt"));
                }
            }

            @Override
            public boolean supportsDistinctValues() {
                return this.m_type != -4 && this.m_type != -1;
            }

            @Override
            public Vector getDistinctValues() {
                this._closeExistingRowSet();
                return this.getNextValueSet(JdbcDataSource.this.getMaximumSetSize());
            }

            @Override
            public Vector getDistinctValueSet(int nSetSize) {
                this._closeExistingRowSet();
                return this.getNextValueSet(nSetSize);
            }

            @Override
            public Vector getNextValueSet(int nSetSize) {
                if (this.m_valueRowSet == null) {
                    this._getDistinctValues();
                }
                Vector<String> returnVector = new Vector<String>();
                for (int index = 0; index < nSetSize && this.isThereAnotherDistinctValue(); ++index) {
                    String temp = this._getNextValue();
                    if (temp == null) continue;
                    returnVector.addElement(temp);
                }
                return returnVector;
            }

            public String _getNextValue() {
                while (this.m_valueRowSet != null && this.m_fIsThereAnotherValue) {
                    try {
                        String temp = this.m_valueRowSet.getString(1);
                        this.m_fIsThereAnotherValue = this.m_valueRowSet.next();
                        if (temp == null) continue;
                        return temp.trim();
                    }
                    catch (NullPointerException e) {
                        this.m_fIsThereAnotherValue = false;
                    }
                    catch (Exception ex) {
                        this.m_fIsThereAnotherValue = false;
                        JdbcDataSource.this.m_messages.addWarning(ex + ": " + ex.getMessage());
                    }
                }
                return null;
            }

            @Override
            public boolean isThereAnotherDistinctValue() {
                return this.m_fIsThereAnotherValue;
            }

            protected void _getDistinctValues() {
                String strQuery = "";
                try {
                    this.m_statement = JdbcDataSource.this.m_connection.createStatement();
                    strQuery = "SELECT DISTINCT ";
                    strQuery = strQuery + JdbcDataSource.this.getSqlLogic(JdbcDataSource.this.getProperties()).genIdentifier(this.getParent().getName());
                    strQuery = strQuery + ".";
                    strQuery = strQuery + JdbcDataSource.this.getSqlLogic(JdbcDataSource.this.getProperties()).genIdentifier(this.getName());
                    strQuery = strQuery + " FROM ";
                    if (JdbcDataSourceTable.this.m_schema != null) {
                        strQuery = strQuery + JdbcDataSource.this.getSqlLogic(JdbcDataSource.this.getProperties()).genIdentifier(JdbcDataSourceTable.this.m_schema.getName());
                        strQuery = strQuery + ".";
                    }
                    String tableName = JdbcDataSource.this.getSqlLogic(JdbcDataSource.this.getProperties()).genIdentifier(this.getParent().getName());
                    if (this.getParent().isPasswordSet()) {
                        String password = (String)JdbcDataSource.this.m_passwordList.get(this.getParent());
                        tableName = tableName + "(PW=" + password + ")";
                    }
                    strQuery = strQuery + tableName;
                    this.m_valueRowSet = this.m_statement.executeQuery(strQuery);
                    this.m_fIsThereAnotherValue = this.m_valueRowSet.next();
                }
                catch (Exception ex) {
                    JdbcDataSource.this.m_messages.addInternalError(ex, bundle.messageString("Message.DataSource.getDistinctVals.txt") + "\n\t" + strQuery);
                    this._closeExistingRowSet();
                }
            }

            protected void _closeExistingRowSet() {
                if (this.m_valueRowSet == null) {
                    return;
                }
                try {
                    if (this.m_valueRowSet != null) {
                        this.m_valueRowSet.close();
                        this.m_valueRowSet = null;
                    }
                    if (this.m_statement != null) {
                        this.m_statement.close();
                        this.m_statement = null;
                    }
                }
                catch (Exception ex) {
                    this.m_valueRowSet = null;
                    this.m_statement = null;
                    JdbcDataSource.this.m_messages.addWarning(ex + ": " + ex.getMessage());
                }
            }
        }
    }

    public class JdbcDataSourceContainer
    extends DataSourceContainer {
        protected String m_strName;
        protected boolean m_bDetailInfoReadYet = false;
        protected int m_cTables;
        protected DataSourceContainerList m_tables;

        public JdbcDataSourceContainer(String strName) {
            this.m_strName = strName;
            this.m_bDetailInfoReadYet = false;
        }

        @Override
        public void initialize() {
            this._readDetailInfo();
        }

        @Override
        public String getName() {
            return this.m_strName;
        }

        @Override
        public String getQualifiedName() {
            return this.getName();
        }

        @Override
        public DataSourceContainer getParent() {
            return JdbcDataSource.this;
        }

        @Override
        public DataSourceContainerList getItems() {
            if (!this.m_bDetailInfoReadYet) {
                this.initialize();
            }
            return this.m_tables;
        }

        @Override
        public int getItemCount() {
            if (!this.m_bDetailInfoReadYet) {
                this.initialize();
            }
            return this.m_cTables;
        }

        @Override
        public String[] getItemNames() {
            String[] strList = new String[this.m_cTables];
            for (int index = 0; index < this.m_cTables; ++index) {
                strList[index] = this.m_tables.elementAt(index).getName();
            }
            return strList;
        }

        protected void _readDetailInfo() {
            this.m_tables = new DataSourceContainerList();
            this.m_bDetailInfoReadYet = true;
            this.m_tables = new DataSourceContainerList(this.getItemCount());
            try {
                ResultSet tableResultSet = JdbcDataSource.this.m_databaseMetaData.getTables(null, this.getName(), "%", JdbcDataSource.this.m_strTableTypes);
                while (tableResultSet.next()) {
                    boolean bIsView;
                    String strTablePass;
                    String strTableName;
                    block5: {
                        strTableName = tableResultSet.getString(3);
                        strTablePass = null;
                        bIsView = QueryUtils.equalsIgnoreCase("VIEW", tableResultSet.getString(4));
                        try {
                            strTablePass = tableResultSet.getString("TABLE_PASS");
                        }
                        catch (SQLException e) {
                            if ("S0022".equals(e.getSQLState()) || e.getErrorCode() == 182) break block5;
                            throw e;
                        }
                    }
                    this.m_tables.addElement(new JdbcDataSourceTable(this, strTableName.trim(), strTablePass, bIsView));
                }
                tableResultSet.close();
                this.m_cTables = this.m_tables.size();
            }
            catch (Exception ex) {
                JdbcDataSource.this.m_messages.addInternalError(ex);
                ex.printStackTrace();
            }
        }
    }

    public class TempViewResultSet
    extends JdbcResultSet {
        public String m_baseview;
        public JdbcDataSource m_datasource;

        public TempViewResultSet(String sqlStr, JdbcDataSource datasource, MessageHandler messages, String tmpview) {
            super(sqlStr, datasource, messages);
            this.m_baseview = tmpview;
            this.m_datasource = datasource;
        }

        @Override
        public void close() {
            super.close();
            String executeStr = new String("Drop Table ");
            executeStr = executeStr.concat(this.m_baseview);
            this.m_datasource.execute(executeStr);
        }
    }
}

