/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.query.datasources.Function;
import com.sas.query.datasources.FunctionConstants;
import com.sas.query.models.ExpressionConstants;
import com.sas.query.models.VectorSort;
import com.sas.query.visuals.QueryResource;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class FunctionList
implements Serializable,
ExpressionConstants,
FunctionConstants {
    static final long serialVersionUID = -714312824608949126L;
    protected Vector m_list;
    protected static QueryResource bundle = new QueryResource(FunctionList.class);

    public FunctionList() {
        this.m_list = new Vector();
    }

    public FunctionList(int initialSize) {
        this.m_list = new Vector(initialSize);
    }

    public int size() {
        return this.m_list.size();
    }

    public void sortByName() {
        VectorSort.sort(this.m_list);
    }

    public synchronized void add(Function[] objArray) {
        for (int i = 0; i < objArray.length; ++i) {
            this.addElement(objArray[i]);
        }
    }

    public synchronized void add(FunctionList newFList) {
        if (newFList == null) {
            return;
        }
        for (int index = 0; index < newFList.size(); ++index) {
            this.addElement(newFList.elementAt(index));
        }
    }

    public synchronized Enumeration elements() {
        return this.m_list.elements();
    }

    public synchronized void addElement(Function object) {
        this.m_list.addElement(object);
    }

    public synchronized Function elementAt(int index) {
        return (Function)this.m_list.elementAt(index);
    }

    public final int indexOf(Function elem) {
        return this.m_list.indexOf(elem);
    }

    public final synchronized void removeAllElements() {
        this.m_list.removeAllElements();
    }

    public final boolean contains(Function elem) {
        return this.m_list.contains(elem);
    }

    public final synchronized void removeByName(String nameToRemove) {
        for (int i = this.m_list.size() - 1; i >= 0; --i) {
            if (((Function)this.m_list.elementAt(i)).getName() != nameToRemove) continue;
            this.m_list.removeElementAt(i);
        }
    }

    public final synchronized FunctionList removeDuplicatesByNiceFunctionName() {
        FunctionList retList = new FunctionList();
        for (int i = this.m_list.size() - 1; i >= 0; --i) {
            String currentNiceName = ((Function)this.m_list.elementAt(i)).getNiceFunctionName();
            boolean addIt = true;
            for (int j = i - 1; j >= 0; --j) {
                if (!((Function)this.m_list.elementAt(j)).getNiceFunctionName().equals(currentNiceName)) continue;
                addIt = false;
                break;
            }
            if (!addIt) continue;
            retList.insertElementAt((Function)this.m_list.elementAt(i), 0);
        }
        return retList;
    }

    public final synchronized FunctionList removeByType(int functionTypeToRemove) {
        FunctionList retList = new FunctionList();
        for (int i = this.m_list.size() - 1; i >= 0; --i) {
            if ((((Function)this.m_list.elementAt(i)).getFunctionType() & functionTypeToRemove) != 0) continue;
            retList.addElement((Function)this.m_list.elementAt(i));
        }
        return retList;
    }

    public synchronized void merge(String[] excludeList, FunctionList newList) {
        if (excludeList != null) {
            for (int i = 0; i < excludeList.length; ++i) {
                this.removeByName(excludeList[i]);
            }
        }
        this.add(newList);
    }

    public final synchronized void removeElementAt(int index) {
        this.m_list.removeElementAt(index);
    }

    public final synchronized void insertElementAt(Function fun, int index) {
        this.m_list.insertElementAt(fun, index);
    }

    public final synchronized boolean removeElement(Function obj) {
        return this.m_list.removeElement(obj);
    }

    public synchronized FunctionList getSubsetByPrimaryParmType(int parmType) {
        if (parmType == 0) {
            return this;
        }
        FunctionList retList = new FunctionList();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Function fun = (Function)e.nextElement();
            if ((fun.getPrimaryParameterType() & parmType) == 0) continue;
            retList.addElement(fun);
        }
        return retList;
    }

    public synchronized FunctionList getSubsetByCategory(int category) {
        if (category == 0xFFFFFF) {
            return this;
        }
        FunctionList retList = new FunctionList();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Function fun = (Function)e.nextElement();
            if ((fun.getCategory() & category) == 0) continue;
            retList.addElement(fun);
        }
        return retList;
    }

    public synchronized boolean containsCategory(int category) {
        if (category == 0xFFFFFF) {
            return this.size() > 0;
        }
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Function fun = (Function)e.nextElement();
            if ((fun.getCategory() & category) == 0) continue;
            return true;
        }
        return false;
    }

    public synchronized FunctionList removeAllInCategory(int badCat) {
        FunctionList retList = new FunctionList();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Function fun = (Function)e.nextElement();
            if ((fun.getCategory() & badCat) != 0) continue;
            retList.addElement(fun);
        }
        return retList;
    }

    public synchronized FunctionList getSubset(String name, int parmType, int retType) {
        return this.getSubsetByName(name).getSubsetByReturnType(retType).getSubsetByPrimaryParmType(parmType);
    }

    public synchronized Function findFunction(int iFunctionType, String functionName, int priParmType, int functionReturnType, int nParms) {
        FunctionList candidates = this.getSubsetByName(functionName).getSubsetByReturnType(functionReturnType).getSubsetByPrimaryParmType(priParmType).getSubsetByFunctionType(iFunctionType).getSubsetByNumParms(nParms);
        if (candidates.size() == 1) {
            return candidates.elementAt(0);
        }
        if (candidates.size() == 0) {
            return null;
        }
        return candidates.elementAt(0);
    }

    public synchronized FunctionList getSubsetByReturnType(int retType) {
        if (retType == 0) {
            return this;
        }
        FunctionList retList = new FunctionList();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Function fun = (Function)e.nextElement();
            if ((fun.getReturnType() & retType) == 0) continue;
            retList.addElement(fun);
        }
        return retList;
    }

    public synchronized FunctionList getSubsetByName(String name) {
        if (name == null) {
            return this;
        }
        if (name.equals("")) {
            return this;
        }
        FunctionList retList = new FunctionList();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Function fun = (Function)e.nextElement();
            if (!fun.getName().equals(name)) continue;
            retList.addElement(fun);
        }
        return retList;
    }

    public synchronized FunctionList getSubsetByFunctionType(int functionType) {
        if (functionType == 0) {
            return this;
        }
        FunctionList retList = new FunctionList();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Function fun = (Function)e.nextElement();
            if ((fun.getFunctionType() & functionType) == 0) continue;
            retList.addElement(fun);
        }
        return retList;
    }

    public synchronized FunctionList getSubsetByNumParms(int nParms) {
        if (nParms == -1) {
            return this;
        }
        FunctionList retList = new FunctionList();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Function fun = (Function)e.nextElement();
            if (fun.getMinParms() > nParms || fun.getMaxParms() < nParms) continue;
            retList.addElement(fun);
        }
        return retList;
    }

    public synchronized FunctionList getSubsetByNumParmDefs(int nParms) {
        if (nParms == -1) {
            return this;
        }
        FunctionList retList = new FunctionList();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Function fun = (Function)e.nextElement();
            if (fun.getMaxParmDefs() != nParms) continue;
            retList.addElement(fun);
        }
        return retList;
    }

    public synchronized String asCommaList(boolean sortit) {
        Vector<String> v = new Vector<String>();
        String ret = "";
        String current = "";
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Function fun = (Function)e.nextElement();
            current = fun.getName();
            if (v.contains(current)) continue;
            v.addElement(current);
        }
        for (int i = 0; i < v.size(); ++i) {
            ret = ret + v.elementAt(i);
            if (i >= v.size() - 1) continue;
            ret = ret + ",";
        }
        return ret;
    }
}

