/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.query.datasources.FunctionConstants;
import com.sas.query.datasources.FunctionParameter;
import com.sas.query.datasources.SqlLogic;
import com.sas.query.models.CompoundExpression;
import com.sas.query.models.Expression;
import com.sas.query.models.ExpressionConstants;
import com.sas.query.models.ExpressionList;
import com.sas.query.visuals.QueryResource;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;

public class Function
implements Cloneable,
Serializable,
ExpressionConstants,
FunctionConstants {
    static final long serialVersionUID = -3228933728488578500L;
    protected static QueryResource bundle = new QueryResource(Function.class);
    protected static String m_shortMissingOperand;
    protected static String m_longMissingOperand;
    protected String m_strFunctionName;
    protected String m_strNiceFunctionName;
    protected int m_functionType;
    protected String m_strSQLTemplate;
    protected String m_strDisplayTemplate;
    protected int m_nReturnType;
    protected FunctionParameter[] m_parameters;
    protected int m_nPrimaryParameter;
    protected String m_strDescription;
    protected int m_functionCategory;
    static String[] ltbDef;
    static String[] distinctAllDef;
    static String[] optionalDdistinctAllDef;
    static String[] optionalDistinctDef;
    static Function[] standardFunctions;

    public Function() {
        if (m_shortMissingOperand == null) {
            m_shortMissingOperand = bundle.getString("shortMissingOperandString.txt");
        }
        if (m_longMissingOperand == null) {
            m_longMissingOperand = bundle.getString("missingOperandDisplay.txt");
        }
    }

    public static String getCatagoryName(int category) {
        return bundle.getString("Function.Label.Category" + category + ".txt");
    }

    public Object clone() throws CloneNotSupportedException {
        Object newguy = super.clone();
        ((Function)newguy).m_strFunctionName = this.m_strFunctionName;
        ((Function)newguy).m_strNiceFunctionName = this.m_strNiceFunctionName;
        ((Function)newguy).m_functionType = this.m_functionType;
        ((Function)newguy).m_strSQLTemplate = this.m_strSQLTemplate;
        ((Function)newguy).m_strDisplayTemplate = this.m_strDisplayTemplate;
        ((Function)newguy).m_nReturnType = this.m_nReturnType;
        ((Function)newguy).m_nPrimaryParameter = this.m_nPrimaryParameter;
        ((Function)newguy).m_strDescription = this.m_strDescription;
        ((Function)newguy).m_functionCategory = this.m_functionCategory;
        Function cfr_ignored_0 = (Function)newguy;
        Function cfr_ignored_1 = (Function)newguy;
        if (this.m_parameters == null) {
            ((Function)newguy).m_parameters = null;
        } else {
            ((Function)newguy).m_parameters = (FunctionParameter[])this.m_parameters.clone();
            for (int i = 0; i < this.m_parameters.length; ++i) {
                ((Function)newguy).m_parameters[i] = (FunctionParameter)this.m_parameters[i].clone();
            }
        }
        return newguy;
    }

    public boolean isNOTable() {
        return this.getReturnType() == 32768;
    }

    public int getPrecedence() {
        if (this.getName() == "()") {
            return 0;
        }
        return 0;
    }

    public boolean canNullsBeIncluded() {
        return this.getReturnType() == 32768 && !this.getName().equals("ISNULL");
    }

    public int getMinParms() {
        int minParms = 0;
        if (this.m_parameters != null) {
            for (int i = 0; i < this.m_parameters.length; ++i) {
                if (this.getParmDef(i).isOptional()) continue;
                ++minParms;
            }
        }
        return minParms;
    }

    public int getMaxParms() {
        int maxParms = 0;
        if (this.m_parameters != null) {
            for (int i = 0; i < this.m_parameters.length; ++i) {
                if (this.getParmDef(i) != null && this.getParmDef(i).isCommaList()) {
                    maxParms = 999;
                    continue;
                }
                ++maxParms;
            }
            if (maxParms > 999) {
                maxParms = 999;
            }
        }
        return maxParms;
    }

    public int getMaxParmDefs() {
        if (this.m_parameters == null) {
            return 0;
        }
        return this.m_parameters.length;
    }

    public CompoundExpression generateTemplate() {
        ExpressionList parms = new ExpressionList();
        if (this.m_parameters != null) {
            for (int i = 0; i < this.getMaxParmDefs(); ++i) {
                FunctionParameter p = this.getParmDef(i);
                parms.addElement(p.generateTemplate());
            }
        }
        CompoundExpression retExp = new CompoundExpression(this, parms);
        return retExp;
    }

    public String generateSQL(CompoundExpression exp, SqlLogic sqlLogic, int declareOrReference) {
        String sqlString = "";
        int nProvidedParms = exp.getCurrentNumberOfOperands();
        int nMaximumParms = this.getMaxParmDefs();
        sqlString = this.m_strSQLTemplate;
        if (nMaximumParms > 0) {
            int i;
            Object[] args = new String[nMaximumParms];
            for (i = 0; i < nMaximumParms; ++i) {
                args[i] = this.getParmDef(i).isOptional() ? "" : m_longMissingOperand;
            }
            for (i = 0; i < nMaximumParms; ++i) {
                if (i >= nProvidedParms) continue;
                if (!this.getParmDef(i).isCommaList()) {
                    Expression theOnlyOne = exp.getParameter(i);
                    if (theOnlyOne != null) {
                        args[i] = theOnlyOne.generateSQL(sqlLogic, declareOrReference);
                        if (args[i] != null) continue;
                        sqlLogic.getQuery().getMessageHandler().addWarning("Substituted parameter generated null!");
                        args[i] = "<???>";
                        continue;
                    }
                    args[i] = "<???>";
                    continue;
                }
                String commaListString = "";
                int numberOfActualsToSuckIntoCommaList = nProvidedParms - i;
                for (int j = 0; j < numberOfActualsToSuckIntoCommaList; ++j) {
                    Expression nextOne = exp.getParameter(i + j);
                    if (nextOne == null) continue;
                    commaListString = commaListString + nextOne.generateSQL(sqlLogic, declareOrReference);
                    if (j + 1 >= numberOfActualsToSuckIntoCommaList) continue;
                    commaListString = commaListString + ", ";
                }
                args[i] = commaListString;
                break;
            }
            sqlString = MessageFormat.format(sqlString, args);
        }
        return sqlString;
    }

    public Vector getFormatTokens(int viewType) {
        Vector<Object> retVector = new Vector<Object>();
        StringTokenizer st = new StringTokenizer(this.getFormatString(viewType), "(){}", true);
        while (st.hasMoreTokens()) {
            String currentToken = st.nextToken();
            if (currentToken.equals("{")) {
                Integer parmFound = new Integer(st.nextToken());
                String endBrace = st.nextToken();
                retVector.addElement(parmFound);
                continue;
            }
            retVector.addElement(currentToken);
        }
        return retVector;
    }

    private String getFormatString(int viewType) {
        if (viewType == 2) {
            return this.m_strSQLTemplate;
        }
        return this.m_strDisplayTemplate;
    }

    public String getDisplayString(CompoundExpression exp) {
        String sqlString = "";
        int nProvidedParms = exp.getCurrentNumberOfOperands();
        int nMaximumParms = this.getMaxParmDefs();
        sqlString = this.getFunctionDescription();
        if (nMaximumParms > 0) {
            int i;
            Object[] args = new String[nMaximumParms];
            for (i = 0; i < nMaximumParms; ++i) {
                args[i] = this.getParmDef(i).isOptional() ? "" : m_shortMissingOperand;
            }
            for (i = 0; i < nMaximumParms; ++i) {
                if (i >= nProvidedParms) continue;
                if (!this.getParmDef(i).isCommaList()) {
                    Expression thisOne = exp.getParameter(i);
                    if (thisOne == null) continue;
                    args[i] = thisOne.getDisplayString();
                    continue;
                }
                String commaListString = "";
                int numberOfActualsToSuckIntoCommaList = nProvidedParms - i;
                for (int j = 0; j < numberOfActualsToSuckIntoCommaList; ++j) {
                    commaListString = commaListString + exp.getParameter(i + j).getDisplayString();
                    if (j + 1 >= numberOfActualsToSuckIntoCommaList) continue;
                    commaListString = commaListString + ", ";
                }
                args[i] = commaListString;
                break;
            }
            sqlString = MessageFormat.format(sqlString, args);
        }
        return sqlString;
    }

    public String toString() {
        return this.getName();
    }

    public String getFunctionDescription() {
        String returnString = this.m_strDescription;
        if (this.m_strDescription == "" || this.m_strDescription == null) {
            returnString = this.m_strFunctionName;
        } else {
            QueryResource specificBundle = null;
            int index = this.m_strDescription.indexOf("Function.");
            if (index > 0) {
                String productName = this.m_strDescription.substring(0, index);
                specificBundle = new QueryResource("com.sas.query.datasources." + productName + "FunctionPropertyBundle");
            }
            String temp = null;
            if (specificBundle != null) {
                temp = specificBundle.getRawString(this.m_strDescription);
            }
            if (temp == null) {
                temp = bundle.getRawString(this.m_strDescription);
            }
            if (temp != null) {
                returnString = temp;
            }
        }
        return returnString;
    }

    public int getCategory() {
        return this.m_functionCategory;
    }

    public String getFunctionName() {
        return this.getName();
    }

    public String getNiceFunctionName() {
        return this.m_strNiceFunctionName;
    }

    public int getPrimaryParameterType() {
        if (this.m_parameters == null) {
            return 0;
        }
        if (this.m_nPrimaryParameter < 0) {
            return 0;
        }
        return this.m_parameters[this.m_nPrimaryParameter].getType();
    }

    public int getPrimaryParameterIndex() {
        if (this.m_nPrimaryParameter >= 0) {
            return this.m_nPrimaryParameter;
        }
        if (this.getMaxParmDefs() > 0) {
            return 0;
        }
        return -1;
    }

    public FunctionParameter getParmDef(int i) {
        if (this.m_parameters == null) {
            return null;
        }
        if (i > -1 && i < this.m_parameters.length) {
            return this.m_parameters[i];
        }
        return null;
    }

    public Function(int cat, String strName, String strNiceName, int functionType, String strSQLTemplate, String strDisplayTemplate, int nReturnType, String strDescription) {
        this.m_functionCategory = cat;
        this.m_strFunctionName = strName;
        this.m_strNiceFunctionName = strNiceName;
        this.m_functionType = functionType;
        this.m_strSQLTemplate = strSQLTemplate;
        this.m_strDisplayTemplate = strDisplayTemplate;
        this.m_nReturnType = nReturnType;
        this.m_parameters = null;
        this.m_nPrimaryParameter = -1;
        this.m_strDescription = strDescription;
    }

    public Function(int cat, String strName, String strNiceName, int functionType, String strSQLTemplate, String strDisplayTemplate, int nReturnType, FunctionParameter parameter, String strDescription) {
        this.m_functionCategory = cat;
        this.m_strFunctionName = strName;
        this.m_strNiceFunctionName = strNiceName;
        this.m_functionType = functionType;
        this.m_strSQLTemplate = strSQLTemplate;
        this.m_strDisplayTemplate = strDisplayTemplate;
        this.m_nReturnType = nReturnType;
        this.m_parameters = new FunctionParameter[1];
        this.m_parameters[0] = parameter;
        this.m_nPrimaryParameter = 0;
        this.m_strDescription = strDescription;
    }

    public Function(int cat, String strName, String strNiceName, int functionType, String strSQLTemplate, String strDisplayTemplate, int nReturnType, FunctionParameter parameter1, FunctionParameter parameter2, int nPrimaryParameter, String strDescription) {
        this.m_functionCategory = cat;
        this.m_strFunctionName = strName;
        this.m_strNiceFunctionName = strNiceName;
        this.m_functionType = functionType;
        this.m_strSQLTemplate = strSQLTemplate;
        this.m_strDisplayTemplate = strDisplayTemplate;
        this.m_nReturnType = nReturnType;
        this.m_parameters = new FunctionParameter[2];
        this.m_parameters[0] = parameter1;
        this.m_parameters[1] = parameter2;
        this.m_nPrimaryParameter = nPrimaryParameter;
        this.m_strDescription = strDescription;
    }

    public Function(int cat, String strName, String strNiceName, int functionType, String strSQLTemplate, String strDisplayTemplate, int nReturnType, FunctionParameter parameter1, FunctionParameter parameter2, String strDescription) {
        this.m_functionCategory = cat;
        this.m_strFunctionName = strName;
        this.m_strNiceFunctionName = strNiceName;
        this.m_functionType = functionType;
        this.m_strSQLTemplate = strSQLTemplate;
        this.m_strDisplayTemplate = strDisplayTemplate;
        this.m_nReturnType = nReturnType;
        this.m_parameters = new FunctionParameter[2];
        this.m_parameters[0] = parameter1;
        this.m_parameters[1] = parameter2;
        this.m_nPrimaryParameter = 0;
        this.m_strDescription = strDescription;
    }

    public Function(int cat, String strName, String strNiceName, int functionType, String strSQLTemplate, String strDisplayTemplate, int nReturnType, FunctionParameter parameter1, FunctionParameter parameter2, FunctionParameter parameter3, int nPrimaryParameter, String strDescription) {
        this.m_functionCategory = cat;
        this.m_strFunctionName = strName;
        this.m_strNiceFunctionName = strNiceName;
        this.m_functionType = functionType;
        this.m_strSQLTemplate = strSQLTemplate;
        this.m_strDisplayTemplate = strDisplayTemplate;
        this.m_nReturnType = nReturnType;
        this.m_parameters = new FunctionParameter[3];
        this.m_parameters[0] = parameter1;
        this.m_parameters[1] = parameter2;
        this.m_parameters[2] = parameter3;
        this.m_nPrimaryParameter = nPrimaryParameter;
        this.m_strDescription = strDescription;
    }

    public Function(int cat, String strName, String strNiceName, int functionType, String strSQLTemplate, String strDisplayTemplate, int nReturnType, FunctionParameter[] parmArray, int nPrimaryParameter, String strDescription) {
        this.m_functionCategory = cat;
        this.m_strFunctionName = strName;
        this.m_strNiceFunctionName = strNiceName;
        this.m_functionType = functionType;
        this.m_strSQLTemplate = strSQLTemplate;
        this.m_strDisplayTemplate = strDisplayTemplate;
        this.m_nReturnType = nReturnType;
        this.m_parameters = parmArray;
        this.m_nPrimaryParameter = nPrimaryParameter;
        this.m_strDescription = strDescription;
    }

    public int getReturnType() {
        return this.m_nReturnType;
    }

    public String getName() {
        if (this.m_strFunctionName == null) {
            return "";
        }
        return this.m_strFunctionName;
    }

    public int getFunctionType() {
        return this.m_functionType;
    }

    public boolean hasShortCut(char charToMatch) {
        if (this.getName().length() == 0) {
            return false;
        }
        return Character.toUpperCase(this.getName().charAt(0)) == Character.toUpperCase(charToMatch);
    }

    public static Function[] standardFunctionDefinitions() {
        return standardFunctions;
    }

    static {
        ltbDef = new String[]{"BOTH", "LEADING", "TRAILING"};
        distinctAllDef = new String[]{"DISTINCT", "ALL"};
        optionalDdistinctAllDef = new String[]{"DISTINCT", "ALL", ""};
        optionalDistinctDef = new String[]{"DISTINCT", ""};
        standardFunctions = new Function[]{new Function(0x400000, "COUNT*", "Count(*)", 1, "COUNT(*)", "Function.Short.COUNT*.txt", 2, "Function.Long.COUNT*.txt"), new Function(0x400000, "SUM", "SUM()", 1, "SUM({0})", "Function.Short.SUM.fmt.txt", 258, new FunctionParameter("value", 258, "Value to sum"), "Function.Long.SUM.txt"), new Function(0x400000, "SUM DISTINCT", "SUM(Distinct X)", 1, "SUM(DISTINCT {0} )", "Function.Short.SUMDISTINCT.fmt.txt", 258, new FunctionParameter("value", 258, "Value to sum"), "Function.Long.SUMDISTINCT.txt"), new Function(0x400000, "AVG", "AVG()", 1, "AVG({0})", "Function.Short.AVG.fmt.txt", 258, new FunctionParameter("value", 2, "Value to average"), "Function.Long.AVG.txt"), new Function(0x400000, "AVG DISTINCT", "AVG(Distinct X)", 1, "AVG(DISTINCT {0})", "Function.Short.AVGDISTINCT.fmt.txt", 258, new FunctionParameter("value", 2, "Value to average"), "Function.Long.AVGDISTINCT.txt"), new Function(0x400000, "MAX", "MAX()", 1, "MAX({0})", "Function.Short.MAX.fmt.txt", 4095, new FunctionParameter("value", 4095, "Value to search"), "Function.Long.MAX.txt"), new Function(0x400000, "MIN", "MIN()", 1, "MIN({0})", "Function.Short.MIN.fmt.txt", 4095, new FunctionParameter("value", 4095, "Value to search"), "Function.Long.MIN.txt"), new Function(0x400000, "COUNT", "COUNT()", 1, "COUNT({0})", "Function.Short.COUNT.fmt.txt", 2, new FunctionParameter("value", 4095, "Values to examine"), "Function.Long.COUNT.txt"), new Function(0x400000, "COUNT DISTINCT", "COUNT(Distinct X)", 1, "COUNT(DISTINCT {0})", "Function.Short.COUNTDISTINCT.fmt.txt", 2, new FunctionParameter("value", 4095, "Values to examine"), "Function.Long.COUNTDISTINCT.txt"), new Function(512, "CURRENT_TIME", "Current Time", 2, "CURRENT_TIME", "Function.Short.CURRENTTIME.txt", 32, "Function.Long.CURRENTTIME.txt"), new Function(512, "CURRENT_DATE", "Current Date", 2, "CURRENT_DATE", "Function.Short.CURRENTDATE.txt", 16, "Function.Long.CURRENTDATE.txt"), new Function(512, "CURRENT_TIMESTAMP", "Current Timestamp", 2, "CURRENT_TIMESTAMP", "Function.Short.CURRENTTIMESTAMP.txt", 64, "Function.Long.CURRENTTIMESTAMP.txt"), new Function(16, "BIT_LENGTH", "Bit length", 2, "BIT_LENGTH({0})", "Function.Short.BITLENGTH.fmt.txt", 2, new FunctionParameter("str", 4, "String to measure"), "Function.Long.BITLENGTH.txt"), new Function(16, "LENGTH", "Length", 2, "CHARACTER_LENGTH({0})", "Function.Short.LENGTH.fmt.txt", 2, new FunctionParameter("str", 4, "String to measure"), "Function.Long.LENGTH.txt"), new Function(16, "CURRENT_USER", "Current User", 2, "CURRENT_USER", "Function.Short.CURRENTUSER.txt", 4, "Function.Long.CURRENTUSER.txt"), new Function(16, "UPPER", "Upper", 2, "UPPER({0})", "Function.Short.UPPER.fmt.txt", 4, new FunctionParameter("string", 4, "String to upper case."), "Function.Long.UPPER.txt"), new Function(16, "LOWER", "Lower", 2, "LOWER({0})", "Function.Short.LOWER.fmt.txt", 4, new FunctionParameter("string", 4, "String to lower case."), "Function.Long.LOWER.txt"), new Function(16, "POSITION", "Position", 2, "POSITION ({0} IN {1})", "Function.Short.POSITION.fmt.txt", 2, new FunctionParameter("string1", 4, "String to search."), new FunctionParameter("string2", 4, "Desired substring."), "Function.Long.POSITION.txt"), new Function(16, "SESSION_USER", "Session User", 2, "SESSION_USER", "Function.Short.SESSIONUSER.txt", 4, "Function.Long.SESSIONUSER.txt"), new Function(16, "TRIM", "Trim leading and trailing blanks", 2, "TRIM({0})", "Function.Short.TYPICALTRIM.fmt.txt", 4, new FunctionParameter("string1", 4, "String to trim."), "Function.Long.TYPICALTRIM.txt"), new Function(16, "TRIM", "Trim", 2, "TRIM({0} {1} FROM {2})", "Function.Short.FULLTRIM.fmt.txt", 4, new FunctionParameter("ltb", 8, "One of Leading, Trailing, or BOTH", false, false, 0, ltbDef), new FunctionParameter("charToRemove", 4, "Character to trim from the string.", false, false, 15, null), new FunctionParameter("stringToTrim", 4, "The string from which to remove characters."), 2, "Function.Long.FULLTRIM.txt"), new Function(16, "SYSTEM_USER", "System User", 2, "SYSTEM_USER", "Function.Short.SYSTEMUSER.txt", 4, "Function.Long.SYSTEMUSER.txt"), new Function(0x800000, "BETWEEN", bundle.getString("betweenOperatorDescription.txt"), 32, "{0} BETWEEN {1} AND {2}", "Function.Short.BETWEEN.fmt.txt", 32768, new FunctionParameter("lhs", 4095, "Value to examine."), new FunctionParameter("beginRange", 4095, "Beginning of range of desired values."), new FunctionParameter("endRange", 4095, "End of range of desired values."), 1, "Function.Long.BETWEEN.txt"), new Function(0x800000, "LIKE", bundle.getString("like2OperatorDescription.txt"), 32, "{0} LIKE {1}", "Function.Short.LIKE.fmt.txt", 32768, new FunctionParameter("value", 4, "Value to examine."), new FunctionParameter("pattern", 4, "Pattern to match."), 1, "Function.Long.LIKE.txt"), new Function(529, "COALESCE", bundle.messageString("coalesceDescription.txt"), 2, "COALESCE({0})", "Function.Short.COALESCE.fmt.txt", 4095, new FunctionParameter("listOfValues", 4095, "Values to examine.", false, true, 0, null), "Function.Long.COALESCE.txt"), new Function(529, "NULLIF", bundle.messageString("nullifDescription.txt"), 2, "NULLIF({0},{1})", "Function.Short.NULLIF.fmt.txt", 4095, new FunctionParameter("value1", 4095, "Value to test and return if non-null."), new FunctionParameter("value2", 4095, "Value to return if first value is null."), 0, "Function.Long.NULLIF.txt"), new Function(0x800000, "IN", bundle.messageString("inOperatorDescription.txt"), 32, "{0} IN ({1})", "Function.Short.IN.fmt.txt", 32768, new FunctionParameter("value", 4, "Value to examine."), new FunctionParameter("listOfValues", 4095, "Value to examine.", false, true, 0, null), 1, "Function.Long.IN.txt"), new Function(0x800000, "ISNULL", bundle.messageString("isNullOperatorDescription.txt"), 32, "{0} IS NULL", "Function.Short.ISNULL.fmt.txt", 32768, new FunctionParameter("value", 4095, "Value to test for nullness."), "Function.Long.ISNULL.txt"), new Function(0x800000, "EXISTS", "Exists", 64, "EXISTS {0}", "Function.Short.EXISTS.fmt.txt", 32768, new FunctionParameter("value", 4095, "subquery to test for existant matches."), "Function.Long.EXISTS.txt")};
    }
}

