/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.query.Query;
import com.sas.query.QueryException;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.DataSourceColumn;
import com.sas.query.datasources.DataSourceColumnList;
import com.sas.query.datasources.DataSourceContainer;
import com.sas.query.datasources.DataSourceContainerList;
import com.sas.query.datasources.DataSourceTable;
import com.sas.query.datasources.RelationshipList;
import com.sas.query.datasources.SqlLogic;
import com.sas.query.datasources.SqlProperties;
import com.sas.query.models.ExpressionConstants;
import com.sas.query.visuals.QueryResource;
import java.util.Vector;

public class DummyDataSource
extends DataSource
implements ExpressionConstants {
    protected transient ColumnInfo[][] m_columnInfo;
    protected static String[] m_tableNames = new String[]{"Employee", "WorkHours"};
    protected static int[] m_cColumnsInTable = new int[]{10, 2};
    protected static DataSourceContainerList m_tableList;
    protected SqlProperties m_properties = null;
    protected SqlLogic m_logic = null;
    protected static QueryResource bundle;

    public DummyDataSource() throws QueryException {
        this._initialize();
    }

    public DummyDataSource(String username, String password) throws QueryException {
        this._initialize();
    }

    @Override
    public void close() {
    }

    @Override
    public void initialize() {
    }

    @Override
    public String getQualifiedName() {
        return this.getName();
    }

    @Override
    public DataSourceContainer getParent() {
        return null;
    }

    @Override
    public String getName() {
        return "Sample DataSource";
    }

    @Override
    public SqlLogic getSqlLogic(Query query) {
        if (this.m_logic == null) {
            this.m_logic = new SqlLogic(query, this.m_passwordList);
        }
        return this.m_logic;
    }

    @Override
    public SqlProperties getProperties() {
        if (this.m_properties == null) {
            this.m_properties = new SqlProperties(this);
        }
        return this.m_properties;
    }

    @Override
    public void execute(String executeStr) {
    }

    @Override
    public DataSourceTable getTable(String strQualifiedTableName) {
        DataSourceContainerList tableList = this.getItems();
        DataSourceTable table = null;
        if (strQualifiedTableName == null) {
            return null;
        }
        for (int index = 0; index < tableList.size(); ++index) {
            if (!strQualifiedTableName.equals(tableList.elementAt(index).getName())) continue;
            return (DataSourceTable)tableList.elementAt(index);
        }
        return table;
    }

    @Override
    public DataSourceColumn getColumn(String strQualifiedColumnName) {
        String separatorString = this.getProperties().getCatalogSeparator();
        int pos = strQualifiedColumnName.lastIndexOf(separatorString);
        if (pos == -1) {
            return null;
        }
        DataSourceTable table = this.getTable(strQualifiedColumnName.substring(0, pos));
        if (table == null) {
            return null;
        }
        String strColumnName = strQualifiedColumnName.substring(pos + 1);
        DataSourceColumnList columnList = table.getColumns();
        for (int index = 0; index < columnList.size(); ++index) {
            DataSourceColumn column = columnList.elementAt(index);
            if (!column.getName().equals(strColumnName)) continue;
            return column;
        }
        return null;
    }

    @Override
    public DataSourceContainerList getItems() {
        if (m_tableList != null) {
            return m_tableList;
        }
        m_tableList = new DataSourceContainerList(this.getItemCount());
        for (int index = 0; index < this.getItemCount(); ++index) {
            m_tableList.addElement(new DummyDataSourceTable(index));
        }
        return m_tableList;
    }

    @Override
    public int getItemCount() {
        return m_tableNames.length;
    }

    @Override
    public String[] getItemNames() {
        return m_tableNames;
    }

    protected void _initialize() {
        this.m_columnInfo = new ColumnInfo[2][10];
        this.m_columnInfo[0][0] = new ColumnInfo(32, "firstName", "First Name", 12, "????");
        this.m_columnInfo[0][1] = new ColumnInfo(32, "lastName", "Last Name", 12, "????");
        this.m_columnInfo[0][2] = new ColumnInfo(4, "employeeID", "ID", 4, "????");
        this.m_columnInfo[0][3] = new ColumnInfo(32, "employeeType", "Type", 12, "????");
        this.m_columnInfo[0][4] = new ColumnInfo(32, "status", null, 12, null);
        this.m_columnInfo[0][5] = new ColumnInfo(4, "eligibility", "Eligibility", 4, "????");
        this.m_columnInfo[0][6] = new ColumnInfo(0, "maritalStatus", null, 1, null);
        this.m_columnInfo[0][7] = new ColumnInfo(1, "dateUpdated", "Date Last Updated", 91, "????");
        this.m_columnInfo[0][8] = new ColumnInfo(1, "timeUpdated", "Time Last Updated", 92, "????");
        this.m_columnInfo[0][9] = new ColumnInfo(1, "timestamp", "TimeStamp", 93, "????");
        this.m_columnInfo[1][0] = new ColumnInfo(4, "employeeID", "ID", 4, "????");
        this.m_columnInfo[1][1] = new ColumnInfo(4, "hoursWorked", "Hours Worked", 4, "????");
    }

    protected int _tableForName(String name) {
        for (int index = 0; index < m_tableNames.length; ++index) {
            if (!name.equals(m_tableNames[index])) continue;
            return index;
        }
        return 0;
    }

    static {
        bundle = new QueryResource(DummyDataSource.class);
    }

    public class DummyDataSourceTable
    extends DataSourceTable {
        protected DataSourceColumnList m_columnList = null;
        protected int m_tableIndex;

        public DummyDataSourceTable(int tableIndex) {
            this.m_tableIndex = tableIndex;
        }

        @Override
        public void initialize() {
        }

        @Override
        public RelationshipList getRelationships() {
            return null;
        }

        @Override
        public String getName() {
            return m_tableNames[this.m_tableIndex];
        }

        @Override
        public String getQualifiedName() {
            return this.getName();
        }

        @Override
        public DataSourceContainer getParent() {
            return DummyDataSource.this;
        }

        @Override
        public int getColumnCount() {
            return m_cColumnsInTable[this.m_tableIndex];
        }

        @Override
        public DataSourceColumnList getColumns() {
            if (this.m_columnList == null) {
                this.m_columnList = new DataSourceColumnList(this.getColumnCount());
                for (int index = 0; index < this.getColumnCount(); ++index) {
                    this.m_columnList.addElement(new DummyDataSourceColumn(index));
                }
            }
            return this.m_columnList;
        }

        public class DummyDataSourceColumn
        extends DataSourceColumn {
            protected int m_nColumn;

            public DummyDataSourceColumn(int nColumn) {
                this.m_nColumn = nColumn;
            }

            @Override
            public String getQualifiedName() {
                return this.getParent().getQualifiedName() + "." + this.getName();
            }

            @Override
            public DataSourceTable getParent() {
                return DummyDataSourceTable.this;
            }

            @Override
            public String getLabel() {
                return DummyDataSource.this.m_columnInfo[DummyDataSourceTable.this.m_tableIndex][this.m_nColumn].getLabel();
            }

            @Override
            public String getName() {
                return DummyDataSource.this.m_columnInfo[DummyDataSourceTable.this.m_tableIndex][this.m_nColumn].getName();
            }

            @Override
            public int getSqlType() {
                return DummyDataSource.this.m_columnInfo[DummyDataSourceTable.this.m_tableIndex][this.m_nColumn].getType();
            }

            @Override
            public boolean isNullable() {
                return this.m_nColumn % 2 != 0;
            }

            @Override
            public int getLength() {
                return DummyDataSource.this.m_columnInfo[DummyDataSourceTable.this.m_tableIndex][this.m_nColumn].getLength();
            }

            @Override
            public String getFormat() {
                return DummyDataSource.this.m_columnInfo[DummyDataSourceTable.this.m_tableIndex][this.m_nColumn].getFormat();
            }

            @Override
            public boolean supportsDistinctValues() {
                return true;
            }

            @Override
            public Vector getDistinctValues() {
                return this.getDistinctValueSet(DummyDataSource.this.getMaximumSetSize());
            }

            @Override
            public Vector getNextValueSet(int nSetSize) {
                return null;
            }

            @Override
            public boolean isThereAnotherDistinctValue() {
                return false;
            }

            @Override
            public Vector getDistinctValueSet(int nSetSize) {
                if (this.supportsDistinctValues()) {
                    Vector<String> distinctValuesList = new Vector<String>();
                    if (this.getSqlType() == 12) {
                        distinctValuesList.addElement("Fred");
                        distinctValuesList.addElement("Barney");
                        distinctValuesList.addElement("Wilma");
                        distinctValuesList.addElement("Betty");
                        distinctValuesList.addElement("Dino");
                        distinctValuesList.addElement("Pebbles");
                    } else if (this.getSqlType() == 4) {
                        distinctValuesList.addElement("3.1417");
                        distinctValuesList.addElement("5.125");
                        distinctValuesList.addElement("8.166666");
                        distinctValuesList.addElement("10");
                        distinctValuesList.addElement("100");
                        distinctValuesList.addElement("1000");
                        distinctValuesList.addElement("10000");
                        distinctValuesList.addElement("100000");
                        distinctValuesList.addElement("1000000");
                        distinctValuesList.addElement("10000000");
                    } else if (this.getSqlType() == 91) {
                        distinctValuesList.addElement("17Mar1990");
                        distinctValuesList.addElement("20Jun1991");
                        distinctValuesList.addElement("12Sep1964");
                        distinctValuesList.addElement("27Nov1962");
                        distinctValuesList.addElement("21Sep1946");
                        distinctValuesList.addElement("13Sep1999");
                    } else if (this.getSqlType() == 92) {
                        distinctValuesList.addElement("9:30");
                        distinctValuesList.addElement("12:21:04");
                        distinctValuesList.addElement("23:35");
                        distinctValuesList.addElement("7:35");
                    } else if (this.getSqlType() == 93) {
                        distinctValuesList.addElement("17Mar1990:12:30:45.5");
                        distinctValuesList.addElement("20Jun1991:05:30:21");
                        distinctValuesList.addElement("12Sep1964:16:46");
                        distinctValuesList.addElement("27Nov1962:07:00:00.0");
                        distinctValuesList.addElement("21Sep1946:15:17:38.9");
                        distinctValuesList.addElement("13Sep1999:12:30:45.5");
                    }
                    return distinctValuesList;
                }
                DummyDataSource.this.m_messages.addError(bundle, "Message.DummyDataSource.throwRuntimeExc");
                return null;
            }
        }
    }

    public class ColumnInfo {
        protected int m_length;
        protected String m_name;
        protected String m_label;
        protected int m_type;
        protected String m_format;

        public ColumnInfo() {
        }

        public ColumnInfo(int length, String name, String label, int type, String format) {
            this.m_length = length;
            this.m_name = name;
            this.m_label = label;
            this.m_type = type;
            this.m_format = format;
        }

        public int getLength() {
            return this.m_length;
        }

        public String getName() {
            return this.m_name;
        }

        public String getLabel() {
            return this.m_label;
        }

        public int getType() {
            return this.m_type;
        }

        public String getFormat() {
            return this.m_format;
        }
    }

    public class TableInfo {
        protected String m_name;
        protected String m_label;

        public TableInfo() {
        }

        public TableInfo(String name, String label) {
            this.m_name = name;
            this.m_label = label;
        }

        public String getName() {
            return this.m_name;
        }

        public String getLabel() {
            return this.m_label;
        }
    }
}

