/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.DataSourceColumn;
import com.sas.query.datasources.DataSourceColumnList;
import com.sas.query.datasources.DataSourceContainer;
import com.sas.query.datasources.DataSourceContainerList;
import com.sas.query.datasources.RelationshipList;

public abstract class DataSourceTable
extends DataSourceContainer {
    protected boolean m_bIsView = false;
    protected String m_nonPasswordDataOptions = "";
    protected boolean m_pwRead = false;
    protected boolean m_pwWrite = false;
    protected boolean m_pwAlter = false;

    public boolean getReadPassword() {
        return this.m_pwRead;
    }

    public boolean getWritePassword() {
        return this.m_pwWrite;
    }

    public boolean getAlterPassword() {
        return this.m_pwAlter;
    }

    public boolean isPasswordSet() {
        return this.getDataSource().isPasswordSet(this);
    }

    public void addPassword(String password) {
        this.getDataSource().addPassword(this, password);
    }

    public void clearPassword() {
        this.getDataSource().clearPassword(this);
    }

    public boolean isView() {
        return this.m_bIsView;
    }

    public abstract RelationshipList getRelationships();

    public void setTableOptions(String dsoptions) {
        int end;
        int start;
        this.clearPassword();
        String temp = dsoptions.toUpperCase();
        String remainingOptions = dsoptions;
        if (temp.indexOf("PW=") >= 0) {
            remainingOptions = "";
            start = temp.indexOf("PW=");
            end = temp.indexOf(32, start + 1);
            String password = "";
            password = end > -1 ? dsoptions.substring(start + 3, end) : dsoptions.substring(start + 3);
            this.addPassword(password);
            if (start > 0) {
                remainingOptions = dsoptions.substring(0, start);
            }
            if (end > -1 && dsoptions.substring(end).trim().length() > 0) {
                remainingOptions = remainingOptions + dsoptions.substring(end);
            }
        }
        this.m_nonPasswordDataOptions = remainingOptions.trim();
        temp = this.m_nonPasswordDataOptions.toUpperCase();
        if (temp.indexOf("READ=") >= 0) {
            start = temp.indexOf("READ=");
            end = temp.indexOf(32, start + 1);
            String readpassword = "";
            readpassword = end > -1 ? this.m_nonPasswordDataOptions.substring(start + 5, end) : this.m_nonPasswordDataOptions.substring(start + 5);
            this.clearPassword();
            this.addPassword(readpassword);
        }
    }

    public String getTableOptions() {
        return this.m_nonPasswordDataOptions;
    }

    public Object getUnderlyingTable() {
        return null;
    }

    public abstract int getColumnCount();

    public abstract DataSourceColumnList getColumns();

    public DataSourceColumn getColumn(String strColumnName) {
        DataSourceColumnList columns = this.getColumns();
        for (int index = 0; index < columns.size(); ++index) {
            if (!columns.elementAt(index).getName().equals(strColumnName)) continue;
            return columns.elementAt(index);
        }
        return null;
    }

    @Override
    public int getItemCount() {
        return 0;
    }

    @Override
    public String[] getItemNames() {
        return null;
    }

    @Override
    public DataSourceContainerList getItems() {
        return null;
    }

    public DataSource getDataSource() {
        DataSourceContainer parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof DataSource); parent = parent.getParent()) {
        }
        return (DataSource)parent;
    }
}

