/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.datasources;

import com.sas.query.datasources.DataSourceTable;
import com.sas.query.models.ColumnInterface;
import com.sas.query.models.ExpressionConstants;
import java.util.Vector;

public abstract class DataSourceColumn
implements ColumnInterface,
ExpressionConstants {
    public abstract String getQualifiedName();

    public String toString() {
        return this.getName();
    }

    public abstract DataSourceTable getParent();

    @Override
    public int getDataType() {
        return DataSourceColumn._mapSqlTypeToExpressionType(this.getSqlType());
    }

    @Override
    public abstract int getSqlType();

    public Object getUnderlyingColumn() {
        return null;
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public boolean isIndexed() {
        return false;
    }

    @Override
    public String getLabel() {
        return null;
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public String getInformat() {
        return null;
    }

    @Override
    public boolean supportsDistinctValues() {
        return false;
    }

    @Override
    public Vector getDistinctValues() {
        return null;
    }

    @Override
    public Vector getDistinctValueSet(int nSetSize) {
        return null;
    }

    @Override
    public Vector getNextValueSet(int nSetSize) {
        return null;
    }

    @Override
    public boolean isThereAnotherDistinctValue() {
        return false;
    }

    public static int _mapSqlTypeToExpressionType(int sqlType) {
        int retType = 0;
        switch (sqlType) {
            case -7: {
                retType = 1;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                retType = 4;
                break;
            }
            case 9: 
            case 91: {
                retType = 16;
                break;
            }
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                retType = 2;
                break;
            }
            case 10: 
            case 92: {
                retType = 32;
                break;
            }
            case 11: 
            case 93: {
                retType = 64;
                break;
            }
            default: {
                retType = 0;
            }
        }
        return retType;
    }
}

