/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.app;

import com.sas.query.Query;
import com.sas.query.datasources.WebAfDataSource;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.Table;
import com.sas.rmi.Connection;
import com.sas.rmi.Rocf;
import com.sas.sasserver.librarylist.LibraryListInterface;
import com.sas.sasserver.sasfilelist.DataSetListInterface;
import java.util.Enumeration;
import java.util.Vector;

public class RocfDriver {
    Rocf m_rocf;
    Connection m_connection;
    Vector dataSetVector = new Vector();

    public void run() {
        try {
            this.doConnect();
            String dataSetName = this.chooseDatasetName();
            MessageHandler messages = new MessageHandler();
            WebAfDataSource dso = new WebAfDataSource(this.m_connection, messages);
            Query query = new Query(dso);
            Table table = query.addTable(dataSetName);
            query.addResultItems(table);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public String chooseDatasetName() throws Exception {
        Class<DataSetListInterface> dli = DataSetListInterface.class;
        Class<LibraryListInterface> lli = LibraryListInterface.class;
        DataSetListInterface dsList = (DataSetListInterface)this.m_rocf.newInstance(dli, this.m_connection);
        LibraryListInterface libList = (LibraryListInterface)this.m_rocf.newInstance(lli, this.m_connection);
        Enumeration libs = libList.getItems();
        while (libs.hasMoreElements()) {
            String curLib = (String)libs.nextElement();
            this.loadLibrary(dsList, curLib);
        }
        return "SASHELP.VTABLE";
    }

    private void loadLibrary(DataSetListInterface dsi, String librefName) {
        dsi.setLibrary(librefName);
        Enumeration dataSets = dsi.getItems();
        while (dataSets.hasMoreElements()) {
            this.dataSetVector.addElement((String)dataSets.nextElement());
        }
    }

    private void doConnect() throws Exception {
        this.m_rocf = new Rocf();
        this.m_connection = new Connection();
        this.m_connection.setLogTrap(true);
        this.m_connection.setHost("dbipc7.us.sas.com");
        this.m_connection.connect();
        this.m_rocf.connect(this.m_connection);
    }

    public static void main(String[] args) {
        RocfDriver r = new RocfDriver();
        r.run();
    }
}

