/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.app;

import com.sas.query.Query;
import com.sas.query.app.AppSupport;
import com.sas.query.app.ExitLater;
import com.sas.query.app.SplashThread;
import com.sas.query.datasources.DataSource;
import com.sas.query.models.ConnectionHandler;
import com.sas.query.models.DefinedConnection;
import com.sas.query.models.MessageHandler;
import com.sas.query.models.ModelChangeEvent;
import com.sas.query.models.XmlUtil;
import com.sas.query.visuals.MessageUtil;
import com.sas.query.visuals.OpenQueryDialog;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.QueryTabView;
import com.sas.query.visuals.ResultPanel;
import com.sas.query.visuals.SqlPanel;
import com.sas.query.visuals.StandardApplet;
import com.sas.query.visuals.WindowUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class QueryTestApp3
extends StandardApplet
implements PropertyChangeListener {
    protected static QueryResource bundle = new QueryResource(QueryTestApp3.class);
    DefinedConnection m_connection;
    DataSource m_dataSource;
    protected MessageHandler m_messages;
    protected JFrame m_frame;
    protected QueryTabView m_tabbedView;
    protected JPanel m_mainPanel;
    protected JTabbedPane m_unionPane;
    protected ResultPanel m_unionResultPanel;
    protected SqlPanel m_unionSqlPanel;
    protected Hashtable m_menuItems;
    protected JMenuBar m_menubar;
    protected JToolBar m_toolbar;
    protected boolean m_bIsApplet = false;
    protected Vector m_viewList = new Vector();
    protected transient AppSupport m_appSupport;

    public static Query promptForQuery(MessageHandler messages) {
        OpenQueryDialog dialog = new OpenQueryDialog(null, messages, bundle.getString("QueryTestApp3.helpSetLocation.txt"));
        dialog.show();
        if (dialog.getDataSource() == null) {
            return null;
        }
        if (dialog.getQuery() == null) {
            return new Query(dialog.getDataSource(), messages);
        }
        return dialog.getQuery();
    }

    public QueryTestApp3() {
        super((Query)null);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.m_appSupport.shutdown();
    }

    @Override
    public void init() {
        MessageHandler messages = new MessageHandler();
        SplashThread splashThread = null;
        this.m_bIsApplet = true;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exc) {
            messages.addInternalError(bundle.messageString("errorLoadLookAndFeel.txt", exc));
        }
        try {
            this.m_query = QueryTestApp3.promptForQuery(messages);
            if (this.m_query == null) {
                messages.addError(bundle, "noOpenDSource");
            }
            if (MessageUtil.displayMessagesAndCheckForErrors(messages)) {
                this.getContentPane().add(new JLabel(bundle.messageString("noOpenDSource")));
                return;
            }
            splashThread = new SplashThread();
            splashThread.start();
            this.m_appSupport = new AppSupport(this.m_query, null);
            this.m_appSupport.addPropertyChangeListener(this);
            DataSource dataSource = this.m_query.getDataSource();
            this.initialize(this.m_query, dataSource, messages);
        }
        catch (Throwable t) {
            messages.addInternalError(bundle.messageString("uncaughtException.ex.fmt.txt", t));
            t.printStackTrace();
        }
        if (splashThread != null) {
            splashThread.appletStop();
            splashThread = null;
        }
    }

    public QueryTestApp3(JFrame frame, Query query, DataSource dataSource, MessageHandler messages) {
        super(query);
        this.m_frame = frame;
        this.setupHelp(query);
        this.m_appSupport = new AppSupport(this.m_query, frame);
        this.m_appSupport.addPropertyChangeListener(this);
        this.initialize(query, dataSource, messages);
    }

    public void initialize(Query query, DataSource dataSource, MessageHandler messages) {
        this.m_dataSource = dataSource;
        this.m_messages = messages;
        query.addPropertyListener(this, 512);
        query.addPropertyListener(this, 65535);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setBackground(Color.lightGray);
        try {
            this.m_mainPanel = new JPanel();
            this.m_mainPanel.setLayout(new BorderLayout());
            JPanel menuPanel = this.m_appSupport.getMenuPanel(bundle.getString("menubarKeyString"), bundle.getString("toolbarKeyString"));
            this.getContentPane().add("North", menuPanel);
            this.m_tabbedView = new QueryTabView(this.m_query);
            this.m_viewList.addElement(this.m_tabbedView);
            this.m_tabbedView.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            this.m_mainPanel.add("Center", this.m_tabbedView);
            this.getContentPane().add("Center", this.m_mainPanel);
            this.m_appSupport.setTabbedView(this.m_tabbedView);
            this._setState();
        }
        catch (Throwable t) {
            messages.addInternalError(bundle.messageString("uncaughtException.ex.fmt.txt", t));
            t.printStackTrace();
        }
    }

    private void setupHelp(Query query) {
        HelpSet hs = null;
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)bundle.getString("QueryTestApp3.helpSetLocation.txt"));
            if (url != null) {
                hs = new HelpSet(cl, url);
            }
        }
        catch (Throwable cl) {
            // empty catch block
        }
        HelpBroker m_hb = null;
        if (hs != null) {
            m_hb = hs.createHelpBroker();
            this.m_query.registerHelpBroker(m_hb);
        }
        this.m_query.enableHelpKey(this.m_frame.getRootPane(), "top");
    }

    @Override
    public void closing() {
    }

    public static void main(String[] args) {
        Query query = null;
        MessageHandler messages = new MessageHandler();
        SplashThread splashThread = null;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exc) {
            messages.addInternalError(bundle.messageString("errorLoadLookAndFeel.txt", exc));
        }
        for (int index = 0; index < args.length; ++index) {
            if (!args[index].equalsIgnoreCase("-filename")) continue;
            if (index + 1 <= args.length) {
                String path = args[index + 1];
                if (QueryTestApp3._verifyPath(path, messages)) {
                    splashThread = new SplashThread();
                    splashThread.start();
                    query = QueryTestApp3.readQueryFromFile(path, query, messages);
                }
                if (MessageUtil.displayMessagesAndCheckForErrors(messages)) {
                    if (splashThread != null) {
                        splashThread.interrupt();
                    }
                    new ExitLater(0);
                    return;
                }
            }
            ++index;
        }
        try {
            if (query == null) {
                query = QueryTestApp3.promptForQuery(messages);
            }
            if (query == null) {
                messages.addError(bundle, "App.Message.NoOpenDataSource.txt");
            }
            if (MessageUtil.displayMessagesAndCheckForErrors(messages)) {
                new ExitLater(0);
                return;
            }
            if (splashThread == null) {
                splashThread = new SplashThread();
                splashThread.start();
            }
            JFrame frame = new JFrame();
            DataSource m_dataSource = query.getDataSource();
            QueryTestApp3 queryTest = new QueryTestApp3(frame, query, m_dataSource, messages);
            frame.setBackground(Color.lightGray);
            frame.getContentPane().add("Center", queryTest);
            frame.pack();
            frame.setSize(WindowUtil.getBestWindowSize(new Dimension(868, 540)));
            frame.setTitle(bundle.messageString("QueryTestApp3.Title.txt"));
            WindowUtil.center(frame);
            frame.show();
        }
        catch (Throwable t) {
            messages.addInternalError(bundle.messageString("uncaughtException.ex.fmt.txt", t));
            t.printStackTrace();
        }
        if (splashThread != null) {
            splashThread.interrupt();
            splashThread = null;
        }
    }

    protected static boolean _verifyPath(String path, MessageHandler messages) {
        String separator = System.getProperty("file.separator");
        String os = System.getProperty("os.name");
        String laxCheck = System.getProperty("lax.nl.env.path");
        if (laxCheck != null && os.startsWith("Windows") && path.indexOf(separator) == path.lastIndexOf(separator)) {
            messages.addError(bundle, "unableToOpenFiles.txt");
            return false;
        }
        return true;
    }

    public void refreshUnions() {
        if (this.getQuery().getUnion() == null) {
            return;
        }
        for (Query query = this.m_query = this.getQuery().getPrimaryQuery(); query != null; query = query.getUnion()) {
            boolean bExists = false;
            for (int index = 0; index < this.m_viewList.size(); ++index) {
                if (((QueryTabView)this.m_viewList.elementAt(index)).getQuery() != query) continue;
                bExists = true;
                break;
            }
            if (bExists) continue;
            int tabCount = this.m_unionPane.getTabCount();
            this.m_unionPane.removeTabAt(tabCount - 1);
            this.m_unionPane.removeTabAt(tabCount - 2);
            QueryTabView view = new QueryTabView(query);
            this.m_unionPane.addTab("Select " + this.m_unionPane.getTabCount(), view);
            this.m_viewList.addElement(view);
            query.addPropertyListener(this, 512);
            query.addPropertyListener(this, 65535);
            this.m_unionPane.addTab("Results", this.m_unionResultPanel);
            this.m_unionPane.addTab("SQL", this.m_unionSqlPanel);
        }
    }

    protected void _setState() {
        if (this.m_unionPane != null) {
            // empty if block
        }
        if (this.m_tabbedView != null) {
            this.m_tabbedView.setState();
        }
    }

    @Override
    public void modelChangeCallback(ModelChangeEvent event) {
        if (event.isStructureChange() && event.didThisStructureAreaChange(512)) {
            this.refreshUnions();
        }
        this._setState();
    }

    protected static Query readQueryFromFile(String path, Query query, MessageHandler messages) {
        try {
            query = XmlUtil.readXml(path, query, messages);
            messages.firePropertyChanges();
            if (messages.failureHasOccurred() && query != null && query.getDataSource() != null) {
                MessageUtil.displayMessages(messages);
            }
        }
        catch (Exception exception) {
            messages.addInternalError(exception);
        }
        return query;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.m_appSupport && ("fileSave".equals(event.getPropertyName()) || "fileSaveAsView".equals(event.getPropertyName()))) {
            String type = "fileSave".equals(event.getPropertyName()) ? "File" : "View";
            ConnectionHandler.addRecentQuery(this.m_query.getDataSource().getName(), (String)event.getNewValue(), type, this.m_messages);
        }
    }
}

