/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query.app;

import com.sas.query.Query;
import com.sas.query.QueryDefiner;
import com.sas.query.app.QueryTestApp;
import com.sas.query.app.StatusBar;
import com.sas.query.app.WatcherDialog;
import com.sas.query.datasources.DataSource;
import com.sas.query.datasources.DataSourceList;
import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.MenuUtil;
import com.sas.query.visuals.MessageUtil;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.ResultDialog;
import com.sas.query.visuals.SummaryView;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class QueryFrame
extends JInternalFrame {
    private static QueryResource resources = new QueryResource(QueryFrame.class);
    protected static QueryResource bundle = new QueryResource(QueryFrame.class);
    protected QueryTestApp m_controller;
    protected Frame m_parentFrame;
    protected DataSource m_dso;
    protected Query m_query;
    protected MessageHandler m_messages = new MessageHandler();
    protected JTabbedPane m_tabbedPane;
    protected JPanel m_panel;
    protected JPanel m_spacerPanel;
    protected Hashtable menuItems;
    protected JMenuBar menubar;
    protected JToolBar toolbar;
    protected StatusBar status;
    private Hashtable m_commands;
    protected FileDialog m_fileDialog = null;
    protected Dialog m_sqlDialog = null;
    protected Dialog m_watchDialog = null;
    public static final String newAction = "new";
    public static final String helpAction = "help";
    public static final String exitAction = "exit";
    public static final String setDataSourceAction = "setDataSource";
    public static final String mapDriveAction = "mapDrive";
    public static final String unmapDriveAction = "unmapDrive";
    public static final String undoAction = "undo";
    public static final String deleteAction = "delete";
    public static final String propertiesAction = "properties";
    public static final String largeIconsAction = "largeIcons";
    public static final String smallIconsAction = "smallIcons";
    public static final String listAction = "list";
    public static final String detailsAction = "details";
    public static final String insertResultItemAction = "insertResultItem";
    public static final String insertTableAction = "insertTable";
    public static final String fileOpenAction = "fileOpen";
    public static final String fileSaveAction = "fileSave";
    public static final String viewSqlAction = "viewSql";
    public static final String viewWatchAction = "viewWatch";
    public static final String makeUnionAction = "makeUnion";
    private Action[] m_defaultActions = new Action[]{new NewAction(), new FileOpenAction(), new FileSaveAction(), new ViewSqlAction(), new ViewWatchAction(), new MakeUnionAction(), new ExitAction(), new SetDatasourceAction(), new MapDriveAction(), new UnmapDriveAction(), new UndoAction(), new DeleteAction(), new PropertiesAction(), new LargeIconsAction(), new SmallIconsAction(), new ListAction(), new DetailsAction(), new InsertTableAction(), new InsertResultItemAction()};

    QueryFrame(QueryTestApp testApp, Query query) {
        super("title", true, true, true, true);
        this.m_controller = testApp;
        this.m_query = query;
        this.m_dso = query.getDataSource();
        this.m_parentFrame = this.m_controller.getFrame();
        this.m_commands = new Hashtable();
        Action[] actions = this.m_defaultActions;
        for (int i = 0; i < actions.length; ++i) {
            Action a = actions[i];
            this.m_commands.put(a.getValue("Name"), a);
        }
        this.menuItems = new Hashtable();
        this.menubar = MenuUtil.createMenubar(resources, "menubar", this.menuItems, this.m_commands);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.m_spacerPanel = this.createQueryView(this.getQuery());
        this.m_panel = new JPanel();
        this.m_panel.setLayout(new BorderLayout());
        this.m_panel.add("Center", this.m_spacerPanel);
        JToolBar toolbar = MenuUtil.createToolbar(resources, "toolbar", this.m_commands);
        for (int index = 0; index < toolbar.getComponentCount(); ++index) {
            if (!(toolbar.getComponentAtIndex(index) instanceof JComboBox)) continue;
            JComboBox combo = (JComboBox)toolbar.getComponentAtIndex(index);
            DataSourceList dataSourceList = this.m_controller.getDataSources();
            for (int dsIndex = 0; dsIndex < dataSourceList.size(); ++dsIndex) {
                combo.addItem(dataSourceList.elementAt(dsIndex).getName());
            }
            combo.addItem("<new connection>");
        }
        JPanel menuPanel = new JPanel();
        menuPanel.setLayout(new BorderLayout());
        menuPanel.add("North", this.menubar);
        menuPanel.add("Center", toolbar);
        this.m_panel.add("North", menuPanel);
        contentPane.add("Center", this.m_panel);
        contentPane.add("South", this.createStatusbar());
        this.pack();
        this.setSize(550, 300);
        this.setTitle("Query Test One");
        this.addFocusListener(new FocusHandler());
        this.m_controller.setCurrentQuery(this.m_query);
        this.addInternalFrameListener(new FrameListener(this));
    }

    public JPanel createQueryView(Query query) {
        JTabbedPane tabbedPane = new JTabbedPane();
        try {
            tabbedPane.addTab("Query", new QueryDefiner(query, 290, 0));
            tabbedPane.addTab("Data Filters", new QueryDefiner(query, 65, 0));
            tabbedPane.addTab("Group Filters", new Label("Not implemented"));
            tabbedPane.setEnabledAt(2, false);
            tabbedPane.addTab("Summary", new SummaryView(query));
        }
        catch (Throwable t) {
            query.getMessageHandler().addInternalError(bundle.messageString("uncaughtException.ex.fmt.txt", t));
            t.printStackTrace();
        }
        JPanel spacerPanel = new JPanel();
        spacerPanel.setLayout(new BorderLayout());
        spacerPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        spacerPanel.add("Center", tabbedPane);
        return spacerPanel;
    }

    protected MenuItem getMenuItem(String cmd) {
        return (MenuItem)this.menuItems.get(cmd);
    }

    protected Action getAction(String cmd) {
        return (Action)this.m_commands.get(cmd);
    }

    protected Container getToolbar() {
        return this.toolbar;
    }

    protected JMenuBar getMenubar() {
        return this.menubar;
    }

    protected Query getQuery() {
        return this.m_query;
    }

    protected StatusBar createStatusbar() {
        this.status = new StatusBar();
        return this.status;
    }

    public void closeWindow() {
        int nChoice = JOptionPane.showConfirmDialog(null, bundle.messageString("saveChangesTo.txt"), "Exit QueryTestApp", 1, 2);
        if (nChoice == 0) {
            this.m_controller.saveQueryToFile(this.m_query);
        } else if (nChoice == 2 || nChoice == -1) {
            return;
        }
        this.dispose();
    }

    class InsertResultItemAction
    extends AbstractAction {
        InsertResultItemAction() {
            super(QueryFrame.insertResultItemAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryFrame.this.m_controller.insertResultItem();
        }
    }

    class InsertTableAction
    extends AbstractAction {
        InsertTableAction() {
            super(QueryFrame.insertTableAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryFrame.this.m_controller.insertTable();
        }
    }

    class DetailsAction
    extends AbstractAction {
        DetailsAction() {
            super(QueryFrame.detailsAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryFrame.this.m_controller.shutdown();
        }
    }

    class ListAction
    extends AbstractAction {
        ListAction() {
            super(QueryFrame.listAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryFrame.this.m_controller.shutdown();
        }
    }

    class SmallIconsAction
    extends AbstractAction {
        SmallIconsAction() {
            super(QueryFrame.smallIconsAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryFrame.this.m_controller.shutdown();
        }
    }

    class LargeIconsAction
    extends AbstractAction {
        LargeIconsAction() {
            super(QueryFrame.largeIconsAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryFrame.this.m_controller.shutdown();
        }
    }

    class PropertiesAction
    extends AbstractAction {
        PropertiesAction() {
            super(QueryFrame.propertiesAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryFrame.this.m_controller.shutdown();
        }
    }

    class DeleteAction
    extends AbstractAction {
        DeleteAction() {
            super(QueryFrame.deleteAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryFrame.this.m_controller.shutdown();
        }
    }

    class UndoAction
    extends AbstractAction {
        UndoAction() {
            super(QueryFrame.undoAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryFrame.this.m_controller.shutdown();
        }
    }

    class UnmapDriveAction
    extends AbstractAction {
        UnmapDriveAction() {
            super(QueryFrame.unmapDriveAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryFrame.this.m_controller.shutdown();
        }
    }

    class MapDriveAction
    extends AbstractAction {
        MapDriveAction() {
            super(QueryFrame.mapDriveAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryFrame.this.m_controller.shutdown();
        }
    }

    class SetDatasourceAction
    extends AbstractAction
    implements ItemListener {
        SetDatasourceAction() {
            super(QueryFrame.setDataSourceAction);
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1) {
                DataSourceList dataSourceList = QueryFrame.this.m_controller.getDataSources();
                for (int index = 0; index < dataSourceList.size(); ++index) {
                    if (!((String)event.getItem()).equals(dataSourceList.elementAt(index).getName())) continue;
                    return;
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.out.println(e);
        }
    }

    class ExitAction
    extends AbstractAction {
        ExitAction() {
            super(QueryFrame.exitAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryFrame.this.m_controller.shutdown();
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            super(QueryFrame.helpAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(null, bundle.messageString("noHelpAvailable.txt"), "Explorer Help", 0);
        }
    }

    class NewAction
    extends AbstractAction {
        NewAction() {
            super(QueryFrame.newAction);
        }

        NewAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryFrame.this.m_controller.showNewQuery(null);
        }
    }

    class MakeUnionAction
    extends NewAction {
        MakeUnionAction() {
            super(QueryFrame.makeUnionAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (QueryFrame.this.getQuery().getUnion() != null) {
                return;
            }
            Query newQuery = new Query(QueryFrame.this.m_dso, QueryFrame.this.m_messages);
            QueryFrame.this.getQuery().addUnion(newQuery, 0);
            QueryFrame.this.m_panel.remove(QueryFrame.this.m_spacerPanel);
            JTabbedPane unionPane = new JTabbedPane();
            unionPane.addTab("Union", new JLabel("union"));
            unionPane.addTab("Select 1", QueryFrame.this.m_spacerPanel);
            unionPane.addTab("Select 2", QueryFrame.this.createQueryView(newQuery));
            unionPane.addTab("Result Order", new QueryDefiner(QueryFrame.this.getQuery(), 72, 0));
            JPanel spacerPanel = new JPanel();
            spacerPanel.setLayout(new BorderLayout());
            spacerPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            spacerPanel.add("Center", unionPane);
            MessageUtil.displayMessages(QueryFrame.this.m_messages);
            QueryFrame.this.m_panel.add(spacerPanel);
            QueryFrame.this.m_panel.doLayout();
            QueryFrame.this.m_panel.validate();
            QueryFrame.this.m_panel.repaint();
        }
    }

    class ViewWatchAction
    extends NewAction {
        ViewWatchAction() {
            super(QueryFrame.viewWatchAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryFrame.this.m_watchDialog = new WatcherDialog(QueryFrame.this.m_query, QueryFrame.this.m_parentFrame, false);
            QueryFrame.this.m_watchDialog.show();
        }
    }

    class ViewSqlAction
    extends NewAction {
        ViewSqlAction() {
            super(QueryFrame.viewSqlAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryFrame.this.m_sqlDialog = new ResultDialog(QueryFrame.this.m_query, QueryFrame.this.m_parentFrame, false);
            QueryFrame.this.m_sqlDialog.show();
        }
    }

    class FileSaveAction
    extends AbstractAction {
        FileSaveAction() {
            super(QueryFrame.fileSaveAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    class FileOpenAction
    extends NewAction {
        FileOpenAction() {
            super(QueryFrame.fileOpenAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryFrame.this.m_controller.readQueryFromFile();
        }
    }

    protected static final class FrameListener
    extends InternalFrameAdapter {
        QueryFrame m_frame;

        public FrameListener(QueryFrame frame) {
            this.m_frame = frame;
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent e) {
            this.m_frame.closeWindow();
        }
    }

    class FocusHandler
    implements FocusListener {
        FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            QueryFrame.this.m_controller.setCurrentQuery(QueryFrame.this.m_query);
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

