/*
 * Decompiled with CFR 0.152.
 */
package com.sas.query;

import com.sas.query.Query;
import com.sas.query.QueryString;
import com.sas.query.datasources.DataSource;
import com.sas.query.models.MessageHandler;
import com.sas.query.visuals.MessageUtil;
import com.sas.query.visuals.QueryResource;
import com.sas.query.visuals.QueryTabView;
import com.sas.query.visuals.StandardDialog;
import com.sas.query.visuals.WindowUtil;
import com.sas.rmi.Connection;
import com.sas.visuals.MessageBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class JQueryDialog
extends StandardDialog {
    protected transient QueryString m_queryString;
    private transient QueryTabView m_viewer;
    private transient boolean m_showLabels;
    private transient boolean m_allowAdvancedJoins;
    private transient Query m_queryCopy;
    static final String RB_KEY = "JQueryDialog.";
    static QueryResource bundle = new QueryResource(JQueryDialog.class);

    public JQueryDialog(Frame parentFrame, Connection conn, String title) {
        super(parentFrame, true);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.updateComponentTreeUI(this);
        this.invalidate();
        this.validate();
        this.repaint();
        this.setConnection(conn);
        this.setTitle(title);
        this.pack();
    }

    public JQueryDialog(Frame parentFrame, QueryString qString, String title) {
        super(parentFrame, true);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.updateComponentTreeUI(this);
        this.invalidate();
        this.validate();
        this.repaint();
        this.setQueryString(qString);
        this.setTitle(title);
        this.setSize(this.getPreferredSize());
        this.pack();
    }

    @Override
    public void setVisible(boolean isVisible) {
        boolean isConn = this.m_queryString.getConnection().isConnected();
        if (this.m_queryCopy != null && isConn) {
            super.setVisible(isVisible);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return WindowUtil.getBestWindowSize(new Dimension(850, 512));
    }

    private void _initialize() {
        try {
            if (this.m_queryCopy == null) {
                this.m_queryString.connect();
                this.m_query = this.m_queryString.getQuery();
                if (this.m_query != null) {
                    DataSource dso = this.m_query.getDataSource();
                    int limits = this.m_query.getLimits();
                    this.m_queryCopy = new Query(dso, limits);
                } else {
                    this.displayMsg(bundle.messageString("JQueryDialog.NoConnectionMessage.fmt.txt", this.m_queryString.getConnection().getHost()));
                }
            }
            if (this.m_queryCopy != null) {
                MessageHandler messages = this.m_queryCopy.getMessageHandler();
                this.m_queryCopy.clear();
                messages.firePropertyChanges();
                this.m_queryCopy.setSQL(this.m_queryString.getSQL());
                MessageUtil.displayMessages(messages);
                messages.firePropertyChanges();
                if (this.m_viewer == null) {
                    this.m_viewer = new QueryTabView(this.m_queryCopy);
                    this.setMainPanel(this.m_viewer);
                }
            }
        }
        catch (Exception e) {
            this.displayMsg(bundle.getString("JQueryDialog.QueryInitFailure.fmt.txt"));
        }
    }

    @Override
    public void onOK() {
        this.m_returnValue = 1;
        this.setVisible(false);
        this.m_queryString.setSQL(this.m_queryCopy.getSql());
    }

    public void setQueryString(QueryString queryString) {
        this.m_queryString = queryString;
        this._initialize();
    }

    public void setConnection(Connection conn) {
        QueryString queryString = new QueryString(conn, "");
        this.setQueryString(queryString);
    }

    public QueryString getQueryString() {
        return this.m_queryString;
    }

    public boolean isQueryTabVisible() {
        return this.m_viewer.isQueryTabVisible();
    }

    public boolean isDataFiltersTabVisible() {
        return this.m_viewer.isDataFiltersTabVisible();
    }

    public boolean isGroupFiltersTabVisible() {
        return this.m_viewer.isGroupFiltersTabVisible();
    }

    public boolean isResultsTabVisible() {
        return this.m_viewer.isResultsTabVisible();
    }

    public boolean isSQLTabVisible() {
        return this.m_viewer.isSQLTabVisible();
    }

    public boolean isAdvancedJoinsAllowed() {
        return this.m_allowAdvancedJoins;
    }

    public boolean areColumnLabelsUsed() {
        return this.m_showLabels;
    }

    public void setAdvancedJoinsAllowed(boolean allow) {
        this.m_allowAdvancedJoins = allow;
    }

    public void setShowLabels(boolean doShow) {
        this.m_showLabels = doShow;
    }

    public void setQueryTabVisible(boolean doShow) {
        this.m_viewer.setQueryTabVisible(doShow);
    }

    public void setDataFiltersTabVisible(boolean doShow) {
        this.m_viewer.setDataFiltersTabVisible(doShow);
    }

    public void setGroupFiltersTabVisible(boolean doShow) {
        this.m_viewer.setGroupFiltersTabVisible(doShow);
    }

    public void setResultsTabVisible(boolean doShow) {
        this.m_viewer.setResultsTabVisible(doShow);
    }

    public void setSQLTabVisible(boolean doShow) {
        this.m_viewer.setSQLTabVisible(doShow);
    }

    private void displayMsg(String text) {
        MessageBox.showModalMessageBox((Component)this.getParentFrame(), (String)text);
    }
}

