/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.util;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.webapp.servlet.util.ServletUtil;
import java.awt.Color;
import java.net.URL;
import java.util.List;

@SASScope
public class StyleSheetUtil {
    public static String findStyleAttributeInStyleSheet(String css, String styleName, String styleAttribute) {
        String style = StyleSheetUtil.findStyleDefinitionInStyleSheet(css, styleName);
        if (style == null) {
            return null;
        }
        return StyleSheetUtil.findStyleAttribute(style, styleAttribute);
    }

    public static String findStyleDefinitionInStyleSheet(String css, String styleName) {
        String style = StyleSheetUtil.findSubstring(css, styleName, "}");
        if (style == null) {
            return null;
        }
        int start = style.indexOf("{");
        if (start > 0) {
            style = style.substring(start + 1);
        }
        return style;
    }

    private static String findSubstring(String str, String startStr, String endStr) {
        int start = str.indexOf(startStr);
        if (start < 0) {
            return null;
        }
        int end = str.indexOf(endStr, start);
        if (end < 0) {
            return null;
        }
        String style = str.substring(start + startStr.length(), end - endStr.length() + 1);
        return style;
    }

    public static String findStyleAttribute(StyleInfo styleInfo, String styleName) {
        if (styleInfo == null) {
            return null;
        }
        String style = styleInfo.getStyle();
        if (style == null) {
            return null;
        }
        return StyleSheetUtil.findStyleAttribute(style, styleName);
    }

    public static String findStyleAttribute(String style, String styleName) {
        if (style == null) {
            return null;
        }
        styleName = styleName + ":";
        int i = 0;
        while (i >= 0 && i < style.length()) {
            int i2 = style.indexOf(59, i);
            String styleSetting = i2 < 0 ? style.substring(i) : style.substring(i, i2);
            if ((styleSetting = styleSetting.trim()).startsWith(styleName)) {
                return styleSetting.substring(styleName.length()).trim();
            }
            if (i2 < 0) {
                return null;
            }
            i = i2 + 1;
        }
        return null;
    }

    public static Color parseColor(String color) {
        if (color == null) {
            return null;
        }
        if (color.startsWith("#")) {
            return Color.decode(color);
        }
        if (color.startsWith("rgb")) {
            return StyleSheetUtil.parseRGB(color);
        }
        return null;
    }

    private static Color parseRGB(String color) {
        try {
            String rgb = StyleSheetUtil.findSubstring(color, "(", ")");
            int i0 = rgb.indexOf(",");
            if (i0 < 0) {
                return null;
            }
            int i1 = rgb.indexOf(",", i0 + 1);
            if (i1 < 0) {
                return null;
            }
            return new Color(StyleSheetUtil.parseRGB(rgb, 0, i0), StyleSheetUtil.parseRGB(rgb, i0 + 1, i1), StyleSheetUtil.parseRGB(rgb, i1 + 1, rgb.length()));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static int parseRGB(String rgb, int start, int end) {
        return Integer.parseInt(rgb.substring(start, end).trim());
    }

    public static String[] findStylesFromStyleSheets(ComponentPropertyManager cpm, List styleNames, String styleAttribute) {
        String[] ret = new String[styleNames.size()];
        List cssList = cpm.getStyleSheetList();
        String styleLocation = StyleSheetUtil.getStyleLocation(cpm);
        for (int i = cssList.size() - 1; i >= 0; --i) {
            String cssLocation = styleLocation + cssList.get(i);
            String css = StyleSheetUtil.readStyleSheet(cssLocation);
            if (css == null) continue;
            boolean done = true;
            for (int j = 0; j < styleNames.size(); ++j) {
                String val;
                if (ret[j] != null) continue;
                String styleName = (String)styleNames.get(j);
                ret[j] = val = styleAttribute != null ? StyleSheetUtil.findStyleAttributeInStyleSheet(css, styleName, styleAttribute) : StyleSheetUtil.findStyleDefinitionInStyleSheet(css, styleName);
                if (val != null) continue;
                done = false;
            }
            if (done) break;
        }
        return ret;
    }

    private static String readStyleSheet(String cssLocation) {
        try {
            String css = ServletUtil.getFileAsString(null, (URL)new URL(cssLocation));
            return css;
        }
        catch (Exception e) {
            CommonLoggerInterface log = LoggerRepository2.getLogger((String)StyleSheetUtil.class.getName(), null);
            log.warn(cssLocation, (Throwable)e);
            return null;
        }
    }

    private static String getStyleLocation(ComponentPropertyManager cpm) {
        String styleLocation = cpm.getStyleLocation();
        if (styleLocation.startsWith("/")) {
            String absPath = cpm.getAbsolutePath();
            int pathi = absPath.indexOf("//");
            pathi = absPath.indexOf("/", pathi + 2);
            absPath = absPath.substring(0, pathi);
            styleLocation = absPath + styleLocation;
        }
        return styleLocation;
    }
}

