/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.util;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.util.RB;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@SASScope(value="ALL")
public class StreamContentServlet
extends HttpServlet {
    public static final String CONTENT_KEY = "CONTENT_KEY";
    public static final String PERSISTENCE = "PERSISTENCE";
    public static final String NOOP = "NOOP";
    public static final String CONTENT_TYPE = "sas_StreamContentServlet_ContentType";
    public static final String CONTENT_DISPOSITION = "sas_StreamContentServlet_ContentDisposition";
    public static final String CONTENT_BYTES = "sas_StreamContentServlet_ContentBytes";
    public static final String DISPOSE_CONTENTS = "sas_StreamContentServlet_DisposeContents";
    public static final String RB_KEY = "StreamContentServlet.";

    public String getServletInfo() {
        return RB.getStringResource(RB_KEY, "servletInfo.txt");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.write(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.write(request, response);
    }

    @SASScope
    protected void write(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object o;
        boolean usePersistence;
        byte[] contentBytes;
        String cd;
        String contentType;
        String noop = request.getParameter(NOOP);
        if ("true".equalsIgnoreCase(noop)) {
            return;
        }
        HttpSession session = request.getSession();
        String src = request.getParameter(CONTENT_KEY);
        String string = contentType = src != null ? (String)session.getAttribute(CONTENT_TYPE + src) : (String)request.getAttribute(CONTENT_TYPE);
        if (contentType == null) {
            throw new ServletException(RB.getStringResource(RB_KEY, "noContentType.txt", request.getLocale()));
        }
        response.setContentType(contentType);
        String string2 = cd = src != null ? (String)session.getAttribute(CONTENT_DISPOSITION + src) : (String)request.getAttribute(CONTENT_DISPOSITION);
        if (cd != null) {
            response.setHeader("Content-Disposition", cd);
        }
        byte[] byArray = contentBytes = src != null ? (byte[])session.getAttribute(CONTENT_BYTES + src) : (byte[])request.getAttribute(CONTENT_BYTES);
        if (contentBytes == null) {
            throw new ServletException(RB.getStringResource(RB_KEY, "noContentBytes.txt", request.getLocale()));
        }
        String persistenceFlag = request.getParameter(PERSISTENCE);
        boolean bl = usePersistence = persistenceFlag == null || !persistenceFlag.equals("false");
        if (usePersistence) {
            response.setContentLength(contentBytes.length);
        }
        ServletOutputStream out = response.getOutputStream();
        out.write(contentBytes, 0, contentBytes.length);
        out.flush();
        out.close();
        if (src != null && ((o = session.getAttribute(DISPOSE_CONTENTS + src)) != null && !((String)o).equalsIgnoreCase("false") || o == null)) {
            session.removeAttribute(CONTENT_TYPE + src);
            session.removeAttribute(CONTENT_DISPOSITION + src);
            session.removeAttribute(CONTENT_BYTES + src);
            session.removeAttribute(DISPOSE_CONTENTS + src);
        }
    }
}

